/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.bs.ml.EASResourceDomainCollection;
import com.kingdee.eas.bs.ml.EASResourceDomainInfo;
import com.kingdee.eas.bs.ml.TranslateStatusEnum;
import com.kingdee.eas.bs.ml.client.AbstractResourceFilterUI;
import com.kingdee.eas.bs.ml.client.LanguageObject;
import com.kingdee.eas.bs.ml.client.MLClientUtils;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.bs.ml.util.SelectBizF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.ComboBoxModel;
import org.apache.log4j.Logger;

public class ResourceFilterUI
extends AbstractResourceFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ResourceFilterUI.class);
    private static final String SINGLE = "single";
    private static final String MULTI = "multi";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private LanguageObject lan = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.comboLang.setModel((ComboBoxModel)MLClientUtils.getLanguageComboModel(false));
        for (int i = 0; i < this.comboLang.getItemCount(); ++i) {
            LanguageObject lo = (LanguageObject)this.comboLang.getItemAt(i);
            if (!"en_US".equals(lo.getNumber())) continue;
            this.comboLang.setSelectedIndex(i);
        }
        this.startDate.setValue(null);
        this.endDate.setValue(null);
        this.comboTransState.setSelectedItem((Object)TranslateStatusEnum.all);
        this.dominF7.setSelector((KDPromptSelector)new SelectBizF7((Component)((Object)this)));
        this.dominF7.setEditable(false);
        this.txtCN.requestFocusInWindow();
        Locale locale = SysContext.getSysContext().getOriginLocale();
        if (!"zh_CN".equalsIgnoreCase(locale.toString())) {
            this.kDLabelContainer1.setVisible(false);
            this.dominF7.setVisible(false);
        }
    }

    public static void storeToCustomerParams(CustomerParams cp, KDTextField kdTextField) {
        if (kdTextField.getText() != null) {
            cp.addCustomerParam(kdTextField.getName(), kdTextField.getText());
        }
    }

    public static void storeToCustomerParams(CustomerParams cp, KDBizPromptBox promptBox) {
        Object[] infos;
        Object obj = promptBox.getValue();
        if (obj instanceof CoreBaseInfo) {
            CoreBaseInfo info = (CoreBaseInfo)obj;
            if (info.getId() != null) {
                CustomerParams params = new CustomerParams();
                params.putMe(SINGLE, ResourceFilterUI.assembleCustomerParams(info));
                cp.putMe(promptBox.getName(), params);
            }
        } else if (obj instanceof Object[] && (infos = (Object[])obj) != null && infos.length > 0) {
            CustomerParams params = new CustomerParams();
            for (int i = 0; i < infos.length; ++i) {
                DataBaseInfo info = (DataBaseInfo)infos[i];
                if (info == null) continue;
                params.putMe(String.valueOf(i), ResourceFilterUI.assembleCustomerParams((CoreBaseInfo)info));
            }
            CustomerParams key = new CustomerParams();
            key.putMe(MULTI, params);
            cp.putMe(promptBox.getName(), key);
        }
    }

    private static CustomerParams assembleCustomerParams(CoreBaseInfo info) {
        CustomerParams element = new CustomerParams();
        element.addCustomerParam(ID, info.getId().toString());
        element.addCustomerParam(NAME, info.getString(NAME));
        element.addCustomerParam(NUMBER, info.getString(NUMBER));
        return element;
    }

    public static void storeToCustomerParams(CustomerParams cp, KDDatePicker datePicker) {
        if (datePicker.getValue() != null) {
            cp.putDate(datePicker.getName(), (Date)datePicker.getValue());
        }
    }

    public static void loadFromCustomerParams(CustomerParams cp, KDTextField kdTextField) {
        String name = null;
        if (cp != null) {
            name = cp.getCustomerParam(kdTextField.getName());
        }
        kdTextField.setText(name);
    }

    public static void loadFromCustomerParams(CustomerParams cp, KDDatePicker datePicker) {
        Date date = null;
        if (cp != null) {
            date = cp.getDate(datePicker.getName());
        }
        datePicker.setValue(date);
    }

    public static void loadFromCustomerParams(CustomerParams cp, KDBizPromptBox promptBox, String className) {
        if (cp == null) {
            promptBox.setValue(null);
            return;
        }
        Object[] obj = null;
        CustomerParams key = cp.getMe(promptBox.getName());
        if (key != null) {
            CustomerParams params = key.getMe(SINGLE);
            if (params != null) {
                obj = ResourceFilterUI.assembleDataBaseInfo(className, params);
            }
            if ((params = key.getMe(MULTI)) != null) {
                ArrayList<CoreBaseInfo> infos = new ArrayList<CoreBaseInfo>();
                Iterator it = params.getKeys().iterator();
                while (it.hasNext()) {
                    CustomerParams element = params.getMe((String)it.next());
                    if (element == null) continue;
                    infos.add(ResourceFilterUI.assembleDataBaseInfo(className, element));
                }
                obj = infos.toArray();
            }
        }
        promptBox.setValue(obj);
    }

    private static CoreBaseInfo assembleDataBaseInfo(String className, CustomerParams element) {
        CoreBaseInfo info = ResourceFilterUI.getCoreBaseInfo(className);
        if (info != null) {
            info.setId(BOSUuid.read((String)element.getCustomerParam(ID)));
            info.put(NAME, (Object)element.getCustomerParam(NAME));
            info.put(NUMBER, (Object)element.getCustomerParam(NUMBER));
        }
        return info;
    }

    public static CoreBaseInfo getCoreBaseInfo(String className) {
        CoreBaseInfo info = null;
        try {
            Object object = Class.forName(className).newInstance();
            if (object instanceof CoreBaseInfo) {
                info = (CoreBaseInfo)object;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return info;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public LanguageObject getLanguage() {
        return this.lan;
    }

    public FilterInfo getFilterInfo() {
        EASResourceDomainCollection domainColl;
        TranslateStatusEnum st;
        Object state;
        UserInfo userInfo;
        Object obj;
        String en;
        String cn;
        FilterInfo fi = new FilterInfo();
        this.lan = (LanguageObject)this.comboLang.getSelectedItem();
        if (this.lan != null) {
            fi.getFilterItems().add(new FilterItemInfo("language", (Object)this.lan.getNumber()));
        }
        if ((cn = MLUtils.myTrim(this.txtCN.getText())) != null && cn.length() > 0) {
            if (cn.equalsIgnoreCase("null")) {
                fi.getFilterItems().add(new FilterItemInfo("parent.res", (Object)cn, CompareType.EQUALS));
            } else {
                fi.getFilterItems().add(new FilterItemInfo("parent.res", (Object)cn, CompareType.LIKE));
            }
        }
        if ((en = MLUtils.myTrim(this.txtTrans.getText())) != null && en.length() > 0) {
            if (en.equalsIgnoreCase("null")) {
                fi.getFilterItems().add(new FilterItemInfo("content", (Object)en, CompareType.EQUALS));
            } else {
                fi.getFilterItems().add(new FilterItemInfo("content", (Object)en, CompareType.LIKE));
            }
        }
        if ((obj = this.startDate.getValue()) != null) {
            fi.getFilterItems().add(new FilterItemInfo("transTime", obj, CompareType.GREATER_EQUALS));
        }
        if ((obj = this.endDate.getValue()) != null) {
            fi.getFilterItems().add(new FilterItemInfo("transTime", obj, CompareType.LESS_EQUALS));
        }
        if ((userInfo = (UserInfo)this.prmtPerson.getValue()) != null) {
            fi.getFilterItems().add(new FilterItemInfo("translator.id", (Object)userInfo.getId().toString()));
        }
        if ((state = this.comboTransState.getSelectedItem()) != null && state.toString().trim().length() > 0 && !(st = (TranslateStatusEnum)((Object)state)).equals((Object)TranslateStatusEnum.all)) {
            fi.getFilterItems().add(new FilterItemInfo("isTranslated", (Object)new Integer(st.getValue())));
        }
        if ((domainColl = (EASResourceDomainCollection)((Object)this.dominF7.getValue())) != null) {
            FilterInfo domainFilter = new FilterInfo();
            for (int i = 0; i < domainColl.size(); ++i) {
                EASResourceDomainInfo domainInfo = domainColl.get(i);
                if (domainInfo == null || domainInfo.getId() == null) continue;
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("parent.domainId", (Object)("%" + domainInfo.getId().toString() + "%"), CompareType.LIKE));
                try {
                    domainFilter.mergeFilter(filter, "OR");
                    continue;
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            try {
                fi.mergeFilter(domainFilter, "AND");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return fi;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        ResourceFilterUI.storeToCustomerParams(cp, this.txtCN);
        ResourceFilterUI.storeToCustomerParams(cp, this.txtTrans);
        ResourceFilterUI.storeToCustomerParams(cp, this.prmtPerson);
        ResourceFilterUI.storeToCustomerParams(cp, this.startDate);
        ResourceFilterUI.storeToCustomerParams(cp, this.endDate);
        ResourceFilterUI.storeToCustomerParams(cp, this.dominF7);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        ResourceFilterUI.loadFromCustomerParams(cp, this.txtCN);
        ResourceFilterUI.loadFromCustomerParams(cp, this.txtTrans);
        ResourceFilterUI.loadFromCustomerParams(cp, this.startDate);
        ResourceFilterUI.loadFromCustomerParams(cp, this.endDate);
        ResourceFilterUI.loadFromCustomerParams(cp, this.prmtPerson, UserInfo.class.getName());
        ResourceFilterUI.loadFromCustomerParams(cp, this.dominF7, EASResourceDomainInfo.class.getName());
    }

    public void clear() {
        this.txtCN.setText("");
        this.txtTrans.setText("");
        this.prmtPerson.setValue(null);
        this.dominF7.setValue(null);
    }

    public boolean verify() {
        if (this.comboLang.getSelectedItem() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"8_ResourceEditUI"));
            return false;
        }
        return true;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.txtCN.requestFocusInWindow();
    }
}

