/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.bs.ml.MLFacadeFactory;
import com.kingdee.eas.bs.ml.client.AbstractResourceImportUI;
import com.kingdee.eas.bs.ml.client.LanguageObject;
import com.kingdee.eas.bs.ml.client.MLClientUtils;
import com.kingdee.eas.bs.ml.client.ResourceExcelHelper;
import com.kingdee.eas.bs.ml.util.IProgTask;
import com.kingdee.eas.bs.ml.util.ProgDialog;
import com.kingdee.eas.bs.ml.util.ResourceInfo;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.tools.datatask.FilesPathInfo;
import com.kingdee.eas.tools.datatask.client.FileSelector;
import com.kingdee.eas.tools.datatask.runtime.ExcelUtil;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelDataReader;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class ResourceImportUI
extends AbstractResourceImportUI {
    private static final Logger logger = CoreUIObject.getLogger(ResourceImportUI.class);
    private boolean cancel = true;
    private HSSFWorkbook workbook;
    private int headRowNum = 2;
    LanguageObject language = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        if (this.getUIContext().get("language") != null && this.getUIContext().get("language") instanceof LanguageObject) {
            this.language = (LanguageObject)this.getUIContext().get("language");
        }
        for (int i = 0; i < this.comboLang.getItemCount(); ++i) {
            Object obj = this.comboLang.getItemAt(i);
            if (obj == null || !(obj instanceof LanguageObject) || !obj.equals(this.language)) continue;
            this.comboLang.setSelectedIndex(i);
            break;
        }
    }

    private void initUI() throws Exception {
        this.comboError.removeAllItems();
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnRightnow);
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnWhenFinish);
        this.comboError.setSelectedIndex(0);
        this.comboLang.setModel((ComboBoxModel)MLClientUtils.getLanguageComboModel(false));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRefreshSheet.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        int sheetNum;
        HSSFSheet sheet;
        int rowNum;
        if (this.workbook == null) {
            return;
        }
        if (!this.checkFile()) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"12_ResourceImportUI"));
            this.txtFile.setText("");
            this.comboLabel.removeAllItems();
            SysUtil.abort();
        }
        if ((rowNum = (sheet = this.workbook.getSheetAt(sheetNum = this.comboLabel.getSelectedIndex())).getPhysicalNumberOfRows()) < 2) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"13_ResourceImportUI"));
            return;
        }
        boolean isUpdateAllWords = this.chkUpdate.isSelected();
        ErrorHandleModeEnum erorrHandleMode = (ErrorHandleModeEnum)this.comboError.getSelectedItem();
        HSSFRow headNumberRow = sheet.getRow(2);
        int cellCount = headNumberRow.getPhysicalNumberOfCells();
        HSSFRow row = null;
        ArrayList<ResourceInfo> list = new ArrayList<ResourceInfo>();
        String cn = null;
        String content = null;
        String description = null;
        for (int i = this.headRowNum; i < rowNum; ++i) {
            row = sheet.getRow(i);
            if (row == null || row.getPhysicalNumberOfCells() <= 0) continue;
            try {
                cn = ExcelUtil.getCellValue((HSSFCell)row.getCell(0));
                if (cn == null || cn.trim().length() == 0 || (content = ExcelUtil.getCellValue((HSSFCell)row.getCell(1))) == null || content.trim().length() == 0) continue;
                description = ExcelUtil.getCellValue((HSSFCell)row.getCell(2));
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
                logger.error((Object)("reader excel on " + (i + 1) + " error!"));
                continue;
            }
            ResourceInfo info = new ResourceInfo();
            info.setCn(cn);
            info.setContent(content);
            info.setDescription(description);
            list.add(info);
        }
        LanguageObject lo = (LanguageObject)this.comboLang.getSelectedItem();
        if (lo == null) {
            return;
        }
        String lan = lo.getNumber();
        boolean hasError = false;
        Map map = null;
        try {
            MyProgTask pt = new MyProgTask(list, isUpdateAllWords, erorrHandleMode.getValue(), lan);
            pt.show();
            map = pt.getResult();
            if (map != null && map.containsKey("hasError")) {
                hasError = (Boolean)map.get("hasError");
            }
        }
        catch (Exception e1) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"36_AttendanceDataImportUI"), (String)e1.getMessage(), (int)2);
            SysUtil.abort();
        }
        if (hasError) {
            if (map != null && map.containsKey("errorStr")) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"12_ResourceImportUI"), (String)map.get("errorStr").toString(), (int)2);
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"14_ResourceImportUI"));
        }
        this.getUIWindow().close();
    }

    public void actionOpen_actionPerformed(ActionEvent e) throws Exception {
        super.actionOpen_actionPerformed(e);
        String filePath = this.txtFile.getText();
        if (filePath == null || filePath.trim().length() <= 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"15_ResourceImportUI"));
            return;
        }
        if (this.tblMain.getRowCount() >= 0) {
            String str = filePath.substring(filePath.lastIndexOf("."));
            if (".xls".equals(str)) {
                this.initSheet();
                int sheetNum = this.comboLabel.getSelectedIndex();
                HSSFSheet sheet = this.workbook.getSheetAt(sheetNum);
                int rowNum = sheet.getPhysicalNumberOfRows();
                if (rowNum < 1) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"16_ResourceImportUI"));
                    this.txtFile.setText("");
                    this.comboLabel.removeAllItems();
                    SysUtil.abort();
                }
            } else {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"17_ResourceImportUI"));
                this.txtFile.setText("");
                this.comboLabel.removeAllItems();
                SysUtil.abort();
            }
        }
    }

    public void actionNo_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    public void btnExportTemplate_actionPerformed(ActionEvent e) throws Exception {
        FileSelector fselector = new FileSelector((Component)((Object)this), "SAVE");
        fselector.setDefFileName("Resource.xls");
        fselector.show();
        if (fselector.isCanceled()) {
            return;
        }
        String expFilePath = fselector.getData().toString();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(expFilePath);
        }
        catch (FileNotFoundException ex) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"10_ResourceExportUtil"));
            SysUtil.abort();
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFCellStyle nameCellStyle = ResourceExcelHelper.createNameCellStyle(wb);
        HSSFCellStyle codeCellStyle = ResourceExcelHelper.createCodeCellStyle(wb);
        HSSFSheet sheet = wb.createSheet();
        HSSFRow headRow = sheet.createRow(0);
        HSSFRow headRow2 = sheet.createRow(1);
        ResourceExcelHelper.createHeadCell(headRow, codeCellStyle, 0, "zh_CN");
        ResourceExcelHelper.createHeadCell(headRow2, nameCellStyle, 0, EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"5_MLClientUtils"));
        ResourceExcelHelper.createHeadCell(headRow, codeCellStyle, 1, "content");
        ResourceExcelHelper.createHeadCell(headRow2, nameCellStyle, 1, EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"11_ResourceExportUtil"));
        ResourceExcelHelper.createHeadCell(headRow, codeCellStyle, 2, "description");
        ResourceExcelHelper.createHeadCell(headRow2, nameCellStyle, 2, EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"description_ResourceExportUtil"));
        sheet.setDefaultColumnWidth(20);
        wb.setSheetName(0, "resource");
        wb.write((OutputStream)out);
        out.flush();
        out.close();
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"18_ResourceImportUI"));
    }

    private boolean checkTemplate(String filePath) {
        String str = filePath.substring(filePath.lastIndexOf("."));
        if (!".xls".equals(str)) {
            return false;
        }
        try {
            this.initSheet();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        int sheetNum = this.comboLabel.getSelectedIndex();
        HSSFSheet sheet = this.workbook.getSheetAt(sheetNum);
        int rowNum = sheet.getPhysicalNumberOfRows();
        return rowNum >= 1;
    }

    private boolean checkFile() {
        HSSFRow headNumRow;
        HSSFSheet sheet;
        int rowNum;
        int sheetNum = this.comboLabel.getSelectedIndex();
        if (sheetNum < 0) {
            return false;
        }
        if (this.workbook == null) {
            try {
                this.initSheet();
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if ((rowNum = (sheet = this.workbook.getSheetAt(sheetNum)).getPhysicalNumberOfRows()) < 3) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"19_ResourceImportUI"));
            SysUtil.abort();
        }
        if ((headNumRow = sheet.getRow(2)) == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"19_ResourceImportUI"));
            this.txtFile.setText("");
            this.comboLabel.removeAllItems();
            SysUtil.abort();
        }
        return true;
    }

    private void initSheet() throws Exception {
        this.comboLabel.removeAllItems();
        FilesPathInfo paths = (FilesPathInfo)this.txtFile.getUserObject();
        String path = "";
        if (paths == null || paths.getFilePath() == null || paths.getFilePath().length <= 0) {
            return;
        }
        path = paths.getFilePath()[0];
        ExternalExcelDataReader reader = new ExternalExcelDataReader();
        ArrayList sheetNames = null;
        sheetNames = reader.getSheetNameCollection(path);
        KDTDefaultCellEditor itemEditor = null;
        KDComboBox comSheetNames = new KDComboBox();
        if (sheetNames != null) {
            int sheetCount = sheetNames.size();
            for (int i = 0; i < sheetCount; ++i) {
                comSheetNames.addItem(sheetNames.get(i));
                this.comboLabel.addItem(sheetNames.get(i));
            }
        }
        itemEditor = new KDTDefaultCellEditor((JComboBox)comSheetNames);
        this.tblMain.getColumn("excelTabName").setEditor((ICellEditor)itemEditor);
        this.comboLabel.addItemListener((ItemListener)new ItemListenerImpl());
        POIFSFileSystem pfs = new POIFSFileSystem((InputStream)new FileInputStream(path));
        this.workbook = new HSSFWorkbook(pfs);
        int size = this.workbook.getNumberOfSheets();
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public void setCancel(boolean cancel) {
        this.cancel = cancel;
    }

    private class ItemListenerImpl
    implements ItemListener {
        private ItemListenerImpl() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object obj = ResourceImportUI.this.comboLabel.getSelectedItem();
            if (obj != null) {
                ICell cell = ResourceImportUI.this.tblMain.getCell(0, "excelTabName");
                cell.setValue((Object)obj.toString());
            }
        }
    }

    public class MyProgTask
    implements IProgTask {
        private List list;
        private boolean isUpdateAllWords;
        private int erorrHandleMode;
        private String language;
        private Map reuslt;

        public MyProgTask(List list, boolean isUpdateAllWords, int erorrHandleMode, String language) {
            this.list = list;
            this.isUpdateAllWords = isUpdateAllWords;
            this.erorrHandleMode = erorrHandleMode;
            this.language = language;
        }

        @Override
        public Object exec() throws Exception {
            this.reuslt = MLFacadeFactory.getRemoteInstance().importContent(this.list, this.isUpdateAllWords, this.erorrHandleMode, this.language);
            return "";
        }

        @Override
        public void afterExec(Object result) throws Exception {
        }

        public void show() {
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)ResourceImportUI.this));
            ProgDialog dialog = null;
            if (win instanceof Frame) {
                dialog = new ProgDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new ProgDialog((Dialog)win);
            }
            dialog.setLongTimeTask(this);
            dialog.show();
        }

        public Map getResult() {
            return this.reuslt;
        }
    }
}

