/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.bs.ml.MLFacadeFactory;
import com.kingdee.eas.bs.ml.ResourceFacadeFactory;
import com.kingdee.eas.bs.ml.client.AbstractResourceUpdateToMLFieldUI;
import com.kingdee.eas.bs.ml.client.LanguageObject;
import com.kingdee.eas.bs.ml.client.MLClientUtils;
import com.kingdee.eas.bs.ml.client.ResourceClientCache;
import com.kingdee.eas.bs.ml.util.IProgTask;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.bs.ml.util.ProgDialog;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ResourceUpdateToMLFieldUI
extends AbstractResourceUpdateToMLFieldUI {
    private static final Logger logger = CoreUIObject.getLogger(ResourceUpdateToMLFieldUI.class);
    LanguageObject language = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.combLanguage.setModel((ComboBoxModel)MLClientUtils.getLanguageComboModelForEnTW());
        this.cbAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ResourceUpdateToMLFieldUI.this.cbAll.isSelected()) {
                    ResourceUpdateToMLFieldUI.this.txtTab.setEnabled(false);
                } else {
                    ResourceUpdateToMLFieldUI.this.txtTab.setEnabled(true);
                }
            }
        });
        if (this.getUIContext().get("language") != null && this.getUIContext().get("language") instanceof LanguageObject) {
            this.language = (LanguageObject)this.getUIContext().get("language");
        }
        for (int i = 0; i < this.combLanguage.getItemCount(); ++i) {
            Object obj = this.combLanguage.getItemAt(i);
            if (obj == null || !(obj instanceof LanguageObject) || !obj.equals(this.language)) continue;
            this.combLanguage.setSelectedIndex(i);
            break;
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        LanguageObject lo = (LanguageObject)this.combLanguage.getSelectedItem();
        if (lo == null) {
            super.actionExitCurrent_actionPerformed(null);
        }
        String lan = lo.getNumber();
        ArrayList<String> list = new ArrayList<String>();
        String str = this.txtTab.getText();
        if (str != null) {
            str = MLUtils.myTrim(str);
            String[] arr = str.split("[,\uff0c;\uff1b]+");
            for (int i = 0; i < arr.length; ++i) {
                list.add(MLUtils.myTrim(arr[i]));
            }
        }
        long start = System.currentTimeMillis();
        MyProgTask pt = new MyProgTask(this.cbAll.isSelected(), list, lan);
        pt.show();
        long end = System.currentTimeMillis();
        logger.info((Object)("spend:" + (end - start)));
        if (pt.isSucess) {
            String ais = SysContext.getSysContext().getDCNumber();
            String fileSepa = System.getProperty("file.separator");
            String dic = System.getProperty("user.dir") + fileSepa + "cache" + fileSepa + "EASResourceCache" + fileSepa + ais;
            this.deleteResFile(new File(dic));
            ResourceClientCache.getInstance().clearCache();
            ResourceFacadeFactory.getRemoteInstance().clearResourceCache();
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"27_ResourceUpdateToMLFieldUI"));
            super.actionExitCurrent_actionPerformed(null);
        } else {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"28_ResourceUpdateToMLFieldUI"), (String)pt.getErrStr(), (int)2);
        }
    }

    private void deleteResFile(File dir) {
        if (dir == null || !dir.exists()) {
            return;
        }
        File[] arr = dir.listFiles();
        for (int i = 0; i < arr.length; ++i) {
            File f = arr[i];
            if (f.isDirectory()) {
                this.deleteResFile(f);
                continue;
            }
            try {
                f.delete();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(null);
    }

    public class MyProgTask
    implements IProgTask {
        private boolean isAllUpdate = true;
        private String language;
        private List tables;
        private boolean isSucess = true;
        private String errStr = "";

        private MyProgTask() {
        }

        public MyProgTask(boolean isAllUpdate, List tables, String language) {
            this.isAllUpdate = isAllUpdate;
            this.language = language;
            this.tables = tables;
        }

        @Override
        public Object exec() throws Exception {
            try {
                MLFacadeFactory.getRemoteInstance().updateMLFieldResource(this.language, this.isAllUpdate, this.tables);
            }
            catch (Exception e) {
                this.errStr = e.getMessage();
                this.isSucess = false;
            }
            return "";
        }

        @Override
        public void afterExec(Object result) throws Exception {
        }

        public void show() {
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)ResourceUpdateToMLFieldUI.this));
            ProgDialog dialog = null;
            if (win instanceof Frame) {
                dialog = new ProgDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new ProgDialog((Dialog)win);
            }
            if (dialog != null) {
                dialog.setLongTimeTask(this);
                dialog.show();
            }
        }

        public boolean isSucess() {
            return this.isSucess;
        }

        public String getErrStr() {
            return this.errStr;
        }
    }
}

