/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.client;

import com.kingdee.bos.ctrl.swing.KDTextPane;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;

public class TextPaneHelper {
    public static void setTextPaneMaxLength(KDTextPane pane, int len) {
        LimitedLengthDocument doc = new LimitedLengthDocument();
        doc.setMaxLength(500);
        pane.setDocument((Document)doc);
        final UndoManager manager = new UndoManager();
        doc.addUndoableEditListener(manager);
        pane.getActionMap().put("undo-textpane", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    manager.undo();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private static class LimitedLengthDocument
    extends DefaultStyledDocument {
        int maxLength;

        private LimitedLengthDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str != null) {
                int len;
                int oldlen = this.getLength();
                int newlen = str.length();
                int maxlen = this.getMaxLength();
                if (maxlen != -1 && (len = oldlen + newlen - maxlen) >= 0) {
                    int temp = newlen - len;
                    if (temp > 0) {
                        str = str.substring(0, temp);
                    } else {
                        return;
                    }
                }
            }
            super.insertString(offs, str, a);
        }

        private int getMaxLength() {
            return this.maxLength;
        }

        private void setMaxLength(int len) {
            this.maxLength = len;
        }
    }
}

