/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.client.tools;

import com.kingdee.eas.bs.ml.ResourceInfo;
import com.kingdee.eas.bs.ml.client.tools.MDResourceParser;
import com.kingdee.eas.bs.ml.client.tools.MetaDocConst;
import com.kingdee.eas.bs.ml.util.MLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;

public final class CommonResourceParser
implements MDResourceParser {
    private Pattern emPat = Pattern.compile("^.*?enumValues[.]{1}enumValue\\[(.*?)\\][.]{1}alias$");
    private Pattern expPat = Pattern.compile("^.*?bizExceptionSubItems[.]{1}bizExceptionSubItem\\[(.*?)\\][.]{1}message$");
    private Pattern resPat = Pattern.compile("^.*resourceItems[.]{1}resourceItem\\[(.*?)\\][.]{1}value$");

    private CommonResourceParser() {
    }

    public static CommonResourceParser getInstance() {
        return new CommonResourceParser();
    }

    @Override
    public List parser(Document doc, Map existWords, String metaType) throws Exception {
        if (doc == null || metaType == null) {
            return Collections.EMPTY_LIST;
        }
        if (existWords == null) {
            existWords = Collections.EMPTY_MAP;
        }
        ArrayList<ResourceInfo> list = new ArrayList<ResourceInfo>();
        Element root = doc.getRootElement();
        String pkg = null;
        String name = null;
        if ("enum".equalsIgnoreCase(metaType) || "exception".equalsIgnoreCase(metaType) || "resource".equalsIgnoreCase(metaType)) {
            String clName = root.elementText(MetaDocConst.NODE_CLASS);
            if (clName == null) {
                return Collections.EMPTY_LIST;
            }
            int idx = clName.lastIndexOf(46);
            if (idx >= 0) {
                name = clName.substring(idx + 1);
                pkg = clName.substring(0, idx);
            }
        } else {
            pkg = root.elementText(MetaDocConst.NODE_PKG);
            name = root.elementText(MetaDocConst.NODE_NAME);
        }
        if (name == null || name.trim().length() <= 0) {
            return Collections.EMPTY_LIST;
        }
        if (pkg == null || pkg.trim().length() <= 0) {
            return Collections.EMPTY_LIST;
        }
        String project = pkg.replaceAll("com.kingdee.eas.", "").replaceAll("com.kingdee.shr.", "");
        if (project.indexOf(".") > 0) {
            project = project.substring(0, project.indexOf("."));
        }
        pkg = pkg.replaceAll("\\.", "\\\\");
        Element resourceElement = root.element(MetaDocConst.NODE_RES);
        if (resourceElement == null) {
            return Collections.EMPTY_LIST;
        }
        Iterator rsIt = resourceElement.elementIterator();
        block0: while (rsIt.hasNext()) {
            Element rsElement = (Element)rsIt.next();
            String key = this.parserKey(metaType, rsElement.attribute(MetaDocConst.ATT_KEY).getText());
            if (key == null || key.length() <= 0) continue;
            Iterator langIt = rsElement.elementIterator();
            while (langIt.hasNext()) {
                ResourceInfo resInfo;
                Element localeElement = (Element)langIt.next();
                String locale = localeElement.attribute(MetaDocConst.ATT_LOCAL).getText();
                if (!locale.equals("zh_CN")) continue;
                String zh_CN = MLUtils.myTrim(localeElement.attribute(MetaDocConst.ATT_VALUE).getText());
                if (zh_CN == null || zh_CN.length() <= 0) continue block0;
                String md5 = MLUtils.md5HashCode(zh_CN);
                if ((metaType.equals("entity") || metaType.equals("query")) && !MLUtils.containChinese(zh_CN)) continue block0;
                if (!existWords.containsKey(key)) {
                    resInfo = new ResourceInfo();
                    resInfo.setZh_CN(zh_CN);
                    resInfo.setPkg(pkg);
                    resInfo.setFileName(name);
                    resInfo.setPrj(project);
                    resInfo.setKey(key);
                    resInfo.setMetaType(metaType);
                    if (!MLUtils.containChinese(zh_CN)) {
                        resInfo.setEn_US(zh_CN);
                    }
                    list.add(resInfo);
                    continue block0;
                }
                if (md5.equals(existWords.get(key))) continue block0;
                resInfo = new ResourceInfo();
                resInfo.setZh_CN(zh_CN);
                resInfo.setPkg(pkg);
                resInfo.setFileName(name);
                resInfo.setKey(key);
                resInfo.setMetaType(metaType);
                resInfo.setUpdate(true);
                if (!MLUtils.containChinese(zh_CN)) {
                    resInfo.setEn_US(zh_CN);
                }
                list.add(resInfo);
                continue block0;
            }
        }
        return list;
    }

    private String parserKey(String metaType, String str) {
        String key = null;
        if ("entity".equals(metaType) || "query".equals(metaType)) {
            key = this.getEntityOrQueryResourceKey(str);
        } else if ("enum".equals(metaType)) {
            key = this.getEnumKey(str);
        } else if ("exception".equals(metaType)) {
            key = this.getExceptionKey(str);
        } else if ("resource".equals(metaType)) {
            key = this.getResourceKey(str);
        }
        return key;
    }

    private String getEntityOrQueryResourceKey(String srcKey) {
        if (srcKey == null) {
            return null;
        }
        if (srcKey.indexOf("].") < 0) {
            return srcKey;
        }
        return srcKey.substring(srcKey.indexOf("].") + 2, srcKey.length());
    }

    private String getEnumKey(String srcKey) {
        if (srcKey == null || srcKey.trim().length() <= 0) {
            return null;
        }
        Matcher m = this.emPat.matcher(srcKey);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private String getExceptionKey(String srcKey) {
        if (srcKey == null || srcKey.trim().length() <= 0) {
            return null;
        }
        Matcher m = this.expPat.matcher(srcKey);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private String getResourceKey(String srcKey) {
        if (srcKey == null || srcKey.trim().length() <= 0) {
            return null;
        }
        Matcher m = this.resPat.matcher(srcKey);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }
}

