/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.client.tools;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.config.DynamicMetadataCollection;
import com.kingdee.bos.config.DynamicMetadataFactory;
import com.kingdee.bos.config.DynamicMetadataInfo;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.configure.DynamicMetadataProviderManager;
import com.kingdee.bos.metadata.configure.IDynamicMetadataProvider;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.bs.ml.util.MetaDocConst;
import com.kingdee.eas.bs.ml.util.ParserHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class FetchDEPInfoUtil {
    private static Logger logger = Logger.getLogger((String)FetchDEPInfoUtil.class.getName());

    public void parseDepSegment(String suffix) throws Exception {
        this.parseDepSegmentNew(suffix);
    }

    public void parseDepSegmentNew(String suffix) throws Exception {
        IDynamicMetadataProvider dmp = DynamicMetadataProviderManager.getProvider();
        if (dmp != null) {
            try {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection selectorColl = new SelectorItemCollection();
                selectorColl.add("id");
                view.setSelector(selectorColl);
                DynamicMetadataCollection dmc = DynamicMetadataFactory.getRemoteInstance().getCollection(view);
                Document doc = null;
                for (int j = 0; j < dmc.size(); ++j) {
                    DynamicMetadataInfo dmi = dmc.get(j);
                    dmi = DynamicMetadataFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(dmi.getId()));
                    String metaType = this.getMetasBosType(dmi.getBosType());
                    byte[] segment = dmi.getSegment();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(segment);
                    doc = FetchDEPInfoUtil.parseXML(byteArrayInputStream, metaType);
                    this.parseDoc(doc);
                }
            }
            catch (BOSException e) {
                logger.error((Object)e, (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private void parseDoc(Document doc) throws Exception {
        String suffix = doc.getName().toString();
        Element root = doc.getRootElement();
        String pkg = root.elementText(MetaDocConst.NODE_PKG);
        String name = root.elementText(MetaDocConst.NODE_NAME);
        if (suffix != null && !"".equals(suffix)) {
            ParserHelper.parse(doc, pkg, name, suffix);
        }
    }

    private Document[] getDepMetadatas() {
        IDynamicMetadataProvider dmp = DynamicMetadataProviderManager.getProvider();
        if (dmp != null) {
            try {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection selectorColl = new SelectorItemCollection();
                selectorColl.add("id");
                view.setSelector(selectorColl);
                DynamicMetadataCollection dmc = DynamicMetadataFactory.getRemoteInstance().getCollection(view);
                Document[] docs = new Document[dmc.size()];
                for (int j = 0; j < dmc.size(); ++j) {
                    DynamicMetadataInfo dmi = dmc.get(j);
                    dmi = DynamicMetadataFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(dmi.getId()));
                    String metaType = this.getMetasBosType(dmi.getBosType());
                    byte[] segment = dmi.getSegment();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(segment);
                    docs[j] = FetchDEPInfoUtil.parseXML(byteArrayInputStream, metaType);
                }
                return docs;
            }
            catch (BOSException e) {
                logger.error((Object)e, (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return new Document[0];
    }

    public static void main(String[] arg) {
    }

    public static Document parseXML(InputStream inputStream, String metaType) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("The argument inputStream is null");
        }
        SAXReader reader = new SAXReader();
        Document doc = null;
        try {
            doc = reader.read(inputStream);
            if (doc != null) {
                doc.setName(metaType);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
        }
        return doc;
    }

    public String getMetasBosType(String bosType) {
        String metasType = "";
        if (bosType != null && "enty".equals(bosType)) {
            metasType = "entity";
        } else if (bosType != null && ("jqye".equals(bosType) || "uqye".equals(bosType) || "baqu".equals(bosType) || "vqye".equals(bosType))) {
            metasType = "query";
        } else if (bosType != null && "uioj".equals(bosType)) {
            metasType = "ui";
        } else if (bosType != null && "perm".equals(bosType)) {
            metasType = "permission";
        } else if (bosType != null && "logs".equals(bosType)) {
            metasType = "log";
        } else if (bosType != null && "bien".equals(bosType)) {
            metasType = "enum";
        } else if (bosType != null && "bize".equals(bosType)) {
            metasType = "exception";
        } else if (bosType != null && "wbui".equals(bosType)) {
            metasType = "resource";
        } else if (bosType != null && "datb".equals(bosType)) {
            metasType = "table";
        } else if (bosType != null && "wbpe".equals(bosType)) {
            metasType = "wbpage";
        } else if (bosType != null && "webui".equals(bosType)) {
            metasType = "webui";
        }
        return metasType;
    }
}

