/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.client.tools;

import com.kingdee.eas.bs.ml.util.MLToolsConstonts;
import com.kingdee.eas.bs.ml.util.MetaDocConst;
import com.kingdee.eas.bs.ml.util.ParserHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class FetchWordsFromJarOrFileUtil {
    private static Logger logger = Logger.getLogger((String)FetchWordsFromJarOrFileUtil.class.getName());
    private static List suffixList = new ArrayList();
    private String rootPath;

    public void FetchWordsFromJarOrFileUtil(String rootPath) {
        this.rootPath = rootPath;
    }

    public void FetchWordsFromJarOrFileUtil() {
    }

    public void start() throws Exception {
        suffixList.add("query");
        suffixList.add("entity");
        suffixList.add("resource");
        suffixList.add("ui");
        suffixList.add("enum");
        suffixList.add("exception");
        suffixList.add(MLToolsConstonts.JAR_SUFFIX);
        suffixList.add("permission");
        suffixList.add("table");
        suffixList.add("mdbview");
        suffixList.add("wbpage");
        suffixList.add("webui");
        if (this.rootPath == null || this.rootPath.trim().length() <= 0) {
            return;
        }
        File file = new File(this.rootPath);
        this.fetchWords(file);
    }

    private void fetchWords(File file) throws Exception {
        if (file.isDirectory()) {
            File[] arr = file.listFiles(new FileFilterImpl());
            for (int i = 0; i < arr.length; ++i) {
                this.fetchWords(arr[i]);
            }
        } else {
            String fileName = file.getName();
            int idx = fileName.lastIndexOf(".");
            if (idx < 0) {
                return;
            }
            String suffix = fileName.substring(idx + 1);
            if (!suffixList.contains(suffix)) {
                return;
            }
            try {
                if (suffix.equals(MLToolsConstonts.JAR_SUFFIX)) {
                    this.parseJar(file);
                }
                ParserHelper.parse(file, suffix);
            }
            catch (Exception e) {
                logger.error((Object)("parse file " + file.getName() + " error!"));
                logger.error((Object)e.getMessage());
                throw e;
            }
        }
    }

    private void parseJar(File jarFile) throws Exception {
        JarFile jf = null;
        try {
            jf = new JarFile(jarFile);
        }
        catch (IOException e) {
            logger.error((Object)("error file:" + jarFile.getName()));
            logger.error((Object)e.getMessage());
            throw e;
        }
        Enumeration<JarEntry> en = jf.entries();
        String pkg = "";
        while (en.hasMoreElements()) {
            String suffix;
            String name;
            int idx;
            JarEntry entry = en.nextElement();
            if (entry.isDirectory() || (idx = (name = entry.getName()).lastIndexOf(46)) < 0 || !suffixList.contains(suffix = name.substring(idx + 1))) continue;
            InputStream is = null;
            try {
                is = jf.getInputStream(entry);
            }
            catch (IOException e) {
                logger.error((Object)("error file:" + entry.getName()));
                logger.error((Object)e.getMessage());
                throw e;
            }
            SAXReader reader = new SAXReader();
            Document doc = null;
            try {
                doc = reader.read(is);
            }
            catch (Exception ex) {
                logger.error((Object)("error file:" + name));
                logger.error((Object)ex.getMessage());
                throw ex;
            }
            Element root = doc.getRootElement();
            if ("ui".equals(suffix) || "wbpage".equals(suffix)) {
                pkg = root.elementText(MetaDocConst.NODE_UI_ReleasePackage);
                if (pkg == null || "".equals(pkg)) {
                    pkg = root.elementText(MetaDocConst.NODE_PKG);
                }
                if ((name = root.elementText(MetaDocConst.NODE_UI_ReleaseClass)) == null || "".equals(name)) {
                    name = root.elementText(MetaDocConst.NODE_NAME);
                }
            } else if ("enum".equalsIgnoreCase(suffix) || "exception".equalsIgnoreCase(suffix) || "resource".equalsIgnoreCase(suffix)) {
                String clName = root.elementText(MetaDocConst.NODE_CLASS);
                if (clName == null) {
                    pkg = root.elementText(MetaDocConst.NODE_PKG);
                    name = root.elementText(MetaDocConst.NODE_NAME);
                } else {
                    int idex = clName.lastIndexOf(46);
                    if (idex >= 0) {
                        name = clName.substring(idex + 1);
                        pkg = clName.substring(0, idex);
                    }
                }
            } else {
                pkg = root.elementText(MetaDocConst.NODE_PKG);
                name = root.elementText(MetaDocConst.NODE_NAME);
            }
            ParserHelper.parse(doc, pkg, name, suffix);
        }
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    private static class FileFilterImpl
    implements FileFilter {
        private FileFilterImpl() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName();
            if (name.lastIndexOf(".") < 0) {
                return false;
            }
            String suffix = name.substring(name.lastIndexOf(".") + 1);
            return suffixList.contains(suffix);
        }
    }
}

