/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.client.tools;

import com.kingdee.eas.bs.ml.MLToolsFacadeFactory;
import com.kingdee.eas.bs.ml.client.tools.FetchWordsFromJarOrFileUtil;
import com.kingdee.eas.bs.ml.client.tools.XMLHelper;
import com.kingdee.eas.bs.ml.util.MetaDocConst;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class MetasResourceWriteBackToFileUtil {
    private static Logger logger = Logger.getLogger((String)FetchWordsFromJarOrFileUtil.class.getName());
    private static List suffixList = new ArrayList();
    private String rootPath;
    private Pattern emPat = Pattern.compile("^.*?enumValues[.]{1}enumValue\\[(.*?)\\][.]{1}alias$");
    private Pattern expPat = Pattern.compile("^.*?bizExceptionSubItems[.]{1}bizExceptionSubItem\\[(.*?)\\][.]{1}message$");
    private Pattern resPat = Pattern.compile("^.*resourceItems[.]{1}resourceItem\\[(.*?)\\][.]{1}value$");

    public void FetchWordsFromJarOrFileUtil(String rootPath) {
        this.rootPath = rootPath;
    }

    public void FetchWordsFromJarOrFileUtil() {
    }

    public void start() throws Exception {
        suffixList.add("resource");
        if (this.rootPath == null || this.rootPath.trim().length() <= 0) {
            return;
        }
        File file = new File(this.rootPath);
        this.findFile(file);
    }

    private void findFile(File file) throws Exception {
        if (file.isDirectory()) {
            File[] arr = file.listFiles(new FileFilterImpl());
            for (int i = 0; i < arr.length; ++i) {
                this.findFile(arr[i]);
            }
        } else {
            String fileName = file.getName();
            int idx = fileName.lastIndexOf(".");
            if (idx < 0) {
                return;
            }
            String suffix = fileName.substring(idx + 1);
            if (!suffixList.contains(suffix)) {
                return;
            }
            try {
                this.parse(file, suffix);
            }
            catch (Exception e) {
                logger.error((Object)("parse file " + file.getName() + " error!"));
                logger.error((Object)e.getMessage());
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(File metaFile, String metaType) throws Exception {
        if (metaFile == null || metaType == null) {
            return;
        }
        Document doc = null;
        try (FileInputStream fi = null;){
            SAXReader reader = new SAXReader();
            fi = new FileInputStream(metaFile);
            doc = reader.read((InputStream)fi);
        }
        Element root = doc.getRootElement();
        if (root == null) {
            return;
        }
        String pkg = null;
        String name = null;
        if ("enum".equalsIgnoreCase(metaType) || "exception".equalsIgnoreCase(metaType) || "resource".equalsIgnoreCase(metaType)) {
            String clName = root.elementText(MetaDocConst.NODE_CLASS);
            if (clName == null) {
                return;
            }
            int idx = clName.lastIndexOf(46);
            if (idx >= 0) {
                name = clName.substring(idx + 1);
                pkg = clName.substring(0, idx);
            }
        } else if ("ui".equalsIgnoreCase(metaType)) {
            pkg = root.elementText(MetaDocConst.NODE_UI_ReleasePackage);
            name = root.elementText(MetaDocConst.NODE_UI_ReleaseClass).trim();
        } else {
            pkg = root.elementText(MetaDocConst.NODE_PKG);
            name = root.elementText(MetaDocConst.NODE_NAME);
        }
        Map existWords = null;
        try {
            existWords = this.getTranslatedWords(pkg, name, metaType);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw e;
        }
        Element resourceElement = root.element(MetaDocConst.NODE_RES);
        if (resourceElement == null) {
            return;
        }
        Iterator rsIt = resourceElement.elementIterator();
        block7: while (rsIt.hasNext()) {
            Element rsElement = (Element)rsIt.next();
            String key = this.parserKey(metaType, rsElement.attribute(MetaDocConst.ATT_KEY).getText());
            if (key == null || key.length() <= 0) continue;
            Object enVl = existWords.get(key);
            if (enVl == null) {
                enVl = "@Translating...";
            }
            Iterator langIt = rsElement.elementIterator();
            while (langIt.hasNext()) {
                Element localeElement = (Element)langIt.next();
                String locale = localeElement.attribute(MetaDocConst.ATT_LOCAL).getText();
                if (!locale.equals("en_US")) continue;
                localeElement.attribute(MetaDocConst.ATT_VALUE).setText(enVl.toString());
                continue block7;
            }
        }
        XMLHelper.writeXML(doc, metaFile);
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    private String parserKey(String metaType, String str) {
        String key = null;
        if ("entity".equals(metaType) || "query".equals(metaType)) {
            key = this.getEntityOrQueryResourceKey(str);
        } else if ("enum".equals(metaType)) {
            key = this.getEnumKey(str);
        } else if ("exception".equals(metaType)) {
            key = this.getExceptionKey(str);
        } else if ("resource".equals(metaType)) {
            key = this.getResourceKey(str);
        }
        return key;
    }

    private String getEntityOrQueryResourceKey(String srcKey) {
        if (srcKey == null) {
            return null;
        }
        if (srcKey.indexOf("].") < 0) {
            return srcKey;
        }
        return srcKey.substring(srcKey.indexOf("].") + 2, srcKey.length());
    }

    private String getEnumKey(String srcKey) {
        if (srcKey == null || srcKey.trim().length() <= 0) {
            return null;
        }
        Matcher m = this.emPat.matcher(srcKey);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private String getExceptionKey(String srcKey) {
        if (srcKey == null || srcKey.trim().length() <= 0) {
            return null;
        }
        Matcher m = this.expPat.matcher(srcKey);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private String getResourceKey(String srcKey) {
        if (srcKey == null || srcKey.trim().length() <= 0) {
            return null;
        }
        Matcher m = this.resPat.matcher(srcKey);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private Map getTranslatedWords(String pkg, String fileName, String metaType) throws Exception {
        if (fileName == null || metaType == null) {
            return Collections.EMPTY_MAP;
        }
        if (pkg == null) {
            pkg = "";
        }
        pkg = pkg.replaceAll("\\.", "\\\\");
        return MLToolsFacadeFactory.getRemoteInstance().getExistResource(pkg, fileName, metaType);
    }

    private static class FileFilterImpl
    implements FileFilter {
        private FileFilterImpl() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName();
            if (name.lastIndexOf(".") < 0) {
                return false;
            }
            String suffix = name.substring(name.lastIndexOf(".") + 1);
            return suffixList.contains(suffix);
        }
    }
}

