/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.client.tools;

import com.kingdee.eas.bs.ml.MLToolsFacadeFactory;
import com.kingdee.eas.bs.ml.client.tools.CommonResourceParser;
import com.kingdee.eas.bs.ml.client.tools.MetaDocConst;
import com.kingdee.eas.bs.ml.client.tools.PermAndLogResourceParser;
import com.kingdee.eas.bs.ml.client.tools.TableMultiFieldParser;
import com.kingdee.eas.bs.ml.client.tools.UIResourceParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ParserHelper {
    private static Logger logger = Logger.getLogger((String)ParserHelper.class.getName());

    public static void parse(Document doc, String pkg, String fileName, String metaType) throws Exception {
        if (doc == null || fileName == null || metaType == null) {
            return;
        }
        if (pkg == null) {
            pkg = "";
        }
        Map existWords = null;
        try {
            existWords = MLToolsFacadeFactory.getRemoteInstance().getExistResource(pkg, fileName, metaType);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw e;
        }
        List list = null;
        if ("entity".equals(metaType) || "query".equals(metaType) || "enum".equals(metaType) || "exception".equals(metaType) || "resource".equals(metaType)) {
            list = CommonResourceParser.getInstance().parser(doc, existWords, metaType);
        } else if ("ui".equals(metaType)) {
            list = UIResourceParser.getInstance().parser(doc, existWords, metaType);
        } else if ("table".equals(metaType)) {
            list = TableMultiFieldParser.getInstance().parser(doc, existWords, metaType);
        } else if ("permission".equals(metaType) || "log".equals(metaType)) {
            list = PermAndLogResourceParser.getInstance().parser(doc, existWords, metaType);
        }
        if (list != null && list.size() > 0) {
            MLToolsFacadeFactory.getRemoteInstance().saveResource(list, metaType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(File metaFile, String metaType) throws Exception {
        if (metaFile == null || metaType == null) {
            return;
        }
        Document doc = null;
        try (FileInputStream fi = null;){
            SAXReader reader = new SAXReader();
            fi = new FileInputStream(metaFile);
            doc = reader.read((InputStream)fi);
        }
        Element root = doc.getRootElement();
        if (root == null) {
            return;
        }
        String pkg = null;
        String name = null;
        if ("enum".equalsIgnoreCase(metaType) || "exception".equalsIgnoreCase(metaType) || "resource".equalsIgnoreCase(metaType)) {
            String clName = root.elementText(MetaDocConst.NODE_CLASS);
            if (clName == null) {
                return;
            }
            int idx = clName.lastIndexOf(46);
            if (idx >= 0) {
                name = clName.substring(idx + 1);
                pkg = clName.substring(0, idx);
            }
        } else if ("ui".equalsIgnoreCase(metaType)) {
            pkg = root.elementText(MetaDocConst.NODE_UI_ReleasePackage);
            name = root.elementText(MetaDocConst.NODE_UI_ReleaseClass).trim();
        } else {
            pkg = root.elementText(MetaDocConst.NODE_PKG);
            name = root.elementText(MetaDocConst.NODE_NAME);
        }
        ParserHelper.parse(doc, pkg, name, metaType);
    }
}

