/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.client.tools;

import com.kingdee.eas.bs.ml.MLTemplateToolsFacadeFactory;
import com.kingdee.eas.bs.ml.PrintTemplateResourceInfo;
import com.kingdee.eas.bs.ml.client.tools.PrintTemplateInterface;
import com.kingdee.eas.bs.ml.util.MLConstonts;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.util.client.EASResource;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class PrintTemplate
implements PrintTemplateInterface {
    private static Logger logger = Logger.getLogger((String)PrintTemplate.class.getName());
    private static Set suffixList = new HashSet();
    private String rootPath;
    private Map existTemp;

    @Override
    public void start() throws Exception {
        this.registSuffix(".meta");
        this.registSuffix(".bos-query");
        this.registSuffix(".r1-print");
        if (this.rootPath == null || this.rootPath.trim().length() <= 0) {
            return;
        }
        this.existTemp = MLTemplateToolsFacadeFactory.getRemoteInstance().getExistTemplate(MLConstonts.Template_Type_Print);
        File file = new File(this.rootPath);
        this.findFile(file);
    }

    @Override
    public void registSuffix(String suff) {
        suffixList.add(suff);
    }

    @Override
    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    private void findFile(File dir) throws Exception {
        File[] files = dir.listFiles(new FileFilterImpl());
        for (int i = 0; i < files.length; ++i) {
            String language;
            File fl = files[i];
            if (fl.isDirectory()) {
                this.findFile(fl);
                continue;
            }
            String fileName = fl.getName();
            String suffix = fileName.substring(fileName.lastIndexOf(46));
            if (!suffixList.contains(suffix)) {
                return;
            }
            if (".meta".equalsIgnoreCase(suffix)) {
                this.parseMeta(fl, suffix);
                continue;
            }
            if (".bos-query".equalsIgnoreCase(suffix)) {
                this.parseBosQuery(fl, suffix);
                continue;
            }
            if (!".r1-print".equalsIgnoreCase(suffix)) continue;
            if (fileName.lastIndexOf("[") >= 0 && fileName.lastIndexOf("]") > 0 && ("zh_TW".equalsIgnoreCase(language = fileName.substring(fileName.lastIndexOf("[") + 1, fileName.lastIndexOf("]"))) || "en".equalsIgnoreCase(language) || "zh_HK".equalsIgnoreCase(language))) {
                return;
            }
            this.parsePrintTemp(fl, suffix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePrintTemp(File file, String suffix) throws Exception {
        String md5;
        int i;
        String relaPath = this.getRelaPath(file);
        if (relaPath == null) {
            return;
        }
        String fileName = file.getName();
        if (fileName == null || fileName.trim().length() < 1 || fileName.lastIndexOf(46) < 0) {
            return;
        }
        String key = relaPath + "\\" + fileName;
        if (!this.existTemp.containsKey(key)) {
            this.existTemp = MLTemplateToolsFacadeFactory.getRemoteInstance().savePTTemplate(relaPath, fileName);
        }
        String printTempId = this.existTemp.get(key).toString();
        Set existWords = MLTemplateToolsFacadeFactory.getRemoteInstance().getPTExistWords(relaPath, fileName);
        ArrayList<PrintTemplateResourceInfo> newWords = new ArrayList<PrintTemplateResourceInfo>();
        SAXReader saxReader = new SAXReader();
        Document doc = null;
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(file);
            doc = saxReader.read((InputStream)fileInputStream);
        }
        List list = new ArrayList();
        if (doc != null) {
            list = doc.selectNodes("//*[name() = 'DocRoot']/*[name() = 'DataSources']/*[name() = 'Reference']");
        }
        String[] attrNames_cn = new String[]{"alias.zh_CN", "desc.zh_CN"};
        int n = list.size();
        for (int m = 0; m < n; ++m) {
            Element el = (Element)list.get(m);
            for (i = 0; i < attrNames_cn.length; ++i) {
                String value_cn;
                Attribute cn = el.attribute(attrNames_cn[i]);
                if (cn == null || (value_cn = MLUtils.myTrim(cn.getValue())) == null || value_cn.length() <= 0 || !MLUtils.containChinese(value_cn)) continue;
                if (value_cn.length() > 1000) {
                    value_cn = value_cn.substring(0, 1000);
                }
                if (existWords.contains(md5 = MLUtils.md5HashCode(value_cn))) continue;
                PrintTemplateResourceInfo resInfo = new PrintTemplateResourceInfo();
                resInfo.setPrintTempID(printTempId);
                resInfo.setZh_CN(value_cn);
                resInfo.setFileName(fileName);
                resInfo.setFilePath(relaPath);
                resInfo.setMd5(md5);
                newWords.add(resInfo);
            }
        }
        list.clear();
        List lt1 = null;
        List lt2 = null;
        if (doc != null) {
            lt1 = doc.selectNodes("//*[name() = 'Text']/*[name() = 'Data']");
            lt2 = doc.selectNodes("//*[name() = 'TD']/*[name() = 'Value' and @type = 'text']");
        }
        ArrayList arrList = new ArrayList();
        arrList.addAll(lt1);
        arrList.addAll(lt2);
        int j = arrList.size();
        for (i = 0; i < j; ++i) {
            Element el = (Element)arrList.get(i);
            String value = MLUtils.myTrim(el.getText());
            if (value == null || value.length() <= 0 || !MLUtils.containChinese(value)) continue;
            if (value.length() > 1000) {
                value = value.substring(0, 1000);
            }
            if (existWords.contains(md5 = MLUtils.md5HashCode(value))) continue;
            PrintTemplateResourceInfo resInfo = new PrintTemplateResourceInfo();
            resInfo.setPrintTempID(printTempId);
            resInfo.setZh_CN(value);
            resInfo.setFileName(fileName);
            resInfo.setFilePath(relaPath);
            resInfo.setMd5(md5);
            newWords.add(resInfo);
        }
        MLTemplateToolsFacadeFactory.getRemoteInstance().saveTemplateWords(newWords, MLConstonts.Template_Type_Print);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseBosQuery(File file, String suffix) throws Exception {
        String relaPath = this.getRelaPath(file);
        if (relaPath == null) {
            return;
        }
        String fileName = file.getName();
        if (fileName == null || fileName.trim().length() < 1 || fileName.lastIndexOf(46) < 0) {
            return;
        }
        String key = relaPath + "\\" + fileName;
        if (!this.existTemp.containsKey(key)) {
            this.existTemp = MLTemplateToolsFacadeFactory.getRemoteInstance().savePTTemplate(relaPath, fileName);
        }
        String printTempId = this.existTemp.get(key).toString();
        Set existWords = MLTemplateToolsFacadeFactory.getRemoteInstance().getPTExistWords(relaPath, fileName);
        ArrayList<PrintTemplateResourceInfo> newWords = new ArrayList<PrintTemplateResourceInfo>();
        SAXReader saxReader = new SAXReader();
        Document doc = null;
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(file);
            doc = saxReader.read((InputStream)fileInputStream);
        }
        List l1 = null;
        Element root = null;
        if (doc != null) {
            l1 = doc.selectNodes("/*[name() = 'Class']/*[name() = 'Field']");
            root = doc.getRootElement();
        }
        ArrayList<Element> list = new ArrayList<Element>();
        list.add(root);
        list.addAll(l1);
        String[] attrNames_cn = new String[]{"alias.zh_CN", "desc.zh_CN"};
        int n = list.size();
        for (int m = 0; m < n; ++m) {
            Element el = (Element)list.get(m);
            for (int i = 0; i < attrNames_cn.length; ++i) {
                String md5;
                String value_cn;
                Attribute cn = el.attribute(attrNames_cn[i]);
                if (cn == null || (value_cn = MLUtils.myTrim(cn.getValue())) == null || value_cn.length() <= 0 || !MLUtils.containChinese(value_cn)) continue;
                if (value_cn.length() > 1000) {
                    value_cn = value_cn.substring(0, 1000);
                }
                if (existWords.contains(md5 = MLUtils.md5HashCode(value_cn))) continue;
                PrintTemplateResourceInfo resInfo = new PrintTemplateResourceInfo();
                resInfo.setPrintTempID(printTempId);
                resInfo.setZh_CN(value_cn);
                resInfo.setFileName(fileName);
                resInfo.setFilePath(relaPath);
                resInfo.setMd5(md5);
                newWords.add(resInfo);
            }
        }
        MLTemplateToolsFacadeFactory.getRemoteInstance().saveTemplateWords(newWords, MLConstonts.Template_Type_Print);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseMeta(File file, String suffix) throws Exception {
        try (FileInputStream fileInputStream = null;){
            String relaPath = this.getRelaPath(file);
            if (relaPath == null) {
                return;
            }
            String fileName = file.getName();
            if (fileName == null || fileName.trim().length() < 1 || fileName.lastIndexOf(46) < 0) {
                return;
            }
            String key = relaPath + "\\" + fileName;
            if (!this.existTemp.containsKey(key)) {
                this.existTemp = MLTemplateToolsFacadeFactory.getRemoteInstance().savePTTemplate(relaPath, fileName);
            }
            String printTempId = this.existTemp.get(key).toString();
            Set existWords = MLTemplateToolsFacadeFactory.getRemoteInstance().getPTExistWords(relaPath, fileName);
            ArrayList<PrintTemplateResourceInfo> newWords = new ArrayList<PrintTemplateResourceInfo>();
            SAXReader saxReader = new SAXReader();
            fileInputStream = new FileInputStream(file);
            Document doc = saxReader.read((InputStream)fileInputStream);
            List list = doc.selectNodes("/Meta/Nodes/Node");
            String[] attrNames_cn = new String[]{"alias.zh_CN"};
            int n = list.size();
            for (int m = 0; m < n; ++m) {
                Element el = (Element)list.get(m);
                for (int i = 0; i < attrNames_cn.length; ++i) {
                    String md5;
                    String value_cn;
                    Attribute cn = el.attribute(attrNames_cn[i]);
                    if (cn == null || (value_cn = MLUtils.myTrim(cn.getValue())) == null || value_cn.trim().length() <= 0 || !MLUtils.containChinese(value_cn)) continue;
                    if (value_cn.length() > 1000) {
                        value_cn = value_cn.substring(0, 400);
                    }
                    if (existWords.contains(md5 = MLUtils.md5HashCode(value_cn))) continue;
                    PrintTemplateResourceInfo resInfo = new PrintTemplateResourceInfo();
                    resInfo.setPrintTempID(printTempId);
                    resInfo.setZh_CN(value_cn);
                    resInfo.setFileName(fileName);
                    resInfo.setFilePath(relaPath);
                    resInfo.setMd5(md5);
                    newWords.add(resInfo);
                }
            }
            MLTemplateToolsFacadeFactory.getRemoteInstance().saveTemplateWords(newWords, MLConstonts.Template_Type_Print);
        }
    }

    private String getRelaPath(File file) throws Exception {
        String fileSep = System.getProperty("file.separator");
        String path = file.getPath();
        int index = (path = path.substring(0, path.lastIndexOf(fileSep))).lastIndexOf("template");
        if (index < 0) {
            throw new Exception(EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"29_PrintTemplate"));
        }
        path = path.substring(index, path.length());
        if (!fileSep.equals("\\")) {
            path.replaceAll(fileSep, "\\\\");
        }
        return path;
    }

    private static class FileFilterImpl
    implements FileFilter {
        private FileFilterImpl() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName();
            if (name.lastIndexOf(".") < 0) {
                return false;
            }
            String suffix = name.substring(name.lastIndexOf("."));
            return suffixList.contains(suffix);
        }
    }
}

