/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.client.tools;

import com.kingdee.eas.bs.ml.MLTemplateToolsFacadeFactory;
import com.kingdee.eas.bs.ml.client.tools.PrintTemplate;
import com.kingdee.eas.bs.ml.client.tools.PrintTemplateInterface;
import com.kingdee.eas.bs.ml.client.tools.XMLHelper;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.util.client.EASResource;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class PrintWriteResource
implements PrintTemplateInterface {
    private static Logger logger = Logger.getLogger((String)PrintTemplate.class.getName());
    private static Set suffixList = new HashSet();
    private String rootPath;

    @Override
    public void start() throws Exception {
        this.registSuffix(".meta");
        this.registSuffix(".bos-query");
        this.registSuffix(".r1-print");
        if (this.rootPath == null || this.rootPath.trim().length() <= 0) {
            return;
        }
        File file = new File(this.rootPath);
        this.findFile(file);
    }

    @Override
    public void registSuffix(String suff) {
        suffixList.add(suff);
    }

    @Override
    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    private void findFile(File dir) throws Exception {
        File[] files = dir.listFiles(new FileFilterImpl());
        for (int i = 0; i < files.length; ++i) {
            File fl = files[i];
            if (fl.isDirectory()) {
                this.findFile(fl);
                continue;
            }
            String fileName = fl.getName();
            String suffix = fileName.substring(fileName.lastIndexOf(46));
            if (!suffixList.contains(suffix)) {
                return;
            }
            String relaPath = this.getRelaPath(fl);
            if (relaPath == null) {
                return;
            }
            Map words = MLTemplateToolsFacadeFactory.getRemoteInstance().getPTTranslatedWords(relaPath, fileName, "en_US");
            if (words == null || words.size() <= 0) {
                return;
            }
            if (".r1-print".equalsIgnoreCase(suffix)) {
                File file_en = this.getEnTemplate(fl);
                this.parsePrintTemp(file_en, words);
                continue;
            }
            if (".bos-query".equalsIgnoreCase(suffix)) {
                this.parseBosQuery(fl, words);
                continue;
            }
            if (!".meta".equalsIgnoreCase(suffix)) continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePrintTemp(File file, Map words) throws Exception {
        try (FileInputStream fileInputStream = null;){
            String md5;
            String value_en;
            int i;
            SAXReader saxReader = new SAXReader();
            fileInputStream = new FileInputStream(file);
            Document doc = saxReader.read((InputStream)fileInputStream);
            List list = doc.selectNodes("/*[name() = 'DocRoot']/*[name() = 'DataSources']/*[name() = 'Reference']");
            String[] attrNames_cn = new String[]{"alias.zh_CN", "desc.zh_CN"};
            String[] attrNames_en = new String[]{"alias.en", "desc.en"};
            int n = list.size();
            for (int m = 0; m < n; ++m) {
                Element el = (Element)list.get(m);
                for (i = 0; i < attrNames_cn.length; ++i) {
                    String value_cn;
                    Attribute cn = el.attribute(attrNames_cn[i]);
                    if (cn == null || (value_cn = MLUtils.myTrim(cn.getValue())) == null || value_cn.length() <= 0 || (value_en = MLUtils.containChinese(value_cn) ? (words.containsKey(md5 = MLUtils.md5HashCode(value_cn)) ? words.get(md5).toString() : null) : value_cn) == null) continue;
                    Attribute en = el.attribute(attrNames_en[i]);
                    if (en == null) {
                        el.addAttribute(attrNames_en[i], value_en);
                        continue;
                    }
                    en.setValue(value_en);
                }
            }
            list.clear();
            List lt1 = doc.selectNodes("//*[name() = 'Text']/*[name() = 'Data']");
            List lt2 = doc.selectNodes("//*[name() = 'TD']/*[name() = 'Value' and @type = 'text']");
            ArrayList arrList = new ArrayList();
            arrList.addAll(lt1);
            arrList.addAll(lt2);
            int j = arrList.size();
            for (i = 0; i < j; ++i) {
                Element el = (Element)arrList.get(i);
                String value = MLUtils.myTrim(el.getText());
                if (value == null || value.length() <= 0 || (value_en = MLUtils.containChinese(value) ? (words.containsKey(md5 = MLUtils.md5HashCode(value)) ? words.get(md5).toString() : null) : value) == null) continue;
                el.clearContent();
                el.addCDATA(value_en);
            }
            XMLHelper.writeXML(doc, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseBosQuery(File file, Map words) throws Exception {
        if (file == null) {
            return;
        }
        SAXReader saxReader = new SAXReader();
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(file);
        }
        Document doc = saxReader.read((InputStream)fileInputStream);
        List l1 = doc.selectNodes("/*[name() = 'Class']/*[name() = 'Field']");
        Element root = doc.getRootElement();
        ArrayList<Element> list = new ArrayList<Element>();
        list.add(root);
        list.addAll(l1);
        String[] attrNames_cn = new String[]{"alias.zh_CN", "desc.zh_CN"};
        String[] attrNames_en = new String[]{"alias.en", "desc.en"};
        int n = list.size();
        for (int m = 0; m < n; ++m) {
            Element el = (Element)list.get(m);
            for (int i = 0; i < attrNames_cn.length; ++i) {
                String md5;
                String value_en;
                String value_cn;
                Attribute cn = el.attribute(attrNames_cn[i]);
                if (cn == null || (value_cn = MLUtils.myTrim(cn.getValue())) == null || value_cn.length() <= 0 || (value_en = MLUtils.containChinese(value_cn) ? (words.containsKey(md5 = MLUtils.md5HashCode(value_cn)) ? words.get(md5).toString() : null) : value_cn) == null) continue;
                Attribute en = el.attribute(attrNames_en[i]);
                if (en == null) {
                    el.addAttribute(attrNames_en[i], value_en);
                    continue;
                }
                en.setValue(value_en);
            }
        }
        XMLHelper.writeXML(doc, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseMeta(File file, Map words) throws Exception {
        if (file == null || words == null || words.size() <= 0) {
            return;
        }
        SAXReader saxReader = new SAXReader();
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(file);
        }
        Document doc = saxReader.read((InputStream)fileInputStream);
        List list = doc.selectNodes("/Meta/Nodes/Node");
        String[] attrNames_cn = new String[]{"alias.zh_CN"};
        String[] attrNames_en = new String[]{"alias.en"};
        int n = list.size();
        for (int m = 0; m < n; ++m) {
            Element el = (Element)list.get(m);
            for (int i = 0; i < attrNames_cn.length; ++i) {
                String md5;
                String value_en;
                String value_cn;
                Attribute cn = el.attribute(attrNames_cn[i]);
                if (cn == null || (value_cn = MLUtils.myTrim(cn.getValue())) == null || value_cn.length() <= 0 || (value_en = MLUtils.containChinese(value_cn) ? (words.containsKey(md5 = MLUtils.md5HashCode(value_cn)) ? words.get(md5).toString() : null) : value_cn) == null) continue;
                Attribute en = el.attribute(attrNames_en[i]);
                if (en == null) {
                    el.addAttribute(attrNames_en[i], value_en);
                    continue;
                }
                en.setValue(value_en);
            }
        }
        XMLHelper.writeXML(doc, file);
    }

    private File getEnTemplate(File file_zh) throws Exception {
        String fileName = file_zh.getName();
        String path = file_zh.getCanonicalPath();
        path = path.replaceAll("\\\\", "/");
        path = path.substring(0, path.lastIndexOf("/") + 1);
        String preffix = fileName.substring(0, fileName.lastIndexOf(".r1-print"));
        fileName = preffix + "[EN].r1-print";
        File file_en = new File(path + fileName);
        if (!file_en.exists()) {
            file_en.createNewFile();
            this.copyFile2(file_zh, file_en);
        }
        return file_en;
    }

    private void copyFile2(File file_zh, File file_en) throws IOException {
        AbstractInterruptibleChannel zh = null;
        AbstractInterruptibleChannel en = null;
        RandomAccessFile ra1 = null;
        RandomAccessFile ra2 = null;
        try {
            ra1 = new RandomAccessFile(file_zh, "r");
            zh = ra1.getChannel();
            ra2 = new RandomAccessFile(file_en, "rws");
            en = ra2.getChannel();
            ((FileChannel)zh).transferTo(0L, ((FileChannel)zh).size(), (WritableByteChannel)((Object)en));
            ((FileChannel)en).force(true);
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (zh != null) {
                zh.close();
            }
            if (en != null) {
                en.close();
            }
            if (ra1 != null) {
                ra1.close();
            }
            if (ra2 != null) {
                ra2.close();
            }
        }
    }

    private String getRelaPath(File file) throws Exception {
        String fileSep = System.getProperty("file.separator");
        String path = file.getPath();
        int index = (path = path.substring(0, path.lastIndexOf(fileSep))).lastIndexOf("template");
        if (index < 0) {
            throw new Exception(EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"29_PrintTemplate"));
        }
        path = path.substring(index, path.length());
        if (!fileSep.equals("\\")) {
            path.replaceAll(fileSep, "\\\\");
        }
        return path;
    }

    private static class FileFilterImpl
    implements FileFilter {
        private FileFilterImpl() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName();
            if (name.lastIndexOf(".") < 0) {
                return false;
            }
            String suffix = name.substring(name.lastIndexOf("."));
            return suffixList.contains(suffix);
        }
    }
}

