/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.client.tools;

import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.LineBorder;

public class ProgressBarUtil
implements ActionListener {
    private static final String DEFAULT_STATUS = "Please Waiting";
    private JDialog dialog;
    private JProgressBar progressBar;
    private JLabel lbStatus;
    private JButton btnCancel;
    private Window parent;
    private Thread thread;
    private String statusInfo;
    private String resultInfo;
    private String cancelInfo;

    public static void show(Window parent, Thread thread) {
        new ProgressBarUtil(parent, thread, DEFAULT_STATUS, null, null);
    }

    public static void show(Window parent, Thread thread, String statusInfo) {
        new ProgressBarUtil(parent, thread, statusInfo, null, null);
    }

    public static void show(Window parent, Thread thread, String statusInfo, String resultInfo, String cancelInfo) {
        new ProgressBarUtil(parent, thread, statusInfo, resultInfo, cancelInfo);
    }

    private ProgressBarUtil(Window parent, Thread thread, String statusInfo, String resultInfo, String cancelInfo) {
        this.parent = parent;
        this.thread = thread;
        this.statusInfo = statusInfo;
        this.resultInfo = resultInfo;
        this.cancelInfo = cancelInfo;
        this.initUI();
        this.startThread();
        this.dialog.setVisible(true);
    }

    private void initUI() {
        this.dialog = this.parent instanceof Dialog ? new JDialog((Dialog)this.parent, true) : (this.parent instanceof Frame ? new JDialog((Frame)this.parent, true) : new JDialog((Frame)null, true));
        final JPanel mainPane = new JPanel(null);
        this.progressBar = new JProgressBar();
        this.lbStatus = new JLabel("" + this.statusInfo);
        this.btnCancel = new JButton("Cancel");
        this.progressBar.setIndeterminate(true);
        this.btnCancel.addActionListener(this);
        mainPane.add(this.progressBar);
        mainPane.add(this.lbStatus);
        mainPane.setBorder(new LineBorder(Color.BLACK));
        this.dialog.getContentPane().add(mainPane);
        this.dialog.setUndecorated(true);
        this.dialog.setResizable(false);
        this.dialog.setSize(390, 100);
        this.dialog.setLocationRelativeTo(this.parent);
        this.dialog.setDefaultCloseOperation(0);
        mainPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ProgressBarUtil.this.layout(mainPane.getWidth(), mainPane.getHeight());
            }
        });
    }

    private void startThread() {
        new Thread(){

            @Override
            public void run() {
                try {
                    ProgressBarUtil.this.thread.start();
                    ProgressBarUtil.this.thread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(ProgressBarUtil.this.parent, EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"30_ProgressBarUtil"), "", 2);
                }
                finally {
                    ProgressBarUtil.this.dialog.dispose();
                    if (ProgressBarUtil.this.resultInfo != null && !ProgressBarUtil.this.resultInfo.trim().equals("")) {
                        String title = "Info";
                        JOptionPane.showMessageDialog(ProgressBarUtil.this.parent, ProgressBarUtil.this.resultInfo, title, 1);
                    }
                }
            }
        }.start();
    }

    private void layout(int width, int height) {
        this.progressBar.setBounds(20, 20, 350, 15);
        this.lbStatus.setBounds(20, 50, 350, 25);
        this.btnCancel.setBounds(width - 85, height - 31, 75, 21);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.resultInfo = this.cancelInfo;
        this.thread.stop();
    }

    public static void main(String[] args) throws Exception {
        Thread thread = new Thread(){

            @Override
            public void run() {
                int index = 0;
                while (index < 5) {
                    try {
                        3.sleep(1000L);
                        System.out.println(++index);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        ProgressBarUtil.show(null, thread, "Status", "Result", "Cancel");
    }
}

