/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.client.tools;

import com.kingdee.eas.bs.ml.MLToolsFacadeFactory;
import com.kingdee.eas.bs.ml.ResourceInfo;
import com.kingdee.eas.bs.ml.util.MLUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class PropertiesFileResourceParser {
    private static Logger logger = Logger.getLogger((String)PropertiesFileResourceParser.class.getName());
    private String sp = System.getProperty("file.separator");
    private Pattern pkgPattern;
    private String rootPath;

    public static void main(String[] args) {
    }

    public void init() {
        if (this.sp.equals("\\")) {
            this.pkgPattern = Pattern.compile("(com\\\\kingdee\\\\.*)\\\\[^\\\\]*$", 2);
        } else if (this.sp.equals("/")) {
            this.pkgPattern = Pattern.compile("(com/kingdee/.*)/[^/]*$");
        }
    }

    public void start() throws Exception {
        this.init();
        if (this.rootPath == null || this.rootPath.trim().length() <= 0) {
            return;
        }
        File file = new File(this.rootPath);
        this.fetchWords(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchWords(File file) throws Exception {
        if (file.isDirectory()) {
            File[] arr = file.listFiles(new FileFilterImpl());
            for (int i = 0; i < arr.length; ++i) {
                this.fetchWords(arr[i]);
            }
        } else {
            String fileName = file.getName().trim();
            int idx = fileName.lastIndexOf(95);
            if (idx < 0) {
                return;
            }
            fileName = fileName.substring(0, idx);
            String filePath = file.getPath();
            String pkg = this.getPackage(filePath);
            if (pkg == null) {
                return;
            }
            String metaType = this.getMetaType(fileName);
            if (metaType == null) {
                return;
            }
            Map existWords = MLToolsFacadeFactory.getRemoteInstance().getExistResource(pkg, fileName, metaType);
            if (existWords == null) {
                existWords = Collections.EMPTY_MAP;
            }
            Properties prop = new Properties();
            try (FileInputStream fileInputStream = null;){
                fileInputStream = new FileInputStream(file);
                prop.load(fileInputStream);
            }
            ArrayList<ResourceInfo> resList = new ArrayList<ResourceInfo>();
            Set<Map.Entry<Object, Object>> set = prop.entrySet();
            for (Map.Entry<Object, Object> entry : set) {
                ResourceInfo resInfo;
                String key;
                if (entry.getKey() == null || (key = MLUtils.myTrim(entry.getKey().toString())).length() <= 0) continue;
                if (entry.getValue() == null) {
                    String string = "";
                }
                String zh_CN = MLUtils.myTrim(entry.getValue().toString().trim());
                if (!existWords.containsKey(key)) {
                    resInfo = new ResourceInfo();
                    resInfo.setZh_CN(zh_CN);
                    resInfo.setPkg(pkg);
                    resInfo.setFileName(fileName);
                    resInfo.setKey(key);
                    resInfo.setMetaType(metaType);
                    resList.add(resInfo);
                    continue;
                }
                if (zh_CN.equals(existWords.get(key))) continue;
                resInfo = new ResourceInfo();
                resInfo.setZh_CN(zh_CN);
                resInfo.setPkg(pkg);
                resInfo.setFileName(fileName);
                resInfo.setKey(key);
                resInfo.setMetaType(metaType);
                resInfo.setUpdate(true);
                resList.add(resInfo);
            }
            MLToolsFacadeFactory.getRemoteInstance().saveResource(resList, metaType);
        }
    }

    private String getMetaType(String fileName) {
        if (fileName == null) {
            return null;
        }
        if (fileName.endsWith("UI")) {
            return "ui";
        }
        if (fileName.endsWith("Resource")) {
            return "resource";
        }
        if (fileName.endsWith("Enum")) {
            return "enum";
        }
        if (fileName.endsWith("Exception")) {
            return "exception";
        }
        if (fileName.equals("FindDialog") || fileName.equals("MoveTree")) {
            return "ui";
        }
        return "resource";
    }

    private String getPackage(String path) {
        if (this.pkgPattern == null || path == null) {
            return null;
        }
        Matcher m = this.pkgPattern.matcher(path);
        Object pkg = null;
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    private static class FileFilterImpl
    implements FileFilter {
        private FileFilterImpl() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName();
            if (name.lastIndexOf("_") < 0) {
                return false;
            }
            String suffix = name.substring(name.lastIndexOf("_"));
            return "_l2.properties".equalsIgnoreCase(suffix.toLowerCase());
        }
    }
}

