/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.client.tools;

import com.kingdee.eas.bs.ml.MultiFieldInfo;
import com.kingdee.eas.bs.ml.client.tools.MDResourceParser;
import com.kingdee.eas.bs.ml.client.tools.MetaDocConst;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class TableMultiFieldParser
implements MDResourceParser {
    private TableMultiFieldParser() {
    }

    public static TableMultiFieldParser getInstance() {
        return new TableMultiFieldParser();
    }

    @Override
    public List parser(Document doc, Map existMLFields, String metaType) throws Exception {
        List existFields;
        if (doc == null || existMLFields == null || metaType == null) {
            return Collections.EMPTY_LIST;
        }
        if (!"table".equalsIgnoreCase(metaType)) {
            return Collections.EMPTY_LIST;
        }
        Element tabNameEl = doc.getRootElement().element(MetaDocConst.NODE_NAME);
        if (tabNameEl == null || tabNameEl.getTextTrim() == null) {
            return Collections.EMPTY_LIST;
        }
        String tableName = tabNameEl.getTextTrim();
        Element pkgEl = doc.getRootElement().element(MetaDocConst.NODE_PKG);
        String project = null;
        if (pkgEl != null) {
            project = pkgEl.getTextTrim();
            if ((project = project.replaceAll("com.kingdee.eas.", "")).indexOf(".") > 0) {
                project = project.substring(0, project.indexOf("."));
            }
        }
        if ((existFields = (List)existMLFields.get(tableName)) == null) {
            return Collections.EMPTY_LIST;
        }
        String xpath = "//*[name() = 'dataTable']/*[name() = 'columns']/*[name() = 'column']";
        List columnNodes = doc.selectNodes(xpath);
        ArrayList<MultiFieldInfo> newFields = new ArrayList<MultiFieldInfo>();
        for (int i = 0; i < columnNodes.size(); ++i) {
            String fieldName;
            Element columnEL = (Element)columnNodes.get(i);
            Element e = columnEL.element("isMultilingual");
            if (e == null || "false".equalsIgnoreCase(e.getTextTrim()) || existFields.contains((fieldName = columnEL.elementTextTrim("name")).toLowerCase())) continue;
            MultiFieldInfo info = new MultiFieldInfo();
            info.setTableName(tableName);
            info.setProject(project);
            info.set_l1(fieldName + "_L1");
            info.set_l2(fieldName + "_L2");
            info.set_l3(fieldName + "_L3");
            newFields.add(info);
        }
        return newFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        FileInputStream fi = null;
        try {
            File file = new File("W:/T_HR_ResumeBase.table");
            fi = new FileInputStream(file);
            SAXReader reader = new SAXReader();
            Document doc = reader.read((InputStream)fi);
            new TableMultiFieldParser().parser(doc, new HashMap(), "table");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (fi != null) {
                try {
                    fi.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

