/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.client.tools;

import com.kingdee.eas.bs.ml.MLTemplateToolsFacadeFactory;
import com.kingdee.eas.bs.ml.WorkFlowResourceInfo;
import com.kingdee.eas.bs.ml.client.tools.XMLHelper;
import com.kingdee.eas.bs.ml.util.MLConstonts;
import com.kingdee.eas.bs.ml.util.MLUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public class WorkflowTemplate {
    private static Logger logger = Logger.getLogger((String)WorkflowTemplate.class.getName());
    private static List suffixList = new ArrayList();
    private String rootPath;
    private Map existTemp;
    public static int FETCH = 1;
    public static int WRITE = 2;

    public void start(int type) throws Exception {
        this.registSuffix("kdwf");
        if (this.rootPath == null || this.rootPath.trim().length() <= 0) {
            return;
        }
        this.existTemp = MLTemplateToolsFacadeFactory.getRemoteInstance().getExistTemplate(MLConstonts.Template_Type_WorkFlow);
        File file = new File(this.rootPath);
        this.fetchWords(file, type);
    }

    public void registSuffix(String suff) {
        suffixList.add(suff);
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fetchWords(File file, int type) throws Exception {
        if (file.isDirectory()) {
            File[] arr = file.listFiles(new FileFilterImpl());
            for (int i = 0; i < arr.length; ++i) {
                this.fetchWords(arr[i], type);
            }
            return;
        } else {
            String fileName = file.getName();
            int idx = fileName.lastIndexOf(".");
            if (idx < 0) {
                return;
            }
            String suffix = fileName.substring(idx + 1);
            if (!suffixList.contains(suffix)) {
                return;
            }
            try {
                if (type == FETCH) {
                    this.parseFile(file);
                    return;
                }
                if (type != WRITE) return;
                this.updateTempMLRes(file);
                return;
            }
            catch (Exception e) {
                logger.error((Object)("parse file " + file.getName() + " error!"));
                logger.error((Object)e.getMessage());
                throw e;
            }
        }
    }

    public void parseFile(File file) throws Exception {
        if (file == null || !file.exists()) {
            return;
        }
        ArrayList<WorkFlowResourceInfo> newWords = new ArrayList<WorkFlowResourceInfo>();
        try (FileInputStream fileInputStream = null;){
            SAXReader saxReader = new SAXReader();
            fileInputStream = new FileInputStream(file);
            Document doc = saxReader.read((InputStream)fileInputStream);
            if (doc == null) {
                return;
            }
            String xpath = "//*[name() = 'Resources']/*[name() = 'Resource']/Language[@Locale = 'l2' or @Locale = 'zh_CN']";
            Element root = doc.getRootElement();
            List list = doc.selectNodes(xpath);
            if (root == null || list == null || list.size() <= 0) {
                return;
            }
            String procId = root.attributeValue("Id");
            String code = root.attributeValue("Code");
            if (procId == null) {
                return;
            }
            if (!this.existTemp.containsKey(procId)) {
                this.existTemp = MLTemplateToolsFacadeFactory.getRemoteInstance().saveWFTemplate(procId, code);
            }
            Set existWords = MLTemplateToolsFacadeFactory.getRemoteInstance().getWFExistWords(procId);
            int j = list.size();
            for (int i = 0; i < j; ++i) {
                String md5;
                String zh;
                Element el = (Element)list.get(i);
                Element resourceEl = el.getParent();
                List languageNodes = resourceEl.selectNodes("Language[@Locale = 'l2' or @Locale = 'zh_CN']");
                if (languageNodes != null && languageNodes.size() == 2 && "zh_CN".equals(el.attribute("Locale").getValue()) || (zh = MLUtils.myTrim(el.getText())) == null || zh.length() <= 0 || !MLUtils.containChinese(zh)) continue;
                if (zh.length() > 1000) {
                    zh = zh.substring(0, 1000).trim();
                }
                if (existWords.contains(md5 = MLUtils.md5HashCode(zh))) continue;
                WorkFlowResourceInfo info = new WorkFlowResourceInfo();
                info.setWorkFlowTempID(this.existTemp.get(procId).toString());
                info.setZh_CN(zh);
                info.setMd5(md5);
                if (!MLUtils.containChinese(zh)) {
                    info.setEn_US(zh);
                    info.setZh_TW(zh);
                }
                newWords.add(info);
            }
            MLTemplateToolsFacadeFactory.getRemoteInstance().saveTemplateWords(newWords, MLConstonts.Template_Type_WorkFlow);
        }
    }

    public void updateTempMLRes(File file) throws Exception {
        if (file == null || !file.exists() || file.isDirectory()) {
            return;
        }
        SAXReader saxReader = new SAXReader();
        FileInputStream fs = new FileInputStream(file);
        Document doc = saxReader.read((InputStream)fs);
        fs.close();
        if (doc == null) {
            return;
        }
        Element root = doc.getRootElement();
        if (root == null) {
            return;
        }
        String procId = root.attributeValue("Id");
        Map translatedWords = MLTemplateToolsFacadeFactory.getRemoteInstance().getWFTranslatedWords(procId, "en_US");
        if (translatedWords == null || translatedWords.size() <= 0) {
            return;
        }
        String xpath = "//*[name() = 'Resources']/*[name() = 'Resource']/Language[@Locale = 'l2' or @Locale = 'zh_CN']";
        List list = doc.selectNodes(xpath);
        int j = list.size();
        for (int i = 0; i < j; ++i) {
            String mlRes;
            String zh;
            Element el = (Element)list.get(i);
            Element resourceEl = el.getParent();
            List languageNodes = resourceEl.selectNodes("Language[@Locale = 'l2' or @Locale = 'zh_CN']");
            if (languageNodes != null && languageNodes.size() == 2 && "zh_CN".equals(el.attribute("Locale").getValue()) || (zh = MLUtils.myTrim(el.getText())) == null || zh.length() <= 0) continue;
            if (!MLUtils.containChinese(zh)) {
                mlRes = zh;
            } else {
                String md5 = MLUtils.md5HashCode(zh);
                Object obj = translatedWords.get(md5);
                if (obj == null) continue;
                mlRes = translatedWords.get(md5).toString();
            }
            List enNodes = resourceEl.selectNodes("Language[@Locale = 'l1']");
            if (enNodes != null && enNodes.size() > 0) {
                Element enNode = (Element)enNodes.get(0);
                enNode.clearContent();
                enNode.addCDATA(mlRes);
                continue;
            }
            QName qn = DocumentHelper.createQName((String)"Language", (Namespace)DocumentHelper.createNamespace((String)"", (String)""));
            Element enNode = DocumentHelper.createElement((QName)qn);
            enNode.addAttribute("Locale", "l1");
            enNode.add(DocumentHelper.createCDATA((String)mlRes));
            resourceEl.add(enNode);
        }
        XMLHelper.writeXML(doc, file);
    }

    private static class FileFilterImpl
    implements FileFilter {
        private FileFilterImpl() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName();
            if (name.lastIndexOf(".") < 0) {
                return false;
            }
            String suffix = name.substring(name.lastIndexOf(".") + 1);
            return suffixList.contains(suffix);
        }
    }
}

