/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.smartmalle;

import com.kingdee.bos.Context;
import com.kingdee.bos.rpc.io.loadbalance.IRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.RPCServerView;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.eas.bs.ml.smartmalle.ISynCleanMallECachesAndMarksUtil;
import com.kingdee.eas.bs.ml.smartmalle.util.IMallERobCachesAndMarksUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class SynCleanMallECachesAndMarksUtilFactory
implements ISynCleanMallECachesAndMarksUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.bs.ml.smartmalle.SynCleanMallEMarksFactory");
    private List<IMallERobCachesAndMarksUtil> servers = new ArrayList<IMallERobCachesAndMarksUtil>();

    @Override
    public void synCleanCache() {
        int size = this.servers.size();
        for (int i = 0; i < size; ++i) {
            try {
                this.servers.get(i).clearCache();
                continue;
            }
            catch (Throwable th) {
                logger.error((Object)"\u6e05\u9664\u5176\u4ed6\u5b9e\u4f8b\u7f13\u5b58\u51fa\u9519", th);
            }
        }
    }

    @Override
    public void closeServerMallEOn(Context ctx) {
        int size = this.servers.size();
        for (int i = 0; i < size; ++i) {
            try {
                this.servers.get(i).closeServerMallEOn(null);
                continue;
            }
            catch (Throwable th) {
                logger.error((Object)"\u5173\u95ed\u5176\u4ed6MallE\u51fa\u9519", th);
            }
        }
    }

    private SynCleanMallECachesAndMarksUtilFactory() {
    }

    public static ISynCleanMallECachesAndMarksUtil getInstance() {
        SynCleanMallECachesAndMarksUtilFactory syn = new SynCleanMallECachesAndMarksUtilFactory();
        RPCServerView sv = RPCServerView.getLast();
        if (sv == null) {
            return syn;
        }
        IRPCServer[] ss = sv.getServers();
        String url = null;
        for (int i = 0; i < ss.length; ++i) {
            try {
                IRPCServer s = ss[i];
                if (s.connectionFailed() || StringUtils.isEmpty((String)(url = s.getUrl())) || SynCleanMallECachesAndMarksUtilFactory.isLocal(url)) continue;
                IMallERobCachesAndMarksUtil pcs = (IMallERobCachesAndMarksUtil)RPCEngineFactory.getEngine((String)url).createObject("com.kingdee.eas.bs.ml.smartmalle.MallERobComponentServer", IMallERobCachesAndMarksUtil.class);
                syn.servers.add(pcs);
                continue;
            }
            catch (Throwable th) {
                logger.error((Object)("url: " + url + "----" + th.getMessage()), th);
            }
        }
        return syn;
    }

    private static boolean isLocal(String url) {
        IServer[] servers = ServerManager.listServers();
        for (int i = 0; i < servers.length; ++i) {
            if (!servers[i].match(url)) continue;
            return true;
        }
        return false;
    }
}

