/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.smartmalle.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.bs.ml.smartmalle.MallEAssistor;
import com.kingdee.eas.bs.ml.smartmalle.MallEResourceInfo;
import com.kingdee.eas.bs.ml.smartmalle.util.MallEMDResourceParser;
import com.kingdee.eas.bs.ml.util.MLToolsConstonts;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.bs.ml.util.MetaDocConst;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class MallEUIResourceParser
implements MallEMDResourceParser {
    private static Set ignoreProp = new HashSet();
    private static Pattern uiDescPtn;
    private static Pattern uiResKeyPtn;
    private static Pattern uiActionResKeyPtn;

    private MallEUIResourceParser() {
    }

    public static MallEUIResourceParser getInstance() {
        return new MallEUIResourceParser();
    }

    @Override
    public List parser(Context ctx, Document doc, Map completedWords, Map mulExistsWords, Map resWords, String metaType, String lan) throws Exception {
        String project;
        if (doc == null || metaType == null) {
            return Collections.EMPTY_LIST;
        }
        if (!"ui".equalsIgnoreCase(metaType)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<MallEResourceInfo> uiResList = new ArrayList<MallEResourceInfo>();
        Element root = doc.getRootElement();
        String pkg = root.elementText(MetaDocConst.NODE_UI_ReleasePackage);
        if (pkg == null || "".equals(pkg)) {
            pkg = root.elementText(MetaDocConst.NODE_PKG);
        }
        if ((project = pkg.replaceAll("com.kingdee.eas.", "")).indexOf(".") > 0) {
            project = project.substring(0, project.indexOf("."));
        }
        pkg = pkg.replaceAll("\\.", "\\\\");
        String name = root.elementText(MetaDocConst.NODE_UI_ReleaseClass);
        if (name == null || "".equals(name)) {
            name = root.elementText(MetaDocConst.NODE_NAME);
        }
        Map actions = this.getActions(root);
        this.parseConstraintsNode(ctx, root, name, pkg, completedWords, mulExistsWords, resWords, uiResList, lan);
        Element resourceElement = root.element(MetaDocConst.NODE_RES);
        if (resourceElement == null) {
            return Collections.EMPTY_LIST;
        }
        Iterator rsIt = resourceElement.elementIterator();
        block0: while (rsIt.hasNext()) {
            String md5;
            String zh_CN;
            String locale;
            Element localeElement;
            Iterator langIt;
            int idx;
            String suffix;
            Element rsElement = (Element)rsIt.next();
            String key = this.getUIResKey(rsElement.attribute(MetaDocConst.ATT_KEY).getText(), actions);
            if (key == null || ignoreProp.contains(suffix = (idx = key.lastIndexOf(46)) > 0 ? key.substring(idx + 1) : key)) continue;
            if (key.endsWith(".border")) {
                key = key + ".title";
            }
            if (key.endsWith(".formatXml")) {
                langIt = rsElement.elementIterator();
                while (langIt.hasNext()) {
                    localeElement = (Element)langIt.next();
                    if (localeElement == null || localeElement.attribute("locale") == null || !(locale = localeElement.attribute("locale").getText()).equals("zh_CN")) continue;
                    zh_CN = localeElement.attribute("value").getText();
                    if (zh_CN == null || zh_CN.trim().length() <= 0) continue block0;
                    md5 = MLUtils.md5HashCode(zh_CN);
                    Map map = this.getFormatXmlRes(key.substring(0, key.lastIndexOf(46)), zh_CN);
                    Set fxSet = map.entrySet();
                    for (Map.Entry entry : fxSet) {
                        MallEResourceInfo resInfo;
                        String mul;
                        String fxK = entry.getKey().toString();
                        String fxVl = MLUtils.myTrim(entry.getValue().toString());
                        String fxVlMD5 = MLUtils.md5HashCode(fxVl);
                        if (fxK == null || fxVl == null) continue;
                        boolean hascnwords = true;
                        boolean hasMulWords = true;
                        boolean hasTrans = false;
                        if (!completedWords.containsKey(fxK)) {
                            if (!mulExistsWords.containsKey(fxK)) {
                                hasMulWords = false;
                            }
                            if (!resWords.containsKey(fxK)) {
                                hascnwords = false;
                            }
                            mul = MallEAssistor.AutoTranslator.autoTranslate(ctx, pkg, name, fxVl, lan, fxVlMD5, metaType);
                            resInfo = new MallEResourceInfo(fxVl, mul, pkg, name, fxK, "UI", false, hascnwords, hasMulWords, hasTrans);
                            uiResList.add(resInfo);
                            continue;
                        }
                        if (fxVlMD5.equals(completedWords.get(fxK))) continue;
                        mul = MallEAssistor.AutoTranslator.autoTranslate(ctx, pkg, name, fxVl, lan, fxVlMD5, metaType);
                        resInfo = new MallEResourceInfo(fxVl, mul, pkg, name, fxK, "UI", true, hascnwords, hasMulWords, hasTrans);
                        uiResList.add(resInfo);
                    }
                }
                continue;
            }
            langIt = rsElement.elementIterator();
            while (langIt.hasNext()) {
                MallEResourceInfo resInfo;
                String mul;
                localeElement = (Element)langIt.next();
                locale = localeElement.attribute("locale").getText();
                if (!locale.equals("zh_CN")) continue;
                zh_CN = MLUtils.myTrim(localeElement.attribute("value").getText());
                if (zh_CN == null || zh_CN.length() <= 0 || !this.isValidRes(zh_CN) || key.endsWith(".items") && zh_CN.startsWith("[Enum]")) continue block0;
                if (key.endsWith("border.title")) {
                    zh_CN = MLUtils.myTrim(this.getBorderTitle(zh_CN));
                }
                md5 = MLUtils.md5HashCode(zh_CN);
                boolean hascnwords = true;
                boolean hasMulWords = true;
                boolean hasTrans = false;
                if (!completedWords.containsKey(key)) {
                    if (!mulExistsWords.containsKey(key)) {
                        hasMulWords = false;
                    }
                    if (!resWords.containsKey(key)) {
                        hascnwords = false;
                    }
                    mul = MallEAssistor.AutoTranslator.autoTranslate(ctx, pkg, name, zh_CN, lan, md5, metaType);
                    resInfo = new MallEResourceInfo(zh_CN, mul, pkg, name, key, "UI", false, hascnwords, hasMulWords, hasTrans);
                    uiResList.add(resInfo);
                    continue;
                }
                if (md5 == null || md5.equals(completedWords.get(key))) continue;
                mul = MallEAssistor.AutoTranslator.autoTranslate(ctx, pkg, name, zh_CN, lan, md5, metaType);
                resInfo = new MallEResourceInfo(zh_CN, mul, pkg, name, key, "UI", true, hascnwords, hasMulWords, hasTrans);
                uiResList.add(resInfo);
            }
        }
        return uiResList;
    }

    private Map getFormatXmlRes(String tblName, String formatXml) throws Exception {
        if (tblName == null || formatXml == null) {
            return Collections.EMPTY_MAP;
        }
        SAXReader reader = new SAXReader();
        StringReader in = new StringReader(formatXml);
        Document doc = null;
        try {
            doc = reader.read((Reader)in);
        }
        catch (Exception ex) {
            System.out.println(tblName);
            return Collections.EMPTY_MAP;
        }
        String colPath = "//*[name() = 'Table']/*[name() = 't:Sheet']/*[name() = 't:Table']/*[name() = 't:ColumnGroup']/*[name() = 't:Column']";
        List colList = doc.selectNodes(colPath);
        ArrayList<String> keyList = new ArrayList<String>();
        int j = colList.size();
        for (int i = 0; i < j; ++i) {
            Element el = (Element)colList.get(i);
            keyList.add(el.attribute("key").getValue());
        }
        String headRowPath = "//*[name() = 't:Head']/*[name() = 't:Row']";
        List rowList = doc.selectNodes(headRowPath);
        String prefix = tblName + ".";
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < rowList.size(); ++i) {
            Element rowEl = (Element)rowList.get(i);
            List cells = rowEl.elements();
            if (cells.size() > keyList.size()) continue;
            int n = cells.size();
            for (int m = 0; m < n; ++m) {
                Element cellEl = (Element)cells.get(m);
                String resKey = prefix + keyList.get(m);
                if (i > 0) {
                    resKey = resKey + MLToolsConstonts.TABLE_MULTI_HEADER + (i + 1);
                }
                map.put(resKey, cellEl.getTextTrim());
            }
        }
        return map;
    }

    private void parseConstraintsNode(Context ctx, Element root, String fileName, String pkg, Map completedWords, Map mulExistsWords, Map resWords, List uiResList, String lan) throws Exception {
        Element components = root.element("components");
        if (components == null) {
            return;
        }
        List list = components.elements();
        for (int i = 0; i < list.size(); ++i) {
            Element component = (Element)list.get(i);
            String str = MLUtils.myTrim(component.elementText("constraints"));
            String md5 = MLUtils.md5HashCode(str);
            String componentName = component.elementText("name");
            if (!MLUtils.containChinese(str) || componentName == null) continue;
            String key = componentName + ".constraints";
            boolean hascnwords = true;
            boolean hasmulwords = true;
            if (!completedWords.containsKey(key)) {
                boolean hasTrans = false;
                if (!mulExistsWords.containsKey(key)) {
                    hasmulwords = false;
                }
                if (!resWords.containsKey(key)) {
                    hascnwords = false;
                }
                String trans = MallEAssistor.AutoTranslator.autoTranslate(ctx, pkg, fileName, str, lan, md5, "ui");
                MallEResourceInfo resInfo = new MallEResourceInfo(str, trans, pkg, fileName, key, "UI", false, hascnwords, hasmulwords, hasTrans);
                uiResList.add(resInfo);
                continue;
            }
            if (str.equals(completedWords.get(key))) continue;
            String trans = MallEAssistor.AutoTranslator.autoTranslate(ctx, pkg, fileName, str, lan, md5, "ui");
            MallEResourceInfo resInfo = new MallEResourceInfo(str, trans, pkg, fileName, key, "UI", true, hascnwords, hasmulwords, false);
            uiResList.add(resInfo);
        }
    }

    private String getUIResKey(String srcKey, Map actions) {
        if (srcKey == null || srcKey.trim().length() <= 0) {
            return null;
        }
        Matcher m = uiResKeyPtn.matcher(srcKey);
        if (m.find()) {
            return m.group(1) + "." + m.group(2);
        }
        if (actions != null && actions.size() > 0 && (m = uiActionResKeyPtn.matcher(srcKey)).find()) {
            String insName = m.group(1);
            if (!actions.containsKey(insName)) {
                return null;
            }
            String actionClassName = actions.get(m.group(1)).toString();
            String prop = m.group(2);
            if (actionClassName == null || prop == null) {
                return null;
            }
            if ("name".equalsIgnoreCase(prop)) {
                return actionClassName + ".NAME";
            }
            if ("longdescription".equalsIgnoreCase(prop)) {
                return actionClassName + ".LONG_DESCRIPTION";
            }
            if ("shortdescription".equalsIgnoreCase(prop)) {
                return actionClassName + ".SHORT_DESCRIPTION";
            }
        }
        if ((m = uiDescPtn.matcher(srcKey)).find() && srcKey.endsWith(".title")) {
            return "this.title";
        }
        return null;
    }

    private Map getActions(Element root) {
        Element actionElement = root.element(MetaDocConst.NODE_UI_ACTIONS);
        if (actionElement == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator acIt = actionElement.elementIterator();
        while (acIt.hasNext()) {
            Element actionEL = (Element)acIt.next();
            String insName = null;
            if (actionEL.element(MetaDocConst.NODE_UI_ACTION_InstanceName) != null) {
                insName = actionEL.element(MetaDocConst.NODE_UI_ACTION_InstanceName).getText();
            }
            String clName = null;
            if (actionEL.element(MetaDocConst.NODE_UI_ACTION_CLASS) != null) {
                clName = actionEL.element(MetaDocConst.NODE_UI_ACTION_CLASS).getText();
            }
            if (insName == null || clName == null) continue;
            map.put(insName, clName);
        }
        return map;
    }

    private boolean isValidRes(String str) {
        if (str == null || str.trim().length() <= 0) {
            return false;
        }
        if ("true".equalsIgnoreCase(str) || "false".equalsIgnoreCase(str) || "null".equalsIgnoreCase(str)) {
            return false;
        }
        String regex = "^-?([1-9]\\d*|0)(\\.\\d+)?$";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(str);
        return !m.find();
    }

    private String getBorderTitle(String borderXML) throws Exception {
        if (borderXML == null) {
            return null;
        }
        SAXReader reader = new SAXReader();
        Document doc = reader.read((Reader)new StringReader(borderXML));
        Element root = doc.getRootElement();
        Element t = root.element("Title");
        if (t != null) {
            return t.getText();
        }
        return null;
    }

    private static void initIgnoreProperties() {
        ignoreProp.add("buttonGroup");
        ignoreProp.add("background");
        ignoreProp.add("caretColor");
        ignoreProp.add("disabledTextColor");
        ignoreProp.add("foreground");
        ignoreProp.add("selectionColor");
        ignoreProp.add("preferredSize");
        ignoreProp.add("maximumSize");
        ignoreProp.add("minimumSize");
        ignoreProp.add("maximumValue");
        ignoreProp.add("minimumValue");
        ignoreProp.add("enabled");
        ignoreProp.add("visible");
        ignoreProp.add("mnemonic");
        ignoreProp.add("action");
        ignoreProp.add("dataType");
        ignoreProp.add("precision");
        ignoreProp.add("maxLength");
        ignoreProp.add("minLength");
        ignoreProp.add("required");
        ignoreProp.add("queryInfo");
        ignoreProp.add("editable");
        ignoreProp.add("editFormat");
        ignoreProp.add("displayFormat");
        ignoreProp.add("commitFormat");
        ignoreProp.add("boundLabelLength");
        ignoreProp.add("boundLabelUnderline");
        ignoreProp.add("icon");
        ignoreProp.add("readOnly");
        ignoreProp.add("selectedIndex");
        ignoreProp.add("orientation");
        ignoreProp.add("focusable");
        ignoreProp.add("focusCycleRoot");
        ignoreProp.add("verifyInputWhenFocusTarget");
        ignoreProp.add("doubleBuffered");
        ignoreProp.add("dragEnabled");
        ignoreProp.add("autoscrolls");
        ignoreProp.add("opaque");
        ignoreProp.add("autoToolTipText");
        ignoreProp.add("caretPosition");
        ignoreProp.add("columns");
        ignoreProp.add("debugGraphicsOptions");
        ignoreProp.add("navigationFilter");
        ignoreProp.add("scrollOffset");
        ignoreProp.add("selectionEnd");
        ignoreProp.add("selectionStart");
        ignoreProp.add("labelVisible");
        ignoreProp.add("display");
        ignoreProp.add("margin");
        ignoreProp.add("verticalAlignment");
        ignoreProp.add("verticalTextPosition");
        ignoreProp.add("borderPainted");
        ignoreProp.add("contentAreaFilled");
        ignoreProp.add("disabledIcon");
        ignoreProp.add("disabledSelectedIcon");
        ignoreProp.add("font");
        ignoreProp.add("focusPainted");
        ignoreProp.add("displayedMnemonicIndex");
        ignoreProp.add("validCharacters");
        ignoreProp.add("dateEnabled");
        ignoreProp.add("milliSecondEnable");
        ignoreProp.add("timeEnabled");
        ignoreProp.add("maximumRowCount");
        ignoreProp.add("popupVisible");
        ignoreProp.add("lightWeightPopupEnabled");
        ignoreProp.add("popupVisible");
        ignoreProp.add("selectedIndex");
        ignoreProp.add("actionCommand");
    }

    static {
        MallEUIResourceParser.initIgnoreProperties();
        uiDescPtn = Pattern.compile("^uiObject\\[[^\\[|\\]]*?\\]\\.title$");
        uiResKeyPtn = Pattern.compile("^uiObject.*?components\\.component\\[(.*?)\\]\\.properties\\.property\\[(.*?)\\]\\.value$");
        uiActionResKeyPtn = Pattern.compile("^uiObject.*?actions\\.action\\[(.*?)\\]\\.(.*)$");
    }
}

