/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.bs.ml.TempResCollection;
import com.kingdee.eas.bs.ml.TempResInfo;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileFilter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class PrintFetchWords {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.bs.ml.util.PrintFetchWords");
    private String path;
    private static List suffixList;
    private TempResCollection result;
    private Map existFile;
    private Map newFileLastModify;
    private Connection conn = null;
    private Context ctx = null;

    public void fetchWords() throws Exception {
        if (this.path == null || this.path.trim().length() <= 0) {
            throw new RuntimeException("\u8def\u5f84\u4e3a\u7a7a");
        }
        this.init();
        File file = new File(this.path);
        this.findFile(file);
        this.saveWordToDB();
        System.out.println("\u6267\u884c\u6210\u529f");
    }

    private void init() throws Exception {
        suffixList = new ArrayList();
        suffixList.add(".meta");
        suffixList.add(".bos-query");
        suffixList.add(".r1-print");
        this.result = new TempResCollection();
        this.newFileLastModify = new HashMap();
        this.initExistFile();
    }

    private void findFile(File dir) throws Exception {
        File[] files = dir.listFiles(new FileFilterImpl());
        for (int i = 0; i < files.length; ++i) {
            String language;
            File fl = files[i];
            if (fl.isDirectory()) {
                this.findFile(fl);
                continue;
            }
            String fileName = fl.getName();
            String suffix = fileName.substring(fileName.lastIndexOf(46));
            if (!suffixList.contains(suffix)) {
                return;
            }
            if (".meta".equalsIgnoreCase(suffix)) {
                this.parseMeta(fl, suffix);
                continue;
            }
            if (".bos-query".equalsIgnoreCase(suffix)) {
                this.parseBosQuery(fl, suffix);
                continue;
            }
            if (!".r1-print".equalsIgnoreCase(suffix)) continue;
            if (fileName.lastIndexOf("[") >= 0 && fileName.lastIndexOf("]") > 0 && ("zh_TW".equalsIgnoreCase(language = fileName.substring(fileName.lastIndexOf("[") + 1, fileName.lastIndexOf("]"))) || "en".equalsIgnoreCase(language) || "zh_HK".equalsIgnoreCase(language))) {
                return;
            }
            this.parsePrintTemp(fl, suffix);
        }
    }

    private void saveWordToDB() throws Exception {
        if (this.result == null || this.result.size() == 0) {
            return;
        }
        try {
            this.conn.setAutoCommit(false);
            StringBuffer sqlTempRes = new StringBuffer();
            sqlTempRes.append(" insert into T_RES_TempRes ");
            sqlTempRes.append(" ( FID,FPrintTempID,FType,FRes,FMD5) ");
            sqlTempRes.append(" values ");
            sqlTempRes.append("(");
            sqlTempRes.append("?,?,?,?,?");
            sqlTempRes.append(" ) ");
            PreparedStatement psTempRes = this.conn.prepareStatement(sqlTempRes.toString());
            StringBuffer sqlTempMultiLanTW = new StringBuffer();
            sqlTempMultiLanTW.append(" insert into T_RES_TempMultiLan ");
            sqlTempMultiLanTW.append(" ( FID,FResID,FLanguage,FMLRes,FCNMD5) ");
            sqlTempMultiLanTW.append(" values ");
            sqlTempMultiLanTW.append("(");
            sqlTempMultiLanTW.append("?,?,?,?,?");
            sqlTempMultiLanTW.append(" ) ");
            PreparedStatement psTempMultiLanTW = this.conn.prepareStatement(sqlTempMultiLanTW.toString());
            StringBuffer sqlTempMultiLanEN = new StringBuffer();
            sqlTempMultiLanEN.append(" insert into T_RES_TempMultiLan ");
            sqlTempMultiLanEN.append(" ( FID,FResID,FLanguage,FMLRes,FCNMD5) ");
            sqlTempMultiLanEN.append(" values ");
            sqlTempMultiLanEN.append("(");
            sqlTempMultiLanEN.append("?,?,?,?,?");
            sqlTempMultiLanEN.append(" ) ");
            PreparedStatement psTempMultiLanEN = this.conn.prepareStatement(sqlTempMultiLanEN.toString());
            int j = this.result.size();
            for (int i = 0; i < j; ++i) {
                String filePath;
                TempResInfo resInfo = this.result.get(i);
                if (resInfo == null || StringUtils.isEmpty((String)(filePath = (String)resInfo.get("filePath")))) continue;
                String md52 = MLUtils.md5HashCode(resInfo.getRes());
                BOSUuid pkTempRes = BOSUuid.create((String)"7050EC94");
                psTempRes.setString(1, pkTempRes.toString());
                psTempRes.setString(2, this.existFile.get(filePath).toString());
                psTempRes.setInt(3, 0);
                psTempRes.setString(4, resInfo.getRes());
                psTempRes.setString(5, md52);
                psTempRes.addBatch();
                BOSUuid pkTempMultiLan = BOSUuid.create((String)"378F422C");
                psTempMultiLanTW.setString(1, pkTempMultiLan.toString());
                psTempMultiLanTW.setString(2, pkTempRes.toString());
                psTempMultiLanTW.setString(3, "zh_TW");
                psTempMultiLanTW.setString(4, "");
                psTempMultiLanTW.setString(5, md52);
                psTempMultiLanTW.addBatch();
                pkTempMultiLan = BOSUuid.create((String)"378F422C");
                psTempMultiLanEN.setString(1, pkTempMultiLan.toString());
                psTempMultiLanEN.setString(2, pkTempRes.toString());
                psTempMultiLanEN.setString(3, "en_US");
                psTempMultiLanEN.setString(4, "");
                psTempMultiLanEN.setString(5, md52);
                psTempMultiLanEN.addBatch();
            }
            psTempRes.executeBatch();
            psTempMultiLanTW.executeBatch();
            psTempMultiLanEN.executeBatch();
            this.conn.commit();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void updateLastModify() throws Exception {
        try {
            if (this.newFileLastModify != null && this.newFileLastModify.size() > 0) {
                this.conn.setAutoCommit(false);
                StringBuffer sql = new StringBuffer();
                sql.append(" update T_RES_PrintTemp set FLastModify = ? ");
                sql.append(" where FFilePath = ? ");
                PreparedStatement ps = this.conn.prepareStatement(sql.toString());
                Set set = this.newFileLastModify.entrySet();
                for (Map.Entry entry : set) {
                    String path = entry.getKey().toString();
                    Long ld = (Long)entry.getValue();
                    ps.setLong(1, ld);
                    ps.setString(2, path);
                    ps.addBatch();
                }
                ps.executeBatch();
                this.conn.commit();
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void initExistFile() throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append(" select Fid, FFilePath from T_RES_PrintTemp ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        if (rs == null) {
            this.existFile = Collections.EMPTY_MAP;
            return;
        }
        this.existFile = new HashMap();
        try {
            while (rs.next()) {
                this.existFile.put(rs.getString("FFilePath"), rs.getString("Fid"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public Set getExistFileWords(String filePath) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append(" select T_Res_TempRes.FRes from T_RES_PrintTemp, T_Res_TempRes where T_Res_TempRes.FPrintTempID = T_RES_PrintTemp.FID ");
        sql.append(" and T_RES_PrintTemp.FFilePath = '").append(filePath).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        if (rs == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> set = new HashSet<String>();
        try {
            while (rs.next()) {
                set.add(rs.getString("FRes"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return set;
    }

    private String getRelaPath(String path) {
        String pt = path.replaceAll("\\\\", "/");
        int index = pt.lastIndexOf("/template");
        if (index >= 0) {
            return pt.substring(index, pt.length());
        }
        return "";
    }

    private void parsePrintTemp(File file, String suffix) throws Exception {
        String zh_cn2;
        int i;
        String relaPath = this.getRelaPath(file.getCanonicalPath());
        if (relaPath == null) {
            return;
        }
        String fileName = file.getName();
        long lastModify = file.lastModified();
        if (fileName == null || fileName.trim().length() < 1 || fileName.lastIndexOf(46) < 0) {
            return;
        }
        String project = MLUtils.getProject(relaPath);
        if (!this.existFile.containsKey(relaPath)) {
            this.savePrintTemp(fileName, relaPath, "r1-print", project);
        }
        Set existWords = this.getExistFileWords(relaPath);
        SAXReader saxReader = new SAXReader();
        Document doc = null;
        try {
            doc = saxReader.read(file);
        }
        catch (Exception e) {
            logger.error((Object)("error file:" + file));
            logger.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        List list = doc.selectNodes("//*[name() = 'DocRoot']/*[name() = 'DataSources']/*[name() = 'Reference']");
        String[] attrNames_cn = new String[]{"alias.zh_CN", "desc.zh_CN"};
        int n = list.size();
        for (int m = 0; m < n; ++m) {
            Element el = (Element)list.get(m);
            for (i = 0; i < attrNames_cn.length; ++i) {
                String value_cn;
                Attribute cn = el.attribute(attrNames_cn[i]);
                if (cn == null || (value_cn = cn.getValue()) == null || value_cn.trim().length() <= 0 || existWords.contains(zh_cn2 = (value_cn = value_cn.trim()).length() > 400 ? value_cn.substring(0, 400) : value_cn)) continue;
                TempResInfo resInfo = new TempResInfo();
                resInfo.setRes(value_cn);
                resInfo.put("filePath", relaPath);
                this.result.add(resInfo);
            }
        }
        list.clear();
        List lt1 = doc.selectNodes("//*[name() = 'Text']/*[name() = 'Data']");
        List lt2 = doc.selectNodes("//*[name() = 'TD']/*[name() = 'Value' and @type = 'text']");
        ArrayList arrList = new ArrayList();
        arrList.addAll(lt1);
        arrList.addAll(lt2);
        int j = arrList.size();
        for (i = 0; i < j; ++i) {
            Element el = (Element)arrList.get(i);
            String value = el.getTextTrim();
            if (value == null || value.trim().length() <= 0 || existWords.contains(zh_cn2 = value.length() > 400 ? value.substring(0, 400) : value)) continue;
            TempResInfo resInfo = new TempResInfo();
            resInfo.setRes(value);
            resInfo.put("filePath", relaPath);
            this.result.add(resInfo);
        }
    }

    private void parseBosQuery(File file, String suffix) throws Exception {
        String relaPath = this.getRelaPath(file.getCanonicalPath());
        if (relaPath == null) {
            return;
        }
        String fileName = file.getName();
        long lastModify = file.lastModified();
        if (fileName == null || fileName.trim().length() < 1 || fileName.lastIndexOf(46) < 0) {
            return;
        }
        String project = MLUtils.getProject(relaPath);
        if (!this.existFile.containsKey(relaPath)) {
            this.savePrintTemp(fileName, relaPath, "bos-query", project);
        }
        Set existWords = this.getExistFileWords(relaPath);
        SAXReader saxReader = new SAXReader();
        Document doc = saxReader.read(file);
        List l1 = doc.selectNodes("/*[name() = 'Class']/*[name() = 'Field']");
        Element root = doc.getRootElement();
        ArrayList<Element> list = new ArrayList<Element>();
        list.add(root);
        list.addAll(l1);
        String[] attrNames_cn = new String[]{"alias.zh_CN", "desc.zh_CN"};
        int n = list.size();
        for (int m = 0; m < n; ++m) {
            Element el = (Element)list.get(m);
            for (int i = 0; i < attrNames_cn.length; ++i) {
                String zh_cn2;
                String value_cn;
                Attribute cn = el.attribute(attrNames_cn[i]);
                if (cn == null || (value_cn = cn.getValue()) == null || value_cn.trim().length() <= 0 || existWords.contains(zh_cn2 = (value_cn = value_cn.trim()).length() > 400 ? value_cn.substring(0, 400) : value_cn)) continue;
                TempResInfo resInfo = new TempResInfo();
                resInfo.setRes(value_cn);
                resInfo.put("filePath", relaPath);
                this.result.add(resInfo);
            }
        }
    }

    private void parseMeta(File file, String suffix) throws Exception {
        String relaPath = this.getRelaPath(file.getCanonicalPath());
        if (relaPath == null) {
            return;
        }
        String fileName = file.getName();
        long lastModify = file.lastModified();
        if (fileName == null || fileName.trim().length() < 1 || fileName.lastIndexOf(46) < 0) {
            return;
        }
        String project = MLUtils.getProject(relaPath);
        if (!this.existFile.containsKey(relaPath)) {
            this.savePrintTemp(fileName, relaPath, "meta", project);
        }
        Set existWords = this.getExistFileWords(relaPath);
        SAXReader saxReader = new SAXReader();
        Document doc = null;
        try {
            doc = saxReader.read(file);
        }
        catch (Exception e) {
            logger.error((Object)("Read file error. File name: " + file));
            logger.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        List list = doc.selectNodes("/Meta/Nodes/Node");
        String[] attrNames_cn = new String[]{"alias.zh_CN"};
        int n = list.size();
        for (int m = 0; m < n; ++m) {
            Element el = (Element)list.get(m);
            for (int i = 0; i < attrNames_cn.length; ++i) {
                String zh_cn2;
                String value_cn;
                Attribute cn = el.attribute(attrNames_cn[i]);
                if (cn == null || (value_cn = cn.getValue()) == null || value_cn.trim().length() <= 0 || existWords.contains(zh_cn2 = (value_cn = value_cn.trim()).length() > 400 ? value_cn.substring(0, 400) : value_cn)) continue;
                TempResInfo resInfo = new TempResInfo();
                resInfo.setRes(value_cn);
                this.result.add(resInfo);
            }
        }
    }

    private void savePrintTemp(String fileName, String relaPath, String suffix, String project) throws Exception {
        try {
            this.conn.setAutoCommit(false);
            StringBuffer sql = new StringBuffer();
            sql.append(" insert into T_RES_PrintTemp ");
            sql.append(" ( FID,FFileName,FFilePath,FISInvalid,FProject ) ");
            sql.append(" values ");
            sql.append("(?,?,?,?,?) ");
            PreparedStatement ps = this.conn.prepareStatement(sql.toString());
            BOSUuid pk = BOSUuid.create((String)"BFFA4289");
            ps.setString(1, pk.toString());
            ps.setString(2, fileName);
            ps.setString(3, relaPath);
            ps.setInt(4, 0);
            ps.setString(5, project);
            ps.addBatch();
            ps.executeBatch();
            this.conn.commit();
            this.existFile.put(relaPath, pk.toString());
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setContext(Context ctx) {
        this.ctx = ctx;
    }

    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    private static class FileFilterImpl
    implements FileFilter {
        private FileFilterImpl() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName();
            if (name.lastIndexOf(".") < 0) {
                return false;
            }
            String suffix = name.substring(name.lastIndexOf("."));
            return suffixList.contains(suffix);
        }
    }
}

