/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class PrintWriteResource {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.bs.ml.util.PrintWriteResource");
    private Connection conn = null;
    private Context ctx = null;
    private String path;

    public void writePrintResource(Context ctx, Connection conn, String language) throws Exception {
        this.ctx = ctx;
        this.conn = conn;
        this.handlePrintWriteByLanguage("en_US");
        this.handlePrintWriteByLanguage("zh_TW");
    }

    private void handlePrintWriteByLanguage(String language) throws Exception {
        Map<String, String> words;
        String filePath;
        StringBuffer sql = new StringBuffer();
        sql.append(" select FFilePath,FRes,FMLRes from T_RES_PrintTemp,T_RES_TempRes,T_RES_TempMultiLan ");
        sql.append(" where T_RES_PrintTemp.fid = T_RES_TempRes.FPrintTempID ");
        sql.append(" and T_RES_TempRes.fid = T_RES_TempMultiLan.FResID ");
        sql.append(" and T_RES_TempMultiLan.FLanguage = '" + language + "' ");
        sql.append(" and FMLRes is not null ");
        sql.append(" and FMLRes <> '' ");
        sql.append(" order by T_RES_PrintTemp.FFilePath ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        HashMap map = new HashMap();
        while (rs.next()) {
            filePath = rs.getString("FFilePath");
            if (filePath == null || filePath.trim().length() <= 0) continue;
            if (map.containsKey(filePath)) {
                words = (Map)map.get(filePath);
            } else {
                words = new HashMap();
                map.put(filePath, words);
            }
            words.put(rs.getString("FRes"), rs.getString("FMLRes"));
        }
        Map lastModifyMap = this.getFileLastModify();
        for (Map.Entry entry : map.entrySet()) {
            String fileName;
            String suffix;
            filePath = entry.getKey().toString();
            File file = new File(this.path + filePath);
            if (!file.exists() || (words = (Map)entry.getValue()) == null || words.size() <= 0) continue;
            Long lastModify = (Long)lastModifyMap.get(filePath);
            if (lastModify == null) {
                lastModify = new Long(-1L);
            }
            if (".r1-print".equalsIgnoreCase(suffix = (fileName = file.getName()).substring(fileName.lastIndexOf("."), fileName.length()))) {
                File printFile = this.getEnTemplate(file, lastModify, language);
                this.parsePrintTemp(printFile, words, language);
                this.updateMeta(file, printFile, new File(file.getPath().substring(0, file.getPath().indexOf(file.getName())) + ".meta"));
                continue;
            }
            if (".bos-query".equalsIgnoreCase(suffix)) {
                this.parseBosQuery(file, words, language);
                continue;
            }
            if (!".meta".equalsIgnoreCase(suffix)) continue;
            this.parseMeta(file, words, language);
        }
    }

    private Map getFileLastModify() throws Exception {
        HashMap map = new HashMap();
        return map;
    }

    private File getEnTemplate(File file_zh, long lastModify, String language) throws Exception {
        String fileName = file_zh.getName();
        String path = file_zh.getCanonicalPath();
        path = path.replaceAll("\\\\", "/");
        path = path.substring(0, path.lastIndexOf("/") + 1);
        String preffix = fileName.substring(0, fileName.lastIndexOf(".r1-print"));
        if ("en_US".equalsIgnoreCase(language)) {
            fileName = preffix + "[EN].r1-print";
        } else if ("zh_TW".equalsIgnoreCase(language)) {
            fileName = preffix + "[zh_TW].r1-print";
        }
        File file_en = new File(path + fileName);
        if (!file_en.exists()) {
            file_en.createNewFile();
            this.copyFile2(file_zh, file_en);
        } else if (file_zh.lastModified() != lastModify) {
            this.copyFile2(file_zh, file_en);
        }
        return file_en;
    }

    private void copyFile(File file_zh, File file_en) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int c;
            fis = new FileInputStream(file_zh);
            fos = new FileOutputStream(file_en);
            while ((c = ((InputStream)fis).read()) != -1) {
                ((OutputStream)fos).write(c);
            }
            fos.flush();
        }
        catch (IOException ex) {
            try {
                ex.printStackTrace();
                throw ex;
            }
            catch (Throwable throwable) {
                MLUtils.closeInputStream(fis);
                MLUtils.closeOutputStream(fos);
                throw throwable;
            }
        }
        MLUtils.closeInputStream(fis);
        MLUtils.closeOutputStream(fos);
    }

    private void copyFile2(File file_zh, File file_en) throws IOException {
        FileChannel zh = null;
        FileChannel en = null;
        try {
            file_en.delete();
            zh = new RandomAccessFile(file_zh, "r").getChannel();
            en = new RandomAccessFile(file_en, "rws").getChannel();
            zh.transferTo(0L, zh.size(), en);
            en.force(true);
        }
        catch (IOException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                MLUtils.closeChaneel(zh);
                MLUtils.closeChaneel(en);
                throw throwable;
            }
        }
        MLUtils.closeChaneel(zh);
        MLUtils.closeChaneel(en);
    }

    private void parsePrintTemp(File file, Map words, String language) throws Exception {
        String zh_cn2;
        SAXReader saxReader = new SAXReader();
        Document doc = saxReader.read(file);
        List list = doc.selectNodes("/*[name() = 'DocRoot']/*[name() = 'DataSources']/*[name() = 'Reference']");
        String[] attrNames_cn = new String[]{"alias.zh_CN", "desc.zh_CN"};
        String[] attrNames_en = new String[]{"alias.en", "desc.en"};
        String[] attrNames_tw = new String[]{"alias.zh_TW", "desc.zh_TW"};
        int n = list.size();
        for (int m = 0; m < n; ++m) {
            Element el = (Element)list.get(m);
            for (int i = 0; i < attrNames_cn.length; ++i) {
                String value_cn;
                Attribute cn = el.attribute(attrNames_cn[i]);
                if (cn == null || (value_cn = cn.getValue()) == null || value_cn.trim().length() <= 0 || !words.containsKey(zh_cn2 = (value_cn = value_cn.trim()).length() > 400 ? value_cn.substring(0, 400) : value_cn)) continue;
                if ("en_US".equalsIgnoreCase(language)) {
                    String value_en = words.get(zh_cn2).toString().trim();
                    Attribute en = el.attribute(attrNames_en[i]);
                    if (en == null) {
                        el.addAttribute(attrNames_en[i], value_en);
                        continue;
                    }
                    en.setValue(value_en);
                    continue;
                }
                if (!"zh_TW".equalsIgnoreCase(language)) continue;
                String value_tw = words.get(zh_cn2).toString().trim();
                Attribute tw = el.attribute(attrNames_tw[i]);
                if (tw == null) {
                    el.addAttribute(attrNames_tw[i], value_tw);
                    continue;
                }
                tw.setValue(value_tw);
            }
        }
        list.clear();
        List lt1 = doc.selectNodes("//*[name() = 'Text']/*[name() = 'Data']");
        List lt2 = doc.selectNodes("//*[name() = 'TD']/*[name() = 'Value' and @type = 'text']");
        ArrayList arrList = new ArrayList();
        arrList.addAll(lt1);
        arrList.addAll(lt2);
        int j = arrList.size();
        for (int i = 0; i < j; ++i) {
            Element el = (Element)arrList.get(i);
            String value = el.getTextTrim();
            if (value == null || value.trim().length() <= 0 || !words.containsKey(zh_cn2 = value.length() > 400 ? value.substring(0, 400) : value)) continue;
            String value_enOrTW = words.get(zh_cn2).toString();
            el.clearContent();
            el.addCDATA(value_enOrTW);
        }
        MLUtils.writeXML(doc, file.getPath());
    }

    private void parseBosQuery(File file, Map words, String language) throws Exception {
        if (file == null) {
            return;
        }
        SAXReader saxReader = new SAXReader();
        Document doc = saxReader.read(file);
        List l1 = doc.selectNodes("/*[name() = 'Class']/*[name() = 'Field']");
        Element root = doc.getRootElement();
        ArrayList<Element> list = new ArrayList<Element>();
        list.add(root);
        list.addAll(l1);
        String[] attrNames_cn = new String[]{"alias.zh_CN", "desc.zh_CN"};
        String[] attrNames_en = new String[]{"alias.en", "desc.en"};
        String[] attrNames_tw = new String[]{"alias.zh_TW", "desc.zh_TW"};
        int n = list.size();
        for (int m = 0; m < n; ++m) {
            Element el = (Element)list.get(m);
            for (int i = 0; i < attrNames_cn.length; ++i) {
                String zh_cn2;
                String value_cn;
                Attribute cn = el.attribute(attrNames_cn[i]);
                if (cn == null || (value_cn = cn.getValue()) == null || value_cn.trim().length() <= 0 || !words.containsKey(zh_cn2 = (value_cn = value_cn.trim()).length() > 400 ? value_cn.substring(0, 400) : value_cn)) continue;
                if ("en_US".equalsIgnoreCase(language)) {
                    String value_en = words.get(zh_cn2).toString();
                    Attribute en = el.attribute(attrNames_en[i]);
                    if (en == null) {
                        el.addAttribute(attrNames_en[i], value_en);
                        continue;
                    }
                    en.setValue(value_en);
                    continue;
                }
                if (!"zh_TW".equalsIgnoreCase(language)) continue;
                String value_tw = words.get(zh_cn2).toString();
                Attribute tw = el.attribute(attrNames_tw[i]);
                if (tw == null) {
                    el.addAttribute(attrNames_tw[i], value_tw);
                    continue;
                }
                tw.setValue(value_tw);
            }
        }
        MLUtils.writeXML(doc, file.getPath());
    }

    private void parseMeta(File file, Map words, String language) throws Exception {
        if (file == null || words == null || words.size() <= 0) {
            return;
        }
        SAXReader saxReader = new SAXReader();
        Document doc = saxReader.read(file);
        List list = doc.selectNodes("/Meta/Nodes/Node");
        String[] attrNames_cn = new String[]{"alias.zh_CN"};
        String[] attrNames_en = new String[]{"alias.en"};
        String[] attrNames_tw = new String[]{"alias.zh_TW"};
        int n = list.size();
        for (int m = 0; m < n; ++m) {
            Element el = (Element)list.get(m);
            for (int i = 0; i < attrNames_cn.length; ++i) {
                String zh_cn2;
                String value_cn;
                Attribute cn = el.attribute(attrNames_cn[i]);
                if (cn == null || (value_cn = cn.getValue()) == null || value_cn.trim().length() <= 0 || !words.containsKey(zh_cn2 = (value_cn = value_cn.trim()).length() > 400 ? value_cn.substring(0, 400) : value_cn)) continue;
                if ("en_US".equalsIgnoreCase(language)) {
                    String value_en = words.get(zh_cn2).toString();
                    Attribute en = el.attribute(attrNames_en[i]);
                    if (en == null) {
                        el.addAttribute(attrNames_en[i], value_en);
                        continue;
                    }
                    en.setValue(value_en);
                    continue;
                }
                if (!"zh_TW".equalsIgnoreCase(language)) continue;
                String value_tw = words.get(zh_cn2).toString();
                Attribute tw = el.attribute(attrNames_tw[i]);
                if (tw == null) {
                    el.addAttribute(attrNames_tw[i], value_tw);
                    continue;
                }
                tw.setValue(value_tw);
            }
        }
        MLUtils.writeXML(doc, file.getPath());
    }

    private void updateMeta(File file_ch, File file_enOrTW, File meta) {
        SAXReader saxReader = new SAXReader();
        try {
            Document doc;
            Element root;
            Iterator iter;
            if (!meta.exists()) {
                meta.createNewFile();
            }
            if ((iter = (root = (doc = saxReader.read(meta)).getRootElement()).elementIterator()).hasNext()) {
                Element element = (Element)iter.next();
                Iterator iterInner = element.elementIterator();
                while (iterInner.hasNext()) {
                    Element elementInner = (Element)iterInner.next();
                    Attribute ageAttr = elementInner.attribute("name");
                    String name = ageAttr.getValue();
                    if (!name.equals(file_ch.getName())) continue;
                    Element temp = elementInner.createCopy();
                    if (temp.attribute("name") != null) {
                        temp.attribute("name").setValue(file_enOrTW.getName());
                    }
                    if (temp.attribute("time") != null) {
                        temp.attribute("time").setValue(String.valueOf(file_enOrTW.lastModified()));
                    }
                    if (temp.attribute("last-modified") != null) {
                        temp.attribute("last-modified").setValue(String.valueOf(meta.lastModified()));
                    }
                    element.add(temp);
                }
            }
            MLUtils.writeXML(doc, meta.getPath());
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateLastModify(Set filePathSet) throws Exception {
        if (filePathSet == null || filePathSet.size() <= 0) {
            return;
        }
        Iterator<Object> it = filePathSet.iterator();
        HashMap<String, Long> map = new HashMap<String, Long>();
        while (it.hasNext()) {
            File file;
            String suffix;
            String filePath = it.next().toString();
            if (filePath.lastIndexOf(".") >= 0 && ".r1-print".equals(suffix = filePath.substring(filePath.lastIndexOf("."), filePath.length())) || !(file = new File(this.path + filePath)).exists()) continue;
            map.put(filePath, file.lastModified());
        }
        String sql = " update t_res_PrintTemplate set FLastModify = ? where FISInvalid = 0 and FFilePath = ? ";
        this.conn.setAutoCommit(false);
        try {
            PreparedStatement ps = this.conn.prepareStatement(sql);
            for (Map.Entry entry : map.entrySet()) {
                ps.setLong(1, (Long)entry.getValue());
                ps.setString(2, entry.getKey().toString());
                ps.addBatch();
            }
            ps.executeBatch();
            this.conn.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void setPath(String path) {
        if (path == null) {
            return;
        }
        path = path.replaceAll("\\\\", "/") + "/";
        this.path = path.substring(0, path.indexOf("template"));
    }

    public static void main(String[] args) {
        File file_ch = new File("D://workspace//template//FM//INVEST//IVT//ENTREPAY//EntRepayBill.r1-print");
        File file_en = new File("D://workspace//template//FM//INVEST//IVT//ENTREPAY//EntRepayBill[EN].r1-print");
        File meta = new File(file_ch.getPath().substring(0, file_ch.getPath().indexOf(file_ch.getName())) + ".meta");
        new PrintWriteResource().updateMeta(file_ch, file_en, meta);
    }
}

