/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.util;

import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.eas.bs.ml.EASResourceException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.filechooser.FileFilter;

public class TableDataExportExcel
extends FileFilter {
    public static final String jpeg = "jpeg";
    public static final String jpg = "jpg";
    public static final String gif = "gif";
    public static final String tiff = "tiff";
    public static final String tif = "tif";
    public static final String png = "png";

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String extension = TableDataExportExcel.getExtension(f);
        if (extension != null) {
            return extension.equals("xls");
        }
        return false;
    }

    @Override
    public String getDescription() {
        return "EXCEL FILE";
    }

    public void inputToTableFromExcel(KDTable tbl) {
        if (tbl == null) {
            return;
        }
        KDFileChooser m_chooserOpen = new KDFileChooser();
        m_chooserOpen.setFileFilter((FileFilter)this);
        int result = m_chooserOpen.showOpenDialog((Component)tbl);
        if (result != 0) {
            return;
        }
        File f = m_chooserOpen.getSelectedFile();
        KDSBook book = POIXlsReader.parse((String)f.getAbsolutePath());
        tbl.getIOManager().parseFromKDS(book.getSheet((Object)new Integer(0)), 1, false);
    }

    public void appendToExcel(KDTable tblMain, boolean withHead, boolean withIndex, String sheetName) throws Exception {
        if (tblMain == null) {
            return;
        }
        KDFileChooser m_chooserSave = new KDFileChooser();
        m_chooserSave.setFileFilter((FileFilter)this);
        int result = m_chooserSave.showSaveDialog((Component)tblMain);
        if (result != 0) {
            return;
        }
        File file = m_chooserSave.getSelectedFile();
        if (null != file.getParentFile() && !file.getParentFile().isDirectory()) {
            throw new EASResourceException(EASResourceException.OUTPUT_FILE_ERROR);
        }
        String fileName = null;
        fileName = file.getAbsolutePath().endsWith(".xls") ? file.getAbsolutePath() : file.getAbsolutePath() + ".xls";
        KDSBook book = null;
        file = new File(fileName);
        if (file.exists()) {
            if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"35_TableDataExportExcel")) != 0) {
                return;
            }
            if (!file.canWrite()) {
                throw new EASResourceException(EASResourceException.CAN_NOT_WRITE);
            }
        } else {
            try {
                file.createNewFile();
                file.delete();
            }
            catch (IOException e) {
                throw new EASResourceException(EASResourceException.FILE_NAME_ERROR);
            }
        }
        book = new KDSBook(file.getName());
        try {
            book.addSheet(null, tblMain.getIOManager().saveToKDSSheet(book, withHead, withIndex, sheetName));
        }
        catch (IllegalArgumentException err) {
            throw new EASResourceException(EASResourceException.REPEAT_SHEET_NAME);
        }
        catch (Exception e) {
            throw new EASResourceException(EASResourceException.ERROR_OPEN_EXCEL);
        }
        ExportManager man = new ExportManager();
        try {
            man.exportToExcel(book, fileName);
        }
        catch (Exception e) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.bs.ml.MLAutoGenerateResource", (String)"21_ResourceListUI"));
        }
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }
}

