/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.bs.ml.TempResCollection;
import com.kingdee.eas.bs.ml.TempResInfo;
import com.kingdee.eas.bs.ml.WorkflowTempInfo;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public class WorkFlowWriteResource {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.bs.ml.util.WorkFlowWriteResource");
    private Connection conn = null;
    private Context ctx = null;

    public void writeWorkFlowResource(Context ctx, Connection conn) throws Exception {
        this.ctx = ctx;
        this.conn = conn;
        ResultSet rs = this.getTranslatedXmlDocument("T_WFD_PROCESSDEF", "FPROCESSXML", "FPROCESSID");
        this.doWriteXMLDoc(rs, "T_WFD_PROCESSDEF", "FPROCESSXML", "FPROCESSID");
        rs = this.getTranslatedXmlDocument("T_WFR_PROCDEF", "FKpdl", "FProcDefId");
        this.doWriteXMLDoc(rs, "T_WFR_PROCDEF", "FKpdl", "FProcDefId");
    }

    private void doWriteXMLDoc(ResultSet rs, String tabName, String xmlFieldName, String idFieldName) throws Exception {
        if (rs == null || tabName == null || xmlFieldName == null || idFieldName == null) {
            return;
        }
        SAXReader saxReader = new SAXReader();
        TempResCollection newWords = new TempResCollection();
        try (Reader characterStream = null;){
            while (rs.next()) {
                String sourceId = rs.getString(idFieldName);
                characterStream = rs.getCharacterStream(xmlFieldName);
                Document doc = saxReader.read(characterStream);
                if (doc == null) continue;
                Map translatedWords = this.getTranslatedWords(sourceId, "en_US");
                TempResCollection list = this.doParseDocument(doc, translatedWords, sourceId, tabName, xmlFieldName, "en_US");
                if (list != null && list.size() > 0) {
                    newWords.addCollection(list);
                }
                if ((list = this.doParseDocument(doc, translatedWords = this.getTranslatedWords(sourceId, "zh_TW"), sourceId, tabName, xmlFieldName, "zh_TW")) != null && list.size() > 0) {
                    newWords.addCollection(list);
                }
                this.writeXMLDocBackToDB(doc, sourceId, tabName, xmlFieldName, idFieldName);
            }
        }
    }

    private TempResCollection doParseDocument(Document doc, Map translatedWords, String sourceId, String tabName, String fieldName, String language) {
        if (doc == null || sourceId == null || tabName == null || fieldName == null || translatedWords == null) {
            return new TempResCollection();
        }
        String xpath = "//*[name() = 'Resources']/*[name() = 'Resource']/Language[@Locale = 'l2' or @Locale = 'zh_CN']";
        List list = doc.selectNodes(xpath);
        TempResCollection newWords = new TempResCollection();
        int j = list.size();
        for (int i = 0; i < j; ++i) {
            String key;
            String zh;
            Element el = (Element)list.get(i);
            Element resourceEl = el.getParent();
            List languageNodes = resourceEl.selectNodes("Language[@Locale = 'l2' or @Locale = 'zh_CN']");
            if (languageNodes != null && languageNodes.size() == 2 && "zh_CN".equals(el.attribute("Locale").getValue()) || (zh = el.getText()) == null || zh.trim().length() <= 0) continue;
            if (!MLUtils.isValidValue_zh_CN(zh = zh.trim())) {
                translatedWords.put(zh.length() > 400 ? zh.substring(0, 400).trim() : zh, zh);
            }
            if (translatedWords.containsKey(key = zh.length() > 400 ? zh.substring(0, 400).trim() : zh)) {
                String en = translatedWords.get(key).toString();
                List enNodes = null;
                if ("en_US".equalsIgnoreCase(language)) {
                    enNodes = resourceEl.selectNodes("Language[@Locale = 'l1']");
                } else if ("zh_TW".equalsIgnoreCase(language)) {
                    enNodes = resourceEl.selectNodes("Language[@Locale = 'l3']");
                }
                if (enNodes != null && enNodes.size() > 0) {
                    Element enNode = (Element)enNodes.get(0);
                    enNode.clearContent();
                    enNode.addCDATA(en);
                    continue;
                }
                QName qn = DocumentHelper.createQName((String)"Language", (Namespace)DocumentHelper.createNamespace((String)"", (String)""));
                Element enNode = DocumentHelper.createElement((QName)qn);
                if ("en_US".equalsIgnoreCase(language)) {
                    enNode.addAttribute("Locale", "l1");
                } else if ("zh_TW".equalsIgnoreCase(language)) {
                    enNode.addAttribute("Locale", "l3");
                }
                enNode.add(DocumentHelper.createCDATA((String)en));
                resourceEl.add(enNode);
                continue;
            }
            TempResInfo info = new TempResInfo();
            WorkflowTempInfo workflowTempInfo = new WorkflowTempInfo();
            workflowTempInfo.setId(BOSUuid.read((String)sourceId));
            info.setWorkFlowTemp(workflowTempInfo);
            info.setRes(zh);
            newWords.add(info);
        }
        return newWords;
    }

    public Map getTranslatedWords(String sourceId, String language) throws Exception {
        if (sourceId == null) {
            return Collections.EMPTY_MAP;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select t_res_WorkFlow.FId, FSourceId,FSourceTable,FSourceField, ");
        sql.append(" T_RES_TempRes.FRes,T_RES_TempMultiLan.FMLRes ");
        sql.append(" from t_res_WorkFlow,T_RES_TempRes,T_RES_TempMultiLan ");
        sql.append(" where t_res_WorkFlow.fid = T_RES_TempRes.FWorkFlowTempID ");
        sql.append(" and T_RES_TempRes.fid = T_RES_TempMultiLan.FResID ");
        sql.append(" and FLanguage = ? ");
        sql.append(" and fMLres is not null ");
        sql.append(" and fMLres <> '' ");
        sql.append(" and t_res_WorkFlow.FISInvalid = 0 ");
        sql.append(" and FSourceId = ? ");
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            ps = this.conn.prepareStatement(sql.toString());
            ps.setString(1, language);
            ps.setString(2, sourceId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String zh = rs.getString("FRes");
                String en = rs.getString("FMLRes");
                if (zh == null || en == null) continue;
                map.put(zh, en);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        return map;
    }

    public ResultSet getTranslatedXmlDocument(String tabName, String xmlFieldName, String idFieldName) throws Exception {
        if (tabName == null || xmlFieldName == null || idFieldName == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct FSourceId from t_res_WorkFlow,T_RES_TempRes,T_RES_TempMultiLan ");
        sql.append(" where t_res_WorkFlow.fid = T_RES_TempRes.FWorkFlowTempID ");
        sql.append(" and T_RES_TempRes.fid = T_RES_TempMultiLan.FResID ");
        sql.append(" and fMLres is not null ");
        sql.append(" and fMLres <> '' ");
        sql.append(" and t_res_WorkFlow.FISInvalid = 0 ");
        sql.append(" and FSourceTable = '").append(tabName).append("' ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        ArrayList<String> list = new ArrayList<String>();
        try {
            while (rs.next()) {
                list.add(rs.getString("FSourceId"));
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw ex;
        }
        sql.delete(0, sql.length());
        sql.append(" select ").append(idFieldName).append(",").append(xmlFieldName);
        sql.append(" from ").append(tabName);
        sql.append(" where ").append(idFieldName);
        sql.append(" in ");
        sql.append(" ( ");
        int j = list.size();
        for (int i = 0; i < j; ++i) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append("'").append(list.get(i)).append("'");
        }
        sql.append(" ) ");
        if (list.size() <= 0) {
            return null;
        }
        PreparedStatement ps = this.conn.prepareStatement(sql.toString());
        ResultSet resultSet = ps.executeQuery();
        return resultSet;
    }

    private void writeXMLDocBackToDB(Document doc, String id, String tabName, String xmlFieldName, String idFieldName) throws Exception {
        if (doc == null || tabName == null || xmlFieldName == null) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update ").append(tabName).append(" ");
        sql.append(" set ").append(xmlFieldName).append(" ");
        sql.append(" = ? ");
        sql.append(" where ").append(idFieldName).append(" = ? ");
        PreparedStatement ps = null;
        Object cb = null;
        StringReader reader = null;
        try {
            ps = this.conn.prepareStatement(sql.toString());
            String xmlStr = doc.asXML();
            reader = new StringReader(xmlStr);
            ps.setCharacterStream(1, (Reader)reader, xmlStr.length());
            ps.setString(2, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
    }
}

