/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.param.client;

import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.param.DumpliParamCollection;
import com.kingdee.eas.base.param.DumpliParamInfo;
import com.kingdee.eas.base.param.IParamTestFacade;
import com.kingdee.eas.base.param.ParamFactory;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.param.ParamTestFacadeFactory;
import com.kingdee.eas.base.param.client.AbstractDeleteDumplicateParamUI;
import com.kingdee.eas.base.param.client.DumplicateParamComparator;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class DeleteDumplicateParamUI
extends AbstractDeleteDumplicateParamUI {
    private static final Logger logger = CoreUIObject.getLogger(DeleteDumplicateParamUI.class);
    private DumpliParamCollection DumpliParams = null;
    private boolean isParamTable = false;
    private static final String resName = "com.kingdee.eas.base.param.ParamResource";
    IParamTestFacade iParam = null;
    private Hashtable comparators = new Hashtable();

    private void initButton() {
        this.btnAddNew.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnQuery.setVisible(false);
        this.btnView.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnRemove.setVisible(true);
        this.btnLocate.setVisible(false);
    }

    public void onLoad() throws Exception {
        this.initButton();
        super.onLoad();
        this.iParam = ParamTestFacadeFactory.getRemoteInstance();
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ParamItemFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        try {
            this.refreshTable();
            KDTableUtil.setSelectedRow((KDTable)this.tblMain, (int)this.tblMain.getSelectManager().getActiveRowIndex());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Object[] sortDumplicateParams(String propertyName, boolean isRefresh) {
        Object[] objs = null;
        if (this.DumpliParams != null) {
            objs = this.DumpliParams.toArray();
            Arrays.sort(objs, this.getDumpParamComparatorFromCache("paramNumber", isRefresh));
        }
        return objs;
    }

    private void loadDumplicateParams() throws Exception {
        this.DumpliParams = ParamItemFactory.getRemoteInstance().getDumpliParams();
        if (this.DumpliParams == null || this.DumpliParams.size() == 0) {
            this.isParamTable = true;
            this.DumpliParams = ParamFactory.getRemoteInstance().getDumpliParams();
        }
    }

    private void fillDumplicateParamsTable(Object[] objs) throws Exception {
        String dateTimeFormat = "%{" + CtrlFormatUtilities.getDateTimeFormatString() + "}t";
        this.tblMain.getColumn("lastUpdateTime").getStyleAttributes().setNumberFormat(dateTimeFormat);
        this.tblMain.getColumn("orgName").getStyleAttributes().setHided(this.isParamTable);
        this.tblMain.getColumn("orgNumber").getStyleAttributes().setHided(this.isParamTable);
        this.tblMain.getColumn("isUserEdit").getStyleAttributes().setHided(this.isParamTable);
        if (objs == null || objs.length == 0) {
            return;
        }
        for (int i = 0; i < objs.length; ++i) {
            DumpliParamInfo info = (DumpliParamInfo)objs[i];
            IRow row = this.tblMain.addRow();
            row.getCell("id").setValue((Object)info.getId());
            row.getCell("orgName").setValue((Object)info.getOrgName());
            row.getCell("orgNumber").setValue((Object)info.getOrgNumber());
            row.getCell("paramNumber").setValue((Object)info.getParamNumber());
            row.getCell("paramName").setValue((Object)info.getParamName());
            row.getCell("Value").setValue((Object)info.getParamValue());
            row.getCell("valueAlias").setValue((Object)info.getParamValueAlias());
            row.getCell("lastUpdateTime").setValue((Object)info.getLastUpdateTime());
            row.getCell("orgType").setValue((Object)info.getOrgType());
            row.getCell("isUserEdit").setValue((Object)info.getIsUserEdit());
        }
        this.tblMain.getColumn("orgName").getStyleAttributes().setHided(this.isParamTable);
        this.tblMain.getColumn("orgNumber").getStyleAttributes().setHided(this.isParamTable);
        this.tblMain.getColumn("isUserEdit").getStyleAttributes().setHided(this.isParamTable);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int index = this.tblMain.getSelectManager().getActiveRowIndex();
        if (index < 0 || this.tblMain.getRow(index) == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.param.PARAMAutoGenerateResource", (String)"6_DeleteDumplicateParamUI"));
        } else {
            IRow row = this.tblMain.getRow(index);
            String id = (String)row.getCell("id").getValue();
            String oql = "where id = '" + id + "'";
            if (this.isParamTable) {
                ParamFactory.getRemoteInstance().deleteParamAndItems(id);
            } else {
                ParamItemFactory.getRemoteInstance().delete(oql);
            }
            this.tblMain.refresh();
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void btnAddIndex_actionPerformed(ActionEvent e) throws Exception {
        try {
            String indexSql = "If not exists (select * from KSQL_CONSTRAINTS where KSQL_CONS_NAME ='UX_BAS_ParamNum' and KSQL_CONS_TABNAME ='T_BAS_Param') ALTER TABLE T_BAS_Param ADD CONSTRAINT UX_BAS_ParamNum UNIQUE (FNumber);";
            indexSql = indexSql + "If not exists (select * from KSQL_CONSTRAINTS where KSQL_CONS_NAME ='UX_BAS_ParamKOrgT' and KSQL_CONS_TABNAME ='T_BAS_ParamItem') ALTER TABLE T_BAS_ParamItem ADD CONSTRAINT UX_BAS_ParamKOrgT UNIQUE (FKeyID , FOrgUnitID , FOrgTreeID);";
            this.iParam.exeCuteSqlThrowException(indexSql);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"addIndexSuccess"));
        }
        catch (Exception ex) {
            logger.info((Object)"Add ParamIndex err!", (Throwable)ex);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"addParamIndexFail_addFailMsg"));
        }
    }

    private void refreshTable() throws Exception {
        this.loadDumplicateParams();
        this.fillDumplicateParamsTable(this.sortDumplicateParams("paramNumber", false));
        this.setTableNameOnLable();
    }

    private void setTableNameOnLable() {
        if (this.isParamTable) {
            this.currentTableName.setText("T_BAS_Param");
        } else {
            this.currentTableName.setText("T_BAS_ParamItem");
        }
    }

    private DumplicateParamComparator getDumpParamComparatorFromCache(String key, boolean isRefresh) {
        DumplicateParamComparator comp = (DumplicateParamComparator)this.comparators.get(key);
        if (comp == null) {
            comp = new DumplicateParamComparator(key, true);
            this.comparators.put(key, comp);
        } else if (!isRefresh) {
            comp.setAscend(!comp.isAscend());
        }
        return comp;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int sortColIndex;
        String sortColKey;
        super.tblMain_tableClicked(e);
        if (e.getClickCount() == 1 && e.getType() == 0 && "paramNumber".equals(sortColKey = this.tblMain.getColumnKey(sortColIndex = e.getColIndex()))) {
            this.tblMain.removeRows();
        }
    }
}

