/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.param.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.param.client.AbstractParamCopyUI;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IPermissionRangeFacade;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermissionRangeFacadeFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.service.OrgRangeService;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.OuF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewOUUnionF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.client.BigMsgBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class ParamCopyUI
extends AbstractParamCopyUI {
    private static final Logger logger = CoreUIObject.getLogger(ParamCopyUI.class);
    private FullOrgUnitCollection destindationOrgUnit = new FullOrgUnitCollection();
    private final String ORG_NUMBER_CELLNAME = "orgNumber";
    private final String ORG_NAME_CELLNAME = "orgName";

    public void onLoad() throws Exception {
        super.onLoad();
        this.initOrgF7();
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.setClassName(this.getUIHandlerClassName());
            request.put("currentuserpk", (Object)ToolUtils.getCurrentUserPK());
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public RequestContext prepareActionSelectOrgUnit(IItemAction itemAction) throws Exception {
        RequestContext request = new RequestContext();
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
            request.put("currentuserpk", (Object)ToolUtils.getCurrentUserPK());
        }
        return request;
    }

    @Override
    public boolean isPrepareActionSelectOrgUnit() {
        return true;
    }

    @Override
    public RequestContext prepareActionSave(IItemAction itemAction) throws Exception {
        RequestContext request = new RequestContext();
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
            request.put("originalOrgUnit", (Object)this.getOriginalOrgUnit());
            request.put("destindationOrgUnit", (Object)this.destindationOrgUnit);
        }
        return request;
    }

    @Override
    public boolean isPrepareActionSave() {
        return true;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    private void initOrgF7() throws EASBizException, BOSException {
        IObjectPK curUserPK = ToolUtils.getCurrentUserPK();
        NewOUUnionF7 orgF7 = new NewOUUnionF7((IUIObject)this);
        orgF7.setShowSub(true);
        orgF7.disableTheOUWhichIsOnlyAdmin();
        orgF7.setMultiSelect(false);
        orgF7.setShowAssistantOrg(true);
        orgF7.setMultiRootUnitsSQL(PermissionRangeHelper.getBizUserCUOrgRangeSQL(null, (IObjectPK)curUserPK));
        if (!Administrator.isCUAdmin(null, (IObjectPK)ToolUtils.getCurrentUserPK())) {
            String extraSQL = PermissionRangeHelper.getUserOrgIdRangeSQL(null, (IObjectPK)curUserPK, (OrgRangeType)OrgRangeType.BIZ_ORG_TYPE);
            StringBuffer extraTreeFilter = new StringBuffer();
            extraTreeFilter.append("\"BASEUNIT\"").append(".FID IN (").append(extraSQL).append(")");
            orgF7.setExtraTreeFilters(extraTreeFilter.toString());
            try {
                FilterInfo outerFilter = new FilterInfo("unit.id in (" + extraSQL + ")");
                orgF7.setOuterFilterInfo(outerFilter);
            }
            catch (ParserException e) {
                throw new BOSException((Throwable)e);
            }
            orgF7.setNeedConsiderFaultTree(true);
        }
        this.kDBizPromptBoxOriginnalOrgUnit.setSelector((KDPromptSelector)orgF7);
        this.kDBizPromptBoxOriginnalOrgUnit.setEditable(false);
    }

    private void setF7ByUser(OuF7PromptDialog orgf7, IObjectPK targetUserPK) throws EASBizException, BOSException {
        if (!Administrator.isCUAdmin(null, (IObjectPK)ToolUtils.getCurrentUserPK())) {
            HashMap<String, Boolean> accreditOrgs = new HashMap<String, Boolean>();
            IPermissionRangeFacade iPermissionRangeFacade = PermissionRangeFacadeFactory.getRemoteInstance();
            Collection col = iPermissionRangeFacade.getOrgRange(ToolUtils.getCurrentUserPK(), ToolUtils.getCurrentUserPK());
            if (col != null) {
                Iterator it = col.iterator();
                while (it.hasNext()) {
                    accreditOrgs.put(it.next().toString(), Boolean.FALSE);
                }
            }
            orgf7.useFilter(accreditOrgs);
        }
        List cuIdList = OrgRangeService.getCUOrgRange(null, (IObjectPK)ToolUtils.getCurrentUserPK());
        try {
            orgf7.setCuIdList(cuIdList);
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
        }
        orgf7.setMultiCUs(true);
    }

    private IObjectPK getTargetUserPK() {
        Object object = this.getUIContext().get("userID");
        if (object == null) {
            return new ObjectUuidPK(this.getCurrentUser().getId());
        }
        return new ObjectUuidPK((String)this.getUIContext().get("userID"));
    }

    private UserInfo getCurrentUser() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    public void actionSelectOrgUnit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectOrgUnit_actionPerformed(e);
        Set selectedOrgs = this.getSelectedBizOrgRanges(this.destindationOrgUnit);
        NewOUUnionF7 dlg = null;
        IObjectPK curUserPK = ToolUtils.getCurrentUserPK();
        NewOUUnionF7 orgF7 = new NewOUUnionF7((IUIObject)this);
        orgF7.setShowSub(true);
        orgF7.disableTheOUWhichIsOnlyAdmin();
        orgF7.setMultiSelect(true);
        orgF7.setShowAssistantOrg(true);
        orgF7.setSelectedOrgIds(selectedOrgs);
        orgF7.setMultiRootUnitsSQL(PermissionRangeHelper.getBizUserCUOrgRangeSQL(null, (IObjectPK)curUserPK));
        if (!Administrator.isCUAdmin(null, (IObjectPK)ToolUtils.getCurrentUserPK())) {
            String extraSQL = PermissionRangeHelper.getUserOrgIdRangeSQL(null, (IObjectPK)curUserPK, (OrgRangeType)OrgRangeType.BIZ_ORG_TYPE);
            StringBuffer extraTreeFilter = new StringBuffer();
            extraTreeFilter.append("\"BASEUNIT\"").append(".FID IN (").append(extraSQL).append(")");
            orgF7.setExtraTreeFilters(extraTreeFilter.toString());
            try {
                FilterInfo outerFilter = new FilterInfo("unit.id in (" + extraSQL + ")");
                orgF7.setOuterFilterInfo(outerFilter);
            }
            catch (ParserException e1) {
                throw new BOSException((Throwable)e1);
            }
            orgF7.setNeedConsiderFaultTree(true);
        }
        dlg = orgF7;
        dlg.show();
        if (!dlg.isCanceled()) {
            FullOrgUnitInfo[] fullOrgUnitInfos = this.getOrgs(dlg.getData());
            if (fullOrgUnitInfos == null) {
                return;
            }
            this.kDTableDestinationOrgUnit.removeRows();
            this.destindationOrgUnit.clear();
            int size = fullOrgUnitInfos.length;
            for (int index = 0; index < size; ++index) {
                IRow row = this.kDTableDestinationOrgUnit.addRow();
                row.getCell("orgNumber").setValue((Object)fullOrgUnitInfos[index].getNumber());
                row.getCell("orgName").setValue((Object)fullOrgUnitInfos[index].getName());
                row.getStyleAttributes().setLocked(true);
                this.destindationOrgUnit.add(fullOrgUnitInfos[index]);
            }
        }
    }

    private Set getSelectedBizOrgRanges(FullOrgUnitCollection destindationOrgUnit) {
        HashSet<String> currentOrgs = new HashSet<String>();
        if (destindationOrgUnit != null && destindationOrgUnit.size() > 0) {
            Iterator iterator = destindationOrgUnit.iterator();
            FullOrgUnitInfo tempOrgUnitInfo = null;
            while (iterator.hasNext()) {
                tempOrgUnitInfo = (FullOrgUnitInfo)iterator.next();
                currentOrgs.add(tempOrgUnitInfo.getId().toString());
            }
        }
        return currentOrgs;
    }

    private FullOrgUnitInfo[] getOrgs(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof OrgUnitInfo) {
            return new FullOrgUnitInfo[]{((OrgUnitInfo)object).castToFullOrgUnitInfo()};
        }
        if (object instanceof OrgUnitInfo[]) {
            OrgUnitInfo[] orgUnitInfos = (OrgUnitInfo[])object;
            FullOrgUnitInfo[] fullOrgUnitInfos = new FullOrgUnitInfo[orgUnitInfos.length];
            int length = orgUnitInfos.length;
            for (int i = 0; i < length; ++i) {
                fullOrgUnitInfos[i] = orgUnitInfos[i].castToFullOrgUnitInfo();
            }
            return fullOrgUnitInfos;
        }
        throw new IllegalArgumentException("object is " + object);
    }

    private FullOrgUnitInfo getOriginalOrgUnit() {
        return (FullOrgUnitInfo)this.kDBizPromptBoxOriginnalOrgUnit.getData();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        FullOrgUnitInfo originalOrgUnit = null;
        originalOrgUnit = this.getOriginalOrgUnit();
        if (originalOrgUnit == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.param.ParamResource", (String)"originalOrgUnitIsNull"));
            return;
        }
        if (this.destindationOrgUnit == null || this.destindationOrgUnit.size() < 1) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.param.ParamResource", (String)"destinationOrgUnitIsNull"));
            return;
        }
        ParamItemCollection copyFailParamItem = null;
        copyFailParamItem = (ParamItemCollection)ParamManager.copyParam(null, originalOrgUnit, (IObjectCollection)this.destindationOrgUnit);
        if (copyFailParamItem != null && copyFailParamItem.size() > 0) {
            Iterator iterator = copyFailParamItem.iterator();
            ParamItemInfo tempParamItem = null;
            StringBuffer copyFailParamNumberListStr = new StringBuffer();
            while (iterator.hasNext()) {
                tempParamItem = (ParamItemInfo)iterator.next();
                copyFailParamNumberListStr.append(tempParamItem.getOrgUnitID().getName()).append("-").append(tempParamItem.getKeyID().getNumber()).append(", ");
            }
            copyFailParamNumberListStr.deleteCharAt(copyFailParamNumberListStr.lastIndexOf(","));
            copyFailParamNumberListStr.append(EASResource.getString((String)"com.kingdee.eas.base.param.ParamResource", (String)"copyParamFail"));
            BigMsgBox.showError((StringBuffer)copyFailParamNumberListStr);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.param.ParamResource", (String)"copyParamSuccess"));
        }
    }
}

