/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.param.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.param.ParamException;
import com.kingdee.eas.base.param.ParamInfo;
import com.kingdee.eas.base.param.ParamValueRangeInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ParamUtil {
    private static Logger logger = Logger.getLogger((String)ParamUtil.class.getName());
    public static final String allSubSys = "0000";
    public static final String customize = "9999";

    public static ParamInfo paramInfoClone(ParamInfo param) {
        ParamInfo paramInfoClone = new ParamInfo();
        if (param == null) {
            return null;
        }
        if (param.getId() != null) {
            paramInfoClone.setId(param.getId());
        }
        if (param.getNumber() != null) {
            paramInfoClone.setNumber(param.getNumber());
        }
        if (param.getDesc() != null) {
            paramInfoClone.setDesc(param.getDesc());
        }
        if (param.getSubSysID() != null) {
            paramInfoClone.setSubSysID(param.getSubSysID());
        }
        paramInfoClone.setOrgType(param.getOrgType());
        paramInfoClone.setIsUserDefine(param.isIsUserDefine());
        paramInfoClone.setCanBeModified(param.isCanBeModified());
        paramInfoClone.setDataType(param.getDataType());
        paramInfoClone.setTheValueRange(new ParamValueRangeInfo());
        if (param.getTheValueRange() != null && param.getTheValueRange().getMaxValue() != null) {
            paramInfoClone.getTheValueRange().setMaxValue(param.getTheValueRange().getMaxValue());
        }
        if (param.getTheValueRange() != null && param.getTheValueRange().getMinValue() != null) {
            paramInfoClone.getTheValueRange().setMinValue(param.getTheValueRange().getMinValue());
        }
        if (param.getTheValueRange() != null && param.getTheValueRange().getId() != null) {
            paramInfoClone.getTheValueRange().setId(param.getTheValueRange().getId());
        }
        if (param.getTheValueRange() != null && param.getTheValueRange().getValueEnum() != null) {
            paramInfoClone.getTheValueRange().setValueEnum(param.getTheValueRange().getValueEnum());
        }
        if (param.getTheValueRange() != null && param.getTheValueRange().getExclusValue() != null) {
            paramInfoClone.getTheValueRange().setExclusValue(param.getTheValueRange().getExclusValue());
        }
        if (param.getName() != null) {
            paramInfoClone.setName(param.getName());
        }
        if (param.getDefaultValue() != null) {
            paramInfoClone.setDefaultValue(param.getDefaultValue());
        }
        return paramInfoClone;
    }

    public static boolean isExclus(Vector exclusValue, String value) throws BOSException {
        for (int i = 0; i < exclusValue.size(); ++i) {
            if (!exclusValue.get(i).equals(String.valueOf(value))) continue;
            return false;
        }
        return true;
    }

    public static boolean checkEnum(String paramValue, ParamValueRangeInfo paramValueRange) throws BOSException, ParamException {
        Vector exclusValue = ParamUtil.getExclusValues(paramValueRange.getExclusValue());
        Vector enumValues = ParamUtil.getEnumValues(paramValueRange.getValueEnum());
        String trueValue = "";
        if (paramValueRange.getValueEnum() != null) {
            String[] value = paramValueRange.getValueEnum().split("#");
            int flag = new Integer(paramValue);
            trueValue = value[flag];
        }
        return ParamUtil.includeExclus(enumValues, exclusValue, trueValue);
    }

    public static boolean checkDate(String paramItemValue, ParamValueRangeInfo paramValueRange) throws BOSException, ParamException {
        Date itemDateTime = null;
        Date maxDateTime = null;
        Date minDateTime = null;
        DateFormat format = BOSLocaleUtil.getDateFormat();
        try {
            if (paramItemValue != null && !paramItemValue.equals("")) {
                itemDateTime = format.parse(paramItemValue.toString());
            }
            if (paramValueRange.getMaxValue() != null && !paramValueRange.getMaxValue().equals("")) {
                maxDateTime = format.parse(paramValueRange.getMaxValue().toString());
            }
            if (paramValueRange.getMinValue() != null && !paramValueRange.getMinValue().equals("")) {
                minDateTime = format.parse(paramValueRange.getMinValue().toString());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new ParamException(ParamException.DATATYPEERROR);
        }
        if (maxDateTime != null && itemDateTime != null && itemDateTime.after(maxDateTime)) {
            throw new ParamException(ParamException.PARAMVALUEBIGTHANMAX);
        }
        if (minDateTime != null && itemDateTime != null && itemDateTime.before(minDateTime)) {
            throw new ParamException(ParamException.PARAMVALUELITTLETHANMIN);
        }
        if (minDateTime != null && maxDateTime != null && maxDateTime.before(minDateTime)) {
            throw new ParamException(ParamException.PARAMVALUELITTLETHANMIN);
        }
        return true;
    }

    public static boolean checkDouble(String paramItemValue, ParamValueRangeInfo paramValueRange) throws BOSException, ParamException {
        Double paramValue = null;
        Double maxValue = null;
        Double minValue = null;
        try {
            if (paramItemValue != null && !paramItemValue.equals("")) {
                paramValue = Double.valueOf(paramItemValue);
            }
            if (paramValueRange.getMaxValue() != null && !paramValueRange.getMaxValue().equals("")) {
                maxValue = Double.valueOf(paramValueRange.getMaxValue());
            }
            if (paramValueRange.getMinValue() != null && !paramValueRange.getMinValue().equals("")) {
                minValue = Double.valueOf(paramValueRange.getMinValue());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new ParamException(ParamException.DATATYPEERROR);
        }
        if (paramValue != null && maxValue != null && paramValue.compareTo(maxValue) > 0) {
            throw new ParamException(ParamException.PARAMVALUEBIGTHANMAX);
        }
        if (paramValue != null && minValue != null && paramValue.compareTo(minValue) < 0) {
            throw new ParamException(ParamException.PARAMVALUELITTLETHANMIN);
        }
        if (maxValue != null && minValue != null && maxValue.compareTo(minValue) < 0) {
            throw new ParamException(ParamException.PARAMVALUELITTLETHANMIN);
        }
        Vector exclusValue = ParamUtil.getExclusValues(paramValueRange.getExclusValue());
        Vector enumValues = ParamUtil.getEnumValues(paramValueRange.getValueEnum());
        return ParamUtil.includeExclus(enumValues, exclusValue, paramItemValue);
    }

    public static boolean checkString(String paramItemValue, ParamValueRangeInfo paramValueRange) throws BOSException, ParamException {
        Vector exclusValue = ParamUtil.getExclusValues(paramValueRange.getExclusValue());
        Vector enumValues = ParamUtil.getEnumValues(paramValueRange.getValueEnum());
        return ParamUtil.includeExclus(enumValues, exclusValue, paramItemValue);
    }

    public static boolean includeExclus(Vector enumValues, Vector exclusValue, String paramValue) throws BOSException, ParamException {
        if (exclusValue.size() > 0 && !ParamUtil.isExclus(exclusValue, String.valueOf(paramValue))) {
            throw new ParamException(ParamException.PARAMITEMVALUEEXCLUS);
        }
        if (enumValues.size() > 0 && !ParamUtil.isInclue(enumValues, String.valueOf(paramValue))) {
            throw new ParamException(ParamException.PARAMITEMVALUENOTINCLUDE);
        }
        return true;
    }

    public static boolean isInclue(Vector enumValues, String value) throws BOSException {
        return enumValues.contains(String.valueOf(value));
    }

    public static boolean checkInt(String paramItemValue, ParamValueRangeInfo paramValueRange) throws BOSException, ParamException {
        Integer paramValue = null;
        Integer minValue = null;
        Integer maxValue = null;
        try {
            if (paramItemValue != null && !paramItemValue.equals("")) {
                paramValue = Integer.decode(paramItemValue);
            }
            if (paramValueRange.getMaxValue() != null && !paramValueRange.getMaxValue().equals("")) {
                maxValue = Integer.decode(paramValueRange.getMaxValue());
            }
            if (paramValueRange.getMinValue() != null && !paramValueRange.getMinValue().equals("")) {
                minValue = Integer.decode(paramValueRange.getMinValue());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new ParamException(ParamException.DATATYPEERROR);
        }
        if (maxValue != null && paramValue != null && paramValue.compareTo(maxValue) > 0) {
            throw new ParamException(ParamException.PARAMVALUEBIGTHANMAX);
        }
        if (minValue != null && paramValue != null && paramValue.compareTo(minValue) < 0) {
            throw new ParamException(ParamException.PARAMVALUELITTLETHANMIN);
        }
        if (minValue != null && maxValue != null && maxValue.compareTo(minValue) < 0) {
            throw new ParamException(ParamException.PARAMVALUELITTLETHANMIN);
        }
        Vector exclusValue = ParamUtil.getExclusValues(paramValueRange.getExclusValue());
        Vector enumValues = ParamUtil.getEnumValues(paramValueRange.getValueEnum());
        return ParamUtil.includeExclus(enumValues, exclusValue, paramItemValue);
    }

    public static Vector getExclusValues(String exclusString) throws BOSException {
        Vector<String> co = new Vector<String>();
        if (exclusString != null && !exclusString.trim().equals("")) {
            String[] stringCo = exclusString.split("#");
            for (int i = 0; i < stringCo.length; ++i) {
                if (stringCo[i].trim().equals("")) continue;
                co.add(stringCo[i]);
            }
        }
        return co;
    }

    public static Vector getEnumValues(String enumString) throws BOSException {
        Vector<String> co = new Vector<String>();
        if (enumString != null && !enumString.trim().equals("")) {
            String[] stringCo = enumString.split("#");
            for (int i = 0; i < stringCo.length; ++i) {
                if (stringCo[i].trim().equals("")) continue;
                co.add(stringCo[i]);
            }
        }
        return co;
    }

    public static Collection filterSameObj(Collection col) {
        if (col == null || col.size() == 0) {
            return new ArrayList();
        }
        Iterator it = col.iterator();
        HashSet alreadySet = new HashSet();
        ArrayList retList = new ArrayList();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj == null || alreadySet.contains(obj)) continue;
            retList.add(obj);
            alreadySet.add(obj);
        }
        return retList;
    }

    public static String aryToStr(List idList, boolean addChar) {
        if (idList == null || idList.isEmpty()) {
            return "''";
        }
        StringBuffer receivers = new StringBuffer();
        for (Object obj : idList) {
            if (obj == null) continue;
            if (addChar) {
                receivers.append("'").append(obj.toString()).append("',");
                continue;
            }
            receivers.append(obj.toString()).append(",");
        }
        String users = receivers.toString();
        if (users != null && users.trim().length() != 0 && users.endsWith(",") && users.trim().length() > 0) {
            users = users.substring(0, users.length() - 1);
        }
        return users;
    }

    public static void updateParamTimeStamp() {
        String className = "com.kingdee.eas.base.uiframe.app.LoginParamCacheServerUtil";
        try {
            Class<?> c = Class.forName(className);
            Method staticMethod = c.getDeclaredMethod("updateLastUpdateTime", new Class[0]);
            staticMethod.invoke(c, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (NoSuchMethodException ne) {
            logger.error((Object)"", (Throwable)ne);
        }
        catch (InvocationTargetException ie) {
            logger.error((Object)"", (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            logger.error((Object)"", (Throwable)iae);
        }
    }

    public static SelectorItemCollection getParamSelect() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isGroupControl"));
        sic.add(new SelectorItemInfo("canBeModified"));
        sic.add(new SelectorItemInfo("defaultValue"));
        sic.add(new SelectorItemInfo("orgType"));
        sic.add(new SelectorItemInfo("theValueRange"));
        sic.add(new SelectorItemInfo("dataType"));
        sic.add(new SelectorItemInfo("subSysID"));
        sic.add(new SelectorItemInfo("baseType"));
        sic.add(new SelectorItemInfo("valueAlias"));
        sic.add(new SelectorItemInfo("CU"));
        return sic;
    }

    public static SelectorItemCollection getParamItemSelect() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("IsControlSub"));
        sic.add(new SelectorItemInfo("IsModify"));
        sic.add(new SelectorItemInfo("Value"));
        sic.add(new SelectorItemInfo("keyID"));
        sic.add(new SelectorItemInfo("orgUnitID"));
        sic.add(new SelectorItemInfo("orgTreeID"));
        sic.add(new SelectorItemInfo("valueAlias"));
        sic.add(new SelectorItemInfo("CU"));
        return sic;
    }
}

