/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.param.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SoftMap
extends AbstractMap
implements Map {
    private Set entrySet = null;
    private Map hashMap;
    private ReferenceQueue queue = new ReferenceQueue();

    private void processQueue() {
        SoftKey sk;
        while ((sk = (SoftKey)this.queue.poll()) != null) {
            this.hashMap.remove(sk);
        }
    }

    public SoftMap() {
        this.hashMap = new HashMap();
    }

    public SoftMap(Map t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    public SoftMap(int initialCapacity) {
        this.hashMap = new HashMap(initialCapacity);
    }

    public SoftMap(int initialCapacity, float loadFactor) {
        this.hashMap = new HashMap(initialCapacity, loadFactor);
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.hashMap.containsKey(SoftKey.create(key));
    }

    public Object get(Object key) {
        return this.hashMap.get(SoftKey.create(key));
    }

    public Object put(Object key, Object value) {
        this.processQueue();
        return this.hashMap.put(SoftKey.create(key, this.queue), value);
    }

    public Object remove(Object key) {
        this.processQueue();
        return this.hashMap.remove(SoftKey.create(key));
    }

    @Override
    public void clear() {
        this.processQueue();
        this.hashMap.clear();
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    private class EntrySet
    extends AbstractSet {
        Set set;

        private EntrySet() {
            this.set = SoftMap.this.hashMap.entrySet();
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                Iterator iter;
                Entry next;
                {
                    this.iter = EntrySet.this.set.iterator();
                    this.next = null;
                }

                @Override
                public boolean hasNext() {
                    while (this.iter.hasNext()) {
                        Map.Entry ent = (Map.Entry)this.iter.next();
                        SoftKey sk = (SoftKey)ent.getKey();
                        Object k = null;
                        if (sk != null) {
                            Object t = sk.get();
                            k = t;
                            if (t == null) continue;
                        }
                        this.next = new Entry(ent, k);
                        return true;
                    }
                    return false;
                }

                public Object next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Entry element = this.next;
                    this.next = null;
                    return element;
                }

                @Override
                public void remove() {
                    this.iter.remove();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            int size = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                i.next();
                ++size;
            }
            return size;
        }

        @Override
        public boolean remove(Object o) {
            SoftMap.this.processQueue();
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object ev = e.getValue();
            SoftKey sk = SoftKey.create(e.getKey());
            Object hv = SoftMap.this.hashMap.get(sk);
            if (hv == null ? ev == null && SoftMap.this.hashMap.containsKey(sk) : hv.equals(ev)) {
                SoftMap.this.hashMap.remove(sk);
                return true;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Map.Entry ent : this.set) {
                Object v;
                SoftKey sk = (SoftKey)ent.getKey();
                if (sk == null) continue;
                h += sk.hashCode() ^ ((v = ent.getValue()) == null ? 0 : v.hashCode());
            }
            return h;
        }
    }

    private static class Entry
    implements Map.Entry {
        private Map.Entry ent;
        private Object key;

        Entry(Map.Entry ent, Object key) {
            this.ent = ent;
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.ent.getValue();
        }

        public Object setValue(Object value) {
            return this.ent.setValue(value);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object value = this.getValue();
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && (value == null ? e.getValue() == null : value.equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            Object value = this.getValue();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }
    }

    private static class SoftKey
    extends SoftReference {
        private int hashCode;

        private SoftKey(Object k) {
            super(k);
            this.hashCode = k.hashCode();
        }

        private static SoftKey create(Object k) {
            if (k == null) {
                return null;
            }
            return new SoftKey(k);
        }

        private SoftKey(Object k, ReferenceQueue q) {
            super(k, q);
            this.hashCode = k.hashCode();
        }

        private static SoftKey create(Object k, ReferenceQueue q) {
            if (k == null) {
                return null;
            }
            return new SoftKey(k, q);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SoftKey)) {
                return false;
            }
            Object t = this.get();
            Object u = ((SoftKey)o).get();
            if (t == null || u == null) {
                return false;
            }
            if (t == u) {
                return true;
            }
            return t.equals(u);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

