/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.receiver;

import com.kingdee.eas.base.receiver.item.NewClassItem;
import com.kingdee.eas.base.receiver.item.NewClassParamItem;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class NewClassEngine {
    private Logger logger = Logger.getLogger(NewClassEngine.class);
    private HashMap classMethodMap = new HashMap();
    private NewClassParamItem cpItem;

    public NewClassEngine() {
    }

    public NewClassEngine(NewClassParamItem cpItem) {
        this.cpItem = cpItem;
    }

    public void init() {
        this.classMethodMap = new HashMap();
    }

    public void setNewClassParamItem(NewClassParamItem cpItem) {
        this.cpItem = cpItem;
    }

    public Map engine(Object[] paramObject) {
        HashMap valueMap = null;
        if (this.cpItem == null || this.cpItem.getClassesName() == null || this.cpItem.getClassesName().length == 0) {
            return null;
        }
        valueMap = new HashMap();
        String classesName = "";
        Method method = null;
        for (int i = 0; i < this.cpItem.getClassesName().length; ++i) {
            classesName = this.cpItem.getClassesName()[i];
            NewClassItem ncItem = null;
            try {
                ncItem = this.getMethodByClassesName(classesName);
            }
            catch (Exception e1) {
                this.logger.info((Object)e1);
            }
            for (int j = 0; ncItem != null && j < ncItem.getMethods().length; ++j) {
                method = ncItem.getMethods()[j];
                try {
                    this.logger.info((Object)("----------NewClassEngine:" + classesName + " " + method.getName()));
                    this.putMethodValue(valueMap, method.getName(), (Set)method.invoke(ncItem.getClassObject(), paramObject));
                    continue;
                }
                catch (Exception e) {
                    this.logger.info((Object)e);
                }
            }
        }
        return valueMap;
    }

    public Set getValueByMap(String methodName, Map valueMap) {
        if (valueMap == null || valueMap.size() == 0 || !valueMap.containsKey(methodName) || valueMap.get(methodName) == null) {
            return null;
        }
        return (Set)valueMap.get(methodName);
    }

    private void putMethodValue(Map valueMap, String methodName, Set valueOb) {
        if (valueMap == null) {
            return;
        }
        HashSet set = null;
        if (!valueMap.containsKey(methodName)) {
            set = new HashSet();
            valueMap.put(methodName, set);
        } else {
            set = (HashSet)valueMap.get(methodName);
        }
        set.addAll(valueOb);
    }

    private boolean isCheckInterface(Class[] inter) {
        if (StringUtils.isEmpty((String)this.cpItem.getInterfaceName())) {
            return true;
        }
        for (int i = 0; i < inter.length; ++i) {
            if (inter[i].toString().indexOf(this.cpItem.getInterfaceName()) == -1) continue;
            return true;
        }
        return false;
    }

    private boolean isCheckAbstract(Class abst) {
        if (StringUtils.isEmpty((String)this.cpItem.getAbstractName())) {
            return true;
        }
        return this.cpItem.getInterfaceName().equals(abst.toString());
    }

    private NewClassItem getMethodByClassesName(String name) throws Exception {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        if (this.classMethodMap.containsKey(name)) {
            return (NewClassItem)this.classMethodMap.get(name);
        }
        Class<?> c = Class.forName(name);
        if (!this.isCheckInterface(c.getInterfaces()) && !this.isCheckAbstract(c.getSuperclass())) {
            return null;
        }
        Object o = c.newInstance();
        NewClassItem ncItem = new NewClassItem();
        ncItem.setClassObject(o);
        Method[] methods = null;
        Method[] tempMethods = c.getDeclaredMethods();
        if (this.cpItem.getMethodName() == null || this.cpItem.getMethodName().length == 0) {
            methods = tempMethods;
        } else {
            methods = new Method[this.cpItem.getMethodName().length];
            int num = 0;
            for (int i = 0; i < tempMethods.length && this.cpItem.getMethodName() != null && this.cpItem.getMethodName().length != 0; ++i) {
                for (int j = 0; j < this.cpItem.getMethodName().length; ++j) {
                    if (tempMethods[i].getName().indexOf(this.cpItem.getMethodName()[j]) == -1) continue;
                    methods[num++] = tempMethods[i];
                }
            }
        }
        ncItem.setMethods(methods);
        this.classMethodMap.put(name, ncItem);
        return ncItem;
    }
}

