/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.receiver.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.receiver.BasReleaseInfo;
import com.kingdee.eas.base.receiver.MessagePersonFacadeFactory;
import com.kingdee.eas.base.receiver.ReceiverConstant;
import com.kingdee.eas.base.receiver.client.ReceiversListUI;
import com.kingdee.eas.base.receiver.util.MemoryItem;
import com.kingdee.eas.base.receiver.util.MessageUtils;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.mobile.util.MobileUtil;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class MessageInputUtils {
    protected static final Logger logger = Logger.getLogger(MessageInputUtils.class);
    private StringBuffer viewText = null;
    private String tempText = "";
    private String tempText1 = "";
    private KDTextField kDTextField1;
    private BasReleaseInfo receiverInfo;
    public HashMap receiversMap;
    private HashMap inputReceiverMap;
    private HashMap inputMuReceiverMap;
    private Set phoneNumber;
    public static final String INPUTMAP = "INPUTMAP";
    public static final String INPUTMUMAP = "INPUTMUMAP";
    public static final String MEMORYITEM = "MEMORYITEM";
    private HashMap deleteMap;
    private HashMap tempMap;
    private HashMap deleteMuMap;
    private MemoryItem memoryItem = new MemoryItem();
    private boolean isUserPhone = false;

    private boolean isEmailAddress(String inputStr) {
        int index = inputStr.indexOf("@");
        return index > 0;
    }

    public MessageInputUtils() {
        this.phoneNumber = new HashSet();
    }

    public void setUserPhoneOrMail(boolean isUser) {
        this.isUserPhone = isUser;
    }

    public Set getPhoneNumberOrMail() {
        return this.phoneNumber;
    }

    public void initPhoneNumber() {
        this.phoneNumber = new HashSet();
    }

    private void putPhoneNumber(String num, Set set) {
        if (this.isUserPhone && (MobileUtil.isCellphoneNumber((String)num) || this.isEmailAddress(num))) {
            set.add(num);
        }
    }

    private String appendPhoneNumber(Set set, boolean isInit) {
        if (this.isUserPhone) {
            Iterator it = set.iterator();
            StringBuffer sb = new StringBuffer();
            String key = "";
            while (it.hasNext()) {
                key = (String)it.next();
                if (!isInit && (isInit || this.phoneNumber.contains(key))) continue;
                this.putPhoneNumber(key, this.phoneNumber);
                sb.append("[").append(key);
                sb.append("]").append(";   ");
            }
            return sb.toString();
        }
        return "";
    }

    private void initKDText() {
        this.kDTextField1.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    MessageInputUtils.this.kDTextField1_focusLost(e);
                }
                catch (Exception exc) {
                    logger.error((Object)"focusLost failed", (Throwable)exc);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                try {
                    MessageInputUtils.this.kDTextField1_focusGained(e);
                }
                catch (Exception exc) {
                    logger.error((Object)"focusGained failed", (Throwable)exc);
                }
            }
        });
        this.kDTextField1.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    MessageInputUtils.this.kDTextField1_keyReleased(e);
                }
                catch (Exception exc) {
                    logger.error((Object)"keyReleased failed", (Throwable)exc);
                }
            }
        });
    }

    protected void kDTextField1_focusGained(FocusEvent e) {
        this.tempText = this.kDTextField1.getText();
    }

    private void deletePhone(HashMap delMap) {
        Iterator it = delMap.entrySet().iterator();
        Map.Entry entry = null;
        String key = "";
        while (it.hasNext()) {
            entry = it.next();
            key = (String)entry.getKey();
            if (!this.phoneNumber.contains(key = key.substring(1, key.length() - 1))) continue;
            this.phoneNumber.remove(key);
        }
    }

    protected void kDTextField1_keyReleased(KeyEvent e) {
        if (e.getKeyChar() == ';' || e.getKeyChar() == '\uff1b') {
            this.checkText();
        }
        if (e.getKeyCode() != 17) {
            HashMap oldMap = MessageUtils.init().initInputText(this.tempText);
            HashMap nowMap = MessageUtils.init().initInputText(this.kDTextField1.getText());
            String str = "";
            if (this.tempMap == null) {
                this.tempMap = new HashMap();
            }
            this.tempMap = MessageUtils.init().compareHashMap(oldMap, nowMap);
            if (this.tempMap.size() > 0) {
                if (this.isUserPhone) {
                    this.deletePhone(this.tempMap);
                }
                this.deleteMap = (HashMap)this.tempMap.clone();
                this.tempText1 = str = MessageUtils.init().batchReceiversInfo(this.receiverInfo, this.deleteMap, this.inputReceiverMap, this.inputMuReceiverMap, this.deleteMuMap, true);
                this.tempText = MessageUtils.init().deleteString(this.inputReceiverMap);
                if (this.isUserPhone) {
                    this.tempText = this.tempText + this.appendPhoneNumber(this.phoneNumber, true);
                }
                this.kDTextField1.setText(this.tempText);
            }
        }
    }

    protected void kDTextField1_focusLost(FocusEvent e) {
        this.checkText();
    }

    private void checkText() {
        this.viewText = new StringBuffer();
        String str = MessageUtils.init().replaceString(this.kDTextField1.getText());
        String temp = "";
        ArrayList<String> ay = new ArrayList<String>();
        boolean initnum = false;
        StringTokenizer st = new StringTokenizer(str, String.valueOf(';'));
        HashSet map = new HashSet();
        while (st.hasMoreElements()) {
            temp = st.nextElement().toString().trim();
            if (temp.indexOf("[") == -1 && temp.indexOf("]") == -1) {
                ay.add(temp);
                this.putPhoneNumber(temp, map);
            } else if (temp.indexOf("[") > 0 && temp.indexOf("]") != -1 && !initnum) {
                ay.add(temp.substring(0, temp.indexOf("[")));
                temp = temp.substring(temp.indexOf("["), temp.indexOf("]") + 1) + ";   ";
                this.viewText.append(temp);
            } else {
                temp = temp + ";   ";
                this.viewText.append(temp);
            }
            initnum = true;
        }
        str = this.kDTextField1.getText();
        if (ay.size() != 0) {
            try {
                List list = MessagePersonFacadeFactory.getRemoteInstance().getSelectName(ay);
                MessageUtils.init().putReceiver(list, this.viewText, this.receiverInfo.getReceiver(), this.inputReceiverMap);
                if (list.size() == 0) {
                    this.viewText.append(this.appendPhoneNumber(map, false));
                }
            }
            catch (BOSException e) {
                logger.error((Object)"checkText failed", (Throwable)e);
            }
            this.tempText = this.viewText.toString().trim();
            this.kDTextField1.setText(this.tempText);
        }
    }

    public void initData(KDTextField kDTextField1, BasReleaseInfo receiverInfo) {
        this.kDTextField1 = kDTextField1;
        if (receiverInfo == null) {
            return;
        }
        this.receiverInfo = receiverInfo;
        if (this.memoryItem == null) {
            return;
        }
        this.kDTextField1.setEnabled(true);
        this.kDTextField1.setEditable(true);
        this.initKDText();
        if (this.inputReceiverMap == null) {
            this.inputReceiverMap = new HashMap();
        }
        if (this.inputMuReceiverMap == null) {
            this.inputMuReceiverMap = new HashMap();
        }
        if (this.deleteMuMap == null) {
            this.deleteMuMap = new HashMap();
        }
    }

    public void showReceiverUI(Object owner) {
        try {
            UIContext uiContext = new UIContext(owner);
            uiContext.put((Object)ReceiverConstant.RECEIVER_INFO, (Object)this.receiverInfo);
            uiContext.put((Object)INPUTMAP, (Object)this.inputReceiverMap);
            uiContext.put((Object)INPUTMUMAP, (Object)this.inputMuReceiverMap);
            uiContext.put((Object)MEMORYITEM, (Object)this.memoryItem);
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow window = uiFactory.create(ReceiversListUI.class.getName(), (Map)uiContext, null, null);
            ReceiversListUI receiversListUI = (ReceiversListUI)window.getUIObject();
            receiversListUI.setTextFieldReceivers(this.kDTextField1);
            window.show();
        }
        catch (UIException e) {
            logger.error((Object)"showReceiverUI failed", (Throwable)e);
        }
    }
}

