/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.receiver.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.IMAGroup;
import com.kingdee.eas.base.message.IMAGroupEntry;
import com.kingdee.eas.base.message.IMAGroupResolvent;
import com.kingdee.eas.base.message.IMAGroupResolventEntry;
import com.kingdee.eas.base.message.MAGroupEntryFactory;
import com.kingdee.eas.base.message.MAGroupEntryInfo;
import com.kingdee.eas.base.message.MAGroupFactory;
import com.kingdee.eas.base.message.MAGroupInfo;
import com.kingdee.eas.base.message.MAGroupResolventEntryFactory;
import com.kingdee.eas.base.message.MAGroupResolventEntryInfo;
import com.kingdee.eas.base.message.MAGroupResolventFactory;
import com.kingdee.eas.base.message.MAGroupResolventInfo;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.receiver.param.ReceiverBOSTypeEnum;
import com.kingdee.eas.base.receiver.util.ReceiverTools;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReceiversGetValueUtils {
    private Logger logger = Logger.getLogger(ReceiversGetValueUtils.class);
    private static ReceiversGetValueUtils receiversGetValueUtils = null;

    private ReceiversGetValueUtils() {
    }

    public static ReceiversGetValueUtils init() {
        if (receiversGetValueUtils == null) {
            receiversGetValueUtils = new ReceiversGetValueUtils();
        }
        return receiversGetValueUtils;
    }

    public void putPhoneOrMailByUser(UserCollection ucol, Set set, boolean isPhone, boolean isHaveValue) throws Exception {
        PersonCollection pcol = new PersonCollection();
        UserInfo uinfo = null;
        for (int i = 0; i < ucol.size(); ++i) {
            uinfo = ucol.get(i);
            try {
                if (isPhone) {
                    this.putPhoneOrMail(uinfo.getName(), uinfo.getCell(), set, isHaveValue);
                } else {
                    this.putPhoneOrMail(uinfo.getName(), uinfo.getEmail(), set, isHaveValue);
                }
                if (uinfo.getPerson() == null) continue;
                pcol.add(uinfo.getPerson());
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)"putPhoneOrMailByUser failed", (Throwable)e);
            }
        }
        this.putPhoneOrMail(pcol, set, isPhone, isHaveValue);
    }

    public PersonCollection getPersonCollectionByAdminOrg(Context ctx, Object valueOb) throws Exception {
        PersonCollection pcol = new PersonCollection();
        PersonInfo pinfo = null;
        HashSet tempSet = new HashSet();
        Set tempSet1 = ReceiverTools.init().getValue2SetID(valueOb, ReceiverBOSTypeEnum.BOS_ADMIN);
        if (tempSet1 != null) {
            tempSet.addAll(tempSet1);
        }
        if ((tempSet1 = ReceiverTools.init().getValue2SetID(valueOb, ReceiverBOSTypeEnum.BOS_FULLORG)) != null) {
            tempSet.addAll(tempSet1);
        }
        String sqlStr = ReceiverTools.init().getSelectByCollection(tempSet);
        StringBuffer sqlSB = new StringBuffer();
        sqlSB.append("SELECT \"PERSON\".FID,\"PERSON\".FName_l2,\"PERSON\".FName_l3,\"PERSON\".FCell,\"PERSON\".FEMail FROM T_BD_Person AS \"PERSON\"").append(" ");
        sqlSB.append("INNER JOIN T_ORG_PositionMember AS \"POSITIONMEMBER\"").append(" ");
        sqlSB.append("ON \"PERSON\".FID = \"POSITIONMEMBER\".FPersonID").append(" ");
        sqlSB.append("LEFT OUTER JOIN T_LCM_LCMRationLevel AS \"LCMRATIONLEVEL\"").append(" ");
        sqlSB.append("ON \"PERSON\".FLCMRationLevelID = \"LCMRATIONLEVEL\".FID").append(" ");
        sqlSB.append("INNER JOIN T_HR_BDEmployeeType AS \"EMPLOYEETYPE\"").append(" ");
        sqlSB.append("ON \"PERSON\".FEmployeeTypeID = \"EMPLOYEETYPE\".FID").append(" ");
        sqlSB.append("INNER JOIN T_ORG_Position AS \"POSITION\"").append(" ");
        sqlSB.append("ON \"POSITIONMEMBER\".FPositionID = \"POSITION\".FID").append(" ");
        sqlSB.append("INNER JOIN T_ORG_Admin AS \"ADMINORGUNIT\"").append(" ");
        sqlSB.append("ON \"POSITION\".FAdminOrgUnitID = \"ADMINORGUNIT\".FID").append(" ");
        sqlSB.append("where \"ADMINORGUNIT\".FID in ").append(sqlStr);
        sqlStr = sqlSB.toString();
        this.logger.info((Object)sqlStr);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
        while (rs.next()) {
            pinfo = new PersonInfo();
            pinfo.setId(BOSUuid.read((String)rs.getString("fid")));
            pinfo.setName(rs.getString("FName_l2"), LocaleUtils.getLocale((String)"L2"));
            pinfo.setName(rs.getString("FName_l3"), LocaleUtils.getLocale((String)"L3"));
            pinfo.setCell(rs.getString("FCell"));
            pinfo.setEmail(rs.getString("FEMail"));
            pcol.add(pinfo);
        }
        return pcol;
    }

    public PersonCollection getPersonCollectionByMAG(Context ctx, Object object) throws Exception {
        IPerson ip = null;
        IMAGroup im = null;
        IMAGroupEntry ime = null;
        IMAGroupResolvent imgr = null;
        IMAGroupResolventEntry ire = null;
        PersonInfo pinfo = null;
        MAGroupInfo magroupInfo = null;
        MAGroupEntryInfo magroupeinfo = null;
        MAGroupResolventInfo mainfo = null;
        MAGroupResolventEntryInfo entryInfo = null;
        PersonCollection pcol = new PersonCollection();
        String personid = "";
        if (ctx == null) {
            ip = PersonFactory.getRemoteInstance();
            im = MAGroupFactory.getRemoteInstance();
            ime = MAGroupEntryFactory.getRemoteInstance();
            imgr = MAGroupResolventFactory.getRemoteInstance();
            ire = MAGroupResolventEntryFactory.getRemoteInstance();
        } else {
            ip = PersonFactory.getLocalInstance((Context)ctx);
            im = MAGroupFactory.getLocalInstance((Context)ctx);
            ime = MAGroupEntryFactory.getLocalInstance((Context)ctx);
            imgr = MAGroupResolventFactory.getLocalInstance((Context)ctx);
            ire = MAGroupResolventEntryFactory.getLocalInstance((Context)ctx);
        }
        Set magID = ReceiverTools.init().getValue2SetID(object, ReceiverBOSTypeEnum.BOS_MAGROUP);
        String sqlStr = ReceiverTools.init().getSelectByCollection(magID);
        if (!StringUtils.isEmpty((String)sqlStr)) {
            mainfo = imgr.getMAGroupResolventInfo("select * where id in " + sqlStr);
            for (int n = 0; n < mainfo.getEntries().size(); ++n) {
                entryInfo = ire.getMAGroupResolventEntryInfo((IObjectPK)new ObjectUuidPK(mainfo.getEntries().get(n).getId().toString()));
                magroupInfo = im.getMAGroupInfo((IObjectPK)new ObjectUuidPK(entryInfo.getGroup().getId().toString()));
                if (magroupInfo == null) continue;
                for (int j = 0; j < magroupInfo.getEntries().size(); ++j) {
                    magroupeinfo = ime.getMAGroupEntryInfo((IObjectPK)new ObjectUuidPK(magroupInfo.getEntries().get(j).getId().toString()));
                    if (magroupeinfo.getPersonnel() == null || magroupeinfo.getPersonnel().getId() == null || StringUtils.isEmpty((String)(personid = magroupeinfo.getPersonnel().getId().toString()))) continue;
                    pinfo = ip.getPersonInfo((IObjectPK)new ObjectUuidPK(personid));
                    pcol.add(pinfo);
                }
            }
        }
        return pcol;
    }

    public void putPhoneOrMail(PersonCollection pcol, Set set, boolean isPhone, boolean isHaveValue) throws Exception {
        PersonInfo pinfo = null;
        for (int i = 0; i < pcol.size(); ++i) {
            pinfo = pcol.get(i);
            try {
                if (isPhone) {
                    this.putPhoneOrMail(pinfo.getName(), pinfo.getCell(), set, isHaveValue);
                    continue;
                }
                this.putPhoneOrMail(pinfo.getName(), pinfo.getEmail(), set, isHaveValue);
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)"putPhoneOrMail failed", (Throwable)e);
            }
        }
    }

    public void putPhoneOrMail(String infoName, String value, Set set, boolean isHaveValue) throws Exception {
        if (isHaveValue && !StringUtils.isEmpty((String)value)) {
            set.add(value);
        } else if (!isHaveValue && StringUtils.isEmpty((String)value)) {
            set.add(infoName);
        }
    }

    public UserCollection getUserCollection(Context ctx, Object object, ReceiverBOSTypeEnum renum) throws Exception {
        UserCollection col = new UserCollection();
        IUser iu = null;
        String str = "select * where id in ";
        if (renum.getValue().equals("80EF7DED")) {
            str = "select * where person in ";
        }
        iu = ctx == null ? UserFactory.getRemoteInstance() : UserFactory.getLocalInstance((Context)ctx);
        Set idSet = ReceiverTools.init().getValue2SetID(object, renum);
        String sqlStr = ReceiverTools.init().getSelectByCollection(idSet);
        if (!StringUtils.isEmpty((String)sqlStr)) {
            col = iu.getUserCollection(str + sqlStr);
        }
        return col;
    }
}

