/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.vc.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.vc.BankVCResultFilterParam;
import com.kingdee.eas.base.vc.client.AbstractBankVCResultFilterUI;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.BankVCFilterParam;
import com.kingdee.eas.fi.cas.CasContrastGLHelper;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.messaging.saaj.util.ByteOutputStream;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class BankVCResultFilterUI
extends AbstractBankVCResultFilterUI {
    private static final long serialVersionUID = -2461498601900981098L;
    private static final Logger logger = CoreUIObject.getLogger(BankVCResultFilterUI.class);
    private CompanyOrgUnitInfo company = null;
    String strCompanyId = null;
    AccountBankCollection acctBankColl = null;
    private static final String resourcePath = "com.kingdee.eas.fi.cas.CasResources";
    private boolean isLoaded;
    private BankVCFilterParam param;

    public BankVCResultFilterUI() throws Exception {
    }

    public BankVCResultFilterUI(BankVCFilterParam param) throws Exception {
        this.param = param;
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public void clear() {
        super.clear();
        this.setParam(this.param);
    }

    protected void init() throws Exception {
        if (this.param == null || this.param.getCompany() == null) {
            this.company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        } else {
            this.company = this.param.getCompany();
            this.btnCompanySelect.setEnabled(false);
        }
        PeriodHelper.initPeriodSpinner((CompanyOrgUnitInfo)this.company, (KDSpinner)this.spBeginYear, (KDSpinner)this.spBeginPeriodNum, (KDSpinner)this.spEndYear, (KDSpinner)this.spEndPeriodNum);
        FMClientHelper.manageAccountLevelRange((KDSpinner)this.spBeginYear, (KDSpinner)this.spEndYear, (KDSpinner)this.spBeginPeriodNum, (KDSpinner)this.spEndPeriodNum);
        this.strCompanyId = this.company.getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.strCompanyId));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)"false"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtBankAccount.setEntityViewInfo(evi);
        PeriodHelper.initPeriodSpinner((CompanyOrgUnitInfo)this.company, (KDSpinner)this.spBeginYear, (KDSpinner)this.spBeginPeriodNum);
        PeriodHelper.initPeriodSpinner((CompanyOrgUnitInfo)this.company, (KDSpinner)this.spEndYear, (KDSpinner)this.spEndPeriodNum);
        CasContrastGLHelper.initComboCurrency((KDComboBox)this.cboCurrency, (boolean)true);
        this.loadData();
    }

    private void setStateByPeriod(boolean bln) {
        this.lblBeginPeriod.setVisible(bln);
        this.lblBeginPeriodNum.setVisible(bln);
        this.lblEndPeriod.setVisible(bln);
        this.lblEndPeriodNum.setVisible(bln);
        this.kDLabel2.setVisible(bln);
        this.kDLabel3.setVisible(bln);
    }

    private void setStateByDate(boolean bln) {
        this.lblBeginDate.setVisible(bln);
        this.beginDate.setVisible(bln);
        this.lblEndDate.setVisible(bln);
        this.endDate.setVisible(bln);
    }

    @Override
    protected void radioBtnPeriod_stateChanged(ChangeEvent e) throws Exception {
        super.radioBtnPeriod_stateChanged(e);
        if (this.radioBtnPeriod.isSelected()) {
            this.setStateByPeriod(true);
            this.setStateByDate(false);
        }
    }

    @Override
    protected void radioBtnDate_stateChanged(ChangeEvent e) throws Exception {
        super.radioBtnDate_stateChanged(e);
        if (this.radioBtnDate.isSelected()) {
            this.setStateByPeriod(false);
            this.setStateByDate(true);
        }
    }

    public Object getParam() {
        BankVCResultFilterParam param = new BankVCResultFilterParam();
        param.setCompanyInfo(this.company);
        if (this.radioBtnPeriod.isSelected()) {
            param.setType(4);
        } else if (this.radioBtnDate.isSelected()) {
            param.setType(3);
        }
        int beginYear = (Integer)this.spBeginYear.getValue();
        param.setBeginPeriodYear(beginYear);
        int beginPeriodNum = (Integer)this.spBeginPeriodNum.getValue();
        param.setBeginPeriodNum(beginPeriodNum);
        int EndYear = (Integer)this.spEndYear.getValue();
        param.setEndPeriodYear(EndYear);
        int EndPeriodNum = (Integer)this.spEndPeriodNum.getValue();
        param.setEndPeriodNum(EndPeriodNum);
        PeriodInfo beginPeriod = CasContrastGLHelper.getPeriodInfo((int)beginYear, (int)beginPeriodNum);
        PeriodInfo endPeriod = CasContrastGLHelper.getPeriodInfo((int)EndYear, (int)EndPeriodNum);
        if (param.getType() == 4 && (beginPeriod == null || endPeriod == null)) {
            return null;
        }
        if (this.radioBtnPeriod.isSelected()) {
            param.setPeriodQuery(true);
            param.setBeginPeriod(beginPeriod);
            param.setEndPeriod(endPeriod);
            param.setBeginDate(beginPeriod.getBeginDate());
            param.setEndDate(endPeriod.getEndDate());
        } else {
            param.setPeriodQuery(false);
            param.setBeginDate(this.beginDate.getSqlDate());
            param.setEndDate(this.endDate.getSqlDate());
        }
        AccountBankInfo accountBankInfo = (AccountBankInfo)this.prmtBankAccount.getValue();
        param.setAccountBank(accountBankInfo);
        CurrencyInfo currencyInfo = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        param.setCurrency(currencyInfo);
        return param;
    }

    public void setParam(Object param) {
        if (param instanceof BankVCFilterParam) {
            this.param = (BankVCFilterParam)param;
            this.loadData();
        } else {
            BankVCResultFilterParam params = (BankVCResultFilterParam)param;
            this.company = params.getCompanyInfo() == null ? ContextHelperFactory.getRemoteInstance().getCurrentCompany() : params.getCompanyInfo();
            switch (params.getType()) {
                case 4: {
                    this.radioBtnPeriod.setSelected(true);
                    this.spBeginYear.setValue((Object)new Integer(params.getBeginPeriodYear()));
                    this.spBeginPeriodNum.setValue((Object)new Integer(params.getBeginPeriodNum()));
                    this.spEndYear.setValue((Object)new Integer(params.getEndPeriodYear()));
                    this.spEndPeriodNum.setValue((Object)new Integer(params.getEndPeriodNum()));
                    break;
                }
                case 3: {
                    this.radioBtnDate.setSelected(true);
                    this.beginDate.setValue((Object)params.getBeginDate());
                    this.endDate.setValue((Object)params.getEndDate());
                }
            }
            this.prmtBankAccount.setValue((Object)params.getAccountBank());
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)params.getCurrency());
        }
    }

    public void loadData() {
        if (this.param == null) {
            return;
        }
        this.company = this.param.getCompany() == null ? ContextHelperFactory.getRemoteInstance().getCurrentCompany() : this.param.getCompany();
        switch (this.param.getType()) {
            case 4: {
                this.radioBtnPeriod.setSelected(true);
                this.spBeginYear.setValue((Object)new Integer(this.param.getPeriodYear()));
                this.spBeginPeriodNum.setValue((Object)new Integer(this.param.getPeriodNum()));
                this.spEndYear.setValue((Object)new Integer(this.param.getPeriodYear()));
                this.spEndPeriodNum.setValue((Object)new Integer(this.param.getPeriodNum()));
                break;
            }
            case 3: {
                this.radioBtnDate.setSelected(true);
                this.beginDate.setValue((Object)this.param.getBeginDate());
                this.endDate.setValue((Object)this.param.getEndDate());
            }
        }
        this.prmtBankAccount.setValue((Object)this.param.getAccountBank());
        FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)this.param.getCurrency());
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        super.actionOK_actionPerformed(e);
    }

    public boolean verify() {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDBizPromptBox)this.prmtBankAccount, (String)"Bank_NullMsg");
        if (this.radioBtnPeriod.isSelected()) {
            int endYear = (Integer)this.spEndYear.getValue();
            int beginYear = (Integer)this.spBeginYear.getValue();
            int endNum = (Integer)this.spEndPeriodNum.getValue();
            int beginNum = (Integer)this.spBeginPeriodNum.getValue();
            if (endYear < beginYear || endYear == beginYear && endNum < beginNum) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.FMResource", (String)"beginDateNotGreaterEndDate"));
                SysUtil.abort();
            }
        }
        if (this.radioBtnDate.isSelected()) {
            if (this.beginDate.getValue() == null || this.endDate.getValue() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.FMResource", (String)"pkDateIsNull"));
                SysUtil.abort();
            }
            Date dateFrom = DateTimeUtils.truncateDate((Date)((Date)this.beginDate.getValue()));
            Date dateTo = DateTimeUtils.truncateDate((Date)((Date)this.endDate.getValue()));
            ClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (Date)dateFrom, (Date)dateTo);
        }
        return super.verify();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void bankAccountQueryInfo() throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.strCompanyId));
        if (!this.chkDestroyed.isSelected()) {
            filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)"false"));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("bank.*");
        selectors.add("account.*");
        this.prmtBankAccount.setSelectorCollection(selectors);
        this.prmtBankAccount.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void chkDestroyed_itemStateChanged(ItemEvent e) throws Exception {
        super.chkDestroyed_itemStateChanged(e);
        if (!this.chkDestroyed.isSelected()) {
            AccountBankInfo accountBank = (AccountBankInfo)this.prmtBankAccount.getValue();
            if (accountBank == null) {
                return;
            }
            if (accountBank.getCloseDate() != null) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.strCompanyId));
                filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)"false"));
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(filter);
                this.prmtBankAccount.setEntityViewInfo(evi);
                this.acctBankColl = CashClientHelper.getAccountBankCollection((String)this.strCompanyId, (boolean)false);
                if (this.acctBankColl != null) {
                    this.prmtBankAccount.setValue((Object)this.acctBankColl.get(0));
                } else {
                    this.prmtBankAccount.setValue(null);
                }
            }
        }
    }

    @Override
    protected void prmtBankAccount_willCommit(CommitEvent e) throws Exception {
        super.prmtBankAccount_willCommit(e);
        this.bankAccountQueryInfo();
    }

    @Override
    protected void prmtBankAccount_willShow(SelectorEvent e) throws Exception {
        super.prmtBankAccount_willShow(e);
        this.bankAccountQueryInfo();
    }

    @Override
    protected void prmtBankAccount_dataChanged(DataChangeEvent e) throws Exception {
        AccountBankInfo bankAcct = (AccountBankInfo)this.prmtBankAccount.getData();
        if (!EmptyUtil.isEmpty((CoreBaseInfo)bankAcct) && bankAcct.isIsByCurrency()) {
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)bankAcct.getCurrency());
            this.cboCurrency.setEnabled(false);
        } else {
            this.cboCurrency.setEnabled(true);
        }
    }

    @Override
    protected void spBeginYear_stateChanged(ChangeEvent e) throws Exception {
        this.spBeginPeriodNum.setModel((SpinnerModel)PeriodHelper.getMonthSnm((CompanyOrgUnitInfo)this.company, (Integer)((Integer)this.spBeginYear.getValue())));
    }

    @Override
    protected void spEndYear_stateChanged(ChangeEvent e) throws Exception {
        this.spEndPeriodNum.setModel((SpinnerModel)PeriodHelper.getMonthSnm((CompanyOrgUnitInfo)this.company, (Integer)((Integer)this.spEndYear.getValue())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomerParams getCustomerParams() {
        Object param = this.getParam();
        if (param == null) {
            return null;
        }
        CustomerParams cp = new CustomerParams();
        ObjectOutputStream objectOs = null;
        try {
            ByteOutputStream byteOs = new ByteOutputStream();
            objectOs = new ObjectOutputStream((OutputStream)byteOs);
            objectOs.writeObject(param);
            byte[] bytes = byteOs.getBytes();
            String paramValue = new String(FMHelper.encode((byte[])bytes));
            cp.addCustomerParam("fmcustomer", paramValue);
            FMHelper.close((ObjectOutputStream)objectOs);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        finally {
            FMHelper.close(objectOs);
        }
        return cp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void setCustomerParams(CustomerParams cp) {
        Object param;
        block9: {
            if (cp == null) {
                return;
            }
            String paramValue = cp.getCustomerParam("fmcustomer");
            if (FMHelper.isEmpty((String)paramValue)) {
                return;
            }
            param = null;
            ObjectInputStream objectIs = null;
            try {
                byte[] bytes = FMHelper.decode((byte[])paramValue.getBytes());
                ByteInputStream byteIs = new ByteInputStream(bytes, bytes.length);
                objectIs = new ObjectInputStream((InputStream)byteIs);
                param = objectIs.readObject();
                FMHelper.close((ObjectInputStream)objectIs);
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            catch (ClassNotFoundException e2) {
                logger.error((Object)e2);
                break block9;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                FMHelper.close(objectIs);
            }
        }
        this.setParam(param);
    }

    protected Class getParamClass() {
        return BankVCResultFilterParam.class;
    }
}

