/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.vc.client;

import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.resource.KDResourceManager;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.base.commonquery.client.CommonEntityDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PromptQueryBox
extends JComponent
implements IKDComponent,
IKDEditor {
    protected static final Image icon_off = KDResourceManager.getImage((String)"prompt_off.gif");
    protected static final Image icon_disable = KDResourceManager.getImage((String)"prompt_disable.gif");
    protected static final Image icon_clear = KDResourceManager.getImage((String)"prompt_clear.gif");
    protected KDTextField edt;
    protected JButton btn;
    protected PromptBoxLayout pl;
    protected boolean commitFlag = false;
    protected Component component;
    protected CommonEntityDialog commonEntityDialog;
    protected EntityViewInfo evi;
    protected PromptBoxListener listener = this.createPromptBoxListener(this);
    protected DataChangeHandler dataHandler;
    protected Object data;
    private transient ChangeEvent changeEvent;
    private transient DataChangeEvent dataEvent;
    protected Object userObject = null;

    public PromptQueryBox() {
        this.edt = new KDTextField();
        this.edt.setEnabledPopup(false);
        this.edt.setEditable(false);
        this.edt.setFocusable(true);
        this.btn = new JButton();
        this.btn.setIcon(new ImageIcon(icon_off));
        this.btn.setFocusable(true);
        this.edt.addActionListener((ActionListener)this.listener);
        this.edt.addKeyListener((KeyListener)this.listener);
        this.btn.addKeyListener(this.listener);
        this.btn.addActionListener(this.listener);
        this.add((Component)this.edt);
        this.add(this.btn);
        this.pl = new PromptBoxLayout();
        this.pl.addLayoutComponent("Editor", (Component)this.edt);
        this.pl.addLayoutComponent("Button", this.btn);
        this.setLayout(this.pl);
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object o) {
        this.userObject = o;
    }

    public void addDataChangeListener(DataChangeListener listener) {
        this.listenerList.add(DataChangeListener.class, listener);
        if (this.dataHandler == null) {
            this.dataHandler = new DataChangeHandler();
            this.addChangeListener(this.dataHandler);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    public Object getValue() {
        return this.getData();
    }

    public boolean isDisplay() {
        return this.isVisible();
    }

    public Object getData() {
        return this.data;
    }

    public void removeDataChangeListener(DataChangeListener listener) {
        this.listenerList.remove(DataChangeListener.class, listener);
    }

    public void setDisplay(boolean isDisplay) {
        this.setVisible(isDisplay);
    }

    public void setValue(Object value) {
        this.setData(value);
    }

    public void setData(Object newdata) {
        if (this.dataEvent == null) {
            this.dataEvent = new DataChangeEvent((Object)this);
        }
        this.dataEvent.setOldValue(this.data);
        if (this.data == null && newdata != null || this.data != null && !this.data.equals(newdata)) {
            boolean isDataOk = true;
            if (newdata != null) {
                DataWrapper wrapper = new DataWrapper(newdata);
                newdata = wrapper.getData();
            }
            if (isDataOk) {
                this.data = newdata;
                this.updateData();
                this.fireStateChanged();
            } else {
                this.data = null;
                this.fireStateChanged();
            }
        } else if (this.data == null) {
            this.updateData();
        }
    }

    public void updateData() {
        this.setText(this.valueToString(this.data));
    }

    protected void setText(String t) {
        this.edt.setText(t);
        this.setCommitAtFocusLost(false);
    }

    protected String valueToString(Object o) {
        String ret = "";
        if (o != null) {
            ret = o.toString();
        }
        return ret;
    }

    protected void setCommitAtFocusLost(boolean aFlag) {
        this.commitFlag = aFlag;
    }

    protected PromptBoxListener createPromptBoxListener(PromptQueryBox pb) {
        return new PromptBoxListener(pb);
    }

    protected void fireDataChanged(DataChangeEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataChangeListener.class) continue;
            ((DataChangeListener)listeners[i + 1]).dataChanged(event);
        }
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public void showcommQuery() {
        if (this.commonEntityDialog == null) {
            return;
        }
        this.commonEntityDialog.show();
        this.setEvi(this.commonEntityDialog.getEntityViewInfoResult());
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public EntityViewInfo getEvi() {
        return this.evi;
    }

    public void setEvi(EntityViewInfo info) {
        this.evi = info;
    }

    public CommonEntityDialog getCommonEntityDialog() {
        return this.commonEntityDialog;
    }

    public void setCommonEntityDialog(CommonEntityDialog commonEntityDialog) {
        this.commonEntityDialog = commonEntityDialog;
    }

    static class DataWrapper {
        protected Object data;

        public DataWrapper(Object data) {
            this.data = data;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object object) {
            this.data = object;
        }
    }

    public static class PromptBoxListener
    implements KeyListener,
    ActionListener,
    FocusListener,
    DocumentListener {
        protected boolean isCtrlDown = false;
        protected PromptQueryBox prompt;

        public PromptBoxListener(PromptQueryBox b) {
            this.prompt = b;
        }

        protected synchronized void setCtrlDown(boolean isDown) {
            if (this.isCtrlDown == isDown) {
                return;
            }
            this.isCtrlDown = isDown;
            if (this.isCtrlDown) {
                this.prompt.btn.setIcon(new ImageIcon(icon_clear));
            } else {
                this.prompt.btn.setIcon(new ImageIcon(icon_off));
            }
        }

        protected boolean isCtrlDown() {
            return this.isCtrlDown;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (keyCode == 118) {
                this.prompt.showcommQuery();
            } else if (keyCode == 17) {
                this.setCtrlDown(true);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (keyCode == 17) {
                this.setCtrlDown(false);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object comp = e.getSource();
            if (comp == this.prompt.btn) {
                if (!this.prompt.hasFocus()) {
                    this.prompt.requestFocus();
                }
                if (this.isCtrlDown()) {
                    this.prompt.setData(null);
                } else {
                    this.prompt.showcommQuery();
                }
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.setCtrlDown(false);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }
    }

    private static class PromptBoxLayout
    implements LayoutManager {
        private static final Dimension zeroSize = new Dimension(0, 0);
        private Component button = null;
        private Component editor = null;

        private PromptBoxLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if ("Button".equals(name)) {
                this.button = comp;
            } else if ("Editor".equals(name)) {
                this.editor = comp;
            }
        }

        @Override
        public void layoutContainer(Container parent) {
            int buttonsX;
            int editorX;
            Insets insets = parent.getInsets();
            int availWidth = parent.getWidth() - (insets.left + insets.right);
            int availHeight = parent.getHeight() - (insets.top + insets.bottom);
            Dimension buttonD = new Dimension(19, 19);
            int buttonWidth = buttonD.width;
            int editorWidth = availWidth - buttonWidth - 2;
            if (parent.getComponentOrientation().isLeftToRight()) {
                editorX = insets.left;
                buttonsX = editorX + editorWidth + 2;
            } else {
                buttonsX = insets.left;
                editorX = buttonsX + buttonWidth + 2;
            }
            this.setBounds(this.editor, editorX, (availHeight - buttonD.height) / 2, editorWidth, buttonD.height);
            this.setBounds(this.button, buttonsX, (availHeight - buttonD.height) / 2, buttonWidth, buttonD.height);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension buttonD = new Dimension(19, 19);
            Dimension editorD = new Dimension(this.preferredSize((Component)this.editor).width, 19);
            Dimension size = new Dimension(buttonD.width, buttonD.height);
            size.width += editorD.width;
            if (parent != null) {
                Insets insets = parent.getInsets();
                size.width += insets.left + insets.right;
                size.height += insets.top + insets.bottom;
            }
            return size;
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        private void setBounds(Component comp, int x, int y, int width, int height) {
            if (comp != null) {
                comp.setBounds(x, y, width, height);
            }
        }

        private Dimension preferredSize(Component comp) {
            return comp == null ? zeroSize : comp.getPreferredSize();
        }
    }

    protected class DataChangeHandler
    implements ChangeListener {
        protected DataChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            PromptQueryBox.this.dataEvent.setNewValue(PromptQueryBox.this.getValue());
            PromptQueryBox.this.fireDataChanged(PromptQueryBox.this.dataEvent);
        }
    }
}

