/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.vc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDataStyle;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.CellTextRender;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.base.vc.DiffTypeEnum;
import com.kingdee.eas.base.vc.VcDiffRuleCollection;
import com.kingdee.eas.base.vc.VcDiffRuleInfo;
import com.kingdee.eas.base.vc.VcSchemeBizObjCollection;
import com.kingdee.eas.base.vc.VcSchemeBizObjInfo;
import com.kingdee.eas.base.vc.VcSchemeInfo;
import com.kingdee.eas.base.vc.client.AbstractVerifyProject5;
import com.kingdee.eas.base.vc.client.BizObjPropSelectF7;
import com.kingdee.eas.base.vc.client.BizPropSelectObject;
import com.kingdee.eas.base.vc.util.VcUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class VerifyProject5
extends AbstractVerifyProject5 {
    private VcSchemeInfo aVcSchemeInfo = null;
    private Action actAdd = null;
    private Action actDel = null;
    private boolean isLoaded = false;
    private int precision = 4;

    public VerifyProject5() throws Exception {
        this.initLayout();
        this.initContainer();
    }

    @Override
    public void loadFields() {
        CurrencyInfo baseCurrency;
        super.loadFields();
        CompanyOrgUnitInfo fiUnit = SysContext.getSysContext().getCurrentFIUnit();
        if (fiUnit != null && (baseCurrency = fiUnit.getBaseCurrency()) != null && baseCurrency.getId() != null) {
            try {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                CurrencyInfo tmpCurrency = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrency.getId()));
                if (tmpCurrency.getPrecision() > 0) {
                    this.precision = tmpCurrency.getPrecision();
                }
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
            catch (EASBizException e2) {
                e2.printStackTrace();
            }
        }
        this.initTableHead();
        if (!this.isLoaded) {
            try {
                this.addEditDataToTable();
            }
            catch (Exception es) {
                es.printStackTrace();
                this.handUIException(es);
            }
            this.isLoaded = true;
        }
        if (this.oprtState.equals(OprtState.ADDNEW)) {
            this.addLine();
        }
        if (!this.aVcSchemeInfo.isIsDiff()) {
            this.aVcSchemeInfo.getDiffRule().clear();
            this.tableCond.removeRows();
            this.isLoaded = false;
        }
    }

    private void addEditDataToTable() throws Exception {
        if ("ADDNEW".equals(this.oprtState)) {
            return;
        }
        VcDiffRuleCollection ruleColl = this.aVcSchemeInfo.getDiffRule();
        if (ruleColl == null) {
            return;
        }
        if (!this.aVcSchemeInfo.isIsDiff()) {
            return;
        }
        Object cellValueAttribute = null;
        IRow row = null;
        BizPropSelectObject bizPropSelectObj = null;
        String strBizObj = "";
        String strPropFullName = "";
        String strPropAlias = "";
        Object vcSchemeBizObjInfo = null;
        VcDiffRuleInfo ruleInfo = null;
        VcUtil vcUtil = null;
        for (int i = 0; i < ruleColl.size(); ++i) {
            ruleInfo = ruleColl.get(i);
            vcUtil = new VcUtil();
            this.addLine();
            int rowCount = this.tableCond.getRowCount();
            row = this.tableCond.getRow(rowCount - 1);
            strPropFullName = ruleInfo.getPropFullName();
            strBizObj = "";
            strPropAlias = ruleInfo.getPropAliasName();
            bizPropSelectObj = new BizPropSelectObject(strPropAlias, strPropFullName, strBizObj);
            row.getCell(0).setValue((Object)bizPropSelectObj);
            DiffTypeEnum type = ruleInfo.getDiffType();
            if (type != null) {
                row.getCell(1).setValue((Object)type.getAlias());
            }
            row.getCell(2).setValue((Object)ruleInfo.getCeiling());
            row.getCell(3).setValue((Object)ruleInfo.getFloor());
        }
    }

    private void initTableHead() {
        int width = this.tableCond.getWidth();
        this.tableCond.getColumn(0).setWidth(width / 2 - 30);
        this.tableCond.getColumn(1).setWidth(width / 6);
        this.tableCond.getColumn(2).setWidth(width / 6);
        this.tableCond.getColumn(3).setWidth(width / 6);
        KDTDataStyle ds = new KDTDataStyle();
        try {
            ds.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)VcUtil.createDecimalFieldForInit()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        KDFormattedTextField formator1 = new KDFormattedTextField(1);
        formator1.setPrecision(this.precision);
        formator1.setDataVerifierType(12);
        KDFormattedTextField formator2 = new KDFormattedTextField(1);
        formator2.setPrecision(this.precision);
        formator2.setDataVerifierType(12);
        this.tableCond.getColumn(2).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formator1));
        this.tableCond.getColumn(3).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formator2));
        this.tableCond.putDefaultRenderers(BigDecimal.class, (IBasicRender)new VcDiffRender());
    }

    @Override
    public void storeFields() {
        super.storeFields();
        HashMap<String, BizPropSelectObject> hash = new HashMap<String, BizPropSelectObject>();
        int m = this.tableCond.getRowCount();
        for (int i = 0; i < m; ++i) {
            BizPropSelectObject selectObject = (BizPropSelectObject)this.tableCond.getRow(i).getCell(0).getValue();
            if (selectObject == null) continue;
            if (hash.get(selectObject.getPropertyAlias()) == null) {
                hash.put(selectObject.getPropertyAlias(), selectObject);
                continue;
            }
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.vc.VcResource", (String)"OnePropOneDiffRule"));
            SysUtil.abort();
        }
        this.delThisSchemeDiff();
        try {
            for (int j = 0; j < this.tableCond.getRowCount(); ++j) {
                this.storeLineData(j);
            }
        }
        catch (Exception es) {
            es.printStackTrace();
            this.handUIException(es);
        }
    }

    private void storeLineData(int j) {
        VcDiffRuleInfo ruleInfo = new VcDiffRuleInfo();
        IRow row = this.tableCond.getRow(j);
        String propName = "";
        String bizObjName = "";
        String strExpression = "";
        ruleInfo.setVcScheme(this.aVcSchemeInfo);
        if (row.getCell(0).getValue() != null && row.getCell(0).getValue() instanceof BizPropSelectObject) {
            BizPropSelectObject ep = (BizPropSelectObject)row.getCell(0).getValue();
            ruleInfo.setPropAliasName(ep.getPropertyAlias());
            ruleInfo.setPropFullName(ep.getPropertyFullName());
            String type = (String)row.getCell(1).getValue();
            if (type.equals(DiffTypeEnum.Value.getAlias())) {
                ruleInfo.setDiffType(DiffTypeEnum.Value);
            } else if (type.equals(DiffTypeEnum.Percent.getAlias())) {
                ruleInfo.setDiffType(DiffTypeEnum.Percent);
            }
            BigDecimal ceiling = (BigDecimal)row.getCell(2).getValue();
            ruleInfo.setCeiling((BigDecimal)row.getCell(2).getValue());
            ruleInfo.setFloor((BigDecimal)row.getCell(3).getValue());
            this.aVcSchemeInfo.getDiffRule().add(ruleInfo);
        }
    }

    public VcSchemeInfo getAVcSchemeInfo() {
        return this.aVcSchemeInfo;
    }

    public void setAVcSchemeInfo(VcSchemeInfo vcSchemeInfo) {
        this.aVcSchemeInfo = vcSchemeInfo;
    }

    public boolean verifyInput() {
        return true;
    }

    private void initContainer() {
        this.actAdd = new AbstractAction("", VcUtil.getCommonIcon("imgTbtn_addline")){

            @Override
            public void actionPerformed(ActionEvent e) {
                VerifyProject5.this.addLine();
                VerifyProject5.this.tableCond.setRefresh(true);
                VerifyProject5.this.tableCond.reLayoutAndPaint();
            }
        };
        this.actDel = new AbstractAction("", VcUtil.getCommonIcon("imgTbtn_deleteline")){

            @Override
            public void actionPerformed(ActionEvent e) {
                VerifyProject5.this.delLine();
            }
        };
        this.actAdd.putValue("ShortDescription", VcUtil.getString("addLine"));
        this.actDel.putValue("ShortDescription", VcUtil.getString("delLine"));
        this.kDContainer1.add(this.actAdd);
        this.kDContainer1.add(this.actDel);
        this.kDContainer1.setEnableActive(false);
    }

    private void addLine() {
        if (!this.aVcSchemeInfo.isIsDiff()) {
            return;
        }
        int iRow = this.tableCond.getRowCount();
        if (iRow != -1) {
            IRow row = this.tableCond.addRow(iRow);
            VcSchemeBizObjInfo bizObjInfo = null;
            KDTDefaultCellEditor ceEnable = null;
            ICell cellValueAttribute = null;
            EntityObjectInfo entityObjInfo = null;
            ArrayList<EntityObjectInfo> entityList = new ArrayList<EntityObjectInfo>();
            VcSchemeBizObjCollection bizObjColl = this.aVcSchemeInfo.getSchemeBizObj();
            for (int i = 0; i < bizObjColl.size(); ++i) {
                bizObjInfo = bizObjColl.get(i);
                entityObjInfo = VcUtil.getEntityFormName(bizObjInfo.getBizObj());
                entityList.add(entityObjInfo);
            }
            ceEnable = new KDTDefaultCellEditor((IKDEditor)this.createPropertyNameF7(entityList));
            cellValueAttribute = row.getCell(0);
            cellValueAttribute.setEditor((ICellEditor)ceEnable);
            Object[] strType = new String[]{DiffTypeEnum.Value.getAlias(), DiffTypeEnum.Percent.getAlias()};
            KDComboBox comboxOper = new KDComboBox(strType);
            ceEnable = new KDTDefaultCellEditor((JComboBox)comboxOper);
            cellValueAttribute = row.getCell(1);
            cellValueAttribute.setEditor((ICellEditor)ceEnable);
            cellValueAttribute.setValue((Object)DiffTypeEnum.Value.getAlias());
            row.getCell(2).setValue((Object)new BigDecimal("0"));
            row.getCell(3).setValue((Object)new BigDecimal("0"));
        }
    }

    private void delLine() {
        int index = this.tableCond.getSelectManager().getActiveRowIndex();
        if (index < 0) {
            return;
        }
        this.tableCond.removeRow(index);
    }

    private KDBizPromptBox createPropertyNameF7(ArrayList entityObjList) {
        KDBizPromptBox propertyNameF7 = new KDBizPromptBox();
        try {
            propertyNameF7 = new KDBizPromptBox();
            BizObjPropSelectF7 f7 = new BizObjPropSelectF7();
            f7.setEntityObjectList(entityObjList);
            IMetaDataLoader metaLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            f7.setMetaLoader(metaLoader);
            f7.setIsVAProp(true);
            f7.setParentWindow((Object)this);
            f7.setTitle(VcUtil.getString("Verify_Prop_Setting"));
            propertyNameF7.setSelector((KDPromptSelector)f7);
            BizPropSelectObject formatter = null;
            formatter = new BizPropSelectObject("", "", "");
            propertyNameF7.setDisplayFormatter((IFormatter)formatter);
            propertyNameF7.setCommitParser((IParser)formatter);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        return propertyNameF7;
    }

    private void delThisSchemeDiff() {
        if (this.aVcSchemeInfo.getId() == null) {
            return;
        }
        try {
            this.aVcSchemeInfo.getDiffRule().clear();
        }
        catch (Exception es) {
            es.printStackTrace();
            this.handUIException(es);
        }
    }

    class VcDiffRender
    extends CellTextRender
    implements IBasicRender {
        VcDiffRender() {
        }

        public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
            if (object != null && object instanceof BigDecimal) {
                BigDecimal value = (BigDecimal)object;
                KDFormattedTextField formator = new KDFormattedTextField(1);
                formator.setPrecision(4);
                formator.setDataVerifierType(12);
                formator.setValue((Object)value);
                String text = formator.getText();
                int dotIndex = text.indexOf(".");
                if (dotIndex < 0) {
                    text = text + ".";
                    for (int i = 0; i < VerifyProject5.this.precision; ++i) {
                        text = text + "0";
                    }
                } else {
                    int m = VerifyProject5.this.precision + 1 - text.length() + dotIndex;
                    for (int i = 0; i < m; ++i) {
                        text = text + "0";
                    }
                }
                super.draw(graphics, clip, (Object)text, cellStyle);
            }
        }
    }
}

