/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.arcm.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class OACommonDataProvider
implements BOSQueryDelegate {
    private Set ids = null;
    private IMetaDataPK qpk = null;
    private Context ctx;

    public OACommonDataProvider(Context ctx, List id, IMetaDataPK qpk) {
        this.ids = new HashSet(id);
        this.qpk = qpk;
        this.ctx = ctx;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet iRowSet = null;
        IQueryExecutor exec = null;
        EntityViewInfo ev = null;
        FilterInfo filter = null;
        int colCount = 0;
        try {
            if (ds.getID().startsWith("multiApproveQuery")) {
                IRowSet currentRowset = this.executeQuery("com.kingdee.eas.base.multiapprove.app.MultiApproveQuery");
                IRowSet historyRowset = this.executeQuery("com.kingdee.eas.base.multiapprove.app.MultiapproveHstQuery");
                String[] columnNames = new String[]{"Multiapprove.createTime", "personId.name", "MultiApprove.opinion", "MultiApprove.handlerOpinion", "MultiApprove.isPass", "AssignDetail.actdefName"};
                colCount = columnNames.length;
                DynamicRowSet rowSet = new DynamicRowSet(colCount);
                for (int i = 0; i < colCount; ++i) {
                    ColInfo colInfo = new ColInfo();
                    colInfo.colType = 12;
                    colInfo.columnName = columnNames[i];
                    colInfo.nullable = 1;
                    rowSet.setColInfo(i + 1, colInfo);
                }
                this.concatRowSet(currentRowset, rowSet);
                this.concatRowSet(historyRowset, rowSet);
                rowSet.beforeFirst();
                return rowSet;
            }
            exec = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)this.qpk);
            exec.option().isAutoTranslateEnum = true;
            ev = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.ids, CompareType.INCLUDE));
            ev.setFilter(filter);
            exec.setObjectView(ev);
            iRowSet = exec.executeQuery();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return iRowSet;
    }

    private IRowSet executeQuery(String queryPk) throws BOSException {
        MetaDataPK multiApprovePK = new MetaDataPK(queryPk);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)multiApprovePK);
        exec.option().isAutoTranslateEnum = true;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)this.ids, CompareType.INCLUDE));
        ev.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterInfo = new SorterItemInfo("createTime");
        sorterInfo.setSortType(SortType.ASCEND);
        sorter.add(sorterInfo);
        ev.setSorter(sorter);
        exec.setObjectView(ev);
        return exec.executeQuery();
    }

    private void concatRowSet(IRowSet rowSet, DynamicRowSet destRowSet) throws SQLException, BOSException {
        Collection col = rowSet.toCollection();
        for (Vector row : col) {
            this.fillRowData(destRowSet, row);
        }
    }

    private void fillRowData(DynamicRowSet rowSet, Vector row) throws SQLException, BOSException {
        if (rowSet == null) {
            throw new IllegalArgumentException();
        }
        if (row == null) {
            throw new IllegalArgumentException();
        }
        rowSet.moveToInsertRow();
        String time = OACommonDataProvider.formatDate((Timestamp)row.get(1));
        rowSet.updateString(1, time);
        rowSet.updateString(2, (String)row.get(2));
        rowSet.updateString(3, (String)row.get(3));
        rowSet.updateString(4, (String)row.get(4));
        String isPass = row.get(6).toString();
        rowSet.updateString(5, isPass);
        rowSet.updateString(6, (String)row.get(7));
        rowSet.insertRow();
    }

    private static String formatDate(Date date) {
        String pattern = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(date).toString();
    }
}

