/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.arcm.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermItemException;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class ArcmWebUtil {
    public static final String DOCDISPATCH_VIEW_PERMISSION = "cp_arcm_DocDispatch_View";
    public static final String DOCDISPATCH_UPDATE_PERMISSION = "cp_arcm_DocDispatch_Update";
    public static final String DOCRECEIVE_VIEW_PERMISSION = "cp_arcm_DocReceive_View";
    public static final String DOCRECEIVE_UPDATE_PERMISSION = "cp_arcm_DocReceive_Update";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.arcm.web.ArcmWebUtil");

    public static void checkPermission(Context ctx, String permissionItem) throws BOSException, EASBizException {
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        if (cuId == null || StringUtils.isEmpty((String)permissionItem)) {
            return;
        }
        IObjectPK userPK = ctx.getCaller();
        ObjectUuidPK orgPK = new ObjectUuidPK(cuId);
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        iPermission.checkFunctionPermission(userPK, (IObjectPK)orgPK, permissionItem);
    }

    public static boolean isHasPermission(Context ctx, String permissionItem) {
        try {
            ArcmWebUtil.checkPermission(ctx, permissionItem);
        }
        catch (PermissionServiceException e) {
            e.printStackTrace();
            logger.debug((Object)("com.kingdee.eas.cp.arcm.web.ArcmWebUtil.isHasPermission is error: " + e.getMessage()));
            return false;
        }
        catch (PermItemException e) {
            e.printStackTrace();
            logger.debug((Object)("com.kingdee.eas.cp.arcm.web.ArcmWebUtil.isHasPermission is error: " + e.getMessage()));
            return false;
        }
        catch (PermissionException e) {
            e.printStackTrace();
            logger.debug((Object)("com.kingdee.eas.cp.arcm.web.ArcmWebUtil.isHasPermission is error: " + e.getMessage()));
            return false;
        }
        catch (EASBizException e) {
            e.printStackTrace();
            logger.debug((Object)("com.kingdee.eas.cp.arcm.web.ArcmWebUtil.isHasPermission is error: " + e.getMessage()));
            return false;
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.debug((Object)("com.kingdee.eas.cp.arcm.web.ArcmWebUtil.isHasPermission is error: " + e.getMessage()));
            return false;
        }
        return true;
    }
}

