/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.ba.client;

import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.forewarn.ForewarnItemFactory;
import com.kingdee.eas.base.forewarn.OrgUserInfo;
import com.kingdee.eas.base.forewarn.client.ReceiverObject;
import com.kingdee.eas.base.forewarn.client.UserListDlg;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.ba.RptReceiverCollection;
import com.kingdee.eas.cp.ba.RptReceiverInfo;
import com.kingdee.eas.cp.ba.RptSolutionCollection;
import com.kingdee.eas.cp.ba.RptSolutionFactory;
import com.kingdee.eas.cp.ba.RptSolutionInfo;
import com.kingdee.eas.cp.ba.SolutionTypeEnum;
import com.kingdee.eas.cp.ba.client.AbstractReceiversListUI;
import com.kingdee.eas.cp.ba.client.RptSolutionInterface;
import com.kingdee.eas.cp.ba.client.RptSolutionUI;
import com.kingdee.eas.cp.ba.util.RptUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class ReceiversListUI
extends AbstractReceiversListUI
implements RptSolutionInterface {
    private static final String forewarnRes = "com.kingdee.eas.base.forewarn.client.Forewarn";
    private KDTree treeDyReceivers;
    private Map entities = new Hashtable();
    private KDTextField tfReceivers = null;
    private String inputText = null;
    private ArrayList treePaths = new ArrayList();
    private String sltedReceiverid = "";
    private HashMap sltedNodeMap = new HashMap();
    HashMap allOrgNodesMap = null;
    private RptReceiverCollection rptCollection = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.rptCollection = (RptReceiverCollection)((Object)this.getUIContext().get(RptUtil.COLLECTION));
        if (this.rptCollection == null) {
            this.rptCollection = new RptReceiverCollection();
        }
        this.init();
        this.kDTabbedPaneReceivers.setContainerType(2);
        this.kDContainerSelectedReceivers.setContainerType(2);
        this.kDTreeView1.setShowControlPanel(true);
        this.kDTreeView1.setShowButton(false);
        this.kDTreeView2.setShowControlPanel(true);
        this.kDTreeView2.setShowButton(false);
    }

    private void init() throws Exception {
        this.initOther();
        this.initStaticReceiversTree();
        this.initSltedReceivers();
        this.initAddListener();
    }

    private void initAddListener() {
        this.treeStaticReceivers.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ReceiversListUI.this.addStaticReceiver();
                }
            }
        });
        final JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem(RptUtil.getString("findUser"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceiversListUI.this.userListShow();
            }
        });
        menu.add(item);
        this.treeSltedReceivers.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3 && ReceiversListUI.this.isSltOrg()) {
                    menu.show((JComponent)e.getSource(), e.getPoint().x, e.getPoint().y);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ReceiversListUI.this.removeReceiver();
                }
            }
        });
    }

    private void initOther() {
        this.setUITitle(RptUtil.getString("receiverList"));
        this.kDWorkButtonAdd.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.kDWorkButtonRemove.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.kDWorkButtonAdd.setEnabled(true);
        this.kDWorkButtonRemove.setEnabled(true);
        this.kDButtonConfirm.setVisible(false);
        this.kDButtonCancel.setEnabled(false);
        this.kDButtonCancel.setVisible(false);
    }

    private void initSltedReceivers() {
        DefaultKingdeeTreeNode rootNode = new DefaultKingdeeTreeNode((Object)RptUtil.getString("receiver"));
        DefaultKingdeeTreeNode staticNode = new DefaultKingdeeTreeNode((Object)RptUtil.getString("addressList"));
        rootNode.add((MutableTreeNode)staticNode);
        DefaultTreeModel sltedModel = new DefaultTreeModel((TreeNode)rootNode);
        this.treeSltedReceivers.setModel((TreeModel)sltedModel);
        this.treeSltedReceivers.expandAllNodes(true, (TreeNode)staticNode);
        if (this.allOrgNodesMap == null || this.rptCollection == null || this.rptCollection.size() < 1) {
            return;
        }
        RptReceiverInfo receiverInfo = null;
        String orgUserID = null;
        DefaultKingdeeTreeNode tmp = null;
        DefaultKingdeeTreeNode tmpNode = this.getChildOfSltedRecRoot(0);
        TreeNode[] nodes = null;
        StringBuffer name = null;
        for (int i = 0; i < this.rptCollection.size(); ++i) {
            receiverInfo = this.rptCollection.get(i);
            orgUserID = receiverInfo.getValue();
            tmp = (DefaultKingdeeTreeNode)this.allOrgNodesMap.get(orgUserID);
            if (tmp == null || this.isStaticNodeExist(tmpNode, tmp)) continue;
            name = new StringBuffer();
            nodes = tmp.getPath();
            if (nodes != null) {
                int nodeLength = nodes.length;
                for (int j = 1; j < nodeLength; ++j) {
                    name.append(((OrgUserInfo)((DefaultKingdeeTreeNode)nodes[j]).getUserObject()).getOrgUserName()).append(".");
                }
            }
            DefaultKingdeeTreeNode nodeClone = (DefaultKingdeeTreeNode)tmp.clone();
            if (name.length() > 0) {
                name.deleteCharAt(name.length() - 1);
                nodeClone.setText(name.toString());
            }
            this.treeSltedReceivers.addNodeInto((MutableTreeNode)nodeClone, (MutableTreeNode)tmpNode);
            String id = ((OrgUserInfo)tmp.getUserObject()).getOrgUserID();
            this.sltedNodeMap.put(id, tmp);
        }
        this.treeSltedReceivers.expandAllNodes(true, (TreeNode)tmpNode);
    }

    private boolean isSltOrg() {
        OrgUserInfo info;
        TreePath path = this.treeSltedReceivers.getSelectionPath();
        if (path == null) {
            return false;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        Object userObj = node.getUserObject();
        if (userObj instanceof OrgUserInfo && (info = (OrgUserInfo)userObj) != null && "0".equals(info.getUserOrOrg())) {
            this.sltedReceiverid = info.getOrgUserID();
            return true;
        }
        return false;
    }

    private void userListShow() {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.sltedNodeMap.get(this.sltedReceiverid);
        StringBuffer userBuffer = new StringBuffer();
        this.searchUserName(node, userBuffer);
        if (userBuffer.length() > 0) {
            this.getUIContext().put("Owner", this.getUIWindow());
            this.getUIContext().put("users", userBuffer.toString());
            try {
                IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                IUIWindow window = uiFactory.create(UserListDlg.class.getName(), this.getUIContext(), null, this.getOprtState());
                window.show();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void searchUserName(DefaultKingdeeTreeNode node, StringBuffer names) {
        if (node == null) {
            return;
        }
        int childCount = node.getChildCount();
        DefaultKingdeeTreeNode tmpNode = null;
        for (int i = 0; i <= childCount - 1; ++i) {
            tmpNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            OrgUserInfo info = (OrgUserInfo)tmpNode.getUserObject();
            if ("1".equals(info.getUserOrOrg())) {
                names.append(info.getOrgUserName() + ";");
                continue;
            }
            this.searchUserName(tmpNode, names);
        }
    }

    public void initStaticReceiversTree() throws Exception {
        this.treeStaticReceivers.setModel(null);
        OrgUserInfo[] infoArray = ForewarnItemFactory.getRemoteInstance().getOrgUserCollection();
        this.buildReceiversTree(infoArray);
        DefaultTreeSelectionModel sltModel = new DefaultTreeSelectionModel();
        sltModel.setSelectionMode(4);
        this.treeStaticReceivers.setSelectionModel((TreeSelectionModel)sltModel);
        this.treeStaticReceivers.setExpandsSelectedPaths(true);
        if (this.treeStaticReceivers.getModel() != null) {
            this.setNodeIcon((DefaultKingdeeTreeNode)this.treeStaticReceivers.getModel().getRoot());
        }
        this.btnSearch.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
    }

    private void setNodeIcon(DefaultKingdeeTreeNode node) {
        if (node == null) {
            return;
        }
        OrgUserInfo info = (OrgUserInfo)node.getUserObject();
        this.setNodeIconByInfo(node, info);
        int rowCount = node.getChildCount();
        DefaultKingdeeTreeNode tmpNode = null;
        for (int i = 0; i < rowCount; ++i) {
            tmpNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            if (tmpNode.isLeaf()) {
                info = (OrgUserInfo)tmpNode.getUserObject();
                this.setNodeIconByInfo(tmpNode, info);
                continue;
            }
            this.setNodeIcon(tmpNode);
        }
    }

    private void setNodeIconByInfo(DefaultKingdeeTreeNode node, OrgUserInfo info) {
        if (info.getUserOrOrg().equals("0")) {
            node.setCustomIcon(EASResource.getIcon((String)"imgTree_company"));
        } else {
            node.setCustomIcon(EASResource.getIcon((String)"imgTree_user"));
        }
    }

    private void buildReceiversTree(OrgUserInfo[] infoArray) {
        if (infoArray == null || infoArray.length <= 0) {
            return;
        }
        DefaultKingdeeTreeNode rootNode = new DefaultKingdeeTreeNode();
        ArrayList preLevelNodes = new ArrayList();
        ArrayList<DefaultKingdeeTreeNode> curLevelNodes = new ArrayList<DefaultKingdeeTreeNode>();
        int preLevel = -1;
        int curLevel = 0;
        DefaultKingdeeTreeNode curNode = rootNode;
        DefaultKingdeeTreeNode tmpNode = null;
        this.allOrgNodesMap = new HashMap();
        OrgUserInfo tmpInfo = null;
        DefaultKingdeeTreeNode tmpNode1 = null;
        for (int i = 0; i < infoArray.length; ++i) {
            tmpNode = new DefaultKingdeeTreeNode((Object)infoArray[i]);
            if (i == 0) {
                curNode = rootNode = tmpNode;
                preLevel = curLevel = Integer.parseInt(infoArray[i].getOrgUserLevel());
                curLevelNodes.add(curNode);
                this.allOrgNodesMap.put(infoArray[i].getOrgUserID(), rootNode);
                continue;
            }
            curLevel = Integer.parseInt(infoArray[i].getOrgUserLevel());
            if (curLevel > preLevel) {
                preLevelNodes.clear();
                preLevelNodes = curLevelNodes;
                curLevelNodes = new ArrayList();
                preLevel = curLevel;
            } else if (curLevel == preLevel) {
                // empty if block
            }
            if (infoArray[i].getUserOrOrg().equals("1")) {
                DefaultKingdeeTreeNode tmp1;
                if (infoArray[i].getParentID() == null || (tmp1 = (DefaultKingdeeTreeNode)this.allOrgNodesMap.get(infoArray[i].getParentID())) == null) continue;
                tmp1.add((MutableTreeNode)tmpNode);
                this.allOrgNodesMap.put(infoArray[i].getOrgUserID(), tmpNode);
                continue;
            }
            curLevelNodes.add(tmpNode);
            for (int j = 0; j < preLevelNodes.size(); ++j) {
                tmpNode1 = (DefaultKingdeeTreeNode)preLevelNodes.get(j);
                tmpInfo = (OrgUserInfo)tmpNode1.getUserObject();
                if (!infoArray[i].getParentID().equals(tmpInfo.getOrgUserID())) continue;
                tmpNode1.add((MutableTreeNode)tmpNode);
                this.allOrgNodesMap.put(infoArray[i].getOrgUserID(), tmpNode);
            }
        }
        this.treeStaticReceivers.setModel((TreeModel)new DefaultTreeModel((TreeNode)rootNode));
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        this.btnConfirm();
    }

    public void btnConfirm() {
        RptReceiverCollection receivers = new RptReceiverCollection();
        DefaultKingdeeTreeNode staticRecNode = this.getChildOfSltedRecRoot(0);
        int size = staticRecNode.getChildCount();
        if (size == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)RptUtil.getString("chooseReceiverWarning"));
            SysUtil.abort();
        }
        StringBuffer sbReceivers = new StringBuffer();
        DefaultKingdeeTreeNode tmpNode = null;
        OrgUserInfo tmpInfo = null;
        RptReceiverInfo receiverInfo = null;
        for (int i = 0; i < size; ++i) {
            tmpNode = (DefaultKingdeeTreeNode)staticRecNode.getChildAt(i);
            tmpInfo = (OrgUserInfo)tmpNode.getUserObject();
            receiverInfo = new RptReceiverInfo();
            if (tmpInfo.getUserOrOrg().equals("1")) {
                receiverInfo.setType("1");
            } else {
                receiverInfo.setType("0");
            }
            receiverInfo.setValue(tmpInfo.getOrgUserID());
            receiverInfo.setDesc(tmpInfo.getOrgUserName());
            receiverInfo.setIsShow(true);
            sbReceivers.append(tmpInfo.getOrgUserName()).append(";");
            receivers.add(receiverInfo);
        }
        String strReceivers = sbReceivers.toString().trim();
        String receiverAlias = "";
        if (strReceivers.length() > 0) {
            receiverAlias = strReceivers.substring(0, strReceivers.length() - 1);
        }
        this.rptCollection.clear();
        this.rptCollection.addCollection(receivers);
        this.getUIContext().put(RptUtil.COLLECTION, this.rptCollection);
        RptSolutionUI rptSolutionUI = (RptSolutionUI)((Object)this.getUIContext().get("PANELUI"));
        if (rptSolutionUI.getTfReceivers() != null) {
            rptSolutionUI.getTfReceivers().setText(receiverAlias);
        }
        rptSolutionUI.destroyWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        RptSolutionUI rptSolutionUI = (RptSolutionUI)((Object)this.getUIContext().get("PANELUI"));
        rptSolutionUI.destroyWindow();
    }

    @Override
    public void actionAddReceiver_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddReceiver_actionPerformed(e);
        this.addStaticReceiver();
    }

    @Override
    public void actionRemoveReceiver_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveReceiver_actionPerformed(e);
        this.removeReceiver();
    }

    private DefaultKingdeeTreeNode getChildOfSltedRecRoot(int index) {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeSltedReceivers.getModel().getRoot();
        return (DefaultKingdeeTreeNode)node.getChildAt(index);
    }

    private void addStaticReceiver() {
        TreePath[] selectedPath = this.treeStaticReceivers.getSelectionPaths();
        if (selectedPath == null) {
            MsgBox.showWarning((Component)((Object)this), (String)RptUtil.getString("choosenReceiverWarning"));
            return;
        }
        DefaultKingdeeTreeNode tmp = null;
        DefaultKingdeeTreeNode tmpNode = this.getChildOfSltedRecRoot(0);
        TreeNode[] nodes = null;
        StringBuffer name = new StringBuffer();
        int nodeLength = 0;
        boolean rootSelected = false;
        DefaultKingdeeTreeNode tmpRootNode = null;
        for (int i = 0; i < selectedPath.length; ++i) {
            name.setLength(0);
            tmp = (DefaultKingdeeTreeNode)selectedPath[i].getLastPathComponent();
            if (tmp == null) continue;
            if (tmp.isRoot()) {
                rootSelected = true;
                tmpRootNode = tmp;
            }
            if (this.isStaticNodeExist(tmpNode, tmp)) continue;
            nodes = tmp.getPath();
            if (nodes != null) {
                nodeLength = nodes.length;
                for (int j = 1; j < nodeLength; ++j) {
                    name.append(((OrgUserInfo)((DefaultKingdeeTreeNode)nodes[j]).getUserObject()).getOrgUserName()).append(".");
                }
            }
            DefaultKingdeeTreeNode nodeClone = (DefaultKingdeeTreeNode)tmp.clone();
            if (name.length() > 0) {
                name.deleteCharAt(name.length() - 1);
                nodeClone.setText(name.toString());
            }
            this.treeSltedReceivers.addNodeInto((MutableTreeNode)nodeClone, (MutableTreeNode)tmpNode);
            String id = ((OrgUserInfo)tmp.getUserObject()).getOrgUserID();
            this.sltedNodeMap.put(id, tmp);
        }
        if (rootSelected) {
            this.treeStaticReceivers.expandAllNodes(true, tmpRootNode);
        }
        this.treeSltedReceivers.expandAllNodes(true, (TreeNode)tmpNode);
    }

    private boolean isStaticNodeExist(DefaultKingdeeTreeNode parentNode, DefaultKingdeeTreeNode childNode) {
        if (parentNode == null || parentNode.getChildCount() <= 0 || childNode == null) {
            return false;
        }
        int count = parentNode.getChildCount();
        OrgUserInfo tmp = null;
        DefaultKingdeeTreeNode tmpNode = null;
        tmp = (OrgUserInfo)childNode.getUserObject();
        String childOrgID = tmp.getOrgUserID();
        for (int i = 0; i < count; ++i) {
            tmpNode = (DefaultKingdeeTreeNode)parentNode.getChildAt(i);
            if (tmpNode == null) continue;
            tmp = (OrgUserInfo)tmpNode.getUserObject();
            if (childOrgID == null || !childOrgID.equals(tmp.getOrgUserID())) continue;
            return true;
        }
        return false;
    }

    private boolean isDynamicNodeExist(DefaultKingdeeTreeNode parentNode, DefaultKingdeeTreeNode childNode) {
        if (parentNode == null || parentNode.getChildCount() <= 0 || childNode == null) {
            return false;
        }
        int count = parentNode.getChildCount();
        ReceiverObject tmp = null;
        DefaultKingdeeTreeNode tmpNode = null;
        tmp = (ReceiverObject)childNode.getUserObject();
        String childID = tmp.getValue();
        for (int i = 0; i < count; ++i) {
            tmpNode = (DefaultKingdeeTreeNode)parentNode.getChildAt(i);
            if (tmpNode == null) continue;
            tmp = (ReceiverObject)tmpNode.getUserObject();
            if (childID == null || !childID.equals(tmp.getValue())) continue;
            return true;
        }
        return false;
    }

    private void removeReceiver() {
        TreePath[] treePath = this.treeSltedReceivers.getSelectionPaths();
        if (treePath == null) {
            MsgBox.showWarning((Component)((Object)this), (String)RptUtil.getString("choosenReceiverWarning"));
            return;
        }
        DefaultKingdeeTreeNode tmp = null;
        for (int i = 0; i < treePath.length; ++i) {
            tmp = (DefaultKingdeeTreeNode)treePath[i].getLastPathComponent();
            if (tmp.isRoot() || tmp.getLevel() == 1) continue;
            this.treeSltedReceivers.removeNodeFromParent((MutableTreeNode)tmp);
            if (!(tmp.getUserObject() instanceof OrgUserInfo)) continue;
            String id = ((OrgUserInfo)tmp.getUserObject()).getOrgUserID();
            this.sltedNodeMap.remove(id);
        }
    }

    private Set getReceiverPKs() {
        HashSet<String> receiverPKs = new HashSet<String>();
        RptReceiverCollection receivers = this.rptCollection;
        if (receivers != null) {
            int receiversSize = receivers.size();
            for (int i = 0; i < receiversSize; ++i) {
                RptReceiverInfo receiver = receivers.get(i);
                if (!receiver.getType().equals("1") && !receiver.getType().equals("0")) continue;
                receiverPKs.add(receiver.getValue());
            }
        }
        return receiverPKs;
    }

    private void tree_treeWillExpand(TreeExpansionEvent e) {
        Object userObject;
        DefaultKingdeeTreeNode node;
        Object object = e.getPath().getLastPathComponent();
        if (object instanceof DefaultKingdeeTreeNode && (node = (DefaultKingdeeTreeNode)object) != null && (userObject = node.getUserObject()) != null && node.getChildCount() == 0) {
            this.createChildNode(node);
            ((KingdeeTreeModel)this.treeDyReceivers.getModel()).reload((TreeNode)node);
        }
    }

    private void createChildNode(DefaultKingdeeTreeNode parentNode) {
        ReceiverObject parentObject = (ReceiverObject)parentNode.getUserObject();
        Object properties = null;
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo propertyInfo = properties.get(i);
            ReceiverObject childObject = new ReceiverObject();
            childObject.setAlias(this.getAlias(parentObject, Util.getPropertyAlias((PropertyInfo)propertyInfo)));
            childObject.setValue(this.getValue(parentObject, propertyInfo.getName()));
            childObject.setExtendValue(this.getExtendValue(parentObject, propertyInfo));
            childObject.setMainEntity(parentObject.getMainEntity());
            childObject.setLinkPropertyInfo((LinkPropertyInfo)propertyInfo);
            DefaultKingdeeTreeNode childNode = new DefaultKingdeeTreeNode((Object)childObject);
            childNode.setText(Util.getPropertyAlias((PropertyInfo)propertyInfo));
            parentNode.add((MutableTreeNode)childNode);
        }
    }

    private String getExtendValue(ReceiverObject parent, PropertyInfo propertyInfo) {
        String extendValue = "";
        String parentExtendValue = parent.getExtendValue();
        String refEntityName = null;
        if (propertyInfo instanceof LinkPropertyInfo) {
            LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propertyInfo;
            refEntityName = Util.getEntity((String)parentExtendValue, (LinkPropertyInfo)linkPropertyInfo).getFullName();
        }
        extendValue = refEntityName == null ? "" : refEntityName;
        return extendValue;
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        String field = this.kDTextFieldName.getText();
        if (field != null && !field.trim().equalsIgnoreCase("")) {
            this.inputText = field.trim();
            this.treePaths.clear();
            this.searchNode((DefaultKingdeeTreeNode)this.treeStaticReceivers.getModel().getRoot());
            TreePath[] paths = this.treePaths.toArray(new TreePath[0]);
            this.treeStaticReceivers.getSelectionModel().clearSelection();
            this.treeStaticReceivers.setSelectionPaths(paths);
            if (paths != null && paths.length > 0) {
                this.treeStaticReceivers.scrollPathToVisible(paths[0]);
            }
        }
    }

    private void searchNode(DefaultKingdeeTreeNode node) {
        if (node == null) {
            return;
        }
        if (this.checkEquals(node.getUserObject().toString())) {
            this.treeStaticReceivers.setSelectionNode(node);
            this.treePaths.add(this.treeStaticReceivers.getSelectionPath());
        }
        int childCount = node.getChildCount();
        DefaultKingdeeTreeNode tmpNode = null;
        for (int i = 0; i < childCount; ++i) {
            tmpNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            if (!tmpNode.isLeaf()) {
                this.searchNode(tmpNode);
                continue;
            }
            if (!this.checkEquals(tmpNode.getUserObject().toString())) continue;
            this.treeStaticReceivers.setSelectionNode(tmpNode);
            this.treePaths.add(this.treeStaticReceivers.getSelectionPath());
        }
    }

    private boolean checkEquals(String str) {
        if (str == null || this.inputText == null || str.trim() == null || str.trim().equals("") || this.inputText.equals("")) {
            return false;
        }
        str = str.trim();
        String upStr = str.toUpperCase(this.getLocale());
        String lowStr = str.toLowerCase(this.getLocale());
        if (str.equalsIgnoreCase(this.inputText)) {
            return true;
        }
        return upStr.indexOf(this.inputText) != -1 || lowStr.indexOf(this.inputText) != -1;
    }

    private String getAlias(ReceiverObject parent, String propertyAlias) {
        String name = "";
        String parentName = parent.getAlias();
        name = parentName.length() == 0 ? propertyAlias : parentName + "." + propertyAlias;
        return name;
    }

    private String getValue(ReceiverObject parent, String propertyName) {
        String value = "";
        String parentValue = parent.getValue();
        value = parentValue.length() == 0 ? propertyName : parentValue + "." + propertyName;
        return value;
    }

    private EntityObjectInfo getEntity(String entityName) {
        EntityObjectInfo objectInfo = null;
        if (!this.entities.containsKey(entityName)) {
            objectInfo = Util.getEntity((IMetaDataPK)new MetaDataPK(entityName));
            this.entities.put(entityName, objectInfo);
        } else {
            objectInfo = (EntityObjectInfo)this.entities.get(entityName);
        }
        return objectInfo;
    }

    public void setTextFieldReceivers(KDTextField field) {
        this.tfReceivers = field;
    }

    @Override
    public void clear() {
        this.rptCollection.clear();
        this.initSltedReceivers();
    }

    @Override
    public boolean cancel() throws Exception {
        RptSolutionUI rptSolutionUI = (RptSolutionUI)((Object)this.getUIContext().get("PANELUI"));
        rptSolutionUI.destroyWindow();
        return true;
    }

    @Override
    public void clearSolutionList() throws Exception {
    }

    @Override
    public boolean conferm(Object invokeUi) throws Exception {
        this.btnConfirm();
        return true;
    }

    @Override
    public RptSolutionInfo getDefaultSoltuion() throws Exception {
        String objId = null;
        String operateType = null;
        Map uicontext = this.getUIContext();
        if (uicontext.get("ID") != null) {
            objId = (String)uicontext.get("ID");
        }
        if (uicontext.get("operateType") != null) {
            operateType = (String)uicontext.get("operateType");
        }
        StringBuffer oql = new StringBuffer("where isDefaultsolution =1 ");
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        oql.append(" and userId='" + userId + "' ");
        if (objId != null) {
            oql.append(" and relativeObjId='" + objId + "' ");
        }
        if (operateType != null) {
            oql.append(" and oprateObjType='" + operateType + "' ");
        }
        RptSolutionInfo rptSolutionInfo = null;
        RptSolutionCollection assignSolutionCol = RptSolutionFactory.getRemoteInstance().getRptSolutionCollection(oql.toString());
        if (assignSolutionCol.size() > 0) {
            rptSolutionInfo = assignSolutionCol.get(0);
        }
        return rptSolutionInfo;
    }

    @Override
    public String getNewConfermLabel() {
        return null;
    }

    @Override
    public Map getReturnData() throws Exception {
        return null;
    }

    @Override
    public void reloadSolution(Object o) throws Exception {
        RptReceiverCollection receivers = (RptReceiverCollection)((Object)o);
        RptReceiverInfo receiverInfo = null;
        String orgUserID = null;
        DefaultKingdeeTreeNode tmp = null;
        DefaultKingdeeTreeNode tmpNode = this.getChildOfSltedRecRoot(0);
        TreeNode[] nodes = null;
        StringBuffer name = null;
        if (receivers != null) {
            for (int i = 0; i < receivers.size(); ++i) {
                receiverInfo = receivers.get(i);
                orgUserID = receiverInfo.getValue();
                tmp = (DefaultKingdeeTreeNode)this.allOrgNodesMap.get(orgUserID);
                if (tmp == null || this.isStaticNodeExist(tmpNode, tmp)) continue;
                name = new StringBuffer();
                nodes = tmp.getPath();
                if (nodes != null) {
                    int nodeLength = nodes.length;
                    for (int j = 1; j < nodeLength; ++j) {
                        name.append(((OrgUserInfo)((DefaultKingdeeTreeNode)nodes[j]).getUserObject()).getOrgUserName()).append(".");
                    }
                }
                DefaultKingdeeTreeNode nodeClone = (DefaultKingdeeTreeNode)tmp.clone();
                if (name.length() > 0) {
                    name.deleteCharAt(name.length() - 1);
                    nodeClone.setText(name.toString());
                }
                this.treeSltedReceivers.addNodeInto((MutableTreeNode)nodeClone, (MutableTreeNode)tmpNode);
                String id = ((OrgUserInfo)tmp.getUserObject()).getOrgUserID();
                this.sltedNodeMap.put(id, tmp);
            }
            this.treeSltedReceivers.expandAllNodes(true, (TreeNode)tmpNode);
        }
    }

    @Override
    public Object saveSolution() throws Exception {
        RptReceiverCollection receivers = new RptReceiverCollection();
        DefaultKingdeeTreeNode staticRecNode = this.getChildOfSltedRecRoot(0);
        int size = staticRecNode.getChildCount();
        if (size == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)RptUtil.getString("chooseReceiverWarning"));
            SysUtil.abort();
        }
        StringBuffer sbReceivers = new StringBuffer();
        DefaultKingdeeTreeNode tmpNode = null;
        OrgUserInfo tmpInfo = null;
        RptReceiverInfo receiverInfo = null;
        for (int i = 0; i < size; ++i) {
            tmpNode = (DefaultKingdeeTreeNode)staticRecNode.getChildAt(i);
            tmpInfo = (OrgUserInfo)tmpNode.getUserObject();
            receiverInfo = new RptReceiverInfo();
            if (tmpInfo.getUserOrOrg().equals("1")) {
                receiverInfo.setType("1");
            } else {
                receiverInfo.setType("0");
            }
            receiverInfo.setValue(tmpInfo.getOrgUserID());
            receiverInfo.setDesc(tmpInfo.getOrgUserName());
            receiverInfo.setIsShow(true);
            sbReceivers.append(tmpInfo.getOrgUserName()).append(";");
            receivers.add(receiverInfo);
        }
        return receivers;
    }

    @Override
    public RptSolutionCollection solutionList(SolutionTypeEnum typeEnum) throws Exception {
        StringBuffer oql = new StringBuffer("where solutionType=" + typeEnum.getValue());
        String objId = null;
        String operateType = null;
        Map uicontext = this.getUIContext();
        if (uicontext.get("ID") != null) {
            objId = (String)uicontext.get("ID");
        }
        if (uicontext.get("operateType") != null) {
            operateType = (String)uicontext.get("operateType");
        }
        if (typeEnum.getValue() == 0) {
            String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            oql.append("and cuid='" + cuid + "'");
        } else if (typeEnum.getValue() == 2) {
            String orgId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            oql.append("and orgId='" + orgId + "'");
        } else if (typeEnum.getValue() == 1) {
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            oql.append("and userId='" + userId + "' ");
        }
        if (objId != null) {
            oql.append(" and relativeObjId='" + objId + "' ");
        }
        if (operateType != null) {
            oql.append(" and oprateObjType='" + operateType + "' ");
        }
        oql.append(" and uiname ='" + this.getMetaDataPK().getFullName() + "'");
        oql.append(" order by isDefaultsolution desc");
        RptSolutionCollection rptSolutionCol = RptSolutionFactory.getRemoteInstance().getRptSolutionCollection(oql.toString());
        return rptSolutionCol;
    }
}

