/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.ba.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.util.Resrcs;
import com.kingdee.eas.base.common.client.CommonUtil;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.cp.ba.RptReleaseInfo;
import com.kingdee.eas.cp.ba.RptReleaseManager;
import com.kingdee.eas.cp.ba.RptReportException;
import com.kingdee.eas.cp.ba.RptTypeEnum;
import com.kingdee.eas.cp.ba.client.AbstractRptReleaseEditUI;
import com.kingdee.eas.cp.ba.client.ReceiversListUI;
import com.kingdee.eas.cp.ba.client.RptSolutionUI;
import com.kingdee.eas.cp.ba.client.RptTypeF7PromptDialog;
import com.kingdee.eas.cp.ba.util.F7Handle;
import com.kingdee.eas.cp.ba.util.RptUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileWriter;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class RptReleaseEditUI
extends AbstractRptReleaseEditUI {
    private static final Logger logger = CoreUIObject.getLogger(RptReleaseEditUI.class);
    private static final String RES = "com.kingdee.eas.cp.ba.client.RptResource";
    public RptReleaseManager mgr = null;
    private String attID = null;
    private File attachment = null;
    private RptTypeEnum typeEnum = null;
    protected boolean isCanSelectNotLeaf = true;

    public File getAttachment() {
        return this.attachment;
    }

    public void setAttachment(File attachment) {
        this.attachment = attachment;
    }

    public String getAttID() {
        return this.attID;
    }

    public void setAttID(String attID) {
        this.attID = attID;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.initUI();
        this.actionReceiver.setEnabled(true);
        this.txtReceiver.setEnabled(false);
        this.txtReceiver.setEditable(false);
    }

    public void initUI() {
        this.prmtCreator.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("All_Admins", "YES");
        PersonPromptBox select = new PersonPromptBox((IUIObject)this, map);
        this.prmtCreator.setSelector((KDPromptSelector)select);
        this.prmtCreator.setDisplayFormat("$name$");
        this.prmtCreator.setEditFormat("$name$");
        this.prmtCreator.setCommitFormat("$number$");
        this.prmtCreator.setEditable(false);
        this.dateCreator.setEditable(false);
    }

    public void onLoad() throws Exception {
        this.checkPermission();
        super.onLoad();
        this.setDataObject((IObjectValue)this.initLoadData());
        this.loadFields();
        this.comboFromSys.setSelectedItemData((Object)this.mgr.getFromSys().getAlias());
        this.txtBizType.setSelectedItemData((Object)this.mgr.getTitle());
        this.prmtCreator.setValue((Object)SysContext.getSysContext().getCurrentUserInfo().getPerson());
        if (this.typeEnum == null) {
            this.typeEnum = RptTypeEnum.SNAP_HTML_MODE;
        }
        if (this.typeEnum.equals((Object)RptTypeEnum.SNAP_LINK_MODE)) {
            this.btnAttAction.setVisible(false);
        }
        RptTypeF7PromptDialog typeDialog = new RptTypeF7PromptDialog((IUIObject)this);
        F7Handle.RptTypeF7Handle(this.prmtSort, (KDPromptSelector)typeDialog, "com.kingdee.eas.cp.ba.app.F7RptTypeQuery", true);
        typeDialog.setCanSelectNotLeaf(false);
        this.prmtSort.setRequired(true);
        this.comboFromSys.setEnabled(false);
        this.dateCreator.setValue((Object)new Timestamp(System.currentTimeMillis()));
        this.btnRelease.setIcon(EASResource.getIcon((String)"imgTbtn_issuance"));
        this.btnAttAction.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.txtReceiver.setCustomBackgroundColor(UIManager.getColor("TextField.requiredBackground"));
        this.btnReceiver.setText(null);
        this.btnReceiver.setIcon(EASResource.getIcon((String)"imgTbtn_recieversetting"));
        this.btnReceiver.setToolTipText(null);
        this.txtName.setMaxLength(255);
    }

    public void checkPermission() throws EASBizException, BOSException {
        OrgUnitInfo currentOrgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
        UserInfo currentUserInfo = SysContext.getSysContext().getCurrentUserInfo();
        if (!(Administrator.isSuperCUAdmin((IObjectPK)new ObjectUuidPK(currentOrgUnitInfo.getId())) || "00000000-0000-0000-0000-00000000000013B7DE7F".equals(currentUserInfo.getId().toString()) || PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectStringPK(currentUserInfo.getId().toString()), (IObjectPK)new ObjectStringPK(currentOrgUnitInfo.getId().toString()), "cp_ba_Rpt"))) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"rpt_Report"));
            SysUtil.abort();
        }
    }

    private RptReleaseInfo initLoadData() {
        RptReleaseInfo releaseInfo = (RptReleaseInfo)this.getUIContext().get(RptUtil.RECEIVER_INFO);
        RptReleaseManager rrm = (RptReleaseManager)this.getUIContext().get(RptUtil.RPT_MGR);
        if ((RptTypeEnum.SNAP_EXCEL_MODE.equals((Object)rrm.getTypeEnum()) || RptTypeEnum.SNAP_HTML_MODE.equals((Object)rrm.getTypeEnum())) && (rrm.getFiles() == null || rrm.getFiles()[0] == null)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"attach_file_error"));
            SysUtil.abort();
        }
        this.setMgr((RptReleaseManager)this.getUIContext().get(RptUtil.RPT_MGR));
        if (releaseInfo == null) {
            releaseInfo = new RptReleaseInfo();
        }
        return releaseInfo;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.mgr == null) {
            return;
        }
        String title = this.mgr.getTitle();
        if (title == null || title.equals("")) {
            return;
        }
        this.lblViewFile.setBoundLabelText(title);
        this.lblViewFile.setBoundLabelLength(title.length() * 2);
        this.lblViewFile.setBoundLabelUnderline(true);
        this.lblViewFile.addMouseListener((MouseListener)new MyMouseListener((Component)((Object)this)));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void checkVerify() throws RptReportException {
        MultiLangItem fromSys;
        LanguageInfo langInfo = new LanguageInfo(this.getLocale());
        MultiLangItem name = this.txtName.getItemBy(langInfo);
        if (name == null || ((String)name.getData()).trim().length() <= 0) {
            this.txtName.requestFocus();
            throw new RptReportException(RptReportException.NAME_NOT_NULL);
        }
        if (((String)name.getData()).trim().length() > 255) {
            this.txtName.requestFocus();
            throw new RptReportException(RptReportException.NAME_TOO_LONG);
        }
        if (this.prmtSort.getValue() == null) {
            this.prmtSort.requestFocus();
            throw new RptReportException(RptReportException.RPTSORT_NOT_NULL);
        }
        String txtRec = this.txtReceiver.getText();
        if (txtRec == null || txtRec.trim().length() <= 0) {
            this.txtReceiver.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"receiver_not_null"));
            this.abort();
        }
        if (txtRec.length() > 80) {
            this.mgr.getReleaseInfo().setDesc(txtRec.substring(0, 79));
        }
        if ((fromSys = this.comboFromSys.getItemBy(langInfo)) == null || ((String)fromSys.getData()).trim().length() <= 0) {
            this.comboFromSys.requestFocus();
            throw new RptReportException(RptReportException.FRSYS_NOT_NULL);
        }
    }

    private String getClassAlise() {
        String className = FrameWorkUtils.getClassAlias((CoreBaseInfo)this.editData);
        return className;
    }

    @Override
    public void releaseAction_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.checkVerify();
        if (this.mgr != null) {
            this.mgr.setReleaseInfo(this.editData);
            if (RptTypeEnum.SNAP_LINK_MODE.equals((Object)this.mgr.getTypeEnum())) {
                this.mgr.getReleaseInfo().setSourceReportType(this.mgr.getSourceReportType());
                this.mgr.getReleaseInfo().setUiClassName(this.mgr.getUiClassName());
                this.mgr.getReleaseInfo().setQuerySolution(this.mgr.getEv().toString());
                this.mgr.getReleaseInfo().setParam(CommonUtil.getBytes((Object)this.mgr.getEv()));
            }
            this.mgr.getReleaseInfo().setReleaseType(this.mgr.getTypeEnum());
            this.mgr.releaseReport(this.mgr.getTypeEnum());
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"report_release_success"));
            this.getUIWindow().close();
        }
    }

    public void doStaticReport(RptReleaseManager mgr) throws Exception {
        if (mgr == null) {
            return;
        }
        mgr.releaseReport();
    }

    public void doLinkedReport(RptReleaseManager mgr) throws Exception {
        if (mgr == null) {
            return;
        }
    }

    @Override
    public void actionReceiver_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)RptUtil.COLLECTION, (Object)this.editData.getReceiver());
        uiContext.put((Object)"selfPanelUiName", (Object)ReceiversListUI.class.getName());
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(RptSolutionUI.class.getName(), (Map)uiContext, null, null);
        RptSolutionUI receiversListUI = (RptSolutionUI)window.getUIObject();
        receiversListUI.setTextFieldReceivers(this.txtReceiver);
        window.show();
    }

    @Override
    public void attShowAction_actionPerformed(ActionEvent e) throws Exception {
        this.viewAttachment(this.getAttID());
    }

    public void viewAttachment(String attchID) throws Exception {
        if (System.getProperty("os.name").indexOf("Windows") == -1) {
            MsgBox.showInfo((String)Resrcs.getString((String)"NotWindowsOS"));
            return;
        }
        if (attchID == null) {
            if (this.mgr == null || this.mgr.getFiles() == null || this.mgr.getFiles().length <= 0) {
                MsgBox.showInfo((String)RptUtil.getString("noAttachment"));
                return;
            }
            try {
                File tempbat = File.createTempFile("tempbat", ".bat");
                FileWriter fw = new FileWriter(tempbat);
                StringBuffer sb = new StringBuffer("start /d \"");
                this.mgr.getFiles()[0].setReadOnly();
                sb.append(this.mgr.getFiles()[0].getParent());
                sb.append("\" ");
                sb.append(this.mgr.getFiles()[0].getName());
                fw.write(sb.toString());
                fw.close();
                String tempbatFullname = tempbat.getPath();
                Runtime.getRuntime().exec(tempbatFullname);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else {
            AttachmentManagerFactory.getClientManager().viewAttachment(attchID);
        }
    }

    public RptReleaseManager getMgr() {
        return this.mgr;
    }

    public void setMgr(RptReleaseManager mgr) {
        this.mgr = mgr;
    }

    class MyMouseListener
    extends MouseAdapter {
        Component owner;

        public MyMouseListener(Component owner) {
            this.owner = owner;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this._setCursor(this.owner, Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this._setCursor(this.owner, Cursor.getPredefinedCursor(0));
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this._setCursor(this.owner, Cursor.getPredefinedCursor(3));
            try {
                if (e.getButton() == 1 && e.getComponent() instanceof KDLabelContainer) {
                    RptReleaseEditUI.this.viewAttachment(RptReleaseEditUI.this.getAttID());
                }
            }
            catch (Exception es) {
                es.printStackTrace();
            }
            finally {
                this._setCursor(this.owner, Cursor.getPredefinedCursor(0));
            }
        }

        private void _setCursor(Component cp, Cursor cursor) {
            cp.setCursor(cursor);
            if (cp instanceof Container) {
                Container cc = (Container)cp;
                int n = cc.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    Component curComponent = cc.getComponent(i);
                    if (!curComponent.isFocusable()) continue;
                    this._setCursor(curComponent, cursor);
                }
            }
        }
    }
}

