/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.ba.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.ba.RptMgrFacadeFactory;
import com.kingdee.eas.cp.ba.RptReceiverFactory;
import com.kingdee.eas.cp.ba.RptReleaseFactory;
import com.kingdee.eas.cp.ba.client.AbstractRptReportListUI;
import com.kingdee.eas.cp.ba.util.RptUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptReportListUI
extends AbstractRptReportListUI {
    private static final Logger logger = CoreUIObject.getLogger(RptReportListUI.class);
    private static final int ENABLE_PORLET_INDEX = 5;
    Map mapPorlets = null;
    Map oldPorlets = null;

    public RptReportListUI() throws Exception {
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                RptReportListUI.this.table_change(e);
            }

            public void editStarting(KDTEditEvent e) {
                Boolean value;
                if (e.getColIndex() == 5 && !(value = (Boolean)e.getValue()).booleanValue() && RptReportListUI.this.mapPorlets.size() >= 5) {
                    e.setValue((Object)Boolean.FALSE);
                    MsgBox.showWarning((String)RptUtil.getString("choose_max"));
                    e.setCancel(true);
                }
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                RptReportListUI.this.table_eidted(e);
            }
        });
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCommit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnCommit.setTextIconDisStyle((short)2);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn(4).getStyleAttributes().setLocked(true);
        this.tblMain.getStyleAttributes().setLocked(false);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.mapPorlets = this.getIsPorlets();
        this.oldPorlets = new HashMap();
        this.oldPorlets.putAll(this.mapPorlets);
    }

    public void refreshList() throws Exception {
        super.refreshList();
        this.mapPorlets = this.getIsPorlets();
        this.oldPorlets = new HashMap();
        this.oldPorlets.putAll(this.mapPorlets);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void table_change(KDTEditEvent e) {
    }

    private void table_eidted(KDTEditEvent e) {
        Object object;
        int colIndex = e.getColIndex();
        if (colIndex == 5 && (object = e.getValue()) instanceof Boolean) {
            boolean flag = (Boolean)object;
            String id = (String)this.tblMain.getRow(e.getRowIndex()).getCell(this.getKeyFieldName()).getValue();
            this.setPorletStatus(id, flag);
        }
    }

    private Map getIsPorlets() {
        this.mapPorlets = new HashMap();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            Boolean isP;
            IRow row = this.tblMain.getRow(i);
            if (row.getCell(5) == null || !(row.getCell(5).getValue() instanceof Boolean) || !(isP = (Boolean)row.getCell(5).getValue()).booleanValue()) continue;
            this.mapPorlets.put(row.getCell(this.getKeyFieldName()).getValue(), isP);
        }
        return this.mapPorlets;
    }

    private void setPorletStatus(String id, boolean flag) {
        if (this.mapPorlets.containsKey(id)) {
            if (!flag) {
                this.mapPorlets.remove(id);
            }
            return;
        }
        this.mapPorlets.put(id, new Boolean(flag));
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.actionViewAtt_actionPerformed(null);
        }
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
        super.menuItemImportData_actionPerformed(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String id = this.getSelectedKeyValue();
        if (id == null || "".equals(id)) {
            return;
        }
        RptReceiverFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(id));
        this.refreshList();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        String user = userInfo.getId().toString();
        String defOrg = null;
        if (userInfo.getDefOrgUnit() != null) {
            defOrg = userInfo.getDefOrgUnit().getId().toString();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("receiver.value", (Object)user, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("receiver.value", (Object)defOrg, CompareType.EQUALS));
        filter.setMaskString("#0 or #1");
        return filter;
    }

    protected String getKeyFieldName() {
        return "receiver.id";
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RptReleaseFactory.getRemoteInstance();
    }

    @Override
    public void actionViewAtt_actionPerformed(ActionEvent e) throws Exception {
        String id = this.getSelectedValue("id");
        if (id == null) {
            return;
        }
        AttachmentManagerFactory.getClientManager().showAttachmentListUIByBoID(id, (Object)this);
    }

    @Override
    public void actionCommit_actionPerformed(ActionEvent e) throws Exception {
        String id;
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        Set set = this.mapPorlets.entrySet();
        for (Map.Entry obj : set) {
            id = (String)obj.getKey();
            if (this.oldPorlets.containsKey(id)) {
                this.oldPorlets.remove(id);
            }
            map.put(id, Boolean.TRUE);
        }
        set = this.oldPorlets.entrySet();
        for (Map.Entry obj : set) {
            id = (String)obj.getKey();
            map.put(id, Boolean.FALSE);
        }
        RptMgrFacadeFactory.getRemoteInstance().commitRptRelease(map);
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        this.showMessage();
        this.refreshList();
    }

    private String getSelectedValue(String colName) {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell(colName);
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        }
        return null;
    }

    public Map getMapPorlets() {
        return this.mapPorlets;
    }

    public void setMapPorlets(Map mapPorlets) {
        this.mapPorlets = mapPorlets;
    }
}

