/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.ba.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.cp.ba.RptReportTypeCollection;
import com.kingdee.eas.cp.ba.RptReportTypeFactory;
import com.kingdee.eas.cp.ba.RptReportTypeInfo;
import com.kingdee.eas.cp.ba.client.AbstractRptReportQueryUI;
import com.kingdee.eas.cp.ba.client.RptTypeF7PromptDialog;
import com.kingdee.eas.cp.ba.util.F7Handle;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.framework.SystemEnum;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class RptReportQueryUI
extends AbstractRptReportQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(RptReportQueryUI.class);
    private static final String AND = " AND ";
    private static final String OR = " OR ";
    private static final String LIKE = " like ";
    private static final String NAME = "name";
    private static final String BEGINDATE = "beginDate";
    private static final String ENDDATE = "enddate";
    private static final String RELEASEPERSON = "releasePerson";
    private static final String RPTSORT = "rptSort";
    private static final String FROMSYS = "fromSys";

    public RptReportQueryUI() throws Exception {
        this.initDate();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void initDate() {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        cal.getTime();
        this.beginDate.setValue((Object)cal.getTime());
        this.endDate.setValue((Object)date);
        RptTypeF7PromptDialog typeDialog = new RptTypeF7PromptDialog((IUIObject)this);
        F7Handle.RptTypeF7Handle(this.rptSort, (KDPromptSelector)typeDialog, "com.kingdee.eas.cp.ba.app.F7RptTypeQuery", true);
        this.fromSys.setSelectedItem(null);
    }

    public CustomerParams getCustomerParams() {
        Object sortObj;
        Object obj;
        CustomerParams ret = new CustomerParams();
        String name = this.txtName.getText();
        if (name != null && name.trim().length() > 0) {
            ret.addCustomerParam(NAME, name);
        }
        if (this.beginDate.getValue() != null) {
            ret.putDate(BEGINDATE, (Date)this.beginDate.getValue());
        }
        if (this.endDate.getValue() != null) {
            ret.putDate(ENDDATE, (Date)this.endDate.getValue());
        }
        if ((obj = this.releasePerson.getValue()) != null && obj instanceof PersonInfo) {
            ret.addCustomerParam(RELEASEPERSON, ((PersonInfo)obj).getId().toString());
        }
        if ((sortObj = this.rptSort.getValue()) != null && sortObj instanceof RptReportTypeInfo) {
            ret.addCustomerParam(RPTSORT, ((RptReportTypeInfo)sortObj).getId().toString());
        }
        if (this.fromSys.getSelectedItem() != null) {
            ret.addCustomerParam(FROMSYS, String.valueOf(((SystemEnum)this.fromSys.getSelectedItem()).getValue()));
        }
        return ret;
    }

    public void setCustomerParams(CustomerParams cp) {
        String tempSort;
        if (cp == null) {
            return;
        }
        this.txtName.setText(cp.getCustomerParam(NAME) == null ? "" : cp.getCustomerParam(NAME).toString());
        String relPerson = cp.getCustomerParam(RELEASEPERSON);
        if (relPerson == null || relPerson.trim().length() <= 0) {
            this.releasePerson.setData(null);
        } else {
            try {
                this.releasePerson.setData((Object)PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)relPerson))));
            }
            catch (Exception e) {
                this.releasePerson.setValue(null);
                e.printStackTrace();
            }
        }
        this.beginDate.setValue((Object)cp.getDate(BEGINDATE));
        this.endDate.setValue((Object)cp.getDate(ENDDATE));
        String fromSys = cp.getCustomerParam(FROMSYS);
        if (fromSys != null && fromSys.length() > 0) {
            this.fromSys.setSelectedItem((Object)SystemEnum.getEnum((int)Integer.valueOf(fromSys)));
        }
        if ((tempSort = cp.getCustomerParam(RPTSORT)) != null && tempSort.length() > 0) {
            try {
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)tempSort));
                filter.setMaskString(" #0 ");
                ev.setFilter(filter);
                RptReportTypeCollection cols = null;
                cols = RptReportTypeFactory.getRemoteInstance().getRptReportTypeCollection(ev);
                if (cols != null) {
                    this.rptSort.setValue((Object)cols.get(0));
                }
            }
            catch (Exception e) {
                this.rptSort.setValue(null);
                e.printStackTrace();
            }
        }
    }

    public void clear() {
        super.clear();
        this.txtName.setText(null);
        this.beginDate.setValue(null);
        this.endDate.setValue(null);
        this.releasePerson.setValue(null);
        this.fromSys.setSelectedItem(null);
        this.rptSort.setValue(null);
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = this.filterInfo.getFilterItems();
        FilterItemInfo item = null;
        int index = 0;
        StringBuffer maskString = new StringBuffer();
        if (this.txtName.getText() != null && this.txtName.getText().trim().length() > 0) {
            item = new FilterItemInfo(NAME, (Object)(this.txtName.getText() + "%"), CompareType.LIKE);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if (!BizCollUtil.objectIsNull((Object)this.beginDate.getTimestamp())) {
            item = new FilterItemInfo("createTime", (Object)this.beginDate.getTimestamp(), CompareType.GREATER_EQUALS);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if (!BizCollUtil.objectIsNull((Object)this.endDate.getTimestamp())) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(this.endDate.getTimestamp());
            String nowTimeStr = calendar.get(1) + "-" + calendar.get(3) + "-" + calendar.get(5) + " 23:59:59.9";
            item = new FilterItemInfo("createTime", (Object)Timestamp.valueOf(nowTimeStr), CompareType.LESS_EQUALS);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if (!BizCollUtil.objectIsNull((Object)this.releasePerson.getValue())) {
            item = new FilterItemInfo("releasePerson.id", (Object)((PersonInfo)this.releasePerson.getData()).getId().toString(), CompareType.EQUALS);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if (!BizCollUtil.objectIsNull((Object)this.fromSys.getSelectedItem())) {
            item = new FilterItemInfo(FROMSYS, (Object)((SystemEnum)this.fromSys.getSelectedItem()).getAlias(), CompareType.EQUALS);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if (!BizCollUtil.objectIsNull((Object)this.rptSort.getValue())) {
            RptReportTypeInfo rrtInfo = (RptReportTypeInfo)this.rptSort.getData();
            String tempLongNumber = rrtInfo.getLongNumber() + "!%";
            item = new FilterItemInfo("rptSort.longNumber", (Object)tempLongNumber, CompareType.LIKE);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        this.filterInfo.setMaskString(maskString.toString());
        return this.filterInfo;
    }

    private void makeMaskString(StringBuffer maskString, int index, String logicWord) {
        if (index == 0) {
            maskString.append("#" + index);
        } else {
            maskString.append(logicWord + "#" + index);
        }
    }
}

