/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.ba.client;

import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.cp.ba.RptSolutionCollection;
import com.kingdee.eas.cp.ba.RptSolutionFactory;
import com.kingdee.eas.cp.ba.RptSolutionInfo;
import com.kingdee.eas.cp.ba.SolutionTypeEnum;
import com.kingdee.eas.cp.ba.client.AbstractRptSolutionUI;
import com.kingdee.eas.cp.ba.client.RptSolutionInterface;
import com.kingdee.eas.cp.ba.client.RptSolutionSaveUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class RptSolutionUI
extends AbstractRptSolutionUI {
    private static final Logger logger = CoreUIObject.getLogger(RptSolutionUI.class);
    public static final String SELFNAME = "selfPanelUiName";
    public static final String OPERATETYPE = "operateType";
    public static final String RESOURCE = "com.kingdee.eas.cp.ba.client.RptResource";
    private JPanel panelChild = null;
    private boolean isViewNextTimeByThisDefaultSolution = false;
    private String uiName = null;
    private String currentPk = null;
    private String bgSchemeId = null;
    private String operateType = null;
    private SolutionTypeEnum currentSolutionType = null;
    private RptSolutionInfo rptSolutionInfo = null;
    protected static final String TOOLBAR = "TOOLBAR";
    protected static final int CONFIRM_ACTION = 0;
    protected static final int CANCEL_ACTION = 1;
    protected static final int CLOSE_WINDOW_ACTION = 2;
    private KDTextField tfReceivers = null;

    public KDTextField getTfReceivers() {
        return this.tfReceivers;
    }

    public void setTextFieldReceivers(KDTextField field) {
        this.tfReceivers = field;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTable();
        if (this.panelChild instanceof CoreUI) {
            this.setUITitle(((CoreUI)this.panelChild).getUITitle());
        } else if (this.panelChild instanceof CustomerQueryPanel) {
            this.setUITitle(((CustomerQueryPanel)this.panelChild).getUITitle());
        }
    }

    public void onShow() throws Exception {
        this.comboSolutionType.setBounds(new Rectangle(125, 0, 50, 19));
        super.onShow();
    }

    private void initTable() throws Exception {
        this.initButton();
        this.initChildUI();
        this.comboSolutionType.addItem((Object)SolutionTypeEnum.PERSON);
        this.comboSolutionType.addItem((Object)SolutionTypeEnum.ORG);
        this.comboSolutionType.addItem((Object)SolutionTypeEnum.CU);
        this.comboSolutionType.addItem((Object)SolutionTypeEnum.PUB);
        this.rptSolutionInfo = this.getSystemSoltuion();
        this.initSystemDefaultSolution();
        RptSolutionInfo info = this.rptSolutionInfo;
        this.refreshSolutionList(info, true, true);
        this.rptSolutionInfo = info;
        this.setSolutionButtion();
        this.initListenerSelf();
        this.initUILayout();
        this.kDCheckBox1.setSelected(false);
    }

    private void initChildUI() throws Exception {
        String selfPanelUiName;
        Map uicontext = this.getUIContext();
        UIContext uiContextOrg = new UIContext((Object)this);
        if (uicontext.get("ID") != null) {
            this.bgSchemeId = (String)uicontext.get("ID");
        }
        if (uicontext.get(OPERATETYPE) != null) {
            this.operateType = (String)uicontext.get(OPERATETYPE);
        }
        for (String key : uicontext.keySet()) {
            uiContextOrg.put((Object)key, uicontext.get(key));
        }
        this.uiName = selfPanelUiName = (String)uiContextOrg.get((Object)SELFNAME);
        IUIObject uiObject = null;
        String oprt = this.getOprtState();
        String name = selfPanelUiName;
        long start = System.currentTimeMillis();
        logger.debug((Object)("Begin initUIObject " + name + " : " + start + "!"));
        Class<?> c = null;
        try {
            c = Class.forName(name);
            uiObject = (IUIObject)c.newInstance();
            long instanceCost = System.currentTimeMillis() - start;
            logger.info((Object)("UIObject " + name + " new instance : " + instanceCost + " ms."));
            IUIObject ui = uiObject.getInstance((Map)uiContextOrg);
            if (ui != null) {
                uiObject = ui;
            }
            if (uiObject instanceof Component) {
                this.panelChild = (JPanel)uiObject;
                this.panelChild.setName("panelChild");
                this.panelContent.add((Component)this.panelChild, null);
                this.panelChild.setLayout(null);
            }
            if (uiObject instanceof CoreUIObject) {
                CoreUIObject coreUIObj = (CoreUIObject)uiObject;
                coreUIObj.initLayout();
            }
        }
        catch (ClassNotFoundException exc) {
            logger.error((Object)exc);
            throw new AbortException();
        }
        catch (Exception exc) {
            if (exc instanceof AbortException) {
                throw (AbortException)exc;
            }
            throw new UIException(UIFrameResource.getString((String)"UIFactoryHelper_createUIError"), (Throwable)exc);
        }
        if (this.dataObjects != null && this.dataObjects.size() > 0) {
            for (Object key : this.dataObjects.keySet()) {
                uiObject.setDataObject(key, (IObjectValue)((AbstractObjectValue)this.dataObjects.get(key)));
            }
        }
        if (uiContextOrg != null && uiContextOrg.size() > 0) {
            for (Object key : uiContextOrg.keySet()) {
                uiObject.getUIContext().put(key, uiContextOrg.get(key));
            }
            uiObject.getUIContext().put("PANELUI", this);
        }
        if (oprt != null && !oprt.equals("")) {
            uiObject.setOprtState(oprt);
        }
        try {
            long onLoadStart = System.currentTimeMillis();
            uiObject.onLoad();
            long onLoadCost = System.currentTimeMillis() - onLoadStart;
            logger.info((Object)("UIObject " + name + " onLoad spent " + onLoadCost + " ms."));
        }
        catch (Exception exc) {
            try {
                uiObject.destroyWindow();
            }
            catch (Exception ex) {
                logger.error((Object)("destory window error:" + ex));
            }
            throw new UIException(UIFrameResource.getString((String)"UIFactoryHelper_onLoadError"), (Throwable)exc);
        }
        if (uiObject.isBindWorkFlow()) {
            uiObject.checkWfAssignment();
        }
        long end = System.currentTimeMillis();
        logger.debug((Object)("End initUIObject " + name + " : " + end + "!"));
        long cost = end - start;
        logger.info((Object)("InitUIObject " + name + " : " + cost + " ms!"));
    }

    private void initUILayout() {
        int childUIHeigtht = this.panelChild.getHeight();
        int childUIWigtht = this.panelChild.getWidth();
        this.setBounds(this.getX(), this.getY(), childUIWigtht + 186, childUIHeigtht - 20 + 20 + 20 + 22 + 10 + 10);
        this.panelContent.setBounds(new Rectangle(186, 10, childUIWigtht, childUIHeigtht));
        this.add((Component)this.panelContent, null);
        this.panelContent.setLayout(null);
        this.panelChild.setBounds(new Rectangle(0, 0, childUIWigtht, childUIHeigtht));
        this.panelChild.setLayout(null);
        this.kDPanel1.setBounds(new Rectangle(9, 14, 176, childUIHeigtht));
        this.add((Component)this.kDPanel1, null);
        this.kDPanel1.setLayout(null);
        this.kDPanel3.setBounds(new Rectangle(0, 21, 180, childUIHeigtht - this.kDPanel2.getHeight()));
        this.kDPanel1.add((Component)this.kDPanel3, null);
        this.solutionList.setBounds(new Rectangle(0, 0, 180, this.kDPanel3.getHeight()));
        this.kDPanel3.add((Component)this.solutionList, null);
        this.kDSeparator2.setBounds(new Rectangle(0, this.kDPanel1.getY() + this.kDPanel1.getHeight() + 13, this.getWidth(), 7));
        this.add((Component)this.kDSeparator2, null);
        this.kDPanel4.setBounds(new Rectangle(this.getWidth() - 160, this.kDSeparator2.getY() + this.kDSeparator2.getHeight() + 3, 150, 22));
        this.add((Component)this.kDPanel4, null);
        this.kDCheckBox1.setBounds(10, this.kDPanel4.getY(), this.kDCheckBox1.getWidth(), this.kDCheckBox1.getHeight());
    }

    private void initSystemDefaultSolution() throws Exception {
        RptSolutionCollection assignSolutionCol;
        SolutionTypeEnum solutionType = null;
        if (this.panelChild instanceof RptSolutionInterface) {
            ((RptSolutionInterface)((Object)this.panelChild)).clear();
        }
        solutionType = this.comboSolutionType.getSelectedItem() != null ? (SolutionTypeEnum)((Object)this.comboSolutionType.getSelectedItem()) : SolutionTypeEnum.PERSON;
        StringBuffer oql = new StringBuffer("where isSystemSolution =1 and solutionType=" + solutionType.getValue());
        if (solutionType.getValue() == 0) {
            String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            oql.append(" and cuid='" + cuid + "'");
        } else if (solutionType.getValue() == 2) {
            String orgId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            oql.append(" and orgId='" + orgId + "'");
        } else if (solutionType.getValue() == 1) {
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            oql.append(" and userId='" + userId + "' ");
        }
        if (this.bgSchemeId != null) {
            oql.append(" and relativeObjId='" + this.bgSchemeId + "' ");
        }
        if (this.operateType != null) {
            oql.append(" and oprateObjType='" + this.operateType + "' ");
        }
        if (this.uiName != null) {
            oql.append(" and uiName='" + this.uiName + "' ");
        }
        if ((assignSolutionCol = RptSolutionFactory.getRemoteInstance().getRptSolutionCollection(oql.toString())).size() <= 0) {
            RptSolutionInfo info = new RptSolutionInfo();
            info.setIsSystemSolution(true);
            info.setSolutionName(EASResource.getString((String)RESOURCE, (String)"default.system.solution"));
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            info.setCuid(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
            info.setOrgId(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
            info.setUserId(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            info.setRelativeObjId(this.bgSchemeId);
            info.setOprateObjType(this.operateType);
            info.setSolutionType(solutionType);
            info.setUiName(this.uiName);
            RptSolutionFactory.getRemoteInstance().addnew(info);
        }
    }

    public void initLayout() {
        super.initLayout();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
    }

    private void initButton() {
        this.btnAddnew.setBounds(new Rectangle(0, 0, 22, 19));
        this.kDPanel2.add((Component)this.btnAddnew, null);
        this.btnSave.setBounds(new Rectangle(25, 0, 22, 19));
        this.kDPanel2.add((Component)this.btnSave, null);
        this.btnSaveAs.setBounds(new Rectangle(50, 0, 22, 19));
        this.kDPanel2.add((Component)this.btnSaveAs, null);
        this.btnUpdate.setBounds(new Rectangle(100, 0, 22, 19));
        this.kDPanel2.add((Component)this.btnUpdate, null);
        this.btnDelete.setBounds(new Rectangle(75, 0, 22, 19));
        this.kDPanel2.add((Component)this.btnDelete, null);
        this.comboSolutionType.setBounds(new Rectangle(125, 0, 60, 19));
        this.kDPanel2.add((Component)this.comboSolutionType, null);
        this.btnAddnew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnUpdate.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSaveAs.setIcon(EASResource.getIcon((String)"imgTbtn_saveas"));
        this.kDCheckBox1.setVisible(false);
        this.kDCheckBox1.setSelected(false);
    }

    private void setSolutionButtion() {
        boolean isSaveAs = false;
        RptSolutionInfo selectInfo = null;
        selectInfo = (RptSolutionInfo)this.solutionList.getSelectedValue();
        if (this.rptSolutionInfo != null && selectInfo == null || this.rptSolutionInfo != null && selectInfo != null && !selectInfo.getId().equals((Object)this.rptSolutionInfo.getId()) || selectInfo != null && selectInfo.isIsSystemSolution()) {
            isSaveAs = true;
        }
        if (isSaveAs) {
            this.btnAddnew.setEnabled(true);
            this.btnUpdate.setEnabled(false);
            this.btnDelete.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.btnSaveAs.setEnabled(true);
        } else if (selectInfo != null) {
            this.btnAddnew.setEnabled(true);
            this.btnUpdate.setEnabled(true);
            this.btnDelete.setEnabled(true);
            this.btnSave.setEnabled(true);
            this.btnSaveAs.setEnabled(true);
        } else {
            this.btnAddnew.setEnabled(false);
            this.btnUpdate.setEnabled(false);
            this.btnDelete.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.btnSaveAs.setEnabled(false);
        }
    }

    protected void setSelfPanel(JPanel comp) {
        this.panelChild = comp;
    }

    private void initListenerSelf() {
        this.btnAddnew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RptSolutionUI.this.addSolutionAction();
                }
                catch (Exception ex) {
                    RptSolutionUI.this.handleException(ex);
                }
            }
        });
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RptSolutionUI.this.saveSolutionAction();
                }
                catch (Exception ex) {
                    RptSolutionUI.this.handleException(ex);
                }
            }
        });
        this.btnSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RptSolutionUI.this.saveAsSolutionAction();
                }
                catch (Exception ex) {
                    RptSolutionUI.this.handleException(ex);
                }
            }
        });
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RptSolutionUI.this.deteleSolutionAction();
                }
                catch (Exception ex) {
                    RptSolutionUI.this.handleException(ex);
                }
            }
        });
        this.btnUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RptSolutionUI.this.updateSolutionAction();
                }
                catch (Exception ex) {
                    RptSolutionUI.this.handleException(ex);
                }
            }
        });
        this.btnConferm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RptSolutionUI.this.confermSolutionAction();
                }
                catch (Exception ex) {
                    RptSolutionUI.this.handleException(ex);
                }
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RptSolutionUI.this.cancelSolutionAction();
                }
                catch (Exception ex) {
                    RptSolutionUI.this.handleException(ex);
                }
            }
        });
        this.solutionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                try {
                    RptSolutionUI.this.solutionListClicked(arg0);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.comboSolutionType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    RptSolutionUI.this.comboSolutionType_itemStateChanged(e);
                }
                catch (Exception exc) {
                    RptSolutionUI.this.handUIException(exc);
                }
            }
        });
    }

    private void solutionListClicked(ListSelectionEvent e) throws Exception {
        if (this.solutionList.getSelectedValue() != null && this.solutionList.getSelectedValue() instanceof RptSolutionInfo) {
            if (this.panelChild instanceof RptSolutionInterface) {
                ((RptSolutionInterface)((Object)this.panelChild)).clear();
            }
            RptSolutionInfo assingInfo = (RptSolutionInfo)this.solutionList.getSelectedValue();
            this.refreshSolutionList(assingInfo, true, false);
            this.rptSolutionInfo = assingInfo;
            this.setSolutionButtion();
        }
    }

    protected void addSolutionAction() throws Exception {
        if (this.panelChild instanceof RptSolutionInterface) {
            ((RptSolutionInterface)((Object)this.panelChild)).clear();
        }
        this.rptSolutionInfo = new RptSolutionInfo();
        this.currentPk = BOSUuid.create((BOSObjectType)this.rptSolutionInfo.getBOSType()).toString();
        this.rptSolutionInfo.setId(BOSUuid.read((String)this.currentPk));
        this.rptSolutionInfo.setCuid(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        this.rptSolutionInfo.setOrgId(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
        this.rptSolutionInfo.setUserId(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        if (this.currentSolutionType == null) {
            this.currentSolutionType = (SolutionTypeEnum)((Object)this.comboSolutionType.getSelectedItem());
            if (this.currentSolutionType == null) {
                this.currentSolutionType = SolutionTypeEnum.PERSON;
            }
            this.comboSolutionType.setSelectedItem((Object)this.currentSolutionType);
        }
        this.rptSolutionInfo.setUiName(this.uiName);
        this.solutionList.setSelectedIndex(0);
    }

    protected void comboSolutionType_itemStateChanged(ItemEvent e) throws Exception {
        this.initSystemDefaultSolution();
        RptSolutionInfo info = null;
        this.refreshSolutionList(info, true, true);
        this.rptSolutionInfo = info;
    }

    private void clearSolutionList() throws Exception {
        this.solutionList.removeAllElements();
        if (this.panelChild instanceof RptSolutionInterface) {
            ((RptSolutionInterface)((Object)this.panelChild)).clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshSolutionList(RptSolutionInfo assignInfo, boolean isUpdateSolutionData, boolean isUpdateSolutionList) throws Exception {
        if (isUpdateSolutionList) {
            this.clearSolutionList();
            RptSolutionInfo solutionInfo = null;
            SolutionTypeEnum typeEnum = (SolutionTypeEnum)((Object)this.comboSolutionType.getSelectedItem());
            RptSolutionCollection asSolutionCol = new RptSolutionCollection();
            if (this.panelChild instanceof RptSolutionInterface) {
                asSolutionCol = ((RptSolutionInterface)((Object)this.panelChild)).solutionList(typeEnum);
            }
            Iterator iterator = asSolutionCol.iterator();
            while (iterator.hasNext()) {
                solutionInfo = (RptSolutionInfo)iterator.next();
                if (assignInfo == null && solutionInfo.isIsSystemSolution()) {
                    assignInfo = solutionInfo;
                }
                this.solutionList.addElement((Object)solutionInfo);
            }
        }
        if (isUpdateSolutionData) {
            if (assignInfo != null) {
                if (this.panelChild instanceof RptSolutionInterface) {
                    ((RptSolutionInterface)((Object)this.panelChild)).clear();
                }
            } else {
                return;
            }
            this.solutionList.setSelectedValue((Object)assignInfo, true);
            this.kDCheckBox1.setSelected(assignInfo.isIsDefaultsolution());
            if (this.panelChild instanceof RptSolutionInterface) {
                Object solutionData = null;
                ((RptSolutionInterface)((Object)this.panelChild)).clear();
                byte[] byteSolution = RptSolutionFactory.getRemoteInstance().getSolutionData(assignInfo.getId().toString());
                if (byteSolution != null) {
                    ByteArrayInputStream is = new ByteArrayInputStream(byteSolution);
                    ObjectInputStream bais = null;
                    try {
                        bais = new ObjectInputStream(new BufferedInputStream(is));
                        solutionData = bais.readObject();
                    }
                    catch (Exception e) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"UpdateSelectScheme"));
                        this.btnDelete.setEnabled(true);
                        SysUtil.abort();
                    }
                    finally {
                        try {
                            bais.close();
                        }
                        catch (Exception e) {
                            this.handleException(e);
                            SysUtil.abort();
                        }
                        try {
                            is.close();
                        }
                        catch (Exception e) {
                            this.handleException(e);
                            SysUtil.abort();
                        }
                    }
                }
                ((RptSolutionInterface)((Object)this.panelChild)).reloadSolution(solutionData);
            }
        }
        this.setSolutionButtion();
    }

    protected void saveSolutionAction() throws Exception {
        RptSolutionInfo info = this.rptSolutionInfo;
        int selectedIndex = this.solutionList.getSelectedIndex();
        if (this.saveSolution(info)) {
            this.refreshSolutionList(info, false, true);
            this.rptSolutionInfo = info;
        }
        this.solutionList.setSelectedIndex(selectedIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveSolution(Object obj) throws Exception {
        RptSolutionInfo assignInfo = (RptSolutionInfo)obj;
        boolean isConfirm = false;
        if (assignInfo == null || assignInfo.getSolutionName() == null || assignInfo.getSolutionName().length() <= 0) {
            UIContext uiContext = new UIContext((Object)this);
            Map map = new HashMap(1);
            uiContext.put((Object)"this.is.for.input.return.value", map);
            IUIWindow window = null;
            try {
                IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                window = uiFactory.create(RptSolutionSaveUI.class.getName(), (Map)uiContext, null, "");
                window.show();
            }
            catch (UIException e) {
                logger.error((Object)e);
            }
            map = (Map)uiContext.get((Object)"this.is.for.input.return.value");
            if (map.isEmpty() || map.get("solutionName") == null) {
                return false;
            }
            int solutionList = this.solutionList.getElementCount();
            if (solutionList > 1 && !map.isEmpty() && map.get("solutionName") != null) {
                for (int i = 0; i < solutionList; ++i) {
                    if (!this.solutionList.getElement(i).toString().equals(map.get("solutionName").toString())) continue;
                    MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"solutionRepeat"));
                    return false;
                }
            }
            if (assignInfo == null || assignInfo.getId() == null) {
                if (this.currentPk == null) {
                    this.currentPk = BOSUuid.create((BOSObjectType)new RptSolutionInfo().getBOSType()).toString();
                }
                if (assignInfo == null) {
                    assignInfo = new RptSolutionInfo();
                }
                this.currentSolutionType = (SolutionTypeEnum)((Object)this.comboSolutionType.getSelectedItem());
                if (this.currentSolutionType == null) {
                    this.currentSolutionType = SolutionTypeEnum.PERSON;
                }
                assignInfo.setSolutionType(this.currentSolutionType);
                assignInfo.setId(BOSUuid.read((String)this.currentPk));
                assignInfo.setCuid(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
                assignInfo.setOrgId(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
                assignInfo.setUserId(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
                assignInfo.setUiName(this.uiName);
            }
            assignInfo.setSolutionName((String)map.get("solutionName"));
        }
        assignInfo.setRelativeObjId(this.bgSchemeId);
        assignInfo.setOprateObjType(this.operateType);
        assignInfo.setIsDefaultsolution(this.kDCheckBox1.isSelected());
        Object solutionData = null;
        if (this.panelChild instanceof RptSolutionInterface) {
            solutionData = ((RptSolutionInterface)((Object)this.panelChild)).saveSolution();
        }
        RptSolutionFactory.getRemoteInstance().save(assignInfo);
        if (solutionData != null) {
            byte[] objByte = null;
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            ObjectOutputStream out = null;
            try {
                out = new ObjectOutputStream(bao);
                out.writeObject(solutionData);
                objByte = bao.toByteArray();
            }
            catch (IOException e) {
                this.handleException(e);
                SysUtil.abort();
            }
            finally {
                try {
                    out.close();
                }
                catch (Exception e) {
                    this.handleException(e);
                    SysUtil.abort();
                }
            }
            RptSolutionFactory.getRemoteInstance().saveSolutionData(assignInfo.getId().toString(), objByte);
        }
        MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"save.success"));
        return true;
    }

    protected void saveAsSolutionAction() throws Exception {
        this.rptSolutionInfo = new RptSolutionInfo();
        this.currentPk = BOSUuid.create((BOSObjectType)this.rptSolutionInfo.getBOSType()).toString();
        RptSolutionInfo info = this.rptSolutionInfo;
        if (this.saveSolution(info)) {
            this.refreshSolutionList(info, false, true);
            this.rptSolutionInfo = info;
        }
        this.solutionList.setSelectedIndex(this.solutionList.getElementCount() - 1);
    }

    protected void deteleSolutionAction() throws Exception {
        if (this.solutionList.getSelectedIndex() >= 0 && this.solutionList.getSelectedValue() != null) {
            this.rptSolutionInfo = (RptSolutionInfo)this.solutionList.getSelectedValue();
            this.solutionList.removeElement(this.solutionList.getSelectedValue());
        }
        if (this.rptSolutionInfo == null) {
            return;
        }
        RptSolutionFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(this.rptSolutionInfo.getId()));
        this.refreshSolutionList(null, true, true);
    }

    protected void updateSolutionAction() {
        UIContext uiContext = new UIContext((Object)this);
        Map map = new HashMap(1);
        uiContext.put((Object)"this.is.for.input.return.value", map);
        IUIWindow window = null;
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            window = uiFactory.create(RptSolutionSaveUI.class.getName(), (Map)uiContext, null, "");
            window.show();
        }
        catch (UIException e) {
            logger.error((Object)e);
        }
        map = (Map)uiContext.get((Object)"this.is.for.input.return.value");
        if (map.isEmpty() || map.get("solutionName") == null) {
            return;
        }
        int selectedIndex = this.solutionList.getSelectedIndex();
        RptSolutionInfo info = (RptSolutionInfo)this.solutionList.getSelectedValue();
        info.setSolutionName((String)map.get("solutionName"));
        try {
            if (this.saveSolution(info)) {
                this.refreshSolutionList(info, false, true);
                this.solutionList.setSelectedIndex(selectedIndex);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void confermSolutionAction() throws Exception {
        if (this.panelChild instanceof RptSolutionInterface && ((RptSolutionInterface)((Object)this.panelChild)).conferm((Object)this) && this.isShowing()) {
            this.destroyWindow();
            return;
        }
    }

    protected void cancelSolutionAction() throws Exception {
        boolean cancel = ((RptSolutionInterface)((Object)this.panelChild)).cancel();
        if (this.isShowing() && cancel) {
            this.destroyWindow();
        }
    }

    public Object getReturnData() throws Exception {
        return ((RptSolutionInterface)((Object)this.panelChild)).getReturnData();
    }

    public boolean isViewNextTimeByThisDefaultSolution() {
        return this.isViewNextTimeByThisDefaultSolution;
    }

    public void setViewNextTimeByThisDefaultSolution(boolean isViewNextTimeByThisDefaultSolution) {
        this.isViewNextTimeByThisDefaultSolution = isViewNextTimeByThisDefaultSolution;
        if (isViewNextTimeByThisDefaultSolution) {
            try {
                if (RptSolutionUI.getDefaultSolution(this.uiName, this.bgSchemeId, this.operateType) != null) {
                    this.confermSolutionAction();
                    this.destroyWindow();
                    return;
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            logger.info((Object)"assign invoking has not done");
            return;
        }
        this.kDCheckBox1.setVisible(isViewNextTimeByThisDefaultSolution);
    }

    public String getObjId() {
        return this.bgSchemeId;
    }

    public void setObjId(String objId) {
        this.bgSchemeId = objId;
    }

    public String getOperateType() {
        return this.operateType;
    }

    public void setOperateType(String operateType) {
        this.operateType = operateType;
    }

    public String getUiName() {
        return this.uiName;
    }

    public void setUiName(String uiName) {
        this.uiName = uiName;
    }

    public static RptSolutionInfo getDefaultSolution(String uiName, String objID, String oprtType) throws Exception {
        return null;
    }

    private RptSolutionInfo getSystemSoltuion() throws Exception {
        return null;
    }
}

