/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.ba.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.workflow.exception.AlreadyBindProcessInstanceException;
import com.kingdee.eas.base.job.client.ProcessSchedulePlan;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.cp.ba.IRptAccepter;
import com.kingdee.eas.cp.ba.IRptReportSubscibe;
import com.kingdee.eas.cp.ba.IRptSubscibeReceiver;
import com.kingdee.eas.cp.ba.RptAccepterFactory;
import com.kingdee.eas.cp.ba.RptReceiverCollection;
import com.kingdee.eas.cp.ba.RptReceiverInfo;
import com.kingdee.eas.cp.ba.RptReportSubscibeCollection;
import com.kingdee.eas.cp.ba.RptReportSubscibeFactory;
import com.kingdee.eas.cp.ba.RptReportSubscibeInfo;
import com.kingdee.eas.cp.ba.RptReportTypeInfo;
import com.kingdee.eas.cp.ba.RptSubscibeReceiverCollection;
import com.kingdee.eas.cp.ba.RptSubscibeReceiverFactory;
import com.kingdee.eas.cp.ba.RptSubscibeReceiverInfo;
import com.kingdee.eas.cp.ba.RptSubscibeTypeEnum;
import com.kingdee.eas.cp.ba.RptTypeEnum;
import com.kingdee.eas.cp.ba.client.AbstractRptSubscibeAddNewUI;
import com.kingdee.eas.cp.ba.client.ReceiversListUI;
import com.kingdee.eas.cp.ba.client.RptTypeF7PromptDialog;
import com.kingdee.eas.cp.ba.util.F7Handle;
import com.kingdee.eas.cp.ba.util.RptUtil;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseCollection;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Iterator;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class RptSubscibeAddNewUI
extends AbstractRptSubscibeAddNewUI {
    private static final Logger logger = CoreUIObject.getLogger(RptSubscibeAddNewUI.class);
    private static final String RES = "com.kingdee.eas.cp.ba.client.RptResource";
    protected EntityViewInfo tempQuery = null;
    protected IMetaDataPK tempQueryPK = null;
    protected CompanyOrgUnitInfo company;
    private String schedule = null;
    public RptReceiverCollection readerCols = new RptReceiverCollection();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tempQuery = new EntityViewInfo();
        this.company = SysContext.getSysContext().getCurrentFIUnit();
        this.btnAddNew.setVisible(false);
        RptTypeF7PromptDialog typeDialog = new RptTypeF7PromptDialog((IUIObject)this);
        F7Handle.RptTypeF7Handle(this.rptSort, (KDPromptSelector)typeDialog, "com.kingdee.eas.cp.ba.app.F7RptTypeQuery", true);
        this.btnReader.setEnabled(true);
        this.initCurrentUI();
        this.comTemType.removeItem((Object)RptTmpTypeEnum.COMMONREPORT);
        this.comTemType.removeItem((Object)RptTmpTypeEnum.GROUPREPORT);
        this.comTemType.removeItem((Object)RptTmpTypeEnum.RPTDYNAMICREPORT);
    }

    private void initCurrentUI() {
        this.rptSort.setRequired(true);
        this.personDesc.setRequired(true);
        this.releaseType.setRequired(true);
        this.rptSort.setRequired(true);
        this.fromSys.setRequired(true);
        this.btnJob.setIcon(EASResource.getIcon((String)"imgTbtn_register"));
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RptReportSubscibeFactory.getRemoteInstance();
    }

    @Override
    protected void comTemType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1) {
            RptTmpTypeEnum tempEnum = this.getSelectedTemplate();
            if (tempEnum == null) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u951f\u65a4\u62f7\u9009\u951f\u65a4\u62f7\u6a21\u951f\u65a4\u62f7\u951f\u65a4\u62f7\u951f\u65a4\u62f7!");
                this.abort();
            }
            switch (tempEnum.getValue()) {
                case 6: 
                case 10: {
                    this.tblMain.putBindContents("rptReportTemplateQuery", new String[]{"id", "", "template.name", "template.number", "template.periodType", "", "template.createTime", ""});
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 11: {
                    this.tblMain.putBindContents("RptReportSumTemplateQuery", new String[]{"id", "", "template.name", "template.number", "template.periodType", "", "template.createTime", ""});
                }
            }
            this.initText(null);
            this.refreshTable();
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.verify(e);
        try {
            this.runSubmit(this.getSubmitValue());
            this.showSubmitSuccess();
        }
        catch (AlreadyBindProcessInstanceException wfExceptoin) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_BindWfInstance"));
            return;
        }
    }

    protected void showSubmitSuccess() {
        this.setMessageText("\u951f\u65a4\u62f7\u951f\u65a4\u62f7\u951f\u7686\u8bb9\u62f7\u951f\u65a4\u62f7\u951f\u65a4\u62f7\u951f\u65a4\u62f7\u951f\u65a4\u62f7 " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        this.setIsShowTextOnly(false);
        this.setShowMessagePolicy(0);
        this.showMessage();
    }

    public CoreBaseInfo getSubmitValue() throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            RptReportSubscibeInfo info = new RptReportSubscibeInfo();
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell("id");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            info.setSupplyID((keyValue = cell.getValue()) == null ? null : keyValue.toString());
            info.setPersonDec(this.personDesc.getText());
            info.setReleaseType((RptTypeEnum)((Object)this.releaseType.getSelectedItem()));
            info.setRptType((RptReportTypeInfo)this.rptSort.getValue());
            info.setFromSys("");
            if (this.auditRelease.isSelected()) {
                info.setSubscibeType(RptSubscibeTypeEnum.AfterAudit);
            } else if (this.standardRelease.isSelected()) {
                info.setSubscibeType(RptSubscibeTypeEnum.AfterAudit);
            } else {
                info.setSubscibeType(RptSubscibeTypeEnum.AfterAudit);
            }
            if (this.readerCols != null && this.readerCols.size() > 0) {
                if (info.getId() != null) {
                    this.updateRelationReceiver(info, this.readerCols);
                } else {
                    this.saveRelationReceiver(info, this.readerCols);
                }
            }
            return info;
        }
        return null;
    }

    public IObjectPK runSubmit(CoreBaseInfo info) throws Exception {
        if (this.getBizInterface() == null) {
            throw new Exception("don't implement getBizInterface()  !");
        }
        return this.getBizInterface().submit(info);
    }

    protected final void verify(ActionEvent e) throws Exception {
        this.beforeStoreFields(e);
        this.storeValues();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (this.personDesc.getText() == null || "".equals(this.personDesc.getText().trim())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"receiver_not_null"));
            this.personDesc.requestFocus();
            this.abort();
        }
        if (this.releaseType.getSelectedItem() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"release_type_not_null"));
            this.releaseType.requestFocus();
            this.abort();
        }
        if (this.rptSort.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"sort_not_null"));
            this.rptSort.requestFocus();
            this.abort();
        }
    }

    protected void storeValues() throws Exception {
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (e == null) {
            return;
        }
        String tempID = this.getSelectedKeyValue();
        if (tempID == null || "".equals(tempID.trim())) {
            this.initText(null);
            return;
        }
        this.initText(this.getSubscibeInfo(tempID));
    }

    public void initText(RptReportSubscibeInfo info) throws Exception {
        if (info == null) {
            this.personDesc.setText(null);
            this.rptSort.setValue(null);
            this.releaseType.setSelectedItem(null);
            this.fromSys.setSelectedItem(null);
            this.initReceiver(null);
        } else {
            this.personDesc.setText(info.getPersonDec());
            this.rptSort.setValue((Object)info.getRptType());
            this.releaseType.setSelectedItem((Object)info.getReleaseType());
            this.fromSys.setSelectedItem((Object)info.getFromSys());
            this.initReceiver(info.getId().toString());
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public void refreshTable() throws Exception {
        this.setLocatePre(false);
        this.buildListFilter();
        this.execQuery();
        this.setSelectFirstRow(this.tblMain);
    }

    public RptTmpTypeEnum getSelectedTemplate() {
        Object obj = this.comTemType.getSelectedItem();
        if (obj != null && obj instanceof RptTmpTypeEnum) {
            return (RptTmpTypeEnum)obj;
        }
        return null;
    }

    protected void buildListFilter() throws BOSException {
        RptTmpTypeEnum tempEnum = this.getSelectedTemplate();
        if (tempEnum == null) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u951f\u65a4\u62f7\u9009\u951f\u65a4\u62f7\u6a21\u951f\u65a4\u62f7\u951f\u65a4\u62f7\u951f\u65a4\u62f7!");
            this.abort();
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.tempQuery.getFilter() == null) {
            this.tempQuery.setFilter(new FilterInfo());
        }
        FilterItemCollection col = this.tempQuery.getFilter().getFilterItems();
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
        this.tempQuery.getFilter().remove("maskString");
        if (this.company == null) {
            this.company = SysContext.getSysContext().getCurrentFIUnit();
        }
        switch (tempEnum.getValue()) {
            case 6: {
                this.setCommonCondition(6);
                break;
            }
            case 10: {
                this.setCommonCondition(10);
                break;
            }
            case 5: {
                this.setSumCondition(5);
                break;
            }
            case 4: {
                this.setSumCondition(4);
                break;
            }
            case 3: {
                this.setSumCondition(3);
                break;
            }
            case 11: {
                this.setSumCondition(11);
            }
        }
        iter = this.tempQuery.getSorter().iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
        if (this.getCurrentOrder() != null) {
            this.tempQuery.getSorter().add(this.getCurrentOrder());
        }
    }

    public String getTempTypeFieldName() {
        return "template.templateType";
    }

    @Override
    public void actionReader_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)RptUtil.COLLECTION, (Object)this.readerCols);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(ReceiversListUI.class.getName(), (Map)uiContext, null, null);
        ReceiversListUI receiversListUI = (ReceiversListUI)window.getUIObject();
        receiversListUI.setTextFieldReceivers(this.personDesc);
        window.show();
    }

    @Override
    protected void auditRelease_stateChanged(ChangeEvent e) throws Exception {
        if (this.standardRelease.isSelected()) {
            this.btnJob.setEnabled(true);
        } else {
            this.btnJob.setEnabled(false);
        }
    }

    @Override
    protected void standardRelease_stateChanged(ChangeEvent e) throws Exception {
        if (this.standardRelease.isSelected()) {
            this.btnJob.setEnabled(true);
        } else {
            this.btnJob.setEnabled(false);
        }
    }

    @Override
    public void actionJob_actionPerformed(ActionEvent e) throws Exception {
        String tempSchedule = ProcessSchedulePlan.open((Object)((Object)this), (String)this.getSchedule());
        if (tempSchedule != null) {
            this.setSchedule(tempSchedule);
        }
    }

    public void initReceiver(String id) throws BOSException {
        if (id != null) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("item", (Object)id, CompareType.EQUALS));
            filter.setMaskString(" #0 ");
            ev.setFilter(filter);
            if (this.readerCols.size() > 0) {
                this.readerCols.clear();
            }
            RptReceiverInfo recInfo = null;
            IRptSubscibeReceiver iAcc = null;
            RptSubscibeReceiverInfo accInfo2 = null;
            ObjectBaseCollection cols = null;
            iAcc = RptSubscibeReceiverFactory.getRemoteInstance();
            cols = iAcc.getObjectBaseCollection(ev);
            for (RptSubscibeReceiverInfo accInfo2 : cols) {
                recInfo = new RptReceiverInfo();
                recInfo.setValue(accInfo2.getValue());
                recInfo.setType(accInfo2.getType());
                this.readerCols.add(recInfo);
            }
        } else if (this.readerCols.size() > 0) {
            this.readerCols.clear();
        }
    }

    private void updateRelationReceiver(RptReportSubscibeInfo info, RptReceiverCollection cols) throws Exception {
        if (info == null) {
            return;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("item", (Object)info.getId().toString(), CompareType.EQUALS));
        filter.setMaskString(" #0 ");
        ev.setFilter(filter);
        Object recInfo = null;
        IRptSubscibeReceiver iAcc = null;
        RptSubscibeReceiverInfo accInfo2 = null;
        ObjectBaseCollection tempCols = null;
        iAcc = RptSubscibeReceiverFactory.getRemoteInstance();
        tempCols = iAcc.getObjectBaseCollection(ev);
        for (RptSubscibeReceiverInfo accInfo2 : tempCols) {
            iAcc.delete((IObjectPK)new ObjectUuidPK(accInfo2.getId()));
        }
        this.saveRelationReceiver(info, cols);
    }

    private void saveRelationReceiver(RptReportSubscibeInfo info, RptReceiverCollection cols) throws BOSException, EASBizException, UuidException {
        if (info == null) {
            return;
        }
        RptSubscibeReceiverInfo accInfo = null;
        RptSubscibeReceiverCollection recCols = info.getReader();
        RptReceiverInfo recInfo = null;
        Iterator ite = cols.iterator();
        IRptAccepter iAcc = null;
        iAcc = RptAccepterFactory.getRemoteInstance();
        while (ite.hasNext()) {
            recInfo = (RptReceiverInfo)ite.next();
            accInfo = new RptSubscibeReceiverInfo();
            accInfo.setType(recInfo.getType());
            accInfo.setValue(recInfo.getValue());
            accInfo.setItem(info);
            recCols.add(accInfo);
        }
    }

    @Override
    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        if (this.tempQueryPK != null) {
            int start = (Integer)e.getParam1();
            int length = (Integer)e.getParam2() - start + 1;
            try {
                IQueryExecutor exec = this.getQueryExecutor(this.tempQueryPK, this.tempQuery);
                IRowSet rowSet = exec.executeQuery(start, length);
                e.setRowSet(rowSet);
                this.onGetRowSet(rowSet);
            }
            catch (Exception ee) {
                this.handUIException(ee);
            }
        }
    }

    private void setCommonCondition(int intEnum) throws BOSException {
        FilterItemCollection col = this.tempQuery.getFilter().getFilterItems();
        col.add(new FilterItemInfo("template.templateType", (Object)new Integer(intEnum)));
        col.add(new FilterItemInfo("company.id", (Object)this.company.getId().toString()));
        this.tempQueryPK = new MetaDataPK("com.kingdee.eas.cp.ba.app", "RptReportTemplateQuery");
        this.tempQuery.getFilter().setMaskString("#0 and #1");
    }

    private void setSumCondition(int intEnum) throws BOSException {
        FilterItemCollection col = this.tempQuery.getFilter().getFilterItems();
        col.add(new FilterItemInfo("template.templateType", (Object)new Integer(intEnum)));
        col.add(new FilterItemInfo("company.id", (Object)this.company.getId().toString()));
        this.tempQueryPK = new MetaDataPK("com.kingdee.eas.cp.ba.app", "RptReportSumTemplateQuery");
        this.tempQuery.getFilter().setMaskString("#0 and #1");
    }

    private RptReportSubscibeInfo getSubscibeInfo(String tempDisId) throws EASBizException, BOSException, UuidException {
        IRptReportSubscibe iRpt = null;
        RptReportSubscibeInfo info = null;
        RptReportSubscibeCollection cols = null;
        try {
            EntityViewInfo ev = new EntityViewInfo();
            SelectorItemCollection sic = ev.getSelector();
            sic.add(new SelectorItemInfo("personDec"));
            sic.add(new SelectorItemInfo("releaseType"));
            sic.add(new SelectorItemInfo("fromSys"));
            sic.add(new SelectorItemInfo("rptType.*"));
            sic.add(new SelectorItemInfo("rptType.name"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("supplyID", (Object)tempDisId));
            filter.setMaskString("#0");
            ev.setFilter(filter);
            iRpt = RptReportSubscibeFactory.getRemoteInstance();
            cols = iRpt.getRptReportSubscibeCollection(ev);
            if (cols != null && cols.size() > 0) {
                info = cols.get(0);
            }
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
        return info;
    }

    protected String getKeyFieldName() {
        return super.getKeyFieldName();
    }

    public String getSchedule() {
        return this.schedule;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }
}

