/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.ba.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.cp.ba.IRptMgrFacade;
import com.kingdee.eas.cp.ba.IRptReportTemplate;
import com.kingdee.eas.cp.ba.IRptReportType;
import com.kingdee.eas.cp.ba.RptMgrFacadeFactory;
import com.kingdee.eas.cp.ba.RptReportTemplateCollection;
import com.kingdee.eas.cp.ba.RptReportTemplateFactory;
import com.kingdee.eas.cp.ba.RptReportTemplateInfo;
import com.kingdee.eas.cp.ba.RptReportTypeCollection;
import com.kingdee.eas.cp.ba.RptReportTypeFactory;
import com.kingdee.eas.cp.ba.RptReportTypeInfo;
import com.kingdee.eas.cp.ba.client.AbstractRptTemplateManagerUI;
import com.kingdee.eas.cp.ba.client.SchemeAddUI;
import com.kingdee.eas.cp.ba.util.RptMgrTreeUtil;
import com.kingdee.eas.cp.ba.util.RptReportTemplateBean;
import com.kingdee.eas.cp.ba.util.RptUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.client.tree.DefaultLNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.client.tree.TreeBuilderFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class RptTemplateManagerUI
extends AbstractRptTemplateManagerUI {
    private static final Logger logger = CoreUIObject.getLogger(RptTemplateManagerUI.class);
    private static final String RES = "com.kingdee.eas.cp.ba.client.RptResource";
    private Object[] dataList;
    private static Locale[] locales = null;
    private TreeSelectionListener treeSelectionListener;
    protected ITreeBuilder treeBuilder;

    @Override
    protected void temList_valueChanged(ListSelectionEvent e) throws Exception {
        Object obj = this.temList.getSelectedValue();
        String id = null;
        if (obj != null && obj instanceof RptReportTemplateBean) {
            id = ((RptReportTemplateBean)obj).getId();
        }
        this.builtTree(id);
    }

    protected void builtTree(String id) throws Exception {
        if (id == null || id.length() <= 0) {
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot(null);
            return;
        }
        TreeSelectionListener[] listeners = this.treeMain.getTreeSelectionListeners();
        if (listeners.length >= 1) {
            this.treeSelectionListener = listeners[0];
            this.treeMain.removeTreeSelectionListener(this.treeSelectionListener);
        }
        this.treeBuilder = TreeBuilderFactory.createTreeBuilder((ILNTreeNodeCtrl)this.getLNTreeNodeCtrl(), (int)this.getTreeInitialLevel(), (int)this.getTreeExpandLevel(), (FilterInfo)this.getDefaultFilterForTree(id));
        if (this.getRootName(id) != null) {
            KDTreeNode rootNode = new KDTreeNode(this.getRootObject(id));
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot((TreeNode)rootNode);
        } else {
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot(null);
        }
        this.treeBuilder.buildTree(this.treeMain);
        this.treeMain.addTreeSelectionListener(this.treeSelectionListener);
        this.treeMain.setShowPopMenuDefaultItem(true);
        this.initPopmenu();
    }

    protected void initPopmenu() {
        EventListener[] ls = this.treeMain.getListeners(TreePopupMenuListener.class);
        if (ls == null || ls.length == 0) {
            this.treeMain.addTreePopupMenu(new TreePopupMenuListener(){

                public boolean popMenu(TreePopupMenuEvent event) {
                    return true;
                }
            });
        }
    }

    protected int getTreeInitialLevel() {
        return 3;
    }

    protected int getTreeExpandLevel() {
        return 3;
    }

    protected ILNTreeNodeCtrl getLNTreeNodeCtrl() throws Exception {
        return new DefaultLNTreeNodeCtrl(this.getTreeInterface());
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return RptReportTemplateFactory.getRemoteInstance();
    }

    protected FilterInfo getDefaultFilterForTree(String id) {
        FilterInfo filter = new FilterInfo();
        filter = this.getDefaultFilterForQuery();
        FilterInfo tempFilter = new FilterInfo();
        tempFilter.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(1), CompareType.GREATER));
        tempFilter.setMaskString(" #0 ");
        try {
            filter.mergeFilter(tempFilter, "AND");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return filter;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        if (this.isIgnoreCUFilter()) {
            return filter;
        }
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        filter.setMaskString("#0 or #1 or #2");
        return filter;
    }

    protected boolean isIgnoreCUFilter() {
        return false;
    }

    protected String getRootName(String id) {
        return EASResource.getString((String)RES, (String)"rpt_name");
    }

    protected Object getRootObject(String id) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo tempFilter = new FilterInfo();
        tempFilter.getFilterItems().add(new FilterItemInfo("parent", (Object)id, CompareType.EQUALS));
        tempFilter.setMaskString(" #0 ");
        ev.setFilter(tempFilter);
        IRptReportTemplate iRpt = null;
        RptReportTemplateInfo tempInfo = null;
        iRpt = RptReportTemplateFactory.getRemoteInstance();
        RptReportTemplateCollection cols = iRpt.getRptReportTemplateCollection(ev);
        if (cols.size() > 0) {
            tempInfo = cols.get(0);
        }
        return tempInfo;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.temList.setSelectionMode(0);
        this.initList();
        this.initTree();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnDel.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnOut.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnDel.setEnabled(true);
        this.btnImport.setEnabled(true);
        this.btnOut.setEnabled(true);
        this.btnRefresh.setEnabled(true);
    }

    private void initList() {
        try {
            IRptMgrFacade rpt = RptMgrFacadeFactory.getRemoteInstance();
            this.dataList = rpt.getScheme();
        }
        catch (BOSException e) {
            this.dataList = new Object[1];
            e.printStackTrace();
        }
        this.temList.setListData(this.dataList);
        if (this.dataList != null && this.dataList.length > 0) {
            this.temList.setSelectedIndex(0);
        }
    }

    private void initTree() throws Exception {
        Object obj = this.temList.getSelectedValue();
        String id = null;
        if (obj != null && obj instanceof RptReportTemplateBean) {
            id = ((RptReportTemplateBean)obj).getId();
        }
        this.builtTree(id);
    }

    @Override
    public void actionDel_actionPerformed(ActionEvent e) throws Exception {
        if (this.temList.isSelectionEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"scheme_not_selected"));
            return;
        }
        Object obj = this.temList.getSelectedValue();
        String id = null;
        if (obj != null && obj instanceof RptReportTemplateBean) {
            id = ((RptReportTemplateBean)obj).getId();
        }
        if (this.checkIsSystemTemplate(id)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"system_template"));
            return;
        }
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"delete_confirm")) != 0) {
            return;
        }
        this.removeNode(id);
        this.initList();
    }

    protected boolean checkIsSystemTemplate(String id) throws BOSException, EASBizException, UuidException {
        IRptReportTemplate iRpt = RptReportTemplateFactory.getRemoteInstance();
        RptReportTemplateInfo info = (RptReportTemplateInfo)iRpt.getDataBaseInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        if (info == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"data_not_exist"));
            return false;
        }
        return info.getTempType() == 1;
    }

    protected void removeNode(String id) throws Exception {
        IRptReportTemplate iRpt = RptReportTemplateFactory.getRemoteInstance();
        RptReportTemplateInfo info = (RptReportTemplateInfo)iRpt.getDataBaseInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        this.removeNode(info);
    }

    protected void removeNode(RptReportTemplateInfo info) throws Exception {
        if (info == null) {
            return;
        }
        IRptReportTemplate iRpt = null;
        iRpt = RptReportTemplateFactory.getRemoteInstance();
        if (info.isIsLeaf()) {
            iRpt.delete((IObjectPK)new ObjectUuidPK(info.getId()));
        } else {
            RptReportTemplateInfo tempInfo = null;
            TreeBaseCollection collection = iRpt.getChildren(info);
            int n = collection.size();
            for (int i = 0; i < n; ++i) {
                tempInfo = (RptReportTemplateInfo)collection.get(i);
                this.removeNode(tempInfo);
            }
            iRpt.delete((IObjectPK)new ObjectUuidPK(info.getId()));
        }
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        if (this.temList.isSelectionEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"scheme_not_selected"));
            SysUtil.abort();
        }
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"import_confirm")) != 0) {
            SysUtil.abort();
        }
        String id = null;
        Object obj = this.temList.getSelectedValue();
        id = ((RptReportTemplateBean)obj).getId();
        if (!RptMgrFacadeFactory.getRemoteInstance().deleteCurrentType()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"data_handle_error"));
            SysUtil.abort();
        }
        this.insertCurrentReportType(id);
        ((Hashtable)this.getUIContext().get("OPTION")).put("action", "import");
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"template_import_success"));
        this.uiWindow.close();
    }

    @Override
    public void actionOut_actionPerformed(ActionEvent e) throws Exception {
        String[] schemeName = this.inputName();
        if (schemeName == null || schemeName.length <= 0) {
            return;
        }
        Map ctx = this.getUIContext();
        DefaultKingdeeTreeNode rootNode = (DefaultKingdeeTreeNode)ctx.get("ROOTNODE");
        if (rootNode == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"not_reporttype"));
            return;
        }
        RptReportTypeInfo info = (RptReportTypeInfo)rootNode.getUserObject();
        boolean mark = RptMgrFacadeFactory.getRemoteInstance().treeCopy(info.getId().toString(), schemeName);
        if (mark) {
            this.initList();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"output_success"));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"output_failture"));
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.initList();
    }

    public boolean checkNameDouble(String name) throws Exception {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)name, CompareType.EQUALS));
        filter.setMaskString(" #0 ");
        ev.setFilter(filter);
        IRptReportTemplate iTemp = null;
        RptReportTemplateInfo tempInfo = null;
        RptReportTemplateCollection cols = null;
        iTemp = RptReportTemplateFactory.getRemoteInstance();
        cols = iTemp.getRptReportTemplateCollection(ev);
        Iterator ite = cols.iterator();
        while (ite.hasNext()) {
            tempInfo = (RptReportTemplateInfo)ite.next();
            if (!tempInfo.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private String[] inputName() throws Exception {
        String sUIName = SchemeAddUI.class.getName();
        UIContext uiContext = new UIContext((Object)this);
        Hashtable option = new Hashtable();
        uiContext.put((Object)"option", option);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(sUIName, (Map)uiContext);
        uiWindow.show();
        String action = (String)option.get("action");
        if (action == null) {
            return null;
        }
        if (action.equals("CEL")) {
            return null;
        }
        String strName1 = (String)option.get("name_l1");
        String strName2 = (String)option.get("name_l2");
        String strName3 = (String)option.get("name_l3");
        String strName0 = (String)option.get("name_" + this.getLocale().toString());
        if (strName0 == null || strName0.trim().length() == 0) {
            return this.inputName();
        }
        if (this.checkNameDouble(strName0)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"template_name_repeate"));
            return this.inputName();
        }
        return new String[]{strName0, strName1, strName2, strName3};
    }

    private void removeOldReportType() throws Exception {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("parent", null, CompareType.EQUALS));
        filter.setMaskString(" #0 and #1 ");
        ev.setFilter(filter);
        IRptReportType iType = null;
        RptReportTypeInfo typeInfo = null;
        RptReportTypeCollection cols = null;
        iType = RptReportTypeFactory.getRemoteInstance();
        cols = iType.getRptReportTypeCollection(ev);
        if (cols.size() > 0) {
            typeInfo = cols.get(0);
            this.removeNode((RptReportTypeInfo)iType.getRoot(typeInfo));
        }
    }

    private void removeNode(RptReportTypeInfo info) {
        if (info == null) {
            return;
        }
        IRptReportType rptTree = null;
        try {
            rptTree = RptReportTypeFactory.getRemoteInstance();
            if (info.isIsLeaf()) {
                RptMgrTreeUtil.deleteLinkedReport(info);
                if (info.getLevel() == RptUtil.DEFAULTROOTLEVEL) {
                    RptMgrTreeUtil.deleteAccepter(info);
                }
                rptTree.delete((IObjectPK)new ObjectUuidPK(info.getId()));
            } else {
                RptReportTypeInfo tempInfo = null;
                TreeBaseCollection cols = rptTree.getChildren(info);
                int n = cols.size();
                for (int i = 0; i < n; ++i) {
                    tempInfo = (RptReportTypeInfo)cols.get(i);
                    this.removeNode(tempInfo);
                }
                if (info.getLevel() == RptUtil.DEFAULTROOTLEVEL) {
                    RptMgrTreeUtil.deleteAccepter(info);
                }
                rptTree.delete((IObjectPK)new ObjectUuidPK(info.getId()));
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"data_handle_error"));
        }
    }

    private void insertCurrentReportType(String id) throws Exception {
        if (id == null || id.trim().length() <= 0) {
            return;
        }
        this.treeCopy(id);
    }

    protected boolean treeCopy(String treeID) throws BOSException, EASBizException {
        RptReportTemplateInfo rootInfo = this.getParentNodeID(treeID);
        this.copyAllTree(rootInfo, null);
        return true;
    }

    protected void copyAllTree(RptReportTemplateInfo rootInfo, RptReportTypeInfo upInfo) throws BOSException, EASBizException {
        IObjectPK pk = null;
        RptReportTypeInfo temInfo = null;
        IRptReportType iType = null;
        IRptReportTemplate iTem = null;
        iTem = RptReportTemplateFactory.getRemoteInstance();
        iType = RptReportTypeFactory.getRemoteInstance();
        temInfo = new RptReportTypeInfo();
        this.contentCopy(temInfo, rootInfo);
        if (upInfo != null) {
            temInfo.setParent(upInfo);
        }
        pk = iType.addnew((CoreBaseInfo)temInfo);
        RptReportTypeInfo parentInfo = (RptReportTypeInfo)iType.getDataBaseInfo(pk);
        if (!rootInfo.isIsLeaf()) {
            RptReportTemplateInfo templateInfo2 = null;
            TreeBaseCollection childCols = iTem.getChildren(rootInfo);
            for (RptReportTemplateInfo templateInfo2 : childCols) {
                this.copyAllTree(templateInfo2, parentInfo);
            }
        }
    }

    protected RptReportTemplateInfo getParentNodeID(String linkID) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo info = new FilterInfo();
        info.getFilterItems().add(new FilterItemInfo("id", (Object)linkID, CompareType.EQUALS));
        info.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(1), CompareType.EQUALS));
        info.getFilterItems().add(new FilterItemInfo("parent", null, CompareType.EQUALS));
        info.setMaskString(" #0 and #1 and #2 ");
        ev.setFilter(info);
        RptReportTemplateInfo rptInfo = null;
        RptReportTemplateCollection cols = RptReportTemplateFactory.getRemoteInstance().getRptReportTemplateCollection(ev);
        if (cols.size() > 0) {
            rptInfo = cols.get(0);
        }
        return rptInfo;
    }

    protected void contentCopy(RptReportTypeInfo rptInfo, RptReportTemplateInfo temInfo) {
        if (temInfo == null) {
            return;
        }
        if (rptInfo == null) {
            temInfo = null;
        }
        rptInfo.setNumber(temInfo.getNumber());
        rptInfo.setIsLeaf(temInfo.isIsLeaf());
        rptInfo.setIsPortlet(temInfo.isIsPortlet());
        rptInfo.setIsBusiness(false);
        rptInfo.setIsStart(1);
        Locale[] loc = locales;
        Locale l2 = null;
        for (Locale l2 : loc) {
            rptInfo.setName(temInfo.getName(l2), l2);
            rptInfo.setDisplayName(temInfo.getDisplayName(l2), l2);
            rptInfo.setDescription(temInfo.getDescription(l2), l2);
        }
    }

    static {
        Map sortedLangMap = UIConfig.getLanguages();
        int leng = sortedLangMap.size();
        LanguageInfo[] langs = new LanguageInfo[leng];
        Iterator iterator = sortedLangMap.entrySet().iterator();
        int index = 0;
        locales = new Locale[leng];
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            String[] loc = key.split("#");
            RptTemplateManagerUI.locales[index] = new Locale(loc[0]);
            ++index;
        }
    }
}

