/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.ba.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.ba.IRptCustomUser;
import com.kingdee.eas.cp.ba.RptCustomItemInfo;
import com.kingdee.eas.cp.ba.RptCustomUserCollection;
import com.kingdee.eas.cp.ba.RptCustomUserFactory;
import com.kingdee.eas.cp.ba.RptCustomUserInfo;
import com.kingdee.eas.cp.ba.RptMgrMenuInfo;
import com.kingdee.eas.cp.ba.client.AbstractRptUserPorletUI;
import com.kingdee.eas.cp.ba.util.RptUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RptUserPorletUI
extends AbstractRptUserPorletUI {
    private static final Logger logger = CoreUIObject.getLogger(RptUserPorletUI.class);
    private static final int ENABLE_PORLET_INDEX = 2;
    Map mapPorlets = null;
    int choseSize;
    RptCustomUserInfo editdata = null;
    RptMgrMenuInfo mainInfo = null;
    boolean isNew = true;

    public RptUserPorletUI() throws Exception {
        this.tbMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                Boolean value;
                if (e.getColIndex() == 2 && !(value = (Boolean)e.getValue()).booleanValue() && RptUserPorletUI.this.choseSize >= 5) {
                    e.setValue((Object)Boolean.FALSE);
                    MsgBox.showWarning((String)RptUtil.getString("choose_max"));
                    e.setCancel(true);
                }
            }

            public void editStopped(KDTEditEvent e) {
                RptUserPorletUI.this.table_eidted(e);
            }
        });
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSubmit.setTextIconDisStyle((short)2);
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    private void table_eidted(KDTEditEvent e) {
        Object object;
        int colIndex = e.getColIndex();
        if (colIndex == 2 && (object = e.getValue()) instanceof Boolean) {
            boolean flag = (Boolean)object;
            String id = (String)this.tbMain.getRow(e.getRowIndex()).getCell("id").getValue();
            this.setPorletStatus(id, flag);
        }
    }

    private void setPorletStatus(String id, boolean flag) {
        RptCustomItemInfo item = this.getItemByMenuID(id);
        RptMgrMenuInfo menuInfo = (RptMgrMenuInfo)this.mapPorlets.get(id);
        menuInfo.setUserPorlet(flag);
        if (!flag) {
            --this.choseSize;
            if (item != null) {
                this.editdata.getItems().remove(item);
            }
        } else {
            ++this.choseSize;
            if (item == null) {
                item = new RptCustomItemInfo();
                item.setMenuID(id);
                item.setName(menuInfo.getName());
                item.setPath(menuInfo.getUiClassName());
                this.editdata.getItems().add(item);
            }
        }
    }

    private RptCustomItemInfo getItemByMenuID(String id) {
        if (id == null || this.editdata == null || this.editdata.getItems().size() < 1) {
            return null;
        }
        RptCustomItemInfo itemInfo = null;
        for (int i = 0; i < this.editdata.getItems().size(); ++i) {
            itemInfo = this.editdata.getItems().get(i);
            if (!id.equals(itemInfo.getMenuID())) continue;
            return itemInfo;
        }
        return null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tbMain.checkParsed(true);
        List lists = (List)this.getUIContext().get(RptUtil.USER_PORLETS);
        this.mainInfo = (RptMgrMenuInfo)this.getUIContext().get(RptUtil.PORLET_NAME);
        if (this.mainInfo == null) {
            this.actionSubmit.setEnabled(false);
            this.actionSubmit.setVisible(false);
            return;
        }
        IRptCustomUser iCustomUser = RptCustomUserFactory.getRemoteInstance();
        StringBuffer sb = new StringBuffer();
        this.setUITitle(this.getUITitle() + "-" + this.mainInfo.getName());
        String user = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        sb.append("select id,items.id,items.menuID,items.name,items.path where ");
        sb.append("userID='");
        sb.append(user);
        sb.append("' and type='");
        sb.append(this.mainInfo.getId());
        sb.append("'");
        RptCustomUserCollection col = iCustomUser.getRptCustomUserCollection(sb.toString());
        if (col == null || col.size() < 1) {
            this.editdata = new RptCustomUserInfo();
            this.editdata.setType(this.mainInfo.getId());
            this.editdata.setUserID(user);
            this.editdata.setName(this.mainInfo.getName());
        } else {
            this.editdata = col.get(0);
            this.isNew = false;
        }
        this.rebuildList(lists);
        this.initTable(lists);
    }

    private void rebuildList(List list) {
        int i;
        RptCustomItemInfo itemInfo = null;
        RptMgrMenuInfo menuInfo = null;
        String menuID = null;
        ArrayList<String> idList = new ArrayList<String>();
        for (i = 0; i < list.size(); ++i) {
            menuInfo = (RptMgrMenuInfo)list.get(i);
            menuInfo.setUserPorlet(false);
            for (int j = 0; this.editdata != null && j < this.editdata.getItems().size(); ++j) {
                itemInfo = this.editdata.getItems().get(j);
                menuID = itemInfo.getMenuID();
                if (!menuID.equals(menuInfo.getId())) continue;
                menuInfo.setUserPorlet(true);
            }
            idList.add(menuInfo.getId());
        }
        for (i = 0; i < this.editdata.getItems().size(); ++i) {
            itemInfo = this.editdata.getItems().get(i);
            menuID = itemInfo.getMenuID();
            if (idList.contains(menuID)) continue;
            this.editdata.getItems().remove(itemInfo);
        }
    }

    private void initTable(List list) {
        if (list == null) {
            return;
        }
        IRow row = null;
        this.mapPorlets = new HashMap();
        Boolean flag = null;
        String id = null;
        for (int i = 0; i < list.size(); ++i) {
            RptMgrMenuInfo info = (RptMgrMenuInfo)list.get(i);
            row = this.tbMain.addRow();
            id = info.getId();
            row.getCell(0).setValue((Object)id);
            row.getCell(1).setValue((Object)info.getName());
            flag = new Boolean(info.isUserPorlet());
            row.getCell(2).setValue((Object)new Boolean(info.isUserPorlet()));
            this.mapPorlets.put(id, info);
            if (!flag.booleanValue()) continue;
            ++this.choseSize;
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (this.editdata.getItems().size() < 1) {
            MsgBox.showError((String)RptUtil.getString("choose_one"));
            return;
        }
        IRptCustomUser iCustom = RptCustomUserFactory.getRemoteInstance();
        iCustom.submit(this.editdata);
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        this.showMessage();
    }
}

