/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.ba.util;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.common.client.CommonUtil;
import com.kingdee.eas.cp.ba.IRptReportSubscibe;
import com.kingdee.eas.cp.ba.RptAutoReleaseManager;
import com.kingdee.eas.cp.ba.RptReceiverCollection;
import com.kingdee.eas.cp.ba.RptReceiverInfo;
import com.kingdee.eas.cp.ba.RptReleaseException;
import com.kingdee.eas.cp.ba.RptReleaseInfo;
import com.kingdee.eas.cp.ba.RptReportSubscibeCollection;
import com.kingdee.eas.cp.ba.RptReportSubscibeFactory;
import com.kingdee.eas.cp.ba.RptReportSubscibeInfo;
import com.kingdee.eas.cp.ba.RptSubscibeReceiverCollection;
import com.kingdee.eas.cp.ba.RptSubscibeReceiverInfo;
import com.kingdee.eas.cp.ba.RptTypeEnum;
import com.kingdee.eas.cp.ba.SourceTypeEnum;
import java.io.File;
import java.util.Iterator;

public class RptReportReleaseUtil {
    public static int reportRelease_static(File file, String name, String bizType, SourceTypeEnum sourceTypeEnum, RptReleaseInfo relInfo) throws Exception {
        if (relInfo == null) {
            return -1;
        }
        if (file == null && (RptTypeEnum.SNAP_HTML_MODE.equals((Object)relInfo.getReleaseType()) || RptTypeEnum.SNAP_EXCEL_MODE.equals((Object)relInfo.getReleaseType()))) {
            throw new RptReleaseException(RptReleaseException.TEMPFILL_ERROR);
        }
        RptAutoReleaseManager mgr = new RptAutoReleaseManager();
        RptReportReleaseUtil.setStaticReleaseInfo(name, bizType, sourceTypeEnum, relInfo);
        mgr.setFile(file);
        mgr.setReleaseInfo(relInfo);
        mgr.releaseStaticReport();
        return 1;
    }

    public static int reportRelease_linked(String name, String bizType, Object ev, SourceTypeEnum sourceTypeEnum, String uiClassName, RptReleaseInfo relInfo) throws Exception {
        if (relInfo == null) {
            return -1;
        }
        RptAutoReleaseManager mgr = new RptAutoReleaseManager();
        RptReportReleaseUtil.setLinkedReleaseInfo(name, bizType, ev, sourceTypeEnum, uiClassName, relInfo);
        mgr.setReleaseInfo(relInfo);
        mgr.releaseLinkedReport();
        return 1;
    }

    public static RptReleaseInfo createLinkedReleaseInfo(String name, String bizType, Object ev, SourceTypeEnum sourceTypeEnum, String uiClassName, String templetDispenseID) throws Exception {
        if (templetDispenseID == null || "".equals(templetDispenseID)) {
            throw new RptReleaseException(RptReleaseException.BIZ_ID_NULL);
        }
        RptReleaseInfo relInfo = RptReportReleaseUtil.contructRptReleaseInfo(templetDispenseID);
        if (relInfo == null) {
            return null;
        }
        relInfo.setName(name);
        relInfo.setType(bizType);
        relInfo.setParam(CommonUtil.getBytes((Object)ev));
        relInfo.setSourceReportType(sourceTypeEnum);
        relInfo.setUiClassName(uiClassName);
        return relInfo;
    }

    public static RptReleaseInfo createStaticReleaseInfo(String name, String bizType, SourceTypeEnum sourceTypeEnum, String templetDispenseID) throws Exception {
        if (templetDispenseID == null || "".equals(templetDispenseID)) {
            throw new RptReleaseException(RptReleaseException.BIZ_ID_NULL);
        }
        RptReleaseInfo relInfo = RptReportReleaseUtil.contructRptReleaseInfo(templetDispenseID);
        if (relInfo == null) {
            return null;
        }
        relInfo.setName(name);
        relInfo.setType(bizType);
        relInfo.setSourceReportType(sourceTypeEnum);
        return relInfo;
    }

    public static RptReleaseInfo setStaticReleaseInfo(String name, String bizType, SourceTypeEnum sourceTypeEnum, RptReleaseInfo relInfo) throws Exception {
        if (relInfo == null) {
            return null;
        }
        relInfo.setName(name);
        relInfo.setType(bizType);
        relInfo.setSourceReportType(sourceTypeEnum);
        return relInfo;
    }

    public static RptReleaseInfo setLinkedReleaseInfo(String name, String bizType, Object ev, SourceTypeEnum sourceTypeEnum, String uiClassName, RptReleaseInfo relInfo) throws Exception {
        if (relInfo == null) {
            return null;
        }
        relInfo.setName(name);
        relInfo.setType(bizType);
        relInfo.setParam(CommonUtil.getBytes((Object)ev));
        relInfo.setSourceReportType(sourceTypeEnum);
        relInfo.setUiClassName(uiClassName);
        return relInfo;
    }

    public static RptReceiverCollection transSubReaderToReceiver(RptReleaseInfo relInfo, RptReceiverCollection recCols, RptSubscibeReceiverCollection subCols) {
        RptReceiverCollection cols = recCols;
        if (subCols == null) {
            cols = null;
            return cols;
        }
        if (cols == null) {
            cols = new RptReceiverCollection();
        }
        RptSubscibeReceiverInfo subInfo = null;
        RptReceiverInfo tempRelInfo = null;
        Iterator ite = subCols.iterator();
        while (ite.hasNext()) {
            subInfo = (RptSubscibeReceiverInfo)ite.next();
            tempRelInfo = new RptReceiverInfo();
            tempRelInfo.setValue(subInfo.getValue());
            tempRelInfo.setType(subInfo.getType());
            tempRelInfo.setItem(relInfo);
            cols.add(tempRelInfo);
        }
        return cols;
    }

    public static RptReleaseInfo contructRptReleaseInfo(String templetDispenseID) {
        RptReportSubscibeInfo subInfo;
        if (templetDispenseID == null || "".equals(templetDispenseID)) {
            // empty if block
        }
        if ((subInfo = RptReportReleaseUtil.getRptReportSubInfo(templetDispenseID)) == null) {
            return null;
        }
        RptReleaseInfo relInfo = new RptReleaseInfo();
        relInfo.setFromSys(subInfo.getFromSys());
        relInfo.setRptSort(subInfo.getRptType());
        relInfo.setReleaseType(subInfo.getReleaseType());
        RptSubscibeReceiverCollection cols = subInfo.getReader();
        if (cols != null && cols.size() > 0) {
            cols.clear();
        }
        RptReportReleaseUtil.transSubReaderToReceiver(relInfo, relInfo.getReceiver(), subInfo.getReader());
        return relInfo;
    }

    public static RptAutoReleaseManager createRptAutoReleaseMgr(File file, RptReleaseInfo relInfo) {
        return new RptAutoReleaseManager(file, relInfo);
    }

    public static RptReportSubscibeInfo getRptReportSubInfo(String id) {
        if (id == null || "".equals(id)) {
            return null;
        }
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection sic = ev.getSelector();
        sic.add(new SelectorItemInfo("personDec"));
        sic.add(new SelectorItemInfo("releaseType"));
        sic.add(new SelectorItemInfo("fromSys"));
        sic.add(new SelectorItemInfo("rptType.*"));
        sic.add(new SelectorItemInfo("rptType.name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("supplyID", (Object)id));
        filter.setMaskString("#0");
        ev.setFilter(filter);
        RptReportSubscibeCollection cols = null;
        RptReportSubscibeInfo subInfo = new RptReportSubscibeInfo();
        IRptReportSubscibe iSub = null;
        try {
            iSub = RptReportSubscibeFactory.getRemoteInstance();
            cols = iSub.getRptReportSubscibeCollection(ev);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (cols != null && cols.size() > 0) {
            subInfo = cols.get(0);
        }
        return subInfo;
    }
}

