/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.ba.web;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDChart;
import com.kingdee.bos.ctrl.swing.chart.data.CommonChartData;
import com.kingdee.bos.ctrl.swing.chart.data.GanttChartData;
import com.kingdee.bos.ctrl.swing.chart.data.IChartData;
import com.kingdee.bos.ctrl.swing.chart.data.PieChartData;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.cp.ba.IKDChartServerData;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import java.lang.reflect.Constructor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.buffalo.server.BuffaloService;
import org.apache.log4j.Logger;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.servlet.ServletUtilities;

public class RptWebService
extends BuffaloService {
    private static final Logger logger = CoreUIObject.getLogger(RptWebService.class);

    public String getChatPath(String className) {
        String path = "";
        int w = 400;
        int h = 200;
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)((HttpServletRequest)this.getRequest()));
        try {
            PieChartData pieChartData = null;
            CommonChartData commonChartData = null;
            GanttChartData ganttChartData = null;
            Class<?> c = Class.forName(className);
            Constructor<?> con = c.getConstructor(null);
            Object obj = con.newInstance(null);
            IKDChartServerData data = (IKDChartServerData)obj;
            KDChart chart = new KDChart();
            chart.setChartType(data.getChartType());
            if (data.getDataType().equals("PieChartData")) {
                pieChartData = (PieChartData)data.getData(ctx);
                chart.addChartData((IChartData)pieChartData);
            } else if (data.getDataType().equals("GanttChartData")) {
                ganttChartData = (GanttChartData)data.getData(ctx);
                chart.addChartData((IChartData)ganttChartData);
            } else {
                commonChartData = (CommonChartData)data.getData(ctx);
                chart.addChartData((IChartData)commonChartData);
            }
            HttpSession session = null;
            if (this.getRequest() != null && this.getRequest() instanceof HttpServletRequest) {
                session = ((HttpServletRequest)this.getRequest()).getSession();
            }
            path = ServletUtilities.saveChartAsJPEG((JFreeChart)chart.getDelegate(), (int)w, (int)h, session);
            if (data.getDataDesc() != null) {
                path = path + ";" + data.getDataDesc();
            }
        }
        catch (Exception e) {
            logger.info((Object)("get image error:" + e));
        }
        return path;
    }
}

