/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.cache;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.eas.cp.base.cache.F7RowSet;
import com.kingdee.eas.cp.base.cache.F7TipsParam;
import com.kingdee.eas.cp.base.cache.ICacheManager;
import com.kingdee.eas.cp.base.cache.hsqldb.HsqldbCacheManger;
import com.kingdee.eas.cp.base.interceptor.F7Interceptor;
import com.kingdee.eas.cp.base.interceptor.IF7Interceptor;
import com.kingdee.eas.cp.base.util.MetadataUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class CacheManager
implements ICacheManager {
    protected static final Map queryCache = new HashMap();
    protected static final Map tableNameCache = new HashMap();
    protected static final Map queryFields = new HashMap();
    protected static final int CACHE_TYPE = 1;
    private static final String F7_SYS_INTERCEPTORS = "com.kingdee.eas.cp.base.interceptor.SysF7Interceptor";
    private static CacheManager cacheManager = null;
    private static IF7Interceptor sysF7Interceptor = null;

    protected CacheManager() {
    }

    public static synchronized ICacheManager getCacheManager(Context ctx) {
        if (cacheManager != null) {
            return cacheManager;
        }
        sysF7Interceptor = F7Interceptor.newInstance(F7_SYS_INTERCEPTORS);
        cacheManager = HsqldbCacheManger.newInstance();
        return cacheManager;
    }

    protected abstract JSONObject getJsonIncludeHeaders(JSONArray var1, F7TipsParam var2) throws JSONException;

    protected abstract IRowSet getJsonRowSet(Context var1, F7TipsParam var2) throws SQLException, JSONException, BOSException;

    protected abstract JSONArray rowSetToJSONArray(IRowSet var1, F7TipsParam var2) throws SQLException, JSONException;

    protected abstract IRowSet getJsonRowSetFromCache(Context var1, F7TipsParam var2, String var3, String[] var4) throws SQLException, JSONException;

    protected abstract IRowSet getJsonRowSetFromDB(Context var1, F7TipsParam var2, String var3, String[] var4) throws SQLException, JSONException, BOSException;

    protected abstract IRowSet getJsonRowSetFromCacheAfterFillDB(Context var1, IRowSet var2, F7TipsParam var3, String var4, String[] var5) throws SQLException, JSONException, BOSException;

    protected IRowSet getRowSetFromDB(Context ctx, F7TipsParam param, String memTableName, String[] dbFieldNames) throws SQLException, JSONException, BOSException {
        sysF7Interceptor.doBeforeQuery(ctx, param.getEntityView());
        IF7Interceptor interceptor = param.getInterceptor();
        if (interceptor != null) {
            interceptor.doBeforeQuery(ctx, param.getEntityView());
        }
        IRowSet rowSet = this.getJsonRowSetFromDB(ctx, param, memTableName, dbFieldNames);
        String[] fieldNames = MetadataUtil.getQueryFields(param.getQuery(), false);
        rowSet = new F7RowSet(fieldNames, rowSet);
        sysF7Interceptor.doAfterQuery(ctx, rowSet, param);
        if (interceptor != null) {
            interceptor.doAfterQuery(ctx, rowSet, param);
        }
        return this.getJsonRowSetFromCacheAfterFillDB(ctx, rowSet, param, memTableName, dbFieldNames);
    }

    protected final IRowSet getRowSetFromCache(Context ctx, F7TipsParam param, String memTableName, String[] dbFieldNames) throws SQLException, JSONException {
        sysF7Interceptor.doBeforeCacheData(ctx, param.getEntityView());
        IF7Interceptor interceptor = param.getInterceptor();
        if (interceptor != null) {
            interceptor.doBeforeCacheData(ctx, param.getEntityView());
        }
        return this.getJsonRowSetFromCache(ctx, param, memTableName, dbFieldNames);
    }

    protected final JSONArray getF7Json(Context ctx, F7TipsParam param) throws SQLException, JSONException, BOSException {
        IRowSet rowSet = this.getJsonRowSet(ctx, param);
        sysF7Interceptor.doAfterCacheData(ctx, rowSet, param);
        IF7Interceptor interceptor = param.getInterceptor();
        if (interceptor != null) {
            String[] fieldNames = MetadataUtil.getQueryFields(param.getQuery(), false);
            rowSet = interceptor.doAfterCacheData(ctx, new F7RowSet(fieldNames, rowSet), param);
        }
        JSONArray jsonArray = this.rowSetToJSONArray(rowSet, param);
        jsonArray = sysF7Interceptor.doAfterJson(jsonArray, param);
        if (interceptor != null) {
            jsonArray = interceptor.doAfterJson(jsonArray, param);
        }
        return jsonArray;
    }

    @Override
    public final JSONObject getF7Search(Context ctx, F7TipsParam param) throws Exception {
        this.checkFileds(ctx, param.getQuery(), param.getEntityView());
        JSONArray jsonArray = this.getF7Json(ctx, param);
        return this.getJsonIncludeHeaders(jsonArray, param);
    }

    @Override
    public final JSONArray getF7CommonUse(Context ctx, F7TipsParam param) throws Exception {
        this.checkFileds(ctx, param.getQuery(), param.getEntityView());
        return this.getF7Json(ctx, param);
    }

    protected void replaceComumnName(IRowSet rowSet, char oldChar, char newChar) throws SQLException {
        IRowSetMetaData meta = rowSet.getRowSetMetaData();
        int count = meta.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            String columnName = meta.getColumnName(i);
            String newColumnName = columnName.replace(oldChar, newChar);
            meta.setColumnName(i, newColumnName);
            meta.setColumnLabel(i, newColumnName);
        }
    }

    @Override
    public void checkFileds(Context ctx, QueryInfo query, EntityViewInfo entityView) throws Exception {
        String[] fieldNames = MetadataUtil.getQueryFields(query, false);
        Object[] fieldNamesClone = null;
        if (fieldNames == null || fieldNames.length < 3) {
            throw new Exception("\u7ed1\u5b9a\u57fa\u7840\u8d44\u6599\u7c7b\u578bquery\u81f3\u5c11\u5e94\u5305\u542b id,name,number \u4e09\u4e2a\u5b57\u6bb5(query\u540d\uff1a" + query.getFullName() + ")");
        }
        fieldNamesClone = (String[])fieldNames.clone();
        for (int i = 0; i < fieldNamesClone.length; ++i) {
            fieldNamesClone[i] = ((String)fieldNamesClone[i]).toLowerCase();
        }
        Arrays.sort(fieldNamesClone);
        if (Arrays.binarySearch(fieldNamesClone, "id") < 0 || Arrays.binarySearch(fieldNamesClone, "name") < 0 || Arrays.binarySearch(fieldNamesClone, "number") < 0) {
            throw new Exception("\u7ed1\u5b9a\u57fa\u7840\u8d44\u6599\u7c7b\u578bquery\u81f3\u5c11\u5e94\u5305\u542b id,name,number \u4e09\u4e2a\u5b57\u6bb5(query\u540d: " + query.getFullName() + ")");
        }
        if (entityView != null && entityView.getFilter() != null) {
            FilterItemCollection filterColl = entityView.getFilter().getFilterItems();
            for (int i = 0; i < filterColl.size(); ++i) {
                String properyName = filterColl.get(i).getPropertyName();
                if (Arrays.binarySearch(fieldNamesClone, properyName.toLowerCase()) >= 0) continue;
                throw new Exception("\u8fc7\u6ee4\u6761\u4ef6\u4e2d\u7684\u5b57\u6bb5: " + properyName + " \u5fc5\u987b\u5728\u7ed1\u5b9a\u7684\u57fa\u7840\u8d44\u6599\u7c7b\u578bquery\u7684\u67e5\u8be2\u5b57\u6bb5\u5217\u8868\u4e2d\u5305\u542b(query\u540d: " + query.getFullName() + ")");
            }
        }
    }
}

