/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.interceptor;

import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.cp.base.cache.F7RowSet;
import com.kingdee.eas.cp.base.cache.F7TipsParam;
import com.kingdee.eas.cp.base.interceptor.F7Interceptor;
import com.kingdee.eas.cp.base.util.MetadataUtil;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Arrays;

public class SysF7Interceptor
extends F7Interceptor {
    @Override
    public IRowSet afterCacheData(Context ctx, IRowSet rowSet, F7TipsParam param) {
        return super.afterCacheData(ctx, rowSet, param);
    }

    @Override
    public IRowSet afterQuery(Context ctx, IRowSet rowSet, F7TipsParam param) {
        String entityName = MetadataUtil.getEntityByQueryName(ctx, param.getQuery().getFullName()).getFullName();
        if (!"com.kingdee.eas.basedata.person.app.Person".equals(entityName)) {
            return rowSet;
        }
        F7RowSet f7RowSet = (F7RowSet)rowSet;
        try {
            while (f7RowSet.next()) {
                String adminOrgUnitDisplayName = f7RowSet.getValue("AdminOrgUnit.displayName");
                if (StringUtil.isEmpty((String)adminOrgUnitDisplayName)) continue;
                String deptName = this.reserveDeptName(adminOrgUnitDisplayName);
                f7RowSet.setValue("AdminOrgUnit.name", deptName);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return rowSet;
    }

    private String reserveDeptName(String deptName) {
        if (deptName == null) {
            return null;
        }
        String[] names = deptName.split("_");
        StringBuffer sb = new StringBuffer();
        for (int i = names.length - 1; i > -1 && i > names.length - 3; --i) {
            sb.append(names[i]).append("_");
        }
        if (sb.length() > 1) {
            sb.delete(sb.length() - 1, sb.length());
        }
        return sb.toString();
    }

    @Override
    public void beforeCacheData(Context ctx, EntityViewInfo entityView) {
        super.beforeCacheData(ctx, entityView);
    }

    @Override
    public void beforeQuery(Context ctx, EntityViewInfo entityView) {
        super.beforeQuery(ctx, entityView);
    }

    @Override
    public JSONArray afterJson(JSONArray jsonArray, F7TipsParam param) {
        JSONObject json;
        int i;
        Object[] fieldNames = MetadataUtil.getQueryFields(param.getQuery(), false);
        Arrays.sort(fieldNames);
        if (Arrays.binarySearch(fieldNames, "parent.name") > -1) {
            for (i = 0; i < jsonArray.length(); ++i) {
                try {
                    json = jsonArray.getJSONObject(i);
                    json.put("AdminOrgUnit.name", json.get("parent.name"));
                    json.remove("parent.name");
                    continue;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        if (Arrays.binarySearch(fieldNames, "docCate") > -1) {
            for (i = 0; i < jsonArray.length(); ++i) {
                try {
                    json = jsonArray.getJSONObject(i);
                    json.put("nameAttach", (Object)("2".equals((String)json.get("docCate")) ? "\u6536\u6587" : "\u53d1\u6587"));
                    continue;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        return jsonArray;
    }
}

