/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.base.BillPassRecordInfo;
import com.kingdee.eas.hr.perf.app.PfServerUtils;
import com.kingdee.eas.mobile.IMsgFacade;
import com.kingdee.eas.mobile.MsgFacadeFactory;
import com.kingdee.eas.mobile.SendMessageParamInfo;
import com.kingdee.eas.mobile.msg.util.MsgUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class MessageTools {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.base.util.MessageTools");

    public static String getMailPersonStr(Context ctx, Set set) throws BOSException {
        if (set.size() == 0) {
            return "";
        }
        IPerson ip = PersonFactory.getLocalInstance((Context)ctx);
        PersonInfo person = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("email"));
        PersonCollection pc = ip.getPersonCollection(evi);
        StringBuffer sb = new StringBuffer();
        int size = pc.size();
        for (int i = 0; i < size; ++i) {
            person = pc.get(i);
            if (person.getEmail() == null || person.getEmail().trim().length() == 0) continue;
            if (sb.toString().length() > 0) {
                sb.append(",");
            }
            sb.append(pc.get(i).getEmail());
        }
        return sb.toString();
    }

    public static boolean sendMailCpBase(Context ctx, Set set, String mailTitle, String mailBody) {
        boolean sendMailResult = true;
        String to = null;
        try {
            to = MessageTools.getMailPersonStr(ctx, set);
        }
        catch (BOSException e) {
            sendMailResult = false;
            logger.error((Object)("MessageTools:sendMailCpBase()------getMailPersonStr() Has error,The BOSException message = " + e.getMessage()));
        }
        logger.info((Object)("MessageTools:sendMailCpBase()------------mailTitle = " + mailTitle + " mailBody = " + mailBody + " ,to = " + to));
        if (to == null || to.length() == 0) {
            return false;
        }
        try {
            logger.info((Object)"MsgUtil.msgMailDerect()-begin");
            MsgUtil.msgMailDerect((Context)ctx, (String)mailTitle, (String)mailBody, (String)to, null, null, null);
            logger.info((Object)"MsgUtil.msgMailDerect()-end");
        }
        catch (EASBizException e) {
            sendMailResult = false;
            logger.error((Object)("MessageTools:sendMailCpBase()------MsgUtil.msgMailDerect() Has error,The EASBizException message = " + e.getMessage()));
        }
        catch (BOSException e) {
            sendMailResult = false;
            logger.error((Object)("MessageTools:sendMailCpBase()------MsgUtil.msgMailDerect() Has error,The BOSException message = " + e.getMessage()));
        }
        return sendMailResult;
    }

    public static String getCellNumberStr(Context ctx, Set set) throws BOSException {
        if (set.size() == 0) {
            return "";
        }
        IPerson ip = PersonFactory.getLocalInstance((Context)ctx);
        PersonInfo person = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("email"));
        evi.getSelector().add(new SelectorItemInfo("cell"));
        PersonCollection pc = ip.getPersonCollection(evi);
        StringBuffer sb = new StringBuffer();
        HashMap<String, String> map = new HashMap<String, String>();
        int size = pc.size();
        for (int i = 0; i < size; ++i) {
            person = pc.get(i);
            if (person.getCell() == null || person.getCell().trim().length() == 0) continue;
            map.put(person.getCell(), person.getCell());
        }
        Iterator iter = map.values().iterator();
        while (iter.hasNext()) {
            if (sb.toString().length() > 0) {
                sb.append(",");
            }
            sb.append(iter.next().toString());
        }
        return sb.toString();
    }

    public static boolean sendSMSCpBase(Context ctx, Set set, String content) {
        boolean ssendSMSResult = true;
        String receiver = null;
        try {
            receiver = MessageTools.getCellNumberStr(ctx, set);
        }
        catch (BOSException e) {
            ssendSMSResult = false;
            logger.error((Object)("MessageTools:sendSMSCpBase()------getCellNumberStr() Has error,The BOSException message = " + e.getMessage()));
        }
        logger.info((Object)("MessageTools:sendSMS()------------content = " + content + " ,receiver = " + receiver));
        if (receiver == null || "".equals(receiver)) {
            return false;
        }
        SendMessageParamInfo paramInfo = new SendMessageParamInfo();
        paramInfo.setAppendCompanyName(false);
        paramInfo.setAppendNumber(false);
        paramInfo.setAppendPersonName(false);
        paramInfo.setAppendRevert(false);
        paramInfo.setAppendUserName(false);
        paramInfo.setContent(content);
        paramInfo.setReceiver(receiver);
        paramInfo.setCanback(false);
        logger.info((Object)"Get IMsgFacade-begin");
        try {
            IMsgFacade iMsgFacade = MsgFacadeFactory.getLocalInstance((Context)ctx);
            logger.info((Object)"Get IMsgFacade-end");
            logger.info((Object)"iMsgFacade.sendMsg()-begin");
            iMsgFacade.sendMsg(paramInfo);
            logger.info((Object)"iMsgFacade.sendMsg()-end");
        }
        catch (BOSException e) {
            ssendSMSResult = false;
            logger.error((Object)("MessageTools:sendSMSCpBase()------MsgFacadeFactory.getLocalInstance(ctx) Has error,The BOSException message = " + e.getMessage()));
        }
        catch (EASBizException e) {
            ssendSMSResult = false;
            logger.error((Object)("MessageTools:sendSMSCpBase()------iMsgFacade.sendMsg(paramInfo) Has error,The EASBizException message = " + e.getMessage()));
        }
        return ssendSMSResult;
    }

    public static Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }

    public static void sendMessage(Context ctx, String[] ids, String messageStr, String senderStr, String bodyStr, BillPassRecordInfo billPassRecordInfo, String showReply) throws BOSException, EASBizException {
        if (null == billPassRecordInfo) {
            return;
        }
        if (ids == null || ids.length == 0) {
            return;
        }
        String billID = billPassRecordInfo.getBillID();
        String billPassRecordId = billPassRecordInfo.getId().toString();
        String formId = billPassRecordInfo.getFormID();
        String billURL = billPassRecordInfo.getEditUrl();
        String modulePackge = billPassRecordInfo.getModulePackge();
        if (null == modulePackge || "".equals(modulePackge) || "null".equalsIgnoreCase(modulePackge)) {
            modulePackge = "com.kingdee.eas.cp.base.app";
        }
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Locale[] lcla = MessageTools.getContextLocales(ctx);
        Locale locale2 = null;
        StringBuffer sourceIdsSB = new StringBuffer("CPMSG::billPassURL:replyBillpassRecord.jsf;billURL:").append(billURL).append(";billID:");
        sourceIdsSB.append(billID);
        sourceIdsSB.append(";formID:");
        sourceIdsSB.append(formId);
        sourceIdsSB.append(";billPassRecordID:");
        sourceIdsSB.append(billPassRecordId);
        sourceIdsSB.append(";fromMesgOrCpBase:CpBase;showReply:").append(showReply);
        Message message = MessageFactory.newMessage((String)"kingdee.workflow");
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 60);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        message.setStringHeader("bizPackage", modulePackge);
        message.setStringHeader("realBizPackage", modulePackge);
        message.setStringHeader("sourceID", "");
        message.setStringHeader("sourceIDs", sourceIdsSB.toString());
        for (Locale locale2 : lcla) {
            message.setLocaleStringHeader("title", messageStr, locale2);
            message.setLocaleStringHeader("sender", senderStr, locale2);
            if (bodyStr == null) {
                message.setLocaleStringHeader("body", messageStr, locale2);
                continue;
            }
            message.setLocaleStringHeader("body", bodyStr, locale2);
        }
        int n = ids.length;
        for (int i = 0; i < n; ++i) {
            if (PfServerUtils.objectIsNull((Object)ids[i])) continue;
            message.setStringHeader("receiver", ids[i]);
            senderAgent.sendMessage(message);
        }
    }
}

