/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;

public class OrgUtil {
    public static PositionMemberCollection getAllPositionByPersonID(Context ctx, String personid) {
        StringBuffer sb = new StringBuffer();
        sb.append("select isPrimary,position.id,position.name,position.number,position.adminOrgUnit.longnumber,position.adminOrgUnit.parent.id,position.adminOrgUnit.unitLayerType.id,position.CU.id");
        sb.append(" where person.id = '");
        sb.append(personid);
        sb.append("' order by isPrimary desc,position.number asc");
        PositionMemberCollection pmColl = null;
        try {
            IPositionMember ipm = PositionMemberFactory.getLocalInstance((Context)ctx);
            pmColl = ipm.getPositionMemberCollection(sb.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return pmColl;
    }

    public static AdminOrgUnitInfo getCompany(Context ctx, AdminOrgUnitInfo adminOrgUnitInfo) {
        AdminOrgUnitInfo adminInfo = null;
        try {
            if (OrgUtil.isCompanyOrUnit(adminOrgUnitInfo)) {
                return adminOrgUnitInfo;
            }
            IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
            adminInfo = iAdmin.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgUnitInfo.getParent().getId().toString()));
            return OrgUtil.getCompany(ctx, adminInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return adminInfo;
        }
    }

    private static boolean isCompanyOrUnit(AdminOrgUnitInfo orgUnit) {
        String UNIT = "00000000-0000-0000-0000-00000000000162824988";
        String COMPANY = "00000000-0000-0000-0000-00000000000262824988";
        if (null != orgUnit && null != orgUnit.getUnitLayerType()) {
            return "00000000-0000-0000-0000-00000000000162824988".equals(orgUnit.getUnitLayerType().getId().toString()) || "00000000-0000-0000-0000-00000000000262824988".equals(orgUnit.getUnitLayerType().getId().toString());
        }
        return true;
    }

    public static AdminOrgUnitInfo getAdminOrgUnitByPositionID(Context ctx, String positionId) {
        AdminOrgUnitInfo info = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("select adminOrgUnit.id,adminOrgUnit.name,adminOrgUnit.unitLayerType.id,adminOrgUnit.parent.id,id,number,name");
            sb.append(" where id = '");
            sb.append(positionId);
            sb.append("'");
            IPosition ipm = PositionFactory.getLocalInstance((Context)ctx);
            PositionCollection pmColl = ipm.getPositionCollection(sb.toString());
            if (pmColl.size() > 0) {
                info = pmColl.get(0).getAdminOrgUnit();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return info;
    }

    public static AdminOrgUnitInfo getHeightOrgByPersonID(Context ctx, String personId) {
        AdminOrgUnitInfo info = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("select position.* ,position.adminOrgUnit.*,isPrimary,id,number,name,parent");
            sb.append(" where person.id = '");
            sb.append(personId);
            sb.append("'");
            IPositionMember ipm = PositionMemberFactory.getLocalInstance((Context)ctx);
            PositionMemberCollection pmColl = ipm.getPositionMemberCollection(sb.toString());
            int size = pmColl.size();
            for (int i = 0; i < size; ++i) {
                if (pmColl.get(i).getPosition() == null || !pmColl.get(i).isIsPrimary()) continue;
                info = pmColl.get(i).getPosition().getAdminOrgUnit();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return info;
    }
}

