/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.person.IPersonFacade;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFacadeFactory;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.base.web.MD5;
import com.kingdee.eas.cp.base.web.PersonBirthInfo;
import com.kingdee.eas.cp.common.json.org.JSONArray;
import com.kingdee.eas.cp.common.json.org.JSONObject;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.SerialBlob;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class PersonBirthAction
extends DispatchAction {
    protected Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.base.web.PersonBirthAction");

    public ActionForward loadPortletContent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String queryDateStr = request.getParameter("queryDate");
        try {
            Date queryDate = new Date();
            if (!StringUtils.isEmpty((String)queryDateStr)) {
                queryDate = DateTimeUtils.parseDate((String)queryDateStr);
            }
            StringBuffer prefixUrl = new StringBuffer();
            prefixUrl.append(request.getScheme());
            prefixUrl.append("://");
            prefixUrl.append(request.getServerName());
            prefixUrl.append(":");
            prefixUrl.append(request.getServerPort());
            prefixUrl.append(request.getContextPath());
            prefixUrl.append("/");
            String realPath = request.getRealPath("/");
            JSONArray data = this.getPersonInfo(queryDate, ctx, prefixUrl.toString(), realPath);
            if (data == null) {
                JSONObject object = new JSONObject();
                object.put("isNoPerson", (Object)"true");
                this.handleResult(response, object.toString());
            } else {
                String resultMsg = data.toString();
                this.handleResult(response, resultMsg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private JSONArray getPersonInfo(Date date, Context ctx, String photoUrlPrefix, String realPath) {
        ArrayList<PersonBirthInfo> infos = new ArrayList<PersonBirthInfo>();
        PersonCollection relatedPerson = new PersonCollection();
        try {
            PersonInfo curPerson = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            if (curPerson != null) {
                try {
                    IPersonFacade facade = PersonFacadeFactory.getRemoteInstance();
                    PersonCollection supervisor = facade.getSupervisor(curPerson.getId());
                    PersonCollection colleagu = facade.getColleague(curPerson.getId());
                    PersonCollection subordinate = facade.getSubordinate(curPerson.getId());
                    relatedPerson.addCollection(supervisor);
                    relatedPerson.addCollection(colleagu);
                    relatedPerson.addCollection(subordinate);
                }
                catch (EASBizException e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (BOSException e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (UuidException e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            MetaDataPK pk = new MetaDataPK("com.kingdee.eas.cp.base.app.PersonBirthdayListQuery");
            IQueryExecutor queryExecutor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
            queryExecutor.setObjectView(this.getEntityViewInfo(date));
            IRowSet set = queryExecutor.executeQuery();
            set.beforeFirst();
            while (set.next()) {
                SerialBlob photoBlob = (SerialBlob)set.getObject("personPhoto");
                String url = this.getUrl(photoBlob, photoUrlPrefix, realPath);
                String personId = set.getString("id");
                boolean isRelated = this.isRelated(personId, relatedPerson);
                PersonBirthInfo info = new PersonBirthInfo(personId, isRelated, set.getString("personName"), set.getString("adminOrgName"), url, set.getString("adminOrgUnit.displayName"));
                infos.add(info);
            }
            if (infos.size() > 0) {
                JSONArray array = new JSONArray();
                int size = infos.size();
                for (int i = 0; i < size; ++i) {
                    PersonBirthInfo info = (PersonBirthInfo)infos.get(i);
                    JSONObject object = new JSONObject();
                    object.put("personId", (Object)info.getPersonId());
                    object.put("url", (Object)info.getUrl());
                    object.put("name", (Object)info.getName());
                    object.put("dep", (Object)info.getDep());
                    object.put("isRelated", info.isRelated());
                    object.put("orgName", (Object)(null != info.getOrgName() ? info.getOrgName().replaceAll("_", "/") : info.getOrgName()));
                    array.put((Object)object);
                }
                return array;
            }
        }
        catch (Throwable e) {
            this.logger.error((Object)e.getMessage(), e);
        }
        return null;
    }

    private boolean isRelated(String personId, PersonCollection relatedPerson) {
        if (!StringUtil.isEmptyString((String)personId)) {
            try {
                PersonInfo personInfo = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
                if (relatedPerson.contains(personInfo)) {
                    return true;
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private EntityViewInfo getEntityViewInfo(Date date) {
        String month = new SimpleDateFormat("MM").format(date);
        String day = new SimpleDateFormat("dd").format(date);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("birthMonth", (Object)month));
        filter.getFilterItems().add(new FilterItemInfo("birthDay", (Object)day));
        evi.setFilter(filter);
        return evi;
    }

    private void handleResult(HttpServletResponse response, String resultMsg) {
        try {
            response.setContentType("text/json;charset=utf-8");
            response.getWriter().write(resultMsg);
            response.getWriter().flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getUrl(SerialBlob photo, String prefixUrl, String realPath) {
        String fileName = "personPhoto";
        if (photo == null) {
            return "/easportal/html/portlet/cp/birthday/images/zhaopian.gif";
        }
        String url = "";
        File file = new File(realPath + fileName);
        if (!file.exists() || file.isFile()) {
            file.mkdir();
        }
        try {
            byte[] bytes = photo.getBytes(1L, (int)photo.length());
            String photoName = MD5.MD5_32(new String(bytes));
            url = "/easportal/" + fileName + "/" + photoName + ".gif";
            File photoFile = new File(realPath + fileName + "/" + photoName + ".gif");
            if (!photoFile.exists()) {
                photoFile.createNewFile();
                FileOutputStream outputStream = new FileOutputStream(photoFile);
                outputStream.write(bytes);
                outputStream.flush();
                outputStream.close();
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return url;
    }
}

