/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.cp.base.IShortcutDef;
import com.kingdee.eas.cp.base.IShortcutMenu;
import com.kingdee.eas.cp.base.ShortcutDefFactory;
import com.kingdee.eas.cp.base.ShortcutMenuCollection;
import com.kingdee.eas.cp.base.ShortcutMenuFactory;
import com.kingdee.eas.cp.base.ShortcutMenuInfo;
import com.kingdee.eas.cp.base.SourceFromEnum;
import com.kingdee.eas.cp.base.web.JsonObjectUtil;
import com.kingdee.eas.cp.base.web.MenuBaseAction;
import com.kingdee.eas.cp.base.web.MenuCommonHandle;
import com.kingdee.eas.cp.base.web.MenuParamInfo;
import com.kingdee.eas.cp.base.web.WebMenuUtil;
import com.kingdee.eas.cp.common.json.org.JSONArray;
import com.kingdee.eas.cp.common.json.org.JSONObject;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ShortcutMenuAction
extends MenuBaseAction {
    @Override
    protected ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if (METHOD_NAME.equals("loadShortcutMenuPortlet")) {
            this.loadShortcutMenuPortlet(mapping, form, request, response);
        } else if (METHOD_NAME.equals("delShortcutMenu")) {
            this.delShortcutMenu(mapping, form, request, response);
        } else if (METHOD_NAME.equals("ddShortcutMenu")) {
            this.ddShortcutMenu(mapping, form, request, response);
        }
        if (METHOD_NAME.equals("loadLeftTree")) {
            this.initLeftTree(mapping, form, request, response);
        } else if (METHOD_NAME.equals("loadTreeNodeInfo")) {
            this.loadTreeNodeInfo(mapping, form, request, response);
        } else if (METHOD_NAME.equals("saveTreeNodeInfo")) {
            this.saveTreeNodeInfo(mapping, form, request, response);
        }
        try {
            response.setContentType("text/json;charset=utf-8");
            response.getWriter().write(this.resultMsg);
            response.getWriter().flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected ActionForward saveTreeNodeInfo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        MenuParamInfo paramInfo = this.initParamInfo(request);
        try {
            this.resultMsg = ShortcutDefFactory.getLocalInstance(CTX).saveShtMenuDef(paramInfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private MenuParamInfo initParamInfo(HttpServletRequest request) {
        String menuName = request.getParameter("menuName");
        String menuType = request.getParameter("menuType");
        String menuUrlValue = request.getParameter("menuUrl_value");
        String menuIcon = request.getParameter("menuIcon");
        String id = null;
        if (!(null == request.getParameter("id") || "".equals(request.getParameter("id")) || "root".equals(request.getParameter("id")) || "undefined".equals(request.getParameter("id")))) {
            id = WebMenuUtil.getShtNodeID(request.getParameter("id"));
        }
        String menuUrl = null;
        String businessType = null;
        if (StringUtils.isNotBlank((String)menuUrlValue) && menuUrlValue.indexOf("*") != -1) {
            menuUrl = menuUrlValue.split("\\*")[0];
            businessType = menuUrlValue.split("\\*")[1];
        } else {
            menuUrl = menuUrlValue;
        }
        MenuParamInfo paramInfo = new MenuParamInfo();
        paramInfo.setId(id);
        paramInfo.setMenuName(menuName);
        paramInfo.setMenuUrl(menuUrl);
        paramInfo.setMenuIcon(menuIcon);
        paramInfo.setAdmin(IS_ADMIN);
        paramInfo.setBusinessType(businessType);
        if (null == menuType) {
            paramInfo.setMenuType("0");
        } else {
            paramInfo.setMenuType(menuType);
        }
        return paramInfo;
    }

    public ActionForward initLeftTree(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            this.resultMsg = this.getLeftTreeJSONArray(CTX, WebMenuUtil.getShtMap()).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private JSONArray getLeftTreeJSONArray(Context ctx, Map idMap) throws Exception {
        IShortcutMenu shortcutMenu = ShortcutMenuFactory.getLocalInstance(CTX);
        JSONArray tree = new JSONArray();
        try {
            ShortcutMenuCollection menuCols = shortcutMenu.getShortcutMenuCollection(this.buildLeftTreeEntityView());
            if (null != menuCols && menuCols.size() > 0) {
                this.putObject2Json(menuCols, tree, idMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tree;
    }

    private void putObject2Json(ShortcutMenuCollection menuCols, JSONArray tree, Map idMap) {
        JSONObject treeChild = null;
        ShortcutMenuInfo shtMenuInfo = null;
        for (int i = 0; i < menuCols.size(); ++i) {
            shtMenuInfo = menuCols.get(i);
            if (null == shtMenuInfo.getNumber()) {
                idMap.put(String.valueOf(System.currentTimeMillis()), shtMenuInfo.getId().toString());
            } else {
                idMap.put(shtMenuInfo.getNumber(), shtMenuInfo.getId().toString());
            }
            treeChild = JsonObjectUtil.convertShtLeftTree(shtMenuInfo);
            tree.put((Object)treeChild);
        }
    }

    private EntityViewInfo buildLeftTreeEntityView() {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        SorterItemInfo orderSortInfo = new SorterItemInfo("displayOrder");
        orderSortInfo.setSortType(SortType.ASCEND);
        view.getSorter().add(orderSortInfo);
        view.setFilter(this.buildLeftTreeFilterInfo());
        return view;
    }

    protected FilterInfo buildLeftTreeFilterInfo() {
        FilterInfo filter = new FilterInfo();
        boolean flag = false;
        try {
            if (IS_ADMIN) {
                filter.getFilterItems().add(new FilterItemInfo("ownerType", (Object)new Integer(0)));
            } else if (!IS_ADMIN && !MenuCommonHandle.existCustomMenu(ShortcutMenuFactory.getLocalInstance(CTX), personInfo)) {
                filter.getFilterItems().add(new FilterItemInfo("ownerType", (Object)new Integer(0)));
                filter.getFilterItems().add(new FilterItemInfo("allWorkFlow", (Object)new Boolean(false)));
                filter.getFilterItems().add(new FilterItemInfo("businessType", null, CompareType.EQUALS));
                flag = true;
            } else {
                filter.getFilterItems().add(new FilterItemInfo("person", (Object)personInfo.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("ownerType", (Object)new Integer(1)));
            }
        }
        catch (Exception e) {
            filter.getFilterItems().add(new FilterItemInfo("ownerType", (Object)new Integer(0)));
        }
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(0)));
        if (flag) {
            FilterInfo filter2 = new FilterInfo();
            filter2.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(0)));
            filter2.getFilterItems().add(new FilterItemInfo("businessType", (Object)"myworkflow_list"));
            filter2.getFilterItems().add(new FilterItemInfo("effectScope", (Object)Boolean.TRUE));
            try {
                filter.mergeFilter(filter2, "or");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return filter;
    }

    protected ActionForward loadTreeNodeInfo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        System.out.println(request.getParameter("id"));
        if (null == request.getParameter("id")) {
            return null;
        }
        String nodeID = WebMenuUtil.getShtNodeID(request.getParameter("id"));
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        JSONObject reply = new JSONObject();
        JSONArray records = new JSONArray();
        try {
            IShortcutMenu iShortcutMenu = ShortcutMenuFactory.getLocalInstance(ctx);
            ShortcutMenuInfo shortcutMenuInfo = (ShortcutMenuInfo)iShortcutMenu.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)nodeID)));
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("number"));
            if (shortcutMenuInfo.getSourceFrom().equals((Object)SourceFromEnum.FROM_MENUDEF)) {
                view.getSelector().add(new SelectorItemInfo("menu.webUrl"));
                view.getSelector().add(new SelectorItemInfo("menu.name"));
                view.getSelector().add(new SelectorItemInfo("menu.menuType"));
                view.getSelector().add(new SelectorItemInfo("menu.webMenu.id"));
                view.getSelector().add(new SelectorItemInfo("menu.webMenu.name"));
                view.getSelector().add(new SelectorItemInfo("menu.webMenu.number"));
                view.getSelector().add(new SelectorItemInfo("menu.guiMenu.id"));
                view.getSelector().add(new SelectorItemInfo("menu.guiMenu.name"));
                view.getSelector().add(new SelectorItemInfo("menu.guiMenu.number"));
                view.getSelector().add(new SelectorItemInfo("menu.icon.id"));
            } else {
                view.getSelector().add(new SelectorItemInfo("shortcutDef.webUrl"));
                view.getSelector().add(new SelectorItemInfo("shortcutDef.localAppPath"));
                view.getSelector().add(new SelectorItemInfo("shortcutDef.name"));
                view.getSelector().add(new SelectorItemInfo("shortcutDef.menuType"));
                view.getSelector().add(new SelectorItemInfo("shortcutDef.guiMenu.id"));
                view.getSelector().add(new SelectorItemInfo("shortcutDef.guiMenu.name"));
                view.getSelector().add(new SelectorItemInfo("shortcutDef.guiMenu.number"));
                view.getSelector().add(new SelectorItemInfo("shortcutDef.webMenu.id"));
                view.getSelector().add(new SelectorItemInfo("shortcutDef.webMenu.name"));
                view.getSelector().add(new SelectorItemInfo("shortcutDef.webMenu.number"));
                view.getSelector().add(new SelectorItemInfo("shortcutDef.icon.id"));
            }
            view.getSelector().add(new SelectorItemInfo("sourceFrom"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)nodeID));
            view.setFilter(filter);
            ShortcutMenuCollection menuCols = iShortcutMenu.getShortcutMenuCollection(view);
            if (null != menuCols.get(0)) {
                records.put((Object)JsonObjectUtil.convertShtTreeNodeInfo(menuCols.get(0)));
            }
            reply.put("records", (Object)records);
            reply.put("results", (Object)new Integer(1));
            this.resultMsg = reply.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected ActionForward loadShortcutMenuPortlet(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        EntityViewInfo viewInfo = this.bulidShortcutViewInfo();
        EntityViewInfo defviewInfo = this.bulidShortcutDefInfo();
        JSONObject reply = new JSONObject();
        JSONArray records = new JSONArray();
        ShortcutMenuCollection menuCols = null;
        ShortcutMenuInfo menuInfo = null;
        try {
            IShortcutDef shortcutDef = ShortcutDefFactory.getLocalInstance(CTX);
            menuCols = ShortcutMenuFactory.getLocalInstance(CTX).getShortcutMenuCollection(viewInfo);
            if (null != menuCols && menuCols.size() > 0) {
                for (int i = 0; i < menuCols.size(); ++i) {
                    menuInfo = menuCols.get(i);
                    if (menuInfo.getSourceFrom().equals((Object)SourceFromEnum.FROM_SHORTCUTDEF)) {
                        defviewInfo.getFilter().getFilterItems().clear();
                        defviewInfo.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)menuInfo.getShortcutDef().getId().toString()));
                        shortcutDef.getShortcutDefCollection(defviewInfo);
                        menuInfo.setShortcutDef(shortcutDef.getShortcutDefCollection(defviewInfo).get(0));
                    }
                    records.put((Object)JsonObjectUtil.convertShortcutMenu2Json(menuInfo));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        reply.put("records", (Object)records);
        reply.put("count", (Object)new Integer(null == menuCols ? 0 : menuCols.size()));
        this.resultMsg = reply.toString();
        return null;
    }

    protected ActionForward delShortcutMenu(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String recordId = WebMenuUtil.getShtNodeID(request.getParameter("id"));
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("recordId", recordId);
            ShortcutMenuFactory.getLocalInstance(CTX).delShortcutMenu(paramMap);
            this.resultMsg = "{ success: true}";
        }
        catch (Exception e) {
            e.printStackTrace();
            this.resultMsg = "{ failure: true, infos:{info:'\u64cd\u4f5c\u5931\u8d25'}}";
        }
        return null;
    }

    protected ActionForward ddShortcutMenu(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String type = request.getParameter("type");
        if (null == request.getParameter("currentRootId") || null == request.getParameter("parentRootId")) {
            System.out.println("@@@" + request.getParameter("currentRootId"));
            System.out.println("@@@" + request.getParameter("parentRootId"));
            return null;
        }
        String currentNodeId = WebMenuUtil.getShtNodeID(request.getParameter("currentRootId"));
        String parentNodeId = WebMenuUtil.getShtNodeID(request.getParameter("parentRootId"));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("currentNode", currentNodeId);
        paramMap.put("parentNode", parentNodeId);
        paramMap.put("type", type);
        try {
            this.resultMsg = ShortcutMenuFactory.getLocalInstance(CTX).ddShortcutMenu(paramMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.resultMsg = "{ failure: true, infos:{info:'\u64cd\u4f5c\u5931\u8d25'}}";
        }
        return null;
    }

    private EntityViewInfo bulidShortcutViewInfo() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("menu.id"));
        selector.add(new SelectorItemInfo("menu.name"));
        selector.add(new SelectorItemInfo("menu.number"));
        selector.add(new SelectorItemInfo("menu.webUrl"));
        selector.add(new SelectorItemInfo("menu.webMenu.id"));
        selector.add(new SelectorItemInfo("menu.webMenu.ui"));
        selector.add(new SelectorItemInfo("menu.guiMenu.id"));
        selector.add(new SelectorItemInfo("menu.guiMenu.uiClassName"));
        selector.add(new SelectorItemInfo("menu.guiMenu.uiClassParam"));
        selector.add(new SelectorItemInfo("menu.guiMenu.uiOprt"));
        selector.add(new SelectorItemInfo("menu.guiMenu.openMethod"));
        selector.add(new SelectorItemInfo("menu.menuType"));
        selector.add(new SelectorItemInfo("menu.icon.id"));
        FilterInfo filter = this.buildLeftTreeFilterInfo();
        SorterItemInfo sort = new SorterItemInfo("displayOrder");
        sort.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sort);
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private EntityViewInfo bulidShortcutDefInfo() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("menuType"));
        selector.add(new SelectorItemInfo("icon"));
        selector.add(new SelectorItemInfo("webUrl"));
        selector.add(new SelectorItemInfo("localAppPath"));
        selector.add(new SelectorItemInfo("webMenu.id"));
        selector.add(new SelectorItemInfo("webMenu.ui"));
        selector.add(new SelectorItemInfo("guiMenu.id"));
        selector.add(new SelectorItemInfo("guiMenu.uiClassName"));
        selector.add(new SelectorItemInfo("guiMenu.uiClassParam"));
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        return viewInfo;
    }
}

