/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.base.wfutil;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.message.IMessageCenter;
import com.kingdee.eas.base.message.IMessageClassManageFacade;
import com.kingdee.eas.base.message.MessageCenterFactory;
import com.kingdee.eas.base.message.MessageClassManageFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.base.wfutil.MsgTypeExt;
import com.kingdee.eas.cp.base.wfutil.MsgTypePro;
import com.kingdee.eas.cp.base.wfutil.WFListService;
import com.kingdee.eas.cp.base.wfutil.dao.CPCustomNodeMessageDaoImpl;
import com.kingdee.eas.cp.eip.mc.web.MessageHander;
import com.kingdee.eas.cp.eip.mc.web.MsgType;
import com.kingdee.eas.cp.eip.mc.web.service.MsgSendRecordService;
import com.kingdee.eas.cp.eip.pc.IProcCatalogFacade;
import com.kingdee.eas.cp.eip.pc.ProcCatalogFacadeFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class WFListUtils {
    Logger logger = Logger.getLogger((String)WFListUtils.class.getName());
    private static final String UNDISPOSSQL = "SELECT COUNT(*) AS COUNT from T_WFR_Assign a with(ReadPast) ,T_BAS_AssignRead b where a.FASSIGNID = b.FASSIGNID and a.FSTATE in(1,2) and a.FIsSendMsg=1 and a.FPERSONUSERID = ?  AND FStatus = ? ";
    private static final String UNREADNOTICESQL = "SELECT COUNT(FID) AS COUNT FROM T_BAS_Message WITH(READPAST) WHERE FReceiver = ? AND FType = ? AND FBizType = ? AND FStatus = ? ";
    private static final String UNREADWORKFLOWSQL = "SELECT COUNT(FID) AS COUNT FROM T_BAS_Message WITH(READPAST) WHERE FReceiver = ? AND FType = ? AND FBizType = ? AND FStatus = ? AND ((FSourceIDs not like '%PASS%') or (FSourceIDs is null))";
    private static final String UNREAD_CP_WF_SQL = "SELECT COUNT(FID) AS COUNT FROM T_BAS_Message WITH(READPAST)  where FReceiver = ? and FType = ? AND FStatus = ? and FBizType != 10";
    private static final String UNREADPASSAROUNDSQL = "SELECT COUNT(FID) AS COUNT FROM T_BAS_Message WITH(READPAST) WHERE FReceiver = ? AND FType = ? AND FBizType = ? AND FStatus = ? AND FSourceIDs like '%PASS%' ";
    private static final String MYTRANSCTIONSQL = "select count(*) AS COUNT from T_WFR_ASSIGN a,T_WFR_PROCINST b where (b.FSTATE != 'closed.completed' and b.FSTATE != 'closed.terminated' and b.FSTATE != 'closed.aborted') and a.FPROCINSTID = b.FPROCINSTID and b.FINITIATORID=? and (a.FSTATE=2 or a.FSTATE=1)  and a.FISSENDMSG = 1";
    private static final String UNREADOthersNOTICESQL = "SELECT COUNT(FID) AS COUNT FROM T_BAS_Message WITH(READPAST) WHERE FReceiver = ? AND FType = ? AND FBizType not in (0,10,40) AND FStatus = ? ";

    public static List getMessageListByClass(Context ctx, MsgType msg, int pageNo, int pageSize, String orderByField, String orderType) {
        MsgType msgType = new MsgType();
        msgType.setBizType(-1);
        msgType.setType(10);
        msgType.setSourceStatus(-1);
        msgType.setNodeType(1);
        msgType.setMsgDate("");
        msgType.setCustomNodeID(msg.getCustomNodeID());
        msgType.setQuickSearch(msg.getQuickSearch());
        msgType.setQuickSearchSubject(msg.getQuickSearchSubject());
        msgType.setStatus(-1);
        msgType.setIfCurrentOrg("false");
        msgType.setIfHistory("false");
        msgType.setIfCombine("false");
        msgType.setPureWeb(Boolean.valueOf("false").booleanValue());
        return WFListUtils.getMessageList(ctx, msgType, pageNo, pageSize, orderByField, orderType);
    }

    public static List getMessageListByClassCp(Context ctx, MsgType msg, int pageNo, int pageSize, String orderByField, String orderType) {
        return WFListUtils.getMessageListByClassByClassType(ctx, msg, pageNo, pageSize, orderByField, orderType, "com.kingdee.eas.cp.");
    }

    public static List getMessageListByClassByClassType(Context ctx, MsgType msg, int pageNo, int pageSize, String orderByField, String orderType, String classType) {
        MsgTypePro msgType = new MsgTypePro();
        msgType.setBizType(-1);
        msgType.setType(10);
        msgType.setSourceStatus(-1);
        msgType.setNodeType(1);
        msgType.setMsgDate("");
        msgType.setCustomNodeID(msg.getCustomNodeID());
        msgType.setQuickSearch(msg.getQuickSearch());
        msgType.setQuickSearchSubject(msg.getQuickSearchSubject());
        msgType.setStatus(-1);
        msgType.setIfCurrentOrg("false");
        msgType.setIfHistory("false");
        msgType.setIfCombine("false");
        msgType.setPureWeb(Boolean.valueOf("false"));
        if (!StringUtils.isEmpty((String)classType)) {
            msgType.setModuleType(classType);
        }
        return WFListUtils.getMessageListCp(ctx, msgType, pageNo, pageSize, orderByField, orderType);
    }

    public static List getMessageClassList(Context ctx, String type) {
        List list = null;
        try {
            IMessageClassManageFacade messageClassFacade = MessageClassManageFacadeFactory.getLocalInstance((Context)ctx);
            list = messageClassFacade.getMyMessageClassList(type, false);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static int getMessageCountByClass(Context ctx, MsgType msg) {
        int count = 0;
        MsgType msgType = new MsgType();
        msgType.setBizType(-1);
        msgType.setType(10);
        msgType.setSourceStatus(-1);
        msgType.setNodeType(1);
        msgType.setMsgDate("");
        if (msg != null) {
            msgType.setCustomNodeID(msg.getCustomNodeID());
            msgType.setQuickSearch(msg.getQuickSearch());
            msgType.setQuickSearchSubject(msg.getQuickSearchSubject());
        } else {
            msgType.setCustomNodeID(null);
        }
        msgType.setStatus(-1);
        msgType.setIfCurrentOrg("false");
        msgType.setIfHistory("false");
        msgType.setIfCombine("false");
        msgType.setPureWeb(Boolean.valueOf("false").booleanValue());
        try {
            MessageHander handler = WFListUtils.getMessageHander(ctx, msgType, 1, 20, "", "");
            if (handler != null) {
                count = handler.getMsgCount();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    public static int getMessageCountByClassCp(Context ctx, MsgType msg) {
        int count = 0;
        MsgTypePro msgType = new MsgTypePro();
        msgType.setBizType(-1);
        msgType.setType(10);
        msgType.setSourceStatus(-1);
        msgType.setNodeType(1);
        msgType.setMsgDate("");
        if (msg != null) {
            msgType.setCustomNodeID(msg.getCustomNodeID());
            msgType.setQuickSearch(msg.getQuickSearch());
            msgType.setQuickSearchSubject(msg.getQuickSearchSubject());
        } else {
            msgType.setCustomNodeID(null);
        }
        msgType.setStatus(-1);
        msgType.setIfCurrentOrg("false");
        msgType.setIfHistory("false");
        msgType.setIfCombine("false");
        msgType.setPureWeb(Boolean.valueOf("false"));
        msgType.setModuleType("com.kingdee.eas.cp.");
        try {
            MessageHander handler = WFListUtils.getMessageHanderCp(ctx, msgType, 1, 20, "", "");
            if (handler != null) {
                count = handler.getMsgCount();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    public static int getCustomNodeMsgCount(Context ctx, String nodeType, String customNodeID) {
        MsgType msgType = new MsgType();
        msgType.setCustomNodeID(customNodeID);
        msgType.setNodeType(Integer.parseInt(nodeType));
        msgType.setIfHistory("false");
        msgType.setIfCurrentOrg("false");
        CPCustomNodeMessageDaoImpl impl = new CPCustomNodeMessageDaoImpl(ctx, msgType);
        int count = impl.getNodeMsgCount();
        return count;
    }

    public int[] getMsgCount(Context ctx) {
        int[] counts = new int[]{0, 0, 0, 0, 0, 0, 1};
        try {
            if (ctx == null) {
                counts[6] = 0;
                return counts;
            }
            IMessageCenter messageCenter = MessageCenterFactory.getLocalInstance((Context)ctx);
            counts = messageCenter.getNewMessageCenterCounts(messageCenter.isOrg(), true);
            this.logger.debug((Object)("unDisposeTaskCount=" + counts[0] + ",unreadMessageCount=" + counts[1] + ",unreadNoticeCount=" + counts[2] + ",unreadTaskCount=" + counts[3] + ",unreadOnlineNoticeCount=" + counts[4] + ",unreadOnlineNoticeCount=" + counts[6]));
        }
        catch (Exception e) {
            counts[6] = 0;
        }
        return counts;
    }

    public static List getCompletedAssignmentList(Context ctx, String msgClassID, int pageNo, int pageSize, String orderByField, String orderType) {
        MsgType msgType = new MsgType();
        msgType.setBizType(-1);
        msgType.setType(10);
        msgType.setSourceStatus(-2);
        msgType.setNodeType(2);
        msgType.setMsgDate("");
        msgType.setCustomNodeID(msgClassID);
        msgType.setStatus(-1);
        msgType.setIfCurrentOrg("false");
        msgType.setIfHistory("false");
        msgType.setIfCombine("false");
        msgType.setPureWeb(Boolean.valueOf("false").booleanValue());
        return WFListUtils.getMessageList(ctx, msgType, pageNo, pageSize, orderByField, orderType);
    }

    public static int getCompletedAssignmenCount(Context ctx, String msgClassID) {
        int count = 0;
        MsgType msgType = new MsgType();
        msgType.setBizType(-1);
        msgType.setType(10);
        msgType.setSourceStatus(-2);
        msgType.setNodeType(2);
        msgType.setMsgDate("");
        msgType.setCustomNodeID(msgClassID);
        msgType.setStatus(-1);
        msgType.setIfCurrentOrg("false");
        msgType.setIfHistory("false");
        msgType.setIfCombine("false");
        msgType.setPureWeb(Boolean.valueOf("false").booleanValue());
        try {
            MessageHander handler = WFListUtils.getMessageHander(ctx, msgType, 1, 20, "", "");
            if (handler != null) {
                count = handler.getMsgCount();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            count = -1;
        }
        return count;
    }

    public static List getNoticeList(Context ctx, String msgClassID, int pageNo, int pageSize, String orderByField, String orderType) {
        MsgType msgType = new MsgType();
        if (StringUtils.isEmpty((String)msgClassID)) {
            msgType.setBizType(-1);
            msgType.setCustomNodeID("");
        } else {
            msgType.setBizType(10);
            msgType.setCustomNodeID(msgClassID);
        }
        msgType.setType(0);
        msgType.setSourceStatus(-3);
        msgType.setNodeType(3);
        msgType.setMsgDate("");
        msgType.setStatus(-1);
        msgType.setIfCurrentOrg("false");
        msgType.setIfHistory("false");
        msgType.setIfCombine("false");
        msgType.setPureWeb(Boolean.valueOf("false").booleanValue());
        return WFListUtils.getMessageList(ctx, msgType, pageNo, pageSize, orderByField, orderType);
    }

    public static List getImmediateMsgList(Context ctx, int pageNo, int pageSize, String orderByField, String orderType) {
        MsgType msgType = new MsgType();
        msgType.setBizType(-1);
        msgType.setType(40);
        msgType.setSourceStatus(-3);
        msgType.setNodeType(3);
        msgType.setMsgDate("");
        msgType.setCustomNodeID("");
        msgType.setStatus(-1);
        msgType.setIfCurrentOrg("false");
        msgType.setIfHistory("false");
        msgType.setIfCombine("false");
        msgType.setPureWeb(Boolean.valueOf("false").booleanValue());
        return WFListUtils.getMessageList(ctx, msgType, pageNo, pageSize, orderByField, orderType);
    }

    public static int getImmediateMsgCnt(Context ctx) {
        int count = 0;
        MsgType msgType = new MsgType();
        msgType.setBizType(-1);
        msgType.setType(40);
        msgType.setSourceStatus(-3);
        msgType.setNodeType(3);
        msgType.setMsgDate("");
        msgType.setCustomNodeID("");
        msgType.setStatus(-1);
        msgType.setIfCurrentOrg("false");
        msgType.setIfHistory("false");
        msgType.setIfCombine("false");
        msgType.setPureWeb(Boolean.valueOf("false").booleanValue());
        try {
            MessageHander handler = WFListUtils.getMessageHander(ctx, msgType, 1, 20, "", "");
            if (handler != null) {
                count = handler.getMsgCount();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            count = -1;
        }
        return count;
    }

    public static List getPassAroundNoticeList(Context ctx, int pageNo, int pageSize, String orderByField, String orderType) {
        MsgType msgType = new MsgType();
        msgType.setBizType(-1);
        msgType.setType(40);
        msgType.setSourceStatus(-3);
        msgType.setNodeType(3);
        msgType.setMsgDate("");
        msgType.setCustomNodeID("");
        msgType.setStatus(-1);
        msgType.setIfCurrentOrg("false");
        msgType.setIfHistory("false");
        msgType.setIfCombine("false");
        msgType.setPureWeb(Boolean.valueOf("false").booleanValue());
        msgType.setQuickSearch("1");
        msgType.setQuickSearchSubject("Pass Around");
        return WFListUtils.getMessageList(ctx, msgType, pageNo, pageSize, orderByField, orderType);
    }

    public static int getPassAroundNoticeCnt(Context ctx) {
        int count = 0;
        MsgType msgType = new MsgType();
        msgType.setBizType(-1);
        msgType.setType(40);
        msgType.setSourceStatus(-3);
        msgType.setNodeType(3);
        msgType.setMsgDate("");
        msgType.setCustomNodeID("");
        msgType.setStatus(-1);
        msgType.setIfCurrentOrg("false");
        msgType.setIfHistory("false");
        msgType.setIfCombine("false");
        msgType.setPureWeb(Boolean.valueOf("false").booleanValue());
        msgType.setQuickSearch("1");
        msgType.setQuickSearchSubject("Pass Around");
        try {
            MessageHander handler = WFListUtils.getMessageHander(ctx, msgType, 1, 20, "", "");
            if (handler != null) {
                count = handler.getMsgCount();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            count = -1;
        }
        return count;
    }

    public static List getWFNoticeList(Context ctx, int pageNo, int pageSize, String orderByField, String orderType) {
        MsgType msgType = new MsgType();
        msgType.setBizType(0);
        msgType.setType(0);
        msgType.setSourceStatus(-3);
        msgType.setNodeType(3);
        msgType.setMsgDate("");
        msgType.setCustomNodeID("");
        msgType.setStatus(-1);
        msgType.setIfCurrentOrg("false");
        msgType.setIfHistory("false");
        msgType.setIfCombine("false");
        msgType.setPureWeb(Boolean.valueOf("false").booleanValue());
        return WFListUtils.getMessageList(ctx, msgType, pageNo, pageSize, orderByField, orderType);
    }

    public static List getAlarmNoticeList(Context ctx, int pageNo, int pageSize, String orderByField, String orderType) {
        MsgType msgType = new MsgType();
        msgType.setBizType(10);
        msgType.setType(0);
        msgType.setSourceStatus(-3);
        msgType.setNodeType(3);
        msgType.setMsgDate("");
        msgType.setCustomNodeID("");
        msgType.setStatus(-1);
        msgType.setIfCurrentOrg("false");
        msgType.setIfHistory("false");
        msgType.setIfCombine("false");
        msgType.setPureWeb(Boolean.valueOf("false").booleanValue());
        return WFListUtils.getMessageList(ctx, msgType, pageNo, pageSize, orderByField, orderType);
    }

    public static List getHastenNoticeList(Context ctx, MsgType msg, int pageNo, int pageSize, String orderByField, String orderType) {
        MsgType msgType = MsgTypeExt.InitMsgType(0, 40, -3, 3, msg);
        return WFListUtils.getMessageList(ctx, msgType, pageNo, pageSize, orderByField, orderType);
    }

    public static int getHastenNoticeCnt(Context ctx, MsgType msg) {
        int count = 0;
        MsgType msgType = MsgTypeExt.InitMsgType(0, 40, -3, 3, msg);
        try {
            MessageHander handler = WFListUtils.getMessageHander(ctx, msgType, 1, 20, "", "");
            if (handler != null) {
                count = handler.getMsgCount();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            count = -1;
        }
        return count;
    }

    public static List getOtherNoticeList(Context ctx, int pageNo, int pageSize, String orderByField, String orderType) {
        MsgType msgType = new MsgType();
        msgType.setBizType(-2);
        msgType.setType(0);
        msgType.setSourceStatus(-3);
        msgType.setNodeType(3);
        msgType.setMsgDate("");
        msgType.setCustomNodeID("");
        msgType.setStatus(-1);
        msgType.setIfCurrentOrg("false");
        msgType.setIfHistory("false");
        msgType.setIfCombine("false");
        msgType.setPureWeb(Boolean.valueOf("false").booleanValue());
        return WFListUtils.getMessageList(ctx, msgType, pageNo, pageSize, orderByField, orderType);
    }

    public static int getMessageCount(Context ctx, MsgType msgType) {
        int count = 0;
        try {
            MessageHander handler = WFListUtils.getMessageHander(ctx, msgType, 1, 20, "", "");
            if (handler != null) {
                count = handler.getMsgCount();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    public static int getMessageCountCp(Context ctx, MsgTypePro msgType) {
        int count = 0;
        try {
            MessageHander handler = WFListUtils.getMessageHander(ctx, msgType, 1, 20, "", "");
            if (handler != null) {
                count = handler.getMsgCount();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    public static List getMessageList(Context ctx, MsgType msgType, int pageNo, int pageSize, String orderByField, String orderType) {
        List list = null;
        try {
            MessageHander handler = WFListUtils.getMessageHander(ctx, msgType, pageNo, pageSize, orderByField, orderType);
            if (handler != null) {
                list = handler.getMsgList();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List getMessageListCp(Context ctx, MsgTypePro msgType, int pageNo, int pageSize, String orderByField, String orderType) {
        List list = null;
        try {
            MessageHander handler = WFListUtils.getMessageHanderCp(ctx, msgType, pageNo, pageSize, orderByField, orderType);
            if (handler != null) {
                list = handler.getMsgList();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static MessageHander getMessageHander(Context ctx, MsgType msgType, int pageNo, int pageSize, String orderByField, String orderType) {
        String tempOrderType = orderType;
        if (tempOrderType == null || tempOrderType.equals("")) {
            tempOrderType = "DESC";
        }
        WFListService msgControl = new WFListService();
        MessageHander handler = null;
        try {
            handler = msgControl.queryMessage(ctx, msgType, pageNo, pageSize, orderByField, tempOrderType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return handler;
    }

    public static MessageHander getMessageHanderCp(Context ctx, MsgTypePro msgType, int pageNo, int pageSize, String orderByField, String orderType) {
        String tempOrderType = orderType;
        if (tempOrderType == null || tempOrderType.equals("")) {
            tempOrderType = "DESC";
        }
        WFListService msgControl = new WFListService();
        MessageHander handler = null;
        try {
            handler = msgControl.queryMessageCp(ctx, msgType, pageNo, pageSize, orderByField, tempOrderType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return handler;
    }

    public static List getMyTransactionProcess(Context ctx, int pageNo, int pageSize, String orderByField, String orderType) {
        ArrayList list = null;
        try {
            IProcCatalogFacade procCatalogFacade = ProcCatalogFacadeFactory.getLocalInstance((Context)ctx);
            list = procCatalogFacade.getMyTransactionProcess(pageNo, pageSize, orderByField, orderType);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static int[] getAllMsgCounts(Context ctx) throws BOSException, EASBizException {
        int[] counts = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        String personID = ctx.getCaller().toString();
        Integer msgStatus = new Integer(0);
        Object[] undisposeParams = new Object[]{personID, msgStatus};
        Object[] unreadAskMsgParams = new Object[]{personID, new Integer(0), new Integer(40), msgStatus};
        Object[] unreadPassAroundParams = new Object[]{personID, new Integer(0), new Integer(0), msgStatus};
        Object[] unreadWorkFlowParams = new Object[]{personID, new Integer(0), new Integer(0), msgStatus};
        Object[] unreadInstanceMsgParams = new Object[]{personID, new Integer(40), new Integer(20), msgStatus};
        Object[] unreadWarningParams = new Object[]{personID, new Integer(0), new Integer(10), msgStatus};
        Object[] unreadOthersParams = new Object[]{personID, new Integer(0), msgStatus};
        Object[] unread_CP_WorkFlowParams = new Object[]{personID, new Integer(0), msgStatus};
        Object[] myTransactionParams = new String[]{personID};
        try {
            IRowSet unread_CP_WorkFlowSet;
            IRowSet unreadOthersSet;
            IRowSet unreadWaringSet;
            IRowSet myTransactionSet;
            IRowSet unreadInstanceMsgRowSet;
            IRowSet unreadworkflowSet;
            IRowSet unreadPassAroundSet;
            IRowSet unreadAskMsgSet;
            IRowSet undisposeTaskRowSet = DbUtil.executeQuery((Context)ctx, (String)UNDISPOSSQL, (Object[])undisposeParams);
            if (undisposeTaskRowSet.next()) {
                counts[0] = undisposeTaskRowSet.getInt("COUNT");
            }
            if ((unreadAskMsgSet = DbUtil.executeQuery((Context)ctx, (String)UNREADNOTICESQL, (Object[])unreadAskMsgParams)).next()) {
                counts[1] = unreadAskMsgSet.getInt("COUNT");
            }
            if ((unreadPassAroundSet = DbUtil.executeQuery((Context)ctx, (String)UNREADPASSAROUNDSQL, (Object[])unreadPassAroundParams)).next()) {
                counts[2] = unreadPassAroundSet.getInt("COUNT");
            }
            if ((unreadworkflowSet = DbUtil.executeQuery((Context)ctx, (String)UNREADWORKFLOWSQL, (Object[])unreadWorkFlowParams)).next()) {
                counts[3] = unreadworkflowSet.getInt("COUNT");
            }
            if ((unreadInstanceMsgRowSet = DbUtil.executeQuery((Context)ctx, (String)UNREADNOTICESQL, (Object[])unreadInstanceMsgParams)).next()) {
                counts[4] = unreadInstanceMsgRowSet.getInt("COUNT");
            }
            if ((myTransactionSet = DbUtil.executeQuery((Context)ctx, (String)MYTRANSCTIONSQL, (Object[])myTransactionParams)).next()) {
                counts[5] = myTransactionSet.getInt("COUNT");
            }
            if ((unreadWaringSet = DbUtil.executeQuery((Context)ctx, (String)UNREADNOTICESQL, (Object[])unreadWarningParams)).next()) {
                counts[6] = unreadWaringSet.getInt("COUNT");
            }
            if ((unreadOthersSet = DbUtil.executeQuery((Context)ctx, (String)UNREADOthersNOTICESQL, (Object[])unreadOthersParams)).next()) {
                counts[7] = unreadOthersSet.getInt("COUNT");
            }
            if ((unread_CP_WorkFlowSet = DbUtil.executeQuery((Context)ctx, (String)UNREAD_CP_WF_SQL, (Object[])unread_CP_WorkFlowParams)).next()) {
                counts[8] = unread_CP_WorkFlowSet.getInt("COUNT");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return counts;
    }

    public static List getSendMsgList(Context ctx, int pageNo, int pageSize, String orderByField, String orderType, String userID) {
        List list = null;
        String tempOrderType = orderType;
        if (tempOrderType == null || tempOrderType.equals("")) {
            tempOrderType = "DESC";
        }
        MsgSendRecordService msgControl = new MsgSendRecordService();
        try {
            MessageHander handler = msgControl.queryMsgSendRecord(ctx, pageSize, pageNo, orderByField, tempOrderType, userID, false);
            if (handler != null) {
                list = handler.getMsgList();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}

